/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.silence;

import com.huawei.ism.tool.base.ui.task.TaskResult;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.entity.analyze.ConfigInfoEntry;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogRow;
import com.huawei.ism.tool.loganalyzer.entity.log.LogDeCompressDir;
import com.huawei.ism.tool.loganalyzer.exception.StopImportException;
import com.huawei.ism.tool.loganalyzer.faulttree.decompress.threadpool.DiskIsEnoughThread;
import com.huawei.ism.tool.loganalyzer.faulttree.util.FileUtil;
import com.huawei.ism.tool.loganalyzer.faulttree.versionsearch.ProductInfo;
import com.huawei.ism.tool.loganalyzer.logic.logsearcher.SoftHardwareConfiginfoSearch;
import com.huawei.ism.tool.loganalyzer.persist.entity.LogConfigInfo;
import com.huawei.ism.tool.loganalyzer.silence.DeCompressPkgWorktakerImplSilence;
import com.huawei.ism.tool.loganalyzer.util.LoganalyzerContext;
import com.huawei.ism.tool.loganalyzer.util.SearchConstant;
import com.huawei.ism.tool.loganalyzer.util.SearcherUtils;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoLogPackageSilence {
    private static final Logger LOGGER = LoggerFactory.getLogger(DoLogPackageSilence.class);
    private LogRow logRow;
    private TaskResult taskResult;

    public DoLogPackageSilence(LogRow rows) {
        this.logRow = rows;
    }

    public TaskResult doPressPackage() {
        try {
            new DoPressThread().run();
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("do press thread error.", (Throwable)e);
            throw e;
        }
        return this.taskResult;
    }

    class DoPressThread {
        DoPressThread() {
        }

        public void run() {
            String name = Thread.currentThread().getName();
            Thread.currentThread().setName("Thread_logDepressaction");
            DoLogPackageSilence.this.taskResult = new TaskResult(TaskResult.Result.FAILED);
            DoLogPackageSilence.this.taskResult.setErrorLocaleDescription("stop");
            LogAnalyzeQueryCallable callable = new LogAnalyzeQueryCallable(DoLogPackageSilence.this.logRow);
            DoLogPackageSilence.this.taskResult = (TaskResult)callable.call();
            Thread.currentThread().setName(name);
        }
    }

    public final class LogAnalyzeQueryCallable
    implements Callable<Object> {
        private LogRow row;

        public LogAnalyzeQueryCallable(LogRow row) {
            this.row = row;
        }

        @Override
        public Object call() {
            TaskResult taskRes = null;
            try {
                taskRes = this.depressFile();
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(this.getClass()).error(" method name:LogAnalyzeQueryTask ", (Throwable)e);
                taskRes = this.handleDecompressError();
                throw e;
            }
            return taskRes;
        }

        private TaskResult handleDecompressError() {
            TaskResult taskRes = new TaskResult(TaskResult.Result.FAILED);
            taskRes.setErrorLocaleDescription("decompress error");
            this.initTmpFiles();
            return taskRes;
        }

        private TaskResult depressFile() {
            TaskResult task;
            String defaultTempPath = SearchConstant.getInstant().getTemp();
            File tempFile = new File(defaultTempPath);
            DiskIsEnoughThread isDiskEnough = new DiskIsEnoughThread(tempFile);
            DeCompressPkgWorktakerImplSilence decompressworktaker = new DeCompressPkgWorktakerImplSilence();
            LogDeCompressDir logDeCompressDir = new LogDeCompressDir();
            try {
                Long size = FileUtil.getDirSize(tempFile);
                double msize = (double)size.longValue() / 1.073741824E9;
                isDiskEnough.start();
                decompressworktaker.convertLogDir(this.row, logDeCompressDir, isDiskEnough);
                this.row.setLogDeCompressDir(logDeCompressDir);
                if (logDeCompressDir.getDeDeCompressDir() == null) {
                    TaskResult task2 = new TaskResult(TaskResult.Result.FAILED);
                    task2.setErrorLocaleDescription("Can not open file as archive");
                    this.initTmpFiles();
                    TaskResult taskResult = task2;
                    return taskResult;
                }
                if ("too big".equals(logDeCompressDir.getDeDeCompressDir().getName())) {
                    TaskResult task3 = new TaskResult(TaskResult.Result.FAILED);
                    task3.setErrorLocaleDescription("too big");
                    this.initTmpFiles();
                    TaskResult taskResult = task3;
                    return taskResult;
                }
                try {
                    String decompressPath = SearcherUtils.getLogPath(logDeCompressDir.getDeDeCompressDir()).getAbsolutePath();
                    this.row.setDatecollect(decompressPath.contains("DataCollect") || decompressPath.contains("System_log"));
                    this.handleSuccSituation();
                    File deCompressRandomDir = DoLogPackageSilence.this.logRow.getLogDeCompressDir().getDeDeCompressRandomDir();
                    this.configInfoEntry(deCompressRandomDir);
                    task = new TaskResult(TaskResult.Result.SUCCESS);
                    LoganalyzerContext.getInstance().getDecompressLogFile().put(this.row.getLogFile().getName(), logDeCompressDir.getDeDeCompressDir());
                    ToolLoggerFactory.getLogger(this.getClass()).debug("filepath:" + logDeCompressDir.getDeDeCompressDir().getPath());
                }
                catch (StopImportException e) {
                    new RandomDirDeleteThread(logDeCompressDir).start();
                    TaskResult task4 = new TaskResult(TaskResult.Result.FAILED);
                    task4.setErrorLocaleDescription("stop");
                    TaskResult taskResult = task4;
                    return taskResult;
                }
            }
            finally {
                isDiskEnough.setDecompressed(true);
            }
            return task;
        }

        private void configInfoEntry(File deCompressRandomDir) {
            if (deCompressRandomDir != null && deCompressRandomDir.exists()) {
                List<File> files = SearcherUtils.showConfigInfoFiles(deCompressRandomDir);
                SoftHardwareConfiginfoSearch searcher = new SoftHardwareConfiginfoSearch();
                ConfigInfoEntry configInfoEntry = searcher.search(files);
                LogConfigInfo logConfigInfo = new LogConfigInfo(DoLogPackageSilence.this.logRow.getLogID(), configInfoEntry);
            }
        }

        private void initTmpFiles() {
            if (this.row != null && !StringUtils.isNULLStr((String)this.row.getLogDeCompressDir().getDeDeCompressRandomDir().getAbsolutePath())) {
                SearcherUtils.deleteTempFile(new File(this.row.getLogDeCompressDir().getDeDeCompressRandomDir().getAbsolutePath()));
            }
        }

        private void handleSuccSituation() {
            ArrayList hasPorductRows = new ArrayList();
            ArrayList nonPorductRows = new ArrayList();
            ArrayList allPorductRows = new ArrayList();
            File tempPackage = DoLogPackageSilence.this.logRow.getLogFile();
            DoLogPackageSilence.this.logRow.setStauts("info.nanlyze.tabel.type.before");
            ProductInfo productInfo = new ProductInfo(DoLogPackageSilence.this.logRow.getLogDeCompressDir().getDeDeCompressRandomDir());
            DoLogPackageSilence.this.logRow.setProductInfo(productInfo);
            allPorductRows.addAll(nonPorductRows);
            allPorductRows.addAll(hasPorductRows);
            LoganalyzerContext.getInstance().getImportLogRow().stopImportAnClick();
            this.deleteOldLog(DoLogPackageSilence.this.logRow);
            LoganalyzerContext.getInstance().getCurLogRows().add(DoLogPackageSilence.this.logRow);
        }

        private boolean isModelAndVersionNull(ProductInfo productInfo) {
            String model = productInfo.getModel();
            String version = productInfo.getVersion();
            return StringUtils.isNULLStr((String)model) || StringUtils.isNULLStr((String)version);
        }

        private void deleteOldLog(LogRow lr) {
            for (LogRow tmpLogRow : LoganalyzerContext.getInstance().getCurLogRows()) {
                if (!tmpLogRow.getLogFile().getAbsolutePath().equals(lr.getLogFile().getAbsolutePath())) continue;
                if (!StringUtils.isNULLStr((String)tmpLogRow.getReportTmpFile())) {
                    FileUtils.deleteFile((File)new File(tmpLogRow.getReportTmpFile()));
                }
                LoganalyzerContext.getInstance().getCurLogRows().remove(tmpLogRow);
                break;
            }
        }
    }

    private static final class RandomDirDeleteThread
    extends Thread {
        private LogDeCompressDir logDeCompressDir;

        private RandomDirDeleteThread(LogDeCompressDir logDeCompressDir) {
            this.logDeCompressDir = logDeCompressDir;
        }

        @Override
        public void run() {
            int count = 0;
            block2: while (true) {
                try {
                    while (true) {
                        Thread.sleep(2000L);
                        if (!this.logDeCompressDir.getDeDeCompressRandomDir().exists() || ++count >= 20) break block2;
                        FileAssistant.clearDir((String)this.logDeCompressDir.getDeDeCompressRandomDir().getAbsolutePath());
                    }
                }
                catch (InterruptedException e) {
                    ToolLoggerFactory.getLogger(this.getClass()).error("logDeCompressDir is error:", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

