/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.silence;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogRow;
import com.huawei.ism.tool.loganalyzer.exception.AnalyzingStopedException;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.rule.Rule;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.interfaces.IRecordContentProcessor;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.model.DataSource;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.model.FileAnalyzer;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.model.SourceType;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.model.Type;
import com.huawei.ism.tool.loganalyzer.faulttree.model.DeviceType;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.cache.RuleMatchResultCache;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.mode.SearchMode;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.processor.PrimarySearchRecordContentProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class PrimarySearchModeSilence
extends SearchMode {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(PrimarySearchModeSilence.class);
    private final RuleMatchResultCache ruleMatchResultCache = new RuleMatchResultCache();
    private ExecutorService executeService;
    private LogRow row;
    private int totalFileNum;
    private AtomicInteger searchFileIndex = new AtomicInteger();
    private int totalProgress = 80;
    private int originalProgress;

    public PrimarySearchModeSilence(LogRow row) {
        this.row = row;
        this.originalProgress = row.getSearchProgress().getCurrent();
        this.totalProgress = row.getDeviceType() == DeviceType.UNIFINED ? 80 : 91;
    }

    @Override
    public void search(DataSource ds, Map<String, List<Rule>> ruleListMap) {
        try {
            try {
                this.initThreadPool();
                this.doSearch(ds, ruleListMap);
            }
            catch (AnalyzingStopedException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.error("PrimarySearchMode.search(DataSource ds, Map<String, List<Rule>> ruleListMap) error:", (Throwable)e);
                this.destroy();
            }
        }
        finally {
            this.destroy();
        }
    }

    private void doSearch(DataSource ds, Map<String, List<Rule>> ruleListMap) {
        SourceType st;
        for (Map.Entry<String, List<Rule>> e : ruleListMap.entrySet()) {
            st = ds.getSourceType(Type.transfer(e.getKey()));
            if (st == null) {
                LOGGER.info("PrimarySearchMode.search start01----------------------st is null");
                continue;
            }
            this.totalFileNum += st.getFileAnalyzerList().size();
        }
        if (this.totalFileNum == 0) {
            if (this.row != null) {
                this.row.getSearchProgress().add(this.row.getDeviceType() == DeviceType.UNIFINED ? 80 : 91);
            }
            return;
        }
        for (Map.Entry<String, List<Rule>> e : ruleListMap.entrySet()) {
            st = ds.getSourceType(Type.transfer(e.getKey()));
            if (st == null) {
                LOGGER.info("PrimarySearchMode.search start02----------------------st is null");
                continue;
            }
            LOGGER.info("PrimarySearchMode.search start----------------------");
            this.doSearch(st, e.getValue());
        }
    }

    private void doSearch(SourceType st, List<Rule> ruleList) {
        this.row.getSearchProgress().setInfo(String.valueOf(ResourceUtil.getString((String)st.getType().getDesc())) + " : 0 / " + st.getFileAnalyzerList().size());
        ArrayList<Future<Boolean>> futureList = new ArrayList<Future<Boolean>>();
        PrimarySearchRecordContentProcessor recordContentProcessor = new PrimarySearchRecordContentProcessor(ruleList, this.ruleMatchResultCache);
        AtomicInteger fileCounter = new AtomicInteger();
        for (FileAnalyzer fileAnalyzer : st.getFileAnalyzerList()) {
            FileAnalyzerCallable c = new FileAnalyzerCallable(fileAnalyzer, recordContentProcessor, this.row);
            c.setFileCounter(fileCounter);
            c.setSt(st);
            c.setOriginalProgress(this.originalProgress);
            c.setSearchFileIndex(this.searchFileIndex);
            c.setTotalFileNum(this.totalFileNum);
            c.setTotalProgress(this.totalProgress);
            futureList.add(this.executeService.submit(c));
        }
        for (Future future : futureList) {
            try {
                future.get();
            }
            catch (ExecutionException e1) {
                PrimarySearchModeSilence.doMyException(e1);
            }
            catch (Exception e2) {
                LOGGER.error("PrimarySearchMode.doSearch(SourceType st, List<Rule> ruleList) occor an error", (Throwable)e2);
            }
        }
    }

    private static void doMyException(ExecutionException e) {
        Throwable throwable = e.getCause();
        while (throwable != null) {
            if (throwable instanceof AnalyzingStopedException) {
                throw (AnalyzingStopedException)throwable;
            }
            throwable = throwable.getCause();
        }
    }

    @Override
    public RuleMatchResultCache getRuleMatchResultCache() {
        return this.ruleMatchResultCache;
    }

    private void initThreadPool() {
        int runtimeAvailableProcessors = Runtime.getRuntime().availableProcessors();
        int availableProcessors = runtimeAvailableProcessors;
        availableProcessors = availableProcessors == 0 ? 1 : availableProcessors;
        this.executeService = Executors.newFixedThreadPool(availableProcessors);
        LOGGER.info("Number of concurrent analysis threads: " + availableProcessors + ", availableProcessors: " + runtimeAvailableProcessors);
    }

    private void destroy() {
        if (this.executeService != null) {
            this.executeService.shutdown();
            this.executeService = null;
        }
    }

    private static class FileAnalyzerCallable
    implements Callable<Boolean> {
        private FileAnalyzer fileAnalyzer;
        private IRecordContentProcessor recordContentProcessor;
        private LogRow row;
        private SourceType st;
        private AtomicInteger fileCounter;
        private int totalFileNum;
        private AtomicInteger searchFileIndex = new AtomicInteger();
        private int totalProgress = 80;
        private int originalProgress;

        private FileAnalyzerCallable(FileAnalyzer fileAnalyzer, IRecordContentProcessor recordContentProcessor, LogRow row) {
            this.fileAnalyzer = fileAnalyzer;
            this.recordContentProcessor = recordContentProcessor;
            this.row = row;
        }

        @Override
        public Boolean call() {
            if (this.row != null) {
                this.row.analyzeInterruptedFromStopCommand();
                long startTime = System.currentTimeMillis();
                this.fileAnalyzer.analyse(this.recordContentProcessor, this.row.getDeviceType());
                this.fileCounter.incrementAndGet();
                this.searchFileIndex.incrementAndGet();
                this.row.getSearchProgress().setInfo(String.valueOf(ResourceUtil.getString((String)this.st.getType().getDesc())) + " : " + this.fileCounter.get() + " / " + this.st.getFileAnalyzerList().size());
                this.row.getSearchProgress().set(this.originalProgress + (int)(((double)this.searchFileIndex.get() + 0.0) / (double)this.totalFileNum * (double)this.totalProgress));
                long spendTime = System.currentTimeMillis() - startTime;
                if (spendTime > 5000L) {
                    LOGGER.info("File-document analysis completed[" + this.fileAnalyzer.getFile().getName() + "], Spend time:" + spendTime + " ms");
                }
            }
            return true;
        }

        private void setSt(SourceType st) {
            this.st = st;
        }

        private void setFileCounter(AtomicInteger fileCounter) {
            this.fileCounter = fileCounter;
        }

        private void setTotalFileNum(int totalFileNum) {
            this.totalFileNum = totalFileNum;
        }

        private void setSearchFileIndex(AtomicInteger searchFileIndex) {
            this.searchFileIndex = searchFileIndex;
        }

        private void setTotalProgress(int totalProgress) {
            this.totalProgress = totalProgress;
        }

        private void setOriginalProgress(int originalProgress) {
            this.originalProgress = originalProgress;
        }
    }
}

