/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.silence;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.IniReader;
import com.huawei.ism.tool.base.utils.KeyValue;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.loganalyzer.entity.analyze.AnalyzeResult;
import com.huawei.ism.tool.loganalyzer.entity.analyze.ErrorCodeResult;
import com.huawei.ism.tool.loganalyzer.entity.analyze.Event;
import com.huawei.ism.tool.loganalyzer.entity.analyze.EventDetail;
import com.huawei.ism.tool.loganalyzer.entity.analyze.HelpKey;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogRow;
import com.huawei.ism.tool.loganalyzer.entity.analyze.ReportLog;
import com.huawei.ism.tool.loganalyzer.entity.analyze.ResultViewInfo;
import com.huawei.ism.tool.loganalyzer.entity.config.OldRule;
import com.huawei.ism.tool.loganalyzer.entity.config.PackageInfo;
import com.huawei.ism.tool.loganalyzer.entity.config.RuleFileConfig;
import com.huawei.ism.tool.loganalyzer.entity.config.SingleLogSearchRule;
import com.huawei.ism.tool.loganalyzer.entity.execresult.ExecuteResult;
import com.huawei.ism.tool.loganalyzer.entity.log.Log;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.version.Version;
import com.huawei.ism.tool.loganalyzer.faulttree.model.DeviceType;
import com.huawei.ism.tool.loganalyzer.faulttree.util.FileUtil;
import com.huawei.ism.tool.loganalyzer.logic.configloader.EventExcelReader;
import com.huawei.ism.tool.loganalyzer.logic.configloader.LoadErrorCode;
import com.huawei.ism.tool.loganalyzer.persist.data.DiagnoseInfos;
import com.huawei.ism.tool.loganalyzer.persist.data.EventInfos;
import com.huawei.ism.tool.loganalyzer.ui.main.DoLogAnalyze;
import com.huawei.ism.tool.loganalyzer.ui.main.MainLogAnaDialog;
import com.huawei.ism.tool.loganalyzer.ui.main.MainLogAnaLayout;
import com.huawei.ism.tool.loganalyzer.util.ComponentDefine;
import com.huawei.ism.tool.loganalyzer.util.FileListFileFilterUtils;
import com.huawei.ism.tool.loganalyzer.util.LoganalyzerContext;
import com.huawei.ism.tool.loganalyzer.util.SearchConstant;
import com.huawei.ism.tool.loganalyzer.worktaker.IIndexSearchWorkTaker;
import com.huawei.ism.tool.loganalyzer.worktaker.callback.ILogListener;
import com.huawei.ism.tool.obase.filechooser.HibernateContainer;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import com.huawei.ism.tool.obase.utils.FileChooserWrapper;
import com.huawei.ism.ui.swing.IsmFileChooser;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.WildcardQuery;
import org.slf4j.Logger;

public final class SearcherUtilsSilence {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SearcherUtilsSilence.class);
    private static final String[] FIELES = new String[]{"id", "desc", "date", "level", "module", "others", "jiffies", "filename", "contents", "filetype", "ctrlid", "filepath", "logLine"};
    private static final Map<String, String> ESCAPING_CHARS_GROUPS = new HashMap<String, String>();
    private static final long REQUIRED_FREE_DISK = 524288000L;
    private static final String SPECIAL_CHAR_REG = "[\\w\\s]+";
    private static final int MAX_VAL = 99999;
    private static final String EVENT_PATH = "Event";
    private static final String EVENT_FILE = "Event.txt";
    private static final String VERMAP_INI = "vermap.ini";
    private static final char DOT = '.';
    private static final String[] DECOPMRESS_TYPES = new String[]{".zip", ".7z", ".tar.gz", ".rar", ".bz2", ".tar", ".tgz"};

    static {
        ESCAPING_CHARS_GROUPS.put("+", "\\+");
        ESCAPING_CHARS_GROUPS.put("-", "\\-");
        ESCAPING_CHARS_GROUPS.put("&", "\\&");
        ESCAPING_CHARS_GROUPS.put("|", "\\|");
        ESCAPING_CHARS_GROUPS.put("!", "\\!");
        ESCAPING_CHARS_GROUPS.put("(", "\\(");
        ESCAPING_CHARS_GROUPS.put(")", "\\)");
        ESCAPING_CHARS_GROUPS.put("{", "\\{");
        ESCAPING_CHARS_GROUPS.put("}", "\\}");
        ESCAPING_CHARS_GROUPS.put("[", "\\[");
        ESCAPING_CHARS_GROUPS.put("]", "\\]");
        ESCAPING_CHARS_GROUPS.put("^", "\\^");
        ESCAPING_CHARS_GROUPS.put("\"", "\\\"");
        ESCAPING_CHARS_GROUPS.put("~", "\\~");
        ESCAPING_CHARS_GROUPS.put("*", "\\*");
        ESCAPING_CHARS_GROUPS.put("?", "\\?");
        ESCAPING_CHARS_GROUPS.put(":", "\\:");
        ESCAPING_CHARS_GROUPS.put("\\", "\\\\");
    }

    private SearcherUtilsSilence() {
    }

    public static boolean checkBlankSpace(String path) {
        return !path.contains("  ");
    }

    public static Log convertDocToLog(Document doc) {
        if (doc == null) {
            return null;
        }
        String date = doc.get(FIELES[2]);
        String dateTmp = SearcherUtilsSilence.insertSparator(date);
        String jiffies = SearcherUtilsSilence.insertSparator(doc.get(FIELES[6]));
        String id = SearcherUtilsSilence.insertSparator(doc.get(FIELES[0]));
        String level = SearcherUtilsSilence.insertSparator(doc.get(FIELES[3]));
        String module = SearcherUtilsSilence.insertSparator(doc.get(FIELES[4]));
        String others = SearcherUtilsSilence.insertSparator(doc.get(FIELES[5]));
        String desc = SearcherUtilsSilence.insertSparator(doc.get(FIELES[1]));
        String filepath = doc.get(FIELES[11]);
        int logLine = Integer.parseInt(doc.get(FIELES[12]));
        Log log = new Log(new File(filepath), id, dateTmp, level, module, jiffies, others, desc);
        log.setLine(logLine);
        log.setOriginalStr(doc.get("log_src_info"));
        return log;
    }

    public static boolean checkPackageType(String srtString, String suffix) {
        if (!StringUtils.isNULLStr((String)srtString) && !StringUtils.isNULLStr((String)suffix)) {
            return srtString.endsWith(suffix);
        }
        return false;
    }

    public static boolean checkPathDeep(String path) {
        return path.length() <= 128;
    }

    public static boolean checkSpecialChar(String path) {
        path = path.replaceAll("\\\\", "");
        path = path.replaceAll("/", "");
        path = path.replaceAll(":", "");
        path = path.replaceAll(".zip", "");
        path = path.replaceAll("\\.", "");
        return path.matches(SPECIAL_CHAR_REG);
    }

    public static boolean checkDiskFreeSpace(String path) {
        return FileUtils.isDiskFull((String)path, (long)524288000L);
    }

    private static String insertSparator(String str) {
        if (!SearcherUtilsSilence.isStringValid(str)) {
            return "";
        }
        StringBuffer builder = new StringBuffer(str);
        if (!str.startsWith("[")) {
            builder.insert(0, "[");
        }
        if (!str.endsWith("]")) {
            builder.append("]");
        }
        return builder.toString();
    }

    public static boolean isStringValid(String str) {
        return str != null && str.length() > 0;
    }

    public static Analyzer getAnalyzer() {
        return new StandardAnalyzer();
    }

    public static Query createWildcardQuery(String field, String value) {
        Term term = new Term(field, "*" + value + "*");
        return new WildcardQuery(term);
    }

    public static String escapingCharsTrans(String srcKey) {
        for (Map.Entry<String, String> entry : ESCAPING_CHARS_GROUPS.entrySet()) {
            srcKey = Pattern.compile(entry.getKey(), 16).matcher(srcKey).replaceAll(entry.getValue());
        }
        return srcKey;
    }

    public static File getLogPath(File logFile) {
        File tempFilePath = logFile;
        File[] subDirs = logFile.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return "DataCollect".equals(pathname.getName());
            }
        });
        if (subDirs == null) {
            return null;
        }
        if (subDirs.length != 0) {
            tempFilePath = new File(logFile, "DataCollect");
        }
        return tempFilePath;
    }

    public static boolean checkLogPackage(File file) {
        File[] logDirs = SearcherUtilsSilence.getLogPath(file).listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (logDirs == null || logDirs.length == 0) {
            File[] logFiles = SearcherUtilsSilence.getLogPath(file).listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String fileName = pathname.getName();
                    boolean isZipFile = fileName.endsWith(".7z") || fileName.endsWith(".tgz") || fileName.endsWith(".tar");
                    boolean bl = isZipFile = isZipFile || fileName.endsWith(".zip") || fileName.endsWith(".bz2");
                    return pathname.isFile() && !isZipFile;
                }
            });
            return logFiles != null && logFiles.length != 0;
        }
        boolean hasEvent = false;
        boolean hasMessage = false;
        File[] fileArray = logDirs;
        int n = logDirs.length;
        int n2 = 0;
        while (n2 < n) {
            File logFile = fileArray[n2];
            File eventFile = new File(logFile, EVENT_PATH);
            File messageFile = new File(logFile, "Messages");
            hasEvent = eventFile.exists();
            hasMessage = messageFile.exists();
            if (hasEvent) {
                boolean bl = hasEvent = FileListFileFilterUtils.fileList(eventFile, new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isFile();
                    }
                }).length != 0;
            }
            if (hasMessage) {
                boolean bl = hasMessage = FileListFileFilterUtils.fileList(messageFile, new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isFile();
                    }
                }).length != 0;
            }
            if (hasEvent || hasMessage) break;
            ++n2;
        }
        return hasEvent || hasMessage;
    }

    public static String newLine(String value, boolean isHtml) {
        StringBuffer newLineBuffer = new StringBuffer();
        if (StringUtils.isNULLStr((String)value)) {
            return "--";
        }
        String[] temps = null;
        temps = value.contains("\\\\n") ? value.split("\\\\n") : value.split("\n");
        String[] stringArray = temps;
        int n = temps.length;
        int n2 = 0;
        while (n2 < n) {
            String temp = stringArray[n2];
            newLineBuffer.append(temp);
            if (isHtml) {
                newLineBuffer.append("<br>");
            } else {
                newLineBuffer.append('\n');
            }
            ++n2;
        }
        return newLineBuffer.toString();
    }

    public static File getTmpResultFilePath() {
        String suffix = String.valueOf(File.separator) + System.currentTimeMillis() + new Random().nextInt(99999);
        File tempPath = new File(String.valueOf(ApplicationContext.getInstance().getTmpPath()) + File.separator + "report" + suffix);
        try {
            if (tempPath.mkdirs()) {
                ToolLoggerFactory.getLogger(SearcherUtilsSilence.class).error("create system temp file path error ." + tempPath.getAbsolutePath());
            }
            return tempPath.getCanonicalFile();
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(SearcherUtilsSilence.class).error("create system temp file path error .", (Throwable)e);
            return null;
        }
    }

    public static Map<String, List<HelpKey>> getHelpKeys(String name, String herf) {
        HashMap<String, List<HelpKey>> helpKeys = new HashMap<String, List<HelpKey>>();
        try {
            String[] herfs;
            if (StringUtils.isNULLStr((String)name) || StringUtils.isNULLStr((String)herf)) {
                return helpKeys;
            }
            String[] keys = name.split("&&");
            String[] stringArray = herfs = herf.split("&&");
            int n = herfs.length;
            int n2 = 0;
            while (n2 < n) {
                String valString = stringArray[n2];
                int index = 1;
                ArrayList<HelpKey> hKeys = new ArrayList<HelpKey>();
                String[] stringArray2 = valString.split(",");
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String url = stringArray2[n4];
                    HelpKey helpKey = new HelpKey();
                    helpKey.setKey(keys[index - 1].trim());
                    helpKey.setUrl(url);
                    helpKey.setLocation(index++);
                    hKeys.add(helpKey);
                    ++n4;
                }
                helpKeys.put(keys[index - 2].trim(), hKeys);
                ++n2;
            }
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(SearchConstant.class).debug("inspect get help key error!", (Throwable)e);
        }
        return helpKeys;
    }

    public static Map<String, List<HelpKey>> getHelpKeys(String key) {
        HashMap<String, List<HelpKey>> helpKeys = new HashMap<String, List<HelpKey>>();
        try {
            String[] keys;
            if (StringUtils.isNULLStr((String)key)) {
                return helpKeys;
            }
            String[] stringArray = keys = key.split("&&");
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String valString = stringArray[n2];
                int index = 1;
                String[] vals = valString.split("\\{");
                String keyString = vals[0].trim();
                String urlString = vals[1].trim();
                int urlLen = urlString.length();
                urlString = urlString.substring(0, urlLen - 1);
                ArrayList<HelpKey> hKeys = new ArrayList<HelpKey>();
                String[] stringArray2 = urlString.split(",");
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String url = stringArray2[n4];
                    HelpKey helpKey = new HelpKey();
                    helpKey.setKey(keyString);
                    helpKey.setUrl(url);
                    helpKey.setLocation(index++);
                    hKeys.add(helpKey);
                    ++n4;
                }
                helpKeys.put(keyString, hKeys);
                ++n2;
            }
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(SearchConstant.class).debug("inspect get help key error!", (Throwable)e);
        }
        return helpKeys;
    }

    public static String replaceKeysByMap(String value, String path, Map<String, List<HelpKey>> helpKeys) {
        String tmp = value;
        for (Map.Entry<String, List<HelpKey>> entry : helpKeys.entrySet()) {
            List<HelpKey> hKeys = entry.getValue();
            tmp = SearcherUtilsSilence.replaceKeys(tmp, path, hKeys);
        }
        return tmp;
    }

    public static String replaceKeys(String value, String path, List<HelpKey> helpKeys) {
        StringBuffer tmp = new StringBuffer();
        path = path.replaceAll("\\\\", "/");
        int ind = 1;
        for (HelpKey helpKey : helpKeys) {
            String keyString = helpKey.getKey();
            String urlString = helpKey.getUrl();
            int index = helpKey.getLocation();
            if (StringUtils.isNULLStr((String)urlString)) {
                ++ind;
                continue;
            }
            urlString = SearcherUtilsSilence.combiationPath(path, urlString);
            StringBuffer replaceBuffer = new StringBuffer();
            replaceBuffer.append("<a class=\"link\" href=\"").append(urlString).append("\" target=\"_blank\">").append(keyString).append("</a>");
            int keyLoc = value.indexOf(keyString);
            if (-1 == keyLoc) {
                ++ind;
                continue;
            }
            String sum = value.substring(0, keyLoc + keyString.length());
            if (ind == index) {
                String targetString = sum.replaceFirst(keyString, replaceBuffer.toString());
                tmp.append(targetString);
                value = value.replace(sum, "");
            }
            ++ind;
        }
        tmp.append(value);
        return tmp.toString();
    }

    private static String combiationPath(String path, String urlString) {
        if (!(urlString.contains("http") || urlString.contains("www") || urlString.contains(".com"))) {
            urlString = StringUtils.isNULLStr((String)path) ? urlString.substring(1, urlString.length()) : String.valueOf(path) + urlString;
        }
        return urlString;
    }

    public static List<ReportLog> replaceAllHelpLink(List<ReportLog> logs) {
        for (ReportLog log : logs) {
            String action = log.getDetail().getAction();
            String helpHref = log.getDetail().getCaseHref();
            String helpName = log.getDetail().getCaseName();
            Map<String, List<HelpKey>> helpKeys = SearcherUtilsSilence.getHelpKeys(helpName, helpHref);
            String valueWithLink = SearcherUtilsSilence.replaceKeysByMap(action, "..", helpKeys);
            log.getDetail().setAction(valueWithLink);
        }
        return logs;
    }

    public static String[] splitHelpHref(String helpHref) {
        String[] splitResult = new String[2];
        if (!StringUtils.isNULLStr((String)helpHref) && !helpHref.equals("{}")) {
            String[] hrefs = helpHref.split("&&");
            StringBuilder caseHref = new StringBuilder();
            StringBuilder caseName = new StringBuilder();
            int index = 0;
            String[] stringArray = hrefs;
            int n = hrefs.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (index > 0) {
                    caseHref.append("&&");
                    caseName.append("&&");
                }
                caseHref.append(string.split("\\{")[1]);
                caseName.append(string.split("\\{")[0]);
                ++index;
                ++n2;
            }
            splitResult[0] = caseHref.toString().replaceAll("\\}", "");
            splitResult[1] = caseName.toString();
        }
        return splitResult;
    }

    public static void copyLocalHelpCase(String productModel, File template) {
        StringBuffer helpSrc = new StringBuffer();
        helpSrc.append(ApplicationContext.getInstance().getPackagesPath());
        helpSrc.append(File.separator).append("AnalyzeLogTool").append(File.separator).append("products").append(File.separator).append(productModel).append(File.separator).append("helpCase");
        StringBuffer helpTarget = new StringBuffer();
        helpTarget.append(template.getAbsolutePath()).append(File.separator).append("data").append(File.separator).append("detail").append(File.separator).append("helpCase");
        if (new File(helpSrc.toString()).exists()) {
            FileUtils.copyDir((String)helpSrc.toString(), (String)helpTarget.toString());
        }
    }

    public static int eventTransitionLog(Map<Long, List<Event>> eventsMap, File xls, IIndexSearchWorkTaker indexSearchWorkTaker, LogRow logRow) {
        int count = 0;
        if (!xls.exists()) {
            return count;
        }
        if (logRow == null) {
            return count;
        }
        Map<String, Integer> eventLocMap = SearcherUtilsSilence.loadEventLoc();
        EventExcelReader reader = new EventExcelReader(xls, eventLocMap);
        logRow.analyzeInterruptedFromStopCommand();
        List<EventDetail> eventDetails = reader.resolveDeviceEntries(logRow, 2);
        File diagnoseXlsFile = new File(xls.getParentFile(), "DiagnoseCode.xls");
        if (diagnoseXlsFile.exists()) {
            Map<String, Integer> diagnoseLocMap = SearcherUtilsSilence.loadDiagnoseLoc();
            EventExcelReader diagnoseReader = new EventExcelReader(diagnoseXlsFile, diagnoseLocMap);
            List<EventDetail> diagnoseDetails = diagnoseReader.resolveDeviceEntries(logRow, 0);
            eventDetails.addAll(diagnoseDetails);
        }
        if (eventDetails.isEmpty()) {
            return count;
        }
        LoadErrorCode.clear();
        LoadErrorCode.setParentFile(xls.getParentFile());
        EventInfos eventInfos = new EventInfos();
        DiagnoseInfos diagnoseInfos = new DiagnoseInfos();
        for (EventDetail eventDetail : eventDetails) {
            count += SearcherUtilsSilence.analyzeEventList(eventsMap, indexSearchWorkTaker, logRow, eventDetail, eventInfos, diagnoseInfos);
        }
        return count;
    }

    private static int analyzeEventList(Map<Long, List<Event>> eventsMap, IIndexSearchWorkTaker indexSearchWorkTaker, LogRow logRow, EventDetail eventDetail, EventInfos eventInfos, DiagnoseInfos diagnoseInfos) {
        int count = 0;
        Locale locale = LanguageManager.getInstance().getCurrentLanguage();
        logRow.analyzeInterruptedFromStopCommand();
        long event16DetailID = Long.parseLong(eventDetail.getAlarmID().toUpperCase(locale).replaceFirst("0X", ""), 16);
        if (eventsMap.containsKey(event16DetailID)) {
            List<Event> eventList = eventsMap.get(event16DetailID);
            for (Event event : eventList) {
                logRow.analyzeInterruptedFromStopCommand();
                ResultViewInfo resultViewInfo = SearcherUtilsSilence.getResultViewInfoOfLocale(eventDetail, locale, event);
                Log log = new Log("", "", "", "", "", "", "");
                log.setDate(event.getLocalTime());
                log.setOriginalStr(event.getOrigin());
                log.setId(event.getAlarmID());
                log.setLevel(event.getAlarmLevel());
                log.setRecoveredLocalTime(event.getRecoveredLocalTime());
                log.setDesc(event.getDescription());
                log.setLogPath(FileUtil.getFilePath(event.getFile()));
                log.setType(event.getType());
                log.setSequence(event.getSequence());
                log.setpId(event.getpId());
                ArrayList<Log> logs = new ArrayList<Log>();
                logs.add(log);
                HashSet<ErrorCodeResult> results = new HashSet<ErrorCodeResult>();
                count += SearcherUtilsSilence.errorCode(indexSearchWorkTaker, logRow, event, results, eventInfos, diagnoseInfos);
                HashMap<SingleLogSearchRule, List<Log>> ruleLogResult = new HashMap<SingleLogSearchRule, List<Log>>();
                SingleLogSearchRule rule = new SingleLogSearchRule();
                rule.setLogRecordReturn(SingleLogSearchRule.LogRecordReturn.ALL);
                ruleLogResult.put(rule, logs);
                OldRule oneRule = new OldRule();
                oneRule.setResultViewInfo(resultViewInfo);
                AnalyzeResult ret = indexSearchWorkTaker.analyze(oneRule, ruleLogResult, logRow);
                ++count;
            }
        }
        return count;
    }

    private static int errorCode(IIndexSearchWorkTaker indexSearchWorkTaker, LogRow logRow, Event event, Set<ErrorCodeResult> results, EventInfos eventInfos, DiagnoseInfos diagnoseInfos) {
        int count = 0;
        if (results.isEmpty()) {
            return count;
        }
        if (event.getOrigin().contains("The error code is") || event.getOrigin().contains("Error code:")) {
            for (ErrorCodeResult result : results) {
                if (result.getLogs().isEmpty()) continue;
                OldRule tmpRule = new OldRule();
                HashMap<SingleLogSearchRule, List<Log>> tmpRuleLogResult = new HashMap<SingleLogSearchRule, List<Log>>();
                SingleLogSearchRule tmpSearchRule = new SingleLogSearchRule();
                tmpSearchRule.setLogRecordReturn(SingleLogSearchRule.LogRecordReturn.ALL);
                tmpRule.setResultViewInfo(result.getResultViewInfo());
                tmpRuleLogResult.put(tmpSearchRule, result.getLogs());
                AnalyzeResult tmpRet = indexSearchWorkTaker.analyze(tmpRule, tmpRuleLogResult, logRow);
                MainLogAnaDialog.getInstance().fillEventAndDiagnoseData(tmpRuleLogResult, tmpRet, logRow, eventInfos, diagnoseInfos);
                ++count;
            }
        }
        return count;
    }

    private static ResultViewInfo getResultViewInfoOfLocale(EventDetail eventDetail, Locale locale, Event event) {
        ResultViewInfo resultViewInfo = new ResultViewInfo();
        resultViewInfo.getViewInfos().add((KeyValue<String, String>)new KeyValue((Object)"issue_no", (Object)"--"));
        if (locale.getLanguage().equals(Locale.ENGLISH.getLanguage())) {
            resultViewInfo.getViewInfos().add((KeyValue<String, String>)new KeyValue((Object)"issue_desc", (Object)eventDetail.getEventNameEn()));
            resultViewInfo.getViewInfos().add((KeyValue<String, String>)new KeyValue((Object)"detail_info", (Object)eventDetail.getEventDetailEn()));
            resultViewInfo.getViewInfos().add((KeyValue<String, String>)new KeyValue((Object)"moduleInfo", (Object)event.getpId()));
            resultViewInfo.getViewInfos().add((KeyValue<String, String>)new KeyValue((Object)"root_cause", (Object)eventDetail.getEventCaseEn()));
            resultViewInfo.getViewInfos().add((KeyValue<String, String>)new KeyValue((Object)"action", (Object)eventDetail.getSuggestionEn()));
        } else {
            resultViewInfo.getViewInfos().add((KeyValue<String, String>)new KeyValue((Object)"issue_desc", (Object)eventDetail.getEventNameZh()));
            resultViewInfo.getViewInfos().add((KeyValue<String, String>)new KeyValue((Object)"detail_info", (Object)eventDetail.getEventDetailZh()));
            resultViewInfo.getViewInfos().add((KeyValue<String, String>)new KeyValue((Object)"moduleInfo", (Object)event.getpId()));
            resultViewInfo.getViewInfos().add((KeyValue<String, String>)new KeyValue((Object)"root_cause", (Object)eventDetail.getEventCaseZh()));
            resultViewInfo.getViewInfos().add((KeyValue<String, String>)new KeyValue((Object)"action", (Object)eventDetail.getSuggestionZh()));
        }
        resultViewInfo.getViewInfos().add(2, (KeyValue<String, String>)new KeyValue((Object)"issue_ver", (Object)eventDetail.getVersion()));
        resultViewInfo.getViewInfos().add((KeyValue<String, String>)new KeyValue((Object)"prod_list", (Object)eventDetail.getProList()));
        return resultViewInfo;
    }

    public static void clearReportTmp(boolean isDelDetailDir, File template) throws IOException {
        File dataFile = new File(template, "data");
        File[] excludeFiles = new File[]{new File(dataFile, "css"), new File(dataFile, "js"), new File(dataFile, "head"), new File(dataFile, "detail")};
        FileUtils.deleteAllInFolder((String)dataFile.getCanonicalPath(), (File[])excludeFiles);
        FileUtils.deleteFile((File)new File(template, "index.html"));
        FileUtils.deleteFile((File)new File(dataFile, "head" + File.pathSeparator + "cover.html"));
        if (isDelDetailDir) {
            FileUtils.deleteAllInFolder((String)new File(dataFile, "detail").getCanonicalPath());
        }
    }

    public static List<String> listTrim(List<String> srcList) {
        ArrayList<String> targetList = new ArrayList<String>();
        for (String str : srcList) {
            targetList.add(str.trim());
        }
        return targetList;
    }

    public static void linkage(final JComboBox first, final IsmTableCell.ComboBoxCell second, final TableRow<Integer, Long> row, final int index) {
        first.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (1 == e.getStateChange()) {
                    String item = ResourceUtil.getString((String)"info.analyze.maindialog.btn.browsxml");
                    String tmpString = ResourceUtil.getString((String)"info.nanlyze.package.version");
                    if (item.equals(first.getSelectedItem().toString())) {
                        row.setValueAt(2, (Object)tmpString);
                        return;
                    }
                    JComboBox jComboBox = second.getComboBox();
                    jComboBox.setEditable(true);
                    jComboBox.removeAllItems();
                    for (Version version : DeviceType.getModel(first.getSelectedItem().toString()).getVersionList()) {
                        jComboBox.addItem(version.getValue());
                    }
                    second.setSelectedItem(jComboBox.getItemAt(index));
                    row.setValueAt(2, (Object)second);
                    ToolLoggerFactory.getLogger(SearcherUtilsSilence.class).info("select device model is:" + first.getSelectedItem());
                    ToolLoggerFactory.getLogger(SearcherUtilsSilence.class).info("select device verison is:" + second);
                }
            }
        });
    }

    public static String getProInfoByConfig(RuleFileConfig config, String logName) {
        int sign = 0;
        String reslut = "";
        String productName = "";
        for (PackageInfo info : LoganalyzerContext.getInstance().getPackageInfos()) {
            if (!info.getLogFileName().equals(logName)) continue;
            productName = String.valueOf(info.getModel()) + info.getVersion();
        }
        List<String> values = null;
        values = config.getSupportTypes();
        values = SearcherUtilsSilence.listTrim(values);
        for (String string : values) {
            if (!productName.contains(string) || string.length() <= sign) continue;
            reslut = string;
            sign = string.length();
        }
        return reslut;
    }

    public static String getPropertyInfoByConfig(RuleFileConfig config, String logName) {
        int sign = 0;
        String reslut = "";
        String productName = "";
        String spcVersion = "";
        for (PackageInfo info : LoganalyzerContext.getInstance().getPackageInfos()) {
            if (!info.getLogFileName().equals(logName)) continue;
            productName = String.valueOf(info.getModel()) + info.getVersion();
            spcVersion = SearcherUtilsSilence.spcVersionFilter(info.getVersion());
        }
        List<String> values = null;
        values = config.getSupporttVersions();
        values = SearcherUtilsSilence.listTrim(values);
        for (String string : values) {
            if (!productName.contains(string) || string.length() <= sign) continue;
            reslut = spcVersion;
            sign = string.length();
        }
        return reslut;
    }

    public static String spcVersionFilter(String spcVersion) {
        if ((spcVersion = spcVersion.trim()).equals("")) {
            return spcVersion;
        }
        return spcVersion.substring(spcVersion.length() - 4).matches("B\\d{3}") ? spcVersion.substring(0, spcVersion.length() - 4) : spcVersion;
    }

    public static LogRow getLogRow(Callable<Object> serviceTask) {
        if (serviceTask instanceof DoLogAnalyze.LogAnalyzeQueryCallable) {
            DoLogAnalyze.LogAnalyzeQueryCallable callable = (DoLogAnalyze.LogAnalyzeQueryCallable)serviceTask;
            return callable.getRow();
        }
        return null;
    }

    public static List<File> getEventFile(File file) {
        ArrayList<File> eventFiles = new ArrayList<File>();
        File[] subDirs = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (subDirs != null && subDirs.length != 0) {
            int i = 0;
            while (i < subDirs.length) {
                File newFile = new File(subDirs[i] + File.separator + EVENT_PATH + File.separator + EVENT_FILE);
                eventFiles.add(newFile);
                ++i;
            }
        }
        return eventFiles;
    }

    public static List<File> getMessageFiles(File file) {
        ArrayList<File> messageFiles = new ArrayList<File>();
        File[] subDirs = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (subDirs != null && subDirs.length != 0) {
            int i = 0;
            while (i < subDirs.length) {
                File message = new File(subDirs[i], "Messages");
                if (message.exists()) {
                    File[] msgFiles = FileListFileFilterUtils.fileList(message, new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.isFile() && pathname.getName().startsWith("message");
                        }
                    });
                    messageFiles.addAll(Arrays.asList(msgFiles));
                }
                ++i;
            }
        }
        return messageFiles;
    }

    public static void setSelectDate(File logFile, File explorDir) {
        String selectDate = SearchConstant.getInstant().getDate();
        long currDate = SearcherUtilsSilence.getLastDate(logFile, explorDir);
        SearchConstant.getInstant().setStartTime(StringUtils.formatDate((Object)(currDate - 86400000L * (long)Integer.parseInt(selectDate)), (String)"yyyy-MM-dd HH:mm:ss"));
        SearchConstant.getInstant().setEndTime(StringUtils.formatDate((Object)currDate, (String)"yyyy-MM-dd HH:mm:ss"));
    }

    public static long getLastDate(File logFile, File explorDir) {
        long currDate = 0L;
        for (File eventFile : SearcherUtilsSilence.getEventFile(SearcherUtilsSilence.getLogPath(explorDir))) {
            if (!eventFile.exists()) continue;
            currDate = eventFile.lastModified();
            break;
        }
        if (currDate == 0L) {
            currDate = logFile.lastModified();
        }
        return currDate;
    }

    public static void doRefreshDetailArea(ILogListener loglistener, String resource, int progress, List<ExecuteResult> executeResultList, LogRow logRow) {
        ExecuteResult resultTemp = null;
        if (progress == 100 || progress == 50) {
            for (ExecuteResult result : executeResultList) {
                if (!resource.equals(result.getDescription()) || result.getProgress() != 0) continue;
                resultTemp = result;
                executeResultList.remove(result);
                break;
            }
        }
        if (resultTemp != null) {
            resultTemp.setProgress(progress);
            executeResultList.add(resultTemp);
        } else {
            executeResultList.add(SearcherUtilsSilence.createExecuteResult(resource, progress));
        }
        if (logRow != null) {
            loglistener.doRefreshProcessMessage(executeResultList, logRow);
            loglistener.doRefreshProcessEvent(executeResultList, logRow);
        }
    }

    public static ExecuteResult createExecuteResult(String description, int progress) {
        ExecuteResult result = new ExecuteResult();
        result.setDescription(description);
        result.setProgress(progress);
        return result;
    }

    /*
     * Exception decompiling
     */
    public static String loadDateByLog(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void deletAllTmpFiles() {
        String tempFilePath = SearchConstant.getInstant().getTemp();
        File indexTmpDir = new File(tempFilePath, "infoAnalyzerIndexDir");
        File srcTmpLogDir = new File(tempFilePath, "InfoAnalyzer_LogSrcDir");
        SearcherUtilsSilence.deleteTempFile(indexTmpDir);
        SearcherUtilsSilence.deleteTempFile(srcTmpLogDir);
    }

    public static void deleteTempFile(File file) {
        int time = 0;
        try {
            ToolLoggerFactory.getLogger(SearcherUtilsSilence.class).info("Delete temp file :" + file.getAbsolutePath());
            while (file.exists() && time < 3) {
                FileAssistant.clearDir((String)file.getAbsolutePath());
                Thread.sleep(3000L);
                ++time;
            }
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(SearcherUtilsSilence.class).error("Delete temp file failed", (Throwable)e);
        }
    }

    public static void copyFiles(File srcFile, File tarDir, String name) {
        if (srcFile.isFile()) {
            if (SearcherUtilsSilence.isDeCompressFile(srcFile) || srcFile.getName().endsWith(".gz")) {
                return;
            }
            StreamUtils.copyFile((File)srcFile, (File)new File(tarDir, String.valueOf(name) + srcFile.getName()));
            return;
        }
        File[] fileArray = FileListFileFilterUtils.fileList(srcFile, null);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File tmpFile = fileArray[n2];
            SearcherUtilsSilence.copyFiles(tmpFile, tarDir, name);
            ++n2;
        }
    }

    public static void writeStringToFile(String message, File file) {
        block5: {
            FileOutputStream fileOutputStream = null;
            OutputStreamWriter writer = null;
            BufferedWriter bufferedWriter = null;
            try {
                try {
                    fileOutputStream = new FileOutputStream(file);
                    writer = new OutputStreamWriter((OutputStream)fileOutputStream, "utf-8");
                    bufferedWriter = new BufferedWriter(writer);
                    bufferedWriter.write(message);
                    bufferedWriter.flush();
                }
                catch (Exception e) {
                    ToolLoggerFactory.getLogger(SearcherUtilsSilence.class).error("Write message failed.", (Throwable)e);
                    StreamUtils.closeResource(bufferedWriter, bufferedWriter);
                    StreamUtils.closeResource(null, (Closeable)writer);
                    StreamUtils.closeResource(null, (Closeable)fileOutputStream);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(bufferedWriter, bufferedWriter);
                StreamUtils.closeResource(null, writer);
                StreamUtils.closeResource(null, (Closeable)fileOutputStream);
                throw throwable;
            }
            StreamUtils.closeResource((Flushable)bufferedWriter, (Closeable)bufferedWriter);
            StreamUtils.closeResource(null, (Closeable)writer);
            StreamUtils.closeResource(null, (Closeable)fileOutputStream);
        }
    }

    public static void writeTempPathToFile(String message, File file) {
        block5: {
            FileOutputStream fileOutputStream = null;
            OutputStreamWriter writer = null;
            BufferedWriter bufferedWriter = null;
            try {
                try {
                    fileOutputStream = new FileOutputStream(file, true);
                    writer = new OutputStreamWriter((OutputStream)fileOutputStream, "utf-8");
                    bufferedWriter = new BufferedWriter(writer);
                    bufferedWriter.write(message);
                    bufferedWriter.newLine();
                    bufferedWriter.flush();
                }
                catch (Exception e) {
                    ToolLoggerFactory.getLogger(SearcherUtilsSilence.class).error("Write message failed.", (Throwable)e);
                    StreamUtils.closeResource(bufferedWriter, bufferedWriter);
                    StreamUtils.closeResource(null, (Closeable)writer);
                    StreamUtils.closeResource(null, (Closeable)fileOutputStream);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(bufferedWriter, bufferedWriter);
                StreamUtils.closeResource(null, writer);
                StreamUtils.closeResource(null, (Closeable)fileOutputStream);
                throw throwable;
            }
            StreamUtils.closeResource((Flushable)bufferedWriter, (Closeable)bufferedWriter);
            StreamUtils.closeResource(null, (Closeable)writer);
            StreamUtils.closeResource(null, (Closeable)fileOutputStream);
        }
    }

    public static String changeTime(int time) {
        String timeString = "";
        if (time == 1) {
            timeString = ResourceUtil.getStringWithParams((String)"info.analyze.problemtable.detail.beginsearch.minute", (Object[])new Object[]{time});
            return timeString;
        }
        if (time < 60) {
            timeString = ResourceUtil.getStringWithParams((String)"info.analyze.problemtable.detail.beginsearch.minutes", (Object[])new Object[]{time});
        }
        if (time >= 60) {
            timeString = time % 60 == 0 ? ResourceUtil.getStringWithParams((String)"info.analyze.problemtable.detail.beginsearch.hours", (Object[])new Object[]{time / 60}) : ResourceUtil.getStringWithParams((String)"info.analyze.problemtable.detail.beginsearch.hoursandminutes", (Object[])new Object[]{time / 60, time % 60});
        }
        return timeString;
    }

    public static List<File> getPowerFiles(File file) {
        ArrayList<File> messageFiles = new ArrayList<File>();
        File[] subDirs = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (subDirs != null && subDirs.length != 0) {
            int i = 0;
            while (i < subDirs.length) {
                File message = new File(subDirs[i], "Messages");
                if (message.exists()) {
                    File[] msgFiles = FileListFileFilterUtils.fileList(message, new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            String name = pathname.getName();
                            return pathname.isFile() && name.contains("power") && name.endsWith(".txt");
                        }
                    });
                    messageFiles.addAll(Arrays.asList(msgFiles));
                }
                ++i;
            }
        }
        return messageFiles;
    }

    public static double getVerifyValue(int size) {
        double value = 0.0;
        switch (size / 100) {
            case 1: {
                value = 2.0;
                break;
            }
            case 2: {
                value = 1.5;
                break;
            }
            case 3: {
                value = 1.5;
                break;
            }
            case 4: {
                value = 1.2;
                break;
            }
            case 5: {
                value = 1.2;
                break;
            }
            case 6: {
                value = 1.1;
                break;
            }
            case 7: {
                value = 1.1;
                break;
            }
            case 8: {
                value = 1.0;
                break;
            }
            case 9: {
                value = 1.0;
                break;
            }
            case 10: {
                value = 1.0;
                break;
            }
            case 20: {
                value = 0.8;
                break;
            }
            case 30: {
                value = 0.8;
                break;
            }
            default: {
                value = 0.8;
            }
        }
        return value;
    }

    public static boolean isDeCompressFile(File file) {
        String[] stringArray = DECOPMRESS_TYPES;
        int n = DECOPMRESS_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (file.getName().endsWith(type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getDeComFileWithoutType(File file) {
        String[] stringArray = DECOPMRESS_TYPES;
        int n = DECOPMRESS_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            String name = file.getName();
            if (name.endsWith(type)) {
                return name.replace(type, "");
            }
            ++n2;
        }
        return "";
    }

    public static String getSameStr(String str, String other, int strBegin, int otherBegin, int len) {
        int index = len;
        while (str.regionMatches(strBegin, other, otherBegin, index)) {
            ++index;
        }
        return str.substring(strBegin, index + strBegin - 1);
    }

    public static boolean isOnSetDate(long date) {
        String startDateString = SearchConstant.getInstant().getStartTime();
        String endDateString = SearchConstant.getInstant().getEndTime();
        long startDate = 0L;
        long endDate = 0L;
        if (!StringUtils.isNULLStr((String)startDateString)) {
            startDate = StringUtils.parseDate2Long((String)startDateString, (String)"yyyy-MM-dd HH:mm:ss");
        }
        endDate = !StringUtils.isNULLStr((String)endDateString) ? StringUtils.parseDate2Long((String)endDateString, (String)"yyyy-MM-dd HH:mm:ss") : Long.MAX_VALUE;
        if (date == 0L) {
            return true;
        }
        return endDate >= date && startDate <= date;
    }

    public static boolean isOnSetDateMsgFile(File pathname) {
        String fristLogTime;
        if (!pathname.getName().contains("message")) {
            return true;
        }
        String startDateString = SearchConstant.getInstant().getStartTime();
        String endDateString = SearchConstant.getInstant().getEndTime();
        String fileDate = StringUtils.findMatchStr((String)pathname.getName(), (String)"((\\d{4})([0-1]\\d)([0-3]\\d)([0-5]\\d)([0-5]\\d)([0-5]\\d))");
        long logFileDate = 0L;
        long startDate = 0L;
        long fristLogDate = 0L;
        long endDate = 0L;
        if (!StringUtils.isNULLStr((String)startDateString)) {
            startDate = StringUtils.parseDate2Long((String)startDateString, (String)"yyyy-MM-dd HH:mm:ss");
        }
        if (!StringUtils.isNULLStr((String)endDateString)) {
            endDate = StringUtils.parseDate2Long((String)endDateString, (String)"yyyy-MM-dd HH:mm:ss");
        }
        if (!StringUtils.isNULLStr((String)(fristLogTime = SearcherUtilsSilence.loadDateByLog(pathname)))) {
            fristLogDate = StringUtils.parseDate2Long((String)fristLogTime, (String)"yyyy-MM-dd HH:mm:ss");
        }
        if (StringUtils.isNULLStr((String)fileDate)) {
            return endDate >= fristLogDate && startDate <= logFileDate;
        }
        logFileDate = StringUtils.parseDate2Long((String)fileDate, (String)"yyyyMMddHHmmss");
        return startDate <= logFileDate;
    }

    public static String getLastVersion(String version) {
        String[] splits = version.split(" ");
        int lastIndex = splits.length - 1;
        String deviceVersion = splits[lastIndex];
        return deviceVersion;
    }

    public static void deleteAllTemp() {
        Set<String> allTempDir = LoganalyzerContext.getInstance().getTempFiles();
        if (allTempDir.isEmpty()) {
            return;
        }
        for (String tempDir : allTempDir) {
            FileUtils.deleteAllInFolder((String)tempDir);
        }
    }

    public static void deleteExistTemp(List<TableRow<LogRow, Long>> selectedLogRows) {
        for (TableRow<LogRow, Long> logRow : selectedLogRows) {
            String existTempFile = logRow.getValueAt(0).toString();
            Map<String, File> logMappingName = LoganalyzerContext.getInstance().getLogTempMap();
            if (logMappingName.isEmpty()) {
                return;
            }
            for (String logNameString : logMappingName.keySet()) {
                SearcherUtilsSilence.deleteOverTemp(existTempFile, logMappingName, logNameString);
            }
        }
    }

    private static void deleteOverTemp(String existTempFile, Map<String, File> logMappingName, String logNameString) {
        if (existTempFile.equals(logNameString)) {
            final File tempDir = logMappingName.get(logNameString);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    SearcherUtilsSilence.deleteTempFile(tempDir);
                }
            }).start();
        }
    }

    public static void refreshCurLog(TableRow<LogRow, Long> logRows, MainLogAnaLayout layout) {
        String selectLogRowName = logRows.getValueAt(0).toString();
        Iterator<LogRow> curLogRowIterea = LoganalyzerContext.getInstance().getCurLogRows().iterator();
        HashSet<LogRow> deleteLogRows = new HashSet<LogRow>();
        while (curLogRowIterea.hasNext()) {
            LogRow logRow = curLogRowIterea.next();
            if (!logRow.getLogFile().getName().equals(selectLogRowName)) continue;
            deleteLogRows.add(logRow);
        }
        LoganalyzerContext.getInstance().getCurLogRows().removeAll(deleteLogRows);
        for (LogRow tmpLogRow : LoganalyzerContext.getInstance().getCurLogRows()) {
            tmpLogRow.setSelectRow(layout.getPackageProTableModel().getRowIndex(tmpLogRow.getRow()));
        }
    }

    public static void clearData(LogRow row, MainLogAnaLayout layout, boolean action) {
        LoganalyzerContext.getInstance().getEvents().clear();
        row.clearCache();
        layout.getMessageDetailList().setModel(row.getListModel());
        if (action) {
            layout.getPackageTable().clearSelection();
            int index = 0;
            int tmp = 0;
            while (tmp < layout.getPackageTable().getAllRows().size()) {
                if (row.getSelectRow() == layout.getPackageTable().convertRowIndexToModel(tmp)) {
                    index = tmp;
                }
                ++tmp;
            }
            layout.getPackageTable().addRowSelectionInterval(index, index);
        }
        LoganalyzerContext.getInstance().setHasDoAnalyzeEvent(true);
        layout.getSearchedProTableModel().removeRow(new TableRow[]{row.getRow()});
        LoganalyzerContext.getInstance().setHasDoAnalyzeLog(true);
    }

    public static boolean isCommonLogLine(String line) {
        return line.contains("[") && line.contains("]");
    }

    public static String alarmLevel(String alarmEn) {
        String alarmZh = alarmEn.equals("Major") ? ResourceUtil.getString((String)"info.analyze.major") : (alarmEn.equals("Warning") ? ResourceUtil.getString((String)"info.analyze.warning") : (alarmEn.equals("Critical") ? ResourceUtil.getString((String)"info.analyze.critical") : "--"));
        return alarmZh;
    }

    public static String alarmLevelI18n(String alarmEn) {
        String alarmZh = alarmEn.equals("Major") ? "info.analyze.major" : (alarmEn.equals("Warning") ? "info.analyze.warning" : (alarmEn.equals("Critical") ? "info.analyze.critical" : "--"));
        return alarmZh;
    }

    public static List<File> getAllverMap() {
        File[] products;
        ArrayList<File> vers = new ArrayList<File>();
        File config = new File(ComponentDefine.CONFIG_PATH);
        File[] fileArray = products = FileListFileFilterUtils.fileList(config, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        int n = products.length;
        int n2 = 0;
        while (n2 < n) {
            File product = fileArray[n2];
            File ver = new File(product, VERMAP_INI);
            if (ver.exists()) {
                vers.add(ver);
            }
            ++n2;
        }
        return vers;
    }

    public static String getVersionByMap(List<File> verMaps, String key) {
        String version = key;
        for (File ver : verMaps) {
            IniReader reader = new IniReader(ver);
            String info = reader.getString(key);
            if (StringUtils.isNULLStr((String)info)) continue;
            version = info.split("\\|")[0];
            break;
        }
        return version;
    }

    private static Map<String, Integer> loadEventLoc() {
        HashMap<String, Integer> eventLocMap = new HashMap<String, Integer>();
        eventLocMap.put("alarmId", 9);
        eventLocMap.put("eventNameZh", 11);
        eventLocMap.put("eventNameEn", 20);
        eventLocMap.put("eventDetailZh", 14);
        eventLocMap.put("eventDetailEn", 23);
        eventLocMap.put("eventCaseZh", 16);
        eventLocMap.put("eventCaseEn", 25);
        eventLocMap.put("suggestionZh", 17);
        eventLocMap.put("suggestionEn", 26);
        return eventLocMap;
    }

    private static Map<String, Integer> loadDiagnoseLoc() {
        HashMap<String, Integer> diagnoseLocMap = new HashMap<String, Integer>();
        diagnoseLocMap.put("alarmId", 6);
        diagnoseLocMap.put("eventNameZh", 8);
        diagnoseLocMap.put("eventNameEn", 17);
        diagnoseLocMap.put("eventDetailZh", 11);
        diagnoseLocMap.put("eventDetailEn", 20);
        diagnoseLocMap.put("eventCaseZh", 13);
        diagnoseLocMap.put("eventCaseEn", 22);
        diagnoseLocMap.put("suggestionZh", 14);
        diagnoseLocMap.put("suggestionEn", 23);
        return diagnoseLocMap;
    }

    public static List<File> showConfigInfoFiles(File dir) {
        ArrayList<File> files = new ArrayList<File>();
        File[] fs = dir.listFiles();
        if (fs != null) {
            int i = 0;
            while (i < fs.length) {
                if (fs[i].isDirectory()) {
                    List<File> tempfs = SearcherUtilsSilence.showConfigInfoFiles(fs[i]);
                    if (!tempfs.isEmpty()) {
                        for (File file : tempfs) {
                            files.add(file);
                        }
                    }
                } else {
                    files.add(new File(fs[i].getAbsolutePath()));
                }
                ++i;
            }
        }
        return files;
    }

    public static void addHighlight(JTextArea textArea, String keyword, Color color) {
        String textInText = textArea.getText();
        keyword = keyword.trim();
        int index = textInText.indexOf(keyword);
        while (index != -1 && !keyword.equals("")) {
            try {
                textArea.getHighlighter().addHighlight(index, index + keyword.length(), new DefaultHighlighter.DefaultHighlightPainter(color));
            }
            catch (BadLocationException e) {
                LOGGER.error("addHighlight is error:", (Throwable)e);
            }
            index = textInText.indexOf(keyword, index + keyword.length());
        }
    }

    public static void printMemory() {
        MemoryMXBean memorymbean = ManagementFactory.getMemoryMXBean();
        long usedMemory = memorymbean.getHeapMemoryUsage().getUsed();
        long totalMemory = memorymbean.getHeapMemoryUsage().getMax();
        long usedMega = usedMemory / 1024L / 1024L;
        long totalMega = totalMemory / 1024L / 1024L;
        String message = new StringBuffer().append("{usedMemory:").append(usedMega).append("MB").append(", totalMemory:").append(totalMega).append("MB").append("}").toString();
        LOGGER.info(message);
    }

    public static long remainderMemory() {
        MemoryMXBean memorymbean = ManagementFactory.getMemoryMXBean();
        long usedMemory = memorymbean.getHeapMemoryUsage().getUsed();
        long totalMemory = memorymbean.getHeapMemoryUsage().getMax();
        long usedMega = usedMemory / 1024L / 1024L;
        long totalMega = totalMemory / 1024L / 1024L;
        return totalMega - usedMega;
    }

    public static String getSaveFilePath(String title, String suffix, Window pDialog, String defaultFileName, String defaultPathId, boolean fileNameEditable, int fileSelectionMode) {
        String endFix = "." + suffix;
        IsmFileChooser ismFileChooser = new IsmFileChooser(title);
        ismFileChooser.setAcceptAllFileFilterUsed(false);
        ismFileChooser.addFileFilter(new String[]{suffix}, endFix);
        String defaultPath = String.valueOf(HibernateContainer.getInstance().get((Object)defaultPathId));
        String string = defaultPath = "null".equals(defaultPath) ? FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath() : defaultPath;
        if (!StringUtils.isNULLStr((String)defaultPath)) {
            File defaultPackagePath = new File(defaultPath);
            ismFileChooser.setCurrentDirectory(defaultPackagePath.isDirectory() ? defaultPackagePath : defaultPackagePath.getParentFile());
        }
        FileChooserWrapper.wrapper((JFileChooser)ismFileChooser);
        FileChooserWrapper.setDefaultFileName((String)defaultFileName, (JFileChooser)ismFileChooser, (boolean)fileNameEditable);
        ismFileChooser.setFileSelectionMode(fileSelectionMode);
        int resultCode = ismFileChooser.showSaveDialog((Component)pDialog);
        if (resultCode != 0) {
            return null;
        }
        File selectedFile = ismFileChooser.getSelectedFile();
        if (selectedFile == null) {
            return null;
        }
        String filePath = selectedFile.getAbsolutePath();
        if (SearcherUtilsSilence.isNwPath(pDialog, filePath)) {
            return null;
        }
        if (filePath.endsWith(".")) {
            int index = filePath.lastIndexOf(46);
            filePath = filePath.substring(0, index);
        }
        if (!filePath.endsWith(endFix)) {
            filePath = String.valueOf(filePath) + endFix;
        }
        if (filePath.length() > 128) {
            DialogUtils.showInfoDialog((Window)pDialog, (String)ResourceUtil.getString((String)"filechooser.prompt.file.max.length"));
            return null;
        }
        HibernateContainer.getInstance().put(defaultPathId, (Object)filePath);
        LOGGER.info("[Save file path >> " + filePath + "][Success]");
        return filePath;
    }

    private static boolean isNwPath(Window parent, String path) {
        if (path.startsWith("\\")) {
            DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getString((String)"filechooser.prompt.file.network.path"));
            return true;
        }
        if (path.contains("  ")) {
            DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getString((String)"filechooser.prompt.file.path.black"));
            return true;
        }
        return false;
    }

    public static void doRefreshFaultTreeArea(MainLogAnaDialog instance, LogRow row) {
        String status = ResourceUtil.getString((String)row.getStauts());
        if (ResourceUtil.getString((String)"info.nanlyze.tabel.type.done").equals(status)) {
            instance.layout.getMainFaultTree().refreshFaultTree(row);
        } else if (ResourceUtil.getString((String)"info.nanlyze.tabel.type.doing").equals(status) || ResourceUtil.getString((String)"info.nanlyze.tabel.type.report").equals(status)) {
            SearcherUtilsSilence.doRefreshProgressBar(instance);
        } else {
            SearcherUtilsSilence.doRefreshDefaultArea(instance);
        }
    }

    public static void doRefreshProgressBar(MainLogAnaDialog instance) {
        instance.layout.getMainFaultTree().showProcess();
    }

    public static void doRefreshDefaultArea(MainLogAnaDialog instance) {
        instance.layout.getMainFaultTree().showDefaultPanel();
    }
}

