/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.silence;

import com.huawei.ism.tool.base.ui.task.TaskResult;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogRow;
import com.huawei.ism.tool.loganalyzer.exception.AutoAnalyzingStopedException;
import com.huawei.ism.tool.loganalyzer.monitor.enumer.ArchiveDirType;
import com.huawei.ism.tool.loganalyzer.monitor.interfaces.IAutoAnalyzeService;
import com.huawei.ism.tool.loganalyzer.silence.DoLogAnalyzeSilence;
import com.huawei.ism.tool.loganalyzer.silence.DoLogPackageSilence;
import com.huawei.ism.tool.loganalyzer.silence.SilenceAnalyzeService;
import com.huawei.ism.tool.loganalyzer.silence.result.Rule;
import com.huawei.ism.tool.loganalyzer.ui.main.MainLogAnaDialog;
import com.huawei.ism.tool.loganalyzer.util.LoganalyzerContext;
import com.huawei.ism.tool.loganalyzer.util.SearchConstant;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;

public class SilenceAnalyzeTask {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SilenceAnalyzeTask.class);
    private IAutoAnalyzeService service = SilenceAnalyzeService.getInstance();
    private boolean ifRunning;

    public List<Rule> start(String model, String version) {
        this.setRunning(true);
        List<LogRow> logRows = null;
        try {
            this.init();
            logRows = this.scanPackagesAndImport();
            this.removeNoMatchVersionLogFile(logRows);
            LOGGER.info("Silence Depress Done!");
            if (!logRows.isEmpty()) {
                this.setAllTimeAnalyze();
                DoLogAnalyzeSilence runAnalyze = new DoLogAnalyzeSilence(logRows);
                List<Rule> list = runAnalyze.logAnalyze(model, version);
                return list;
            }
        }
        catch (Exception e) {
            LOGGER.error("autoAnalyzeTask run exception", (Throwable)e);
            throw e;
        }
        finally {
            if (logRows != null) {
                this.archive(logRows);
            }
        }
        return new ArrayList<Rule>();
    }

    private void removeNoMatchVersionLogFile(List<LogRow> logRows) {
        Iterator<LogRow> it = logRows.iterator();
        while (it.hasNext()) {
            LogRow logRow = it.next();
            Boolean isNotMatchVersion = (Boolean)LoganalyzerContext.getInstance().getWriteVersionMap().get(logRow.getLogFile().getAbsolutePath());
            if (isNotMatchVersion == null) {
                isNotMatchVersion = false;
            }
            if (!isNotMatchVersion.booleanValue()) continue;
            this.service.removeRepeatLogPackage(logRow);
            this.service.achiveLogFile(logRow.getLogFile().getName(), ArchiveDirType.IMPORT_FAIL);
            it.remove();
            LOGGER.warn(" The log file can't match the version, so removed.");
        }
    }

    private void init() {
        this.service.createAutoAnalyzeDir();
    }

    private void archive(List<LogRow> logRows) {
        try {
            for (LogRow logRow : logRows) {
                if (!this.achiveLogFile(logRow)) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            LOGGER.error("archive exception", (Throwable)e);
        }
    }

    private boolean achiveLogFile(LogRow logRow) {
        boolean resultFlag = false;
        if (logRow.getStauts().equals("info.nanlyze.tabel.type.done")) {
            this.service.achiveLogFile(logRow.getLogFile().getName(), ArchiveDirType.ANALYZE_SUCCESS);
        } else if (logRow.getStauts().equals("info.nanlyze.tabel.type.faild")) {
            this.service.achiveLogFile(logRow.getLogFile().getName(), ArchiveDirType.ANALYZE_FAIL);
        }
        resultFlag = true;
        return resultFlag;
    }

    private List<LogRow> scanPackagesAndImport() {
        ArrayList<LogRow> analyzeRows = new ArrayList<LogRow>();
        try {
            List<File> packages = this.scanLogPackages();
            for (File tempPackage : packages) {
                LogRow logRow = new LogRow();
                String packName = tempPackage.getName();
                LoganalyzerContext.getInstance().setImportPackName(packName);
                LoganalyzerContext.getInstance().setImportLogRow(logRow);
                logRow.setLogFile(tempPackage);
                DoLogPackageSilence doPackageThread = new DoLogPackageSilence(logRow);
                if (!tempPackage.exists()) continue;
                TaskResult result = doPackageThread.doPressPackage();
                if ("The disk is not enough".equals(result.getErrorLocaleDescription())) {
                    String defaultTempPath = SearchConstant.getInstant().getTemp();
                    DialogUtils.showInfoDialog((Frame)((Object)MainLogAnaDialog.getInstance()), (String)ResourceUtil.getStringWithParams((String)"info.nanlyze.file.disk.not.enough2", (Object[])new Object[]{defaultTempPath.substring(0, 1)}));
                    break;
                }
                this.service.archiveImportFail(result, logRow.getLogFile().getName());
                if (TaskResult.Result.SUCCESS != result.getResult()) continue;
                logRow.clearAllCache();
                analyzeRows.add(logRow);
            }
        }
        catch (AutoAnalyzingStopedException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("import exception", (Throwable)e);
            throw e;
        }
        return analyzeRows;
    }

    private List<File> scanLogPackages() {
        ArrayList<File> packages = new ArrayList<File>();
        File[] files = this.service.getMonitorDir().listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile() && (file.getName().endsWith(".7z") || file.getName().endsWith(".tgz") || file.getName().endsWith(".tar") || file.getName().endsWith(".zip") || file.getName().endsWith(".bz2"))) {
                    packages.add(file);
                }
                ++n2;
            }
        }
        return packages;
    }

    private void setAllTimeAnalyze() {
        SearchConstant.getInstant().setStartTime("");
        SearchConstant.getInstant().setEndTime("");
        SearchConstant.getInstant().setShowStartTime("");
        SearchConstant.getInstant().setShowEndTime("");
        SearchConstant.getInstant().setDate("");
        SearchConstant.getInstant().setDateType(2);
    }

    private synchronized void setRunning(boolean isRunning) {
        this.ifRunning = isRunning;
    }

    public synchronized boolean isRunning() {
        return this.ifRunning;
    }
}

