/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.silence;

import com.huawei.ism.tool.framework.init.FrameworkInitiator;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.loganalyzer.silence.MainLogAnaDialogSilence;
import com.huawei.ism.tool.loganalyzer.silence.SilenceAnalyze;
import com.huawei.ism.tool.loganalyzer.silence.SilenceAnalyzeService;
import com.huawei.ism.tool.loganalyzer.silence.faulttree.FaultTreeInitializtionSilence;
import com.huawei.ism.tool.loganalyzer.silence.result.Rule;
import com.huawei.ism.tool.loganalyzer.ui.main.MainLogAnaDialog;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SilenceInvoke {
    private static final Logger LOGGER = Logger.getLogger(SilenceInvoke.class);
    private static boolean isInit = false;

    public static synchronized Map<String, Object> analyse(Map<String, String> map) {
        List<Rule> analyseResult = null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            LOGGER.info((Object)("Silence Analyse logPackagePath :" + map.get("logPackagePath")));
            LOGGER.info((Object)("Silence Analyse rulePath :" + map.get("rulePath")));
            LOGGER.info((Object)("Silence Analyse model :" + map.get("model")));
            LOGGER.info((Object)("Silence Analyse version :" + map.get("version")));
            LOGGER.info((Object)("Silence Analyse param :" + map.get("rulePath")));
            LOGGER.info((Object)("Silence Analyse lan :" + map.get("lan")));
            FrameworkInitiator.init();
            if ("zh".equals(map.get("lan"))) {
                LanguageManager.getInstance().setCurrentLanguage(Locale.SIMPLIFIED_CHINESE);
            } else {
                LanguageManager.getInstance().setCurrentLanguage(Locale.ENGLISH);
            }
            ApplicationContext.getInstance();
            if (!isInit) {
                FaultTreeInitializtionSilence.getInstance().initialize(map.get("rulePath"));
                isInit = true;
            }
            new MainLogAnaDialogSilence();
            new MainLogAnaDialog();
            SilenceAnalyzeService.getInstance().setMonitorDir(map.get("logPackagePath"));
            analyseResult = SilenceAnalyze.getInstance().start(map.get("model"), map.get("version"));
            LOGGER.info((Object)("Silence Analyze Done! Find Problem Number:" + analyseResult.size()));
            for (Rule rule : analyseResult) {
                LOGGER.info((Object)("Silence Analyze Result Name:" + rule.getName()));
                LOGGER.info((Object)("Silence Analyze Result ErrMsg:" + rule.getErrMsg()));
                LOGGER.info((Object)("Silence Analyze Result Suggestion:" + rule.getSuggestion()));
                LOGGER.info((Object)("Silence Analyze Result Name:" + rule.getName()));
            }
            hashMap.put("isSuccess", true);
            hashMap.put("errMsg", null);
            hashMap.put("ruleList", analyseResult);
            return hashMap;
        }
        catch (Exception e) {
            hashMap.put("isSuccess", false);
            if ("zh".equals(map.get("lan"))) {
                hashMap.put("errMsg", "\n\u65e5\u5fd7\u5206\u6790\u672a\u5b8c\u6210\uff0c\u4e0d\u652f\u6301\u81ea\u52a8\u8bc4\u4f30.\n\u8bf7\u4f7f\u7528\u4fe1\u606f\u6536\u96c6\u5de5\u5177\u6536\u96c6\u65e5\u5fd7\uff0c\u518d\u6839\u636e\u5f53\u524d\u68c0\u67e5\u9879\u7684\u68c0\u67e5\u89c4\u5219\u5339\u914d\u65e5\u5fd7\u8fdb\u884c\u4eba\u5de5\u5206\u6790");
            } else {
                hashMap.put("errMsg", "\nLog analyse is not complete. Automatic evaluation is not supported. \nCollect logs using the information collection tool, and then perform manual analysis on logs that are matched based on the check rules of the current check items.");
            }
            if (analyseResult != null) {
                hashMap.put("ruleList", analyseResult);
            } else {
                hashMap.put("ruleList", null);
            }
            LOGGER.error((Object)("Silence Analyze Occur error!" + e));
            e.printStackTrace();
            return hashMap;
        }
    }
}

