/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.silence.constent;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.base.utils.XmlWriter;
import com.huawei.ism.tool.framework.platform.PlatformAppContext;
import com.huawei.ism.tool.framework.platform.common.data.DataType;
import com.huawei.ism.tool.framework.platform.common.data.ToolLoginUser;
import com.huawei.ism.tool.framework.platform.common.data.ToolUserRole;
import com.huawei.ism.tool.framework.platform.common.data.UserOpToolData;
import com.huawei.ism.tool.framework.platform.common.tool.AbstractTool;
import com.huawei.ism.tool.framework.platform.common.toolbox.AbstractToolBox;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.listener.HookHandler;
import com.huawei.ism.tool.framework.platform.listener.IListener;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.runtime.AbstractRuntime;
import com.huawei.ism.tool.framework.platform.runtime.impl.AppletRuntime;
import com.huawei.ism.tool.framework.platform.task.IBackgroundTask;
import com.huawei.ism.tool.framework.pubservice.common.IHttpSession;
import com.huawei.ism.tool.framework.pubui.entity.UpdateStatus;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.slf4j.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class SilenceApplicationContext {
    private static final int SLEEP = 500;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SilenceApplicationContext.class);
    private static AbstractRuntime runtime = PlatformAppContext.getInstance().getRuntime();
    private FileOutputStream fos = null;
    private BlockingDeque<Thread> threads = new LinkedBlockingDeque<Thread>();
    private boolean showUpdate = false;
    private boolean blockLcokRealese = true;
    private boolean remind = false;
    private Map<String, String> sslVersionMap = new HashMap<String, String>();
    private String deviceGraphCfgPath = null;
    private String deviceImgCfgPath = null;
    private String toolTypeName = null;
    private String userField = "";
    private boolean isEdit = false;
    private String filePath = null;
    private String userRole = "";
    private boolean isInitUserRole;
    private UserOpToolData userOpData;
    private String sceneDialogFlag = "";
    private static final String SENCEOPERATE_XML = "userAreaSelected.xml";
    private boolean toolStoreActivated = false;
    private UpdateStatus updateRemindStatus;
    private UpdateStatus certificationRemindStatus;
    private String toolboxUploadFileName = "";
    private String supportUser = "unKnown";
    private String userRight = "";
    private ToolLoginUser toolLoginUser = new ToolLoginUser();
    private boolean needLogin = false;
    private boolean customerImprove = false;
    private boolean netConnectFailed = false;
    private static final String TOOLSFOLDER = "tools";
    private static final String UPDATECHECKER = "updatechecker";
    private boolean showActivatingDialog = false;
    private List<IHttpSession> httpSessionList = new ArrayList<IHttpSession>();
    private String applySupportType = "";
    private boolean isOEM = false;
    private static final String OEM_VENDER = "OEM";
    private static final String VENDER_KEY = "tool.vendor";
    private boolean toolboxUpdate = false;
    private boolean toolUpdate = false;
    private static SilenceApplicationContext instance = new SilenceApplicationContext();
    private HookHandler hookHandler = null;
    private String curToolkitUser = System.getProperty("user.name");
    private static final String RUNING_LOG_PATH = "app.log.path";

    private SilenceApplicationContext() {
        String vendor = "";
        this.setOEM(vendor.equalsIgnoreCase(OEM_VENDER));
    }

    public ToolLoginUser getToolLoginUser() {
        if (this.isSpecificDeviceModeConfigured()) {
            ToolLoginUser user = new ToolLoginUser("SVP_User", ToolUserRole.HWENGINEER, ToolUserRole.HWENGINEER);
            user.setBuildInUser(true);
            return user;
        }
        return this.toolLoginUser;
    }

    public void setToolLoginUser(ToolLoginUser toolLoginUser) {
        this.toolLoginUser = toolLoginUser;
    }

    public boolean isToolStoreActivated() {
        return this.toolStoreActivated;
    }

    public UserOpToolData getUserOpData() {
        return this.userOpData;
    }

    public void setUserOpData(UserOpToolData userOpData) {
        this.userOpData = userOpData;
    }

    public void setToolStoreActivated(boolean toolStoreActivated) {
        this.toolStoreActivated = toolStoreActivated;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getSceneDialogFlag() {
        return this.sceneDialogFlag;
    }

    public void setSceneDialogFlag(String sceneDialogFlag) {
        this.sceneDialogFlag = sceneDialogFlag;
    }

    public String getUserField() {
        return this.userField;
    }

    public void setUserField(String userField) {
        this.userField = userField;
    }

    public String getUserRole() {
        return this.userRole;
    }

    public void setUserRole(String userRole) {
        this.userRole = userRole;
    }

    public boolean isBlockLcokRealese() {
        return this.blockLcokRealese;
    }

    public void setBlockLcokRealese(boolean blockLcokRealese) {
        this.blockLcokRealese = blockLcokRealese;
    }

    public boolean isCallHomeEnv() {
        return true;
    }

    public void setToolLockStream(FileOutputStream fops) {
        this.fos = fops;
    }

    public FileOutputStream getToolLockStream() {
        return this.fos;
    }

    public boolean isRemoteLogic() {
        return runtime instanceof AppletRuntime;
    }

    public static synchronized SilenceApplicationContext getInstance() {
        return instance;
    }

    public String getWorkPath() {
        return "D:\\AnalyzeLog\\analycode\\toolkit_Code\\Toolkits_main\\module_CommonTools\\AnalyzeLog";
    }

    public String getHelpPath() {
        return DataType.help.getDirName();
    }

    public String getTmpPath() {
        return DataType.temp.getDirName();
    }

    public String getLibPath() {
        return DataType.lib.getDirName();
    }

    public String getCfgPath() {
        return DataType.cfg.getDirName();
    }

    public String getPluginsCfgPath() {
        return DataType.applicationCfg.getDirName();
    }

    public String getExtToolsPath() {
        return DataType.tools.getDirName();
    }

    public String getExtToolRefreshPath() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.getWorkPath()) + File.separator);
        sb.append(String.valueOf(this.getTmpPath()) + File.separator);
        sb.append("refreshData");
        return sb.toString();
    }

    public String getDownloadPath() {
        return DataType.updates.getDirName();
    }

    public String getPluginPath() {
        return DataType.plugins.getDirName();
    }

    public String getVersion() {
        return runtime.getVersion();
    }

    public String getReleaseDate() {
        return runtime.getReleaseDate();
    }

    public String getVender() {
        return runtime.getVender();
    }

    public String getUserDataPath() {
        return DataType.data.getDirName();
    }

    public Locale[] getSupportedLans() {
        return runtime.getSupportedLans();
    }

    public boolean isEnglishEnv() {
        return runtime.isEnglishEnv();
    }

    public String getCurrentJreVersion() {
        return runtime.getJreVersion();
    }

    public boolean currentJreIsSupport() {
        return runtime.isJreSupported();
    }

    public String getSystemTempPath() {
        return runtime.getSystemTempPath();
    }

    public boolean isOldUI() {
        return "traditional".equalsIgnoreCase(this.getAppConfig("app.ui.type"));
    }

    public boolean isSpecificDeviceMode() {
        return LocalHostUtil.isRunInV3LaterSvp() || "true".equalsIgnoreCase(this.getAppConfig("app.specific.device.mode.enalbed"));
    }

    public boolean isSpecificDeviceModeConfigured() {
        return "true".equalsIgnoreCase(this.getAppConfig("app.specific.device.mode.enalbed"));
    }

    public String getDeviceType() {
        if (LocalHostUtil.isRunInV3LaterSvp() && !SilenceApplicationContext.getInstance().isSpecificDeviceMode()) {
            return "HVS";
        }
        return this.getAppConfig("app.specific.device.type");
    }

    public String getDeviceInnerIPs() {
        LOGGER.debug("isSpecificDeviceModeConfigured():" + this.isSpecificDeviceModeConfigured());
        if (LocalHostUtil.isRunInV3LaterSvp() && !this.isSpecificDeviceModeConfigured()) {
            return this.getAppConfig("app.specific.device.v3r3.inner.ips");
        }
        return this.getAppConfig("app.specific.device.inner.ips");
    }

    public String getDeviceIP() {
        if (LocalHostUtil.isRunInV3LaterSvp() && !this.isSpecificDeviceModeConfigured()) {
            return this.getAppConfig("app.specific.device.v3r3.ip");
        }
        return this.getAppConfig("app.specific.device.ip");
    }

    public boolean isDeviceUsingSSL() {
        if (LocalHostUtil.isRunInV3LaterSvp() && !this.isSpecificDeviceModeConfigured()) {
            return true;
        }
        return "true".equalsIgnoreCase(this.getAppConfig("app.specific.device.ssl"));
    }

    public boolean isWindowsOS() {
        return runtime.isWindowsOS();
    }

    public String getSystemCfg(String key) {
        return runtime.getAppConfig(key);
    }

    public void setJunitIsOpen() {
        runtime.setJUnitMode();
    }

    public boolean isJunit() {
        return runtime.isJunit();
    }

    public String getAppConfig(String key) {
        return runtime.getAppConfig(key);
    }

    public File getUserCfgFile() {
        return runtime.getUserCfgFile();
    }

    public AbstractToolBox getToolContainer() {
        return PlatformAppContext.getInstance().getToolBox();
    }

    public void fireToolStarted(String toolId) {
        AbstractToolBox toolBox = this.getToolContainer();
        if (toolBox != null) {
            toolBox.fireToolStarted(toolId);
        }
    }

    public void fireToolStopped(String toolId) {
        AbstractToolBox toolBox = this.getToolContainer();
        if (toolBox != null) {
            toolBox.fireToolStopped(toolId);
        }
    }

    public void addBackgroundTask(IBackgroundTask task) {
        PlatformAppContext.getInstance().addBackgroundTask(task);
    }

    public void removeBackgroundTask(IBackgroundTask task) {
        PlatformAppContext.getInstance().removeBackgroundTask(task);
    }

    public List<IBackgroundTask> getBackgroundTasks() {
        return PlatformAppContext.getInstance().getBackgroundTasks();
    }

    public List<AbstractTool> getTools() {
        return PlatformAppContext.getInstance().getTools();
    }

    public BlockingDeque<Thread> getThreads() {
        return this.threads;
    }

    public void showDialogs() {
        block2: while (!this.threads.isEmpty()) {
            Thread tmpThread = (Thread)this.threads.pollLast();
            if (tmpThread == null) {
                throw new NullPointerException();
            }
            ToolLoggerFactory.getLogger(this.getClass()).debug("thread name : " + tmpThread.getName());
            tmpThread.start();
            while (tmpThread.isAlive()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    ToolLoggerFactory.getLogger(this.getClass()).error("thread error!", (Throwable)e);
                    continue block2;
                }
            }
        }
    }

    public String getCurToolkitUser() {
        return this.curToolkitUser;
    }

    public void setCurToolkitUser(String curToolkitUser) {
        this.curToolkitUser = curToolkitUser;
    }

    public boolean isShowUpdate() {
        return this.showUpdate;
    }

    public void setShowUpdate(boolean showUpdate) {
        this.showUpdate = showUpdate;
    }

    public boolean isRemind() {
        return this.remind;
    }

    public void setRemind(boolean remind) {
        this.remind = remind;
    }

    public String getDevSslVersion(String devIp) {
        return this.sslVersionMap.get(devIp);
    }

    public void addDevSslVersion(String devIp, String sslVersion) {
        this.sslVersionMap.put(devIp, sslVersion);
    }

    public void addListener(IListener listener) {
        runtime.addListener(listener);
    }

    public void removeListener(IListener listener) {
        runtime.removeListener(listener);
    }

    public <T> List<T> getListenerList(Class<T> classType) {
        return runtime.getListenerList(classType);
    }

    public void setDeviceGraphCfgPath(String deviceGraphCfgPath) {
        this.deviceGraphCfgPath = deviceGraphCfgPath;
    }

    public String getDeviceGraphCfgPath() {
        return this.deviceGraphCfgPath;
    }

    public void setDeviceImgCfgPath(String deviceImgCfgPath) {
        this.deviceImgCfgPath = deviceImgCfgPath;
    }

    public String getDeviceImgCfgPath() {
        return this.deviceImgCfgPath;
    }

    public String getToolTypeName() {
        return this.toolTypeName;
    }

    public void setToolTypeName(String toolTypeName) {
        this.toolTypeName = toolTypeName;
    }

    public boolean isEdit() {
        return this.isEdit;
    }

    public void setEdit(boolean edit) {
        this.isEdit = edit;
    }

    public String getToolboxUploadFileName() {
        return this.toolboxUploadFileName;
    }

    public void setToolboxUploadFileName(String toolboxUploadFileName) {
        this.toolboxUploadFileName = toolboxUploadFileName;
    }

    public String getRunnigLogPath() {
        String runningLogPath = this.getRunningLogPath();
        if (SilenceApplicationContext.isNullStr(runningLogPath)) {
            return this.getWorkPath();
        }
        return runningLogPath;
    }

    private final String getRunningLogPath() {
        String runtimeDataPath = SilenceApplicationContext.getInstance().getAppConfig(RUNING_LOG_PATH);
        if (SilenceApplicationContext.isNullStr(runtimeDataPath)) {
            return "";
        }
        File runtimeFile = new File(runtimeDataPath);
        if (runtimeFile.exists() && !runtimeFile.isDirectory()) {
            return "";
        }
        if (!runtimeFile.exists() && !runtimeFile.mkdirs()) {
            return "";
        }
        return runtimeFile.getAbsolutePath();
    }

    private static boolean isNullStr(String str) {
        return str == null || "".equals(str.trim());
    }

    public void initUserAreaSelected() {
        block11: {
            String xmlFileAbsolutePath = SilenceApplicationContext.getInstance().getXmlAbsolutePath();
            File file = new File(xmlFileAbsolutePath);
            if (file.exists() && !this.isInitUserRole) {
                FileInputStream xmlInput = null;
                try {
                    try {
                        xmlInput = new FileInputStream(file);
                        Document docXMLUserAreaSelected = XmlUtils.parseDocument((InputStream)xmlInput);
                        Element userAreaRoot = docXMLUserAreaSelected.getDocumentElement();
                        if ("".equals(this.userField)) {
                            Element userArea = (Element)userAreaRoot.getElementsByTagName("userArea").item(0);
                            String userAreaSelected = userArea.getTextContent();
                            this.setUserField(userAreaSelected);
                        }
                        Element userRoleElement = XmlUtils.getChild((Element)userAreaRoot, (String)"sceneIntroducedialog");
                        if ("".equals(this.userRole)) {
                            String role = XmlUtils.getTextContentOfChild((Element)userRoleElement, (String)"userType");
                            this.setUserRole(role);
                        }
                        if ("".equals(this.sceneDialogFlag)) {
                            String introduceDialogFlag = XmlUtils.getTextContentOfChild((Element)userRoleElement, (String)"sceneShow");
                            this.setSceneDialogFlag(introduceDialogFlag);
                        }
                        this.isInitUserRole = true;
                    }
                    catch (Exception e) {
                        ToolLoggerFactory.getLogger(this.getClass()).error("\u6253\u5f00XML\u5931\u8d25\uff0c\u6216\u8005\u8bfb\u53d6XML\u5931\u8d25\uff01" + xmlFileAbsolutePath, (Throwable)e);
                        StreamUtils.closeStream(null, (InputStream)xmlInput);
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    StreamUtils.closeStream(null, xmlInput);
                    throw throwable;
                }
                StreamUtils.closeStream(null, (InputStream)xmlInput);
            } else if (!this.isInitUserRole) {
                this.setUserField("Storage");
                this.setUserRole("EnterPrise");
                this.setSceneDialogFlag("IsTheFirstTime");
            }
        }
    }

    public void createUserXml(String pathXMLUserAreaSelected) throws ToolException {
        Document xmlDoc = XmlWriter.createNewDocument();
        Element root = XmlWriter.createTagElement((Document)xmlDoc, (String)"userAreaRoot");
        xmlDoc.appendChild(root);
        if (this.userField == null || this.userField.isEmpty()) {
            this.userField = "Storage";
        }
        Element userAreaElement = XmlWriter.createTagElement((Document)xmlDoc, (String)"userArea");
        CDATASection userFiledText = xmlDoc.createCDATASection(this.userField);
        userAreaElement.appendChild(userFiledText);
        Element senceIntroduceElement = XmlWriter.createTagElement((Document)xmlDoc, (String)"sceneIntroducedialog");
        root.appendChild(userAreaElement);
        root.appendChild(senceIntroduceElement);
        if (this.sceneDialogFlag == null || this.sceneDialogFlag.isEmpty() || "IsTheFirstTime".equals(this.sceneDialogFlag)) {
            this.sceneDialogFlag = "SHOWAGAIN";
        }
        Element sceneShowElement = XmlWriter.createTagElement((Document)xmlDoc, (String)"sceneShow");
        CDATASection sceneShowText = xmlDoc.createCDATASection(this.sceneDialogFlag);
        sceneShowElement.appendChild(sceneShowText);
        if (this.userRole == null || this.userRole.isEmpty()) {
            this.userRole = "EnterPrise";
        }
        Element userTypeElement = XmlWriter.createTagElement((Document)xmlDoc, (String)"userType");
        CDATASection userTypeText = xmlDoc.createCDATASection(this.userRole);
        userTypeElement.appendChild(userTypeText);
        senceIntroduceElement.appendChild(sceneShowElement);
        senceIntroduceElement.appendChild(userTypeElement);
        XmlWriter.writeDomToXmlFile((Document)xmlDoc, (String)pathXMLUserAreaSelected, (boolean)true);
    }

    public void beginWriteFile(String xmlFileAbsolutePath, File file) {
        if (file.exists() && !file.delete()) {
            LOGGER.error("userRolexml file delete failuer!");
        }
        try {
            if (file.createNewFile()) {
                this.createUserXml(xmlFileAbsolutePath);
            }
        }
        catch (Exception e1) {
            LOGGER.error("create userAreaXml file failuer", (Throwable)e1);
        }
    }

    public String getXmlAbsolutePath() {
        String workpath = SilenceApplicationContext.getInstance().getWorkPath();
        String path = String.valueOf(File.separator) + "data" + File.separator;
        StringBuilder senceStringBuilder = new StringBuilder();
        senceStringBuilder.append(workpath);
        senceStringBuilder.append(path);
        senceStringBuilder.append(SENCEOPERATE_XML);
        String senceOperateXmlPath = senceStringBuilder.toString();
        return senceOperateXmlPath;
    }

    public String getSupportUser() {
        return this.supportUser;
    }

    public void setSupportUser(String supportUser) {
        this.supportUser = supportUser;
    }

    public String getUserRight() {
        return this.userRight;
    }

    public void setUserRight(String userRight) {
        this.userRight = userRight;
    }

    public boolean isNeedLogin() {
        return this.needLogin;
    }

    public void setNeedLogin(boolean needLogin) {
        this.needLogin = needLogin;
    }

    public void setNetConnectFailed(boolean netConnectFailed) {
        this.netConnectFailed = netConnectFailed;
    }

    public boolean isNetConnectFailed() {
        return this.netConnectFailed;
    }

    public boolean getCustomerImprove() {
        return this.customerImprove;
    }

    public void setCustomerImprove(boolean customerImprove) {
        this.customerImprove = customerImprove;
    }

    public String getConfigurationPath() {
        return String.valueOf(this.getWorkPath()) + File.separator + "configuration" + File.separator;
    }

    public static boolean isRunInTool() {
        String userDir = SilenceApplicationContext.getInstance().getWorkPath();
        int index = userDir.lastIndexOf(TOOLSFOLDER);
        return -1 != index;
    }

    public static boolean isRunInToolBox() {
        String userDir = SilenceApplicationContext.getInstance().getWorkPath();
        int index = userDir.lastIndexOf(TOOLSFOLDER);
        return -1 == index && !userDir.endsWith(UPDATECHECKER);
    }

    public String getDefaultCerPath() {
        StringBuffer path = new StringBuffer();
        String currWorkPath = this.getCurrWorkPath();
        String pluginsCfgPath = SilenceApplicationContext.getInstance().getPluginsCfgPath();
        path.append(currWorkPath).append(File.separator).append(pluginsCfgPath).append(File.separator).append("defaultCer").append(File.separator);
        LOGGER.info("get default certificate file.");
        return path.toString();
    }

    public String getCurrWorkPath() {
        String userDirs = Normalizer.normalize(SilenceApplicationContext.getInstance().getWorkPath(), Normalizer.Form.NFKC);
        File iniFile = new File(userDirs, "tool.ini");
        File updateFile = new File(userDirs, "updatechecker.exe");
        int index = userDirs.lastIndexOf(TOOLSFOLDER);
        if (-1 != index && iniFile.exists()) {
            LOGGER.info("Tools is getting the toolbox userDir");
            userDirs = userDirs.substring(0, index - 1);
        } else if (userDirs.endsWith(UPDATECHECKER) && updateFile.exists()) {
            LOGGER.info("Updatechecker is getting the toolbox userDir");
            index = userDirs.lastIndexOf(UPDATECHECKER);
            userDirs = userDirs.substring(0, index - 1);
        }
        StringBuilder sbBuilder = new StringBuilder(userDirs);
        sbBuilder.append(File.separator);
        return sbBuilder.toString();
    }

    public synchronized UpdateStatus getUpdateRemindStatus() {
        return this.updateRemindStatus;
    }

    public synchronized void setUpdateRemindStatus(UpdateStatus updateRemindStatus) {
        this.updateRemindStatus = updateRemindStatus;
    }

    public synchronized UpdateStatus getCertificationRemindStatus() {
        return this.certificationRemindStatus;
    }

    public synchronized void setCertificationRemindStatus(UpdateStatus certificationRemindStatus) {
        this.certificationRemindStatus = certificationRemindStatus;
    }

    public boolean isShowActivatingDialog() {
        return this.showActivatingDialog;
    }

    public void setShowActivatingDialog(boolean showActivatingDialog) {
        this.showActivatingDialog = showActivatingDialog;
    }

    public List<IHttpSession> getHttpSessionList() {
        return this.httpSessionList;
    }

    public void closeHttpSession() {
        for (IHttpSession httpSession : this.httpSessionList) {
            httpSession.closeAllSession();
        }
        this.httpSessionList.clear();
    }

    public boolean isOEM() {
        return this.isOEM;
    }

    public String getApplySupportType() {
        return this.applySupportType;
    }

    public void setApplySupportType(String applySupportType) {
        this.applySupportType = applySupportType;
    }

    public void setOEM(boolean oEM) {
        this.isOEM = oEM;
    }

    public boolean isFirstStartBox() {
        boolean res;
        StringBuilder builder = new StringBuilder();
        builder.append(this.getWorkPath()).append(File.separator).append(this.getTmpPath());
        File folder = new File(builder.toString());
        builder.append(File.separator).append("firstStartBoxFlag.xml");
        File file = new File(builder.toString());
        if (file.exists()) {
            return false;
        }
        if (!folder.exists()) {
            res = folder.mkdirs();
            LOGGER.info("the file mkdirs is " + res);
        }
        try {
            res = file.createNewFile();
            LOGGER.info("the file new create is " + res);
        }
        catch (IOException e) {
            LOGGER.error("create firstStartBoxFlag error");
        }
        return true;
    }

    public boolean isToolboxUpdate() {
        return this.toolboxUpdate;
    }

    public void setToolboxUpdate(boolean toolboxUpdate) {
        this.toolboxUpdate = toolboxUpdate;
    }

    public boolean isToolUpdate() {
        return this.toolUpdate;
    }

    public void setToolUpdate(boolean toolUpdate) {
        this.toolUpdate = toolUpdate;
    }

    public void forceToolStopped(String pluginId) {
        AbstractToolBox toolBox = this.getToolContainer();
        if (toolBox != null) {
            LocalHostUtil.killCurrentProcess();
            toolBox.forceToolStopped(pluginId);
        }
    }

    public HookHandler getHookHandler() {
        return this.hookHandler;
    }

    public void setHookHandler(HookHandler hookHandler) {
        this.hookHandler = hookHandler;
    }
}

