/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.silence.decompressor;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.silence.decompressor.DecompressorSilence;
import com.huawei.ism.tool.loganalyzer.silence.decompressor.decompress.Bz2DecompressorSilence;
import com.huawei.ism.tool.loganalyzer.silence.decompressor.decompress.SevenZDecompressorSilence;
import com.huawei.ism.tool.loganalyzer.silence.decompressor.decompress.TarDecompressorSilence;
import com.huawei.ism.tool.loganalyzer.silence.decompressor.decompress.TgzDecompressorSlence;
import com.huawei.ism.tool.loganalyzer.silence.decompressor.decompress.ZipDecompressorSilence;
import com.huawei.ism.tool.loganalyzer.util.IOUtil;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public enum CompressedFileTypeSilence {
    SEVENZ(930790575, SevenZDecompressorSilence.class),
    BZ2(1113221177, Bz2DecompressorSilence.class),
    GZ(529205248, TgzDecompressorSlence.class),
    TGZ(529205256, TgzDecompressorSlence.class),
    TAR(1131376230, TarDecompressorSilence.class),
    TAR1(774861424, TarDecompressorSilence.class),
    TAR2(1668440435, TarDecompressorSilence.class),
    TAR3(774859887, TarDecompressorSilence.class),
    ZIP(1347093252, ZipDecompressorSilence.class),
    ZIP2(1347093766, ZipDecompressorSilence.class);

    private static final Set<String> COMPRESSEDFILETYPESET;
    private static final Map<Integer, Constructor<? extends DecompressorSilence>> DECOMPRESSORCONSTRUCTORMAP;
    private int value;
    private Constructor<? extends DecompressorSilence> decompressorConstructor;

    static {
        COMPRESSEDFILETYPESET = new HashSet<String>();
        DECOMPRESSORCONSTRUCTORMAP = new HashMap<Integer, Constructor<? extends DecompressorSilence>>();
        CompressedFileTypeSilence[] compressedFileTypeSilenceArray = CompressedFileTypeSilence.values();
        int n = compressedFileTypeSilenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompressedFileTypeSilence t = compressedFileTypeSilenceArray[n2];
            DECOMPRESSORCONSTRUCTORMAP.put(t.value, t.decompressorConstructor);
            ++n2;
        }
        COMPRESSEDFILETYPESET.add(".7z");
        COMPRESSEDFILETYPESET.add(".bz2");
        COMPRESSEDFILETYPESET.add(".gz");
        COMPRESSEDFILETYPESET.add(".tgz");
        COMPRESSEDFILETYPESET.add(".rar");
        COMPRESSEDFILETYPESET.add(".tar.gz");
        COMPRESSEDFILETYPESET.add(".tar");
        COMPRESSEDFILETYPESET.add(".zip");
    }

    private CompressedFileTypeSilence(int value, Class<? extends DecompressorSilence> ecompressorClass) {
        this.value = value;
        try {
            this.decompressorConstructor = ecompressorClass.getConstructor(File.class);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(CompressedFileTypeSilence.class).debug("DecompressorConstructor is error:", (Throwable)e);
        }
    }

    public int getValue() {
        return this.value;
    }

    public static boolean validSuffixName(File file) {
        return CompressedFileTypeSilence.validSuffixName(file.getName());
    }

    public static boolean validSuffixName(String fileName) {
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex == -1) {
            return false;
        }
        String suffix = fileName.substring(dotIndex, fileName.length());
        return COMPRESSEDFILETYPESET.contains(suffix);
    }

    public static DecompressorSilence getDecompressor(File file) {
        if (CompressedFileTypeSilence.validSuffixName(file)) {
            int head;
            block5: {
                head = CompressedFileTypeSilence.getFileHeader(file);
                if (head != 0) break block5;
                return null;
            }
            try {
                Constructor<? extends DecompressorSilence> decompressorConstructor = DECOMPRESSORCONSTRUCTORMAP.get(head);
                if (decompressorConstructor != null) {
                    return decompressorConstructor.newInstance(file);
                }
                return CompressedFileTypeSilence.TAR.decompressorConstructor.newInstance(file);
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(CompressedFileTypeSilence.class).debug("GetDecompressor is error:", (Throwable)e);
            }
        }
        return null;
    }

    private static int getFileHeader(File file) throws IOException {
        int value;
        block6: {
            Logger logger = ToolLoggerFactory.getLogger(CompressedFileTypeSilence.class);
            if (file.length() < 4L) {
                return 0;
            }
            FileInputStream fis = null;
            DataInputStream in = null;
            value = 0;
            try {
                try {
                    fis = new FileInputStream(file);
                    in = new DataInputStream(fis);
                    value = in.readInt();
                }
                catch (Exception e) {
                    logger.debug("getFileHeader is error:", (Throwable)e);
                    IOUtil.close(in);
                    IOUtil.close((Closeable)fis);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(in);
                IOUtil.close((Closeable)fis);
                throw throwable;
            }
            IOUtil.close((Closeable)in);
            IOUtil.close((Closeable)fis);
        }
        return value;
    }
}

