/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.silence.decompressor;

import com.huawei.ism.tool.loganalyzer.faulttree.decompress.decompressor.Decompressor;
import com.huawei.ism.tool.loganalyzer.faulttree.decompress.enumer.CompressedFileType;
import com.huawei.ism.tool.loganalyzer.faulttree.decompress.model.DirScanResult;
import com.huawei.ism.tool.loganalyzer.faulttree.decompress.threadpool.DecompressThreadPool;
import com.huawei.ism.tool.loganalyzer.faulttree.decompress.threadpool.DiskIsEnoughThread;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.DiskNotEnoughException;
import com.huawei.ism.tool.loganalyzer.silence.decompressor.CompressedFileTypeSilence;
import com.huawei.ism.tool.loganalyzer.silence.decompressor.DecompressorSilence;
import com.huawei.ism.tool.loganalyzer.util.FileListFileFilterUtils;
import com.huawei.ism.tool.loganalyzer.util.SearcherUtils;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecompressMainSlience {
    private static final String MESSAGE_FILE_NAME = "Messages";
    private static List<String> blackNameList = new ArrayList<String>();
    private static final Logger LOGGER = LoggerFactory.getLogger(DecompressMainSlience.class);
    private static final FileFilter FILE_FILTER;

    static {
        blackNameList.add("kvm");
        blackNameList.add("KVM");
        blackNameList.add("BMC");
        FILE_FILTER = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isFile() && !CompressedFileType.validSuffixName(file)) {
                    return false;
                }
                for (String blackName : blackNameList) {
                    if (!file.getName().contains(blackName)) continue;
                    LOGGER.info("Black Name File or Dir, can't be scaned and decompressed: " + file);
                    return false;
                }
                return true;
            }
        };
    }

    public static void decompress(File zipFile, File output, DiskIsEnoughThread isDiskEnough) {
        DecompressorSilence decompressor = CompressedFileTypeSilence.getDecompressor(zipFile);
        if (decompressor != null) {
            if (!isDiskEnough.isEnough()) {
                LOGGER.debug(String.valueOf(output.getParentFile().getFreeSpace()) + "---->>disk is not enough");
                throw new DiskNotEnoughException("disk is not enough");
            }
            long start = System.currentTimeMillis();
            decompressor.decompress(output);
            DecompressThreadPool pool = new DecompressThreadPool();
            DecompressMainSlience.scanAndDeCompress(output, isDiskEnough, pool);
            pool.destroy();
            isDiskEnough.setDecompressed(true);
            LOGGER.info("Decompress Total Spend Time\uff1a" + (System.currentTimeMillis() - start));
        }
    }

    public static void scanAndDeCompress(File output, DiskIsEnoughThread isDiskEnough, DecompressThreadPool pool) {
        block4: {
            DirScanResult dsr;
            while (true) {
                if (!isDiskEnough.isEnough()) {
                    LOGGER.debug(String.valueOf(output.getParentFile().getFreeSpace()) + "---->>disk is not enough2");
                    throw new DiskNotEnoughException("disk is not enough");
                }
                File[] files = output.listFiles(FILE_FILTER);
                if (files == null) break block4;
                dsr = new DirScanResult(files);
                List<Decompressor> decompressorList = dsr.getDecompressorList();
                if (decompressorList.isEmpty()) break;
                pool.execute(decompressorList);
            }
            if (!dsr.getDirList().isEmpty()) {
                for (File file : dsr.getDirList()) {
                    DecompressMainSlience.scanAndDeCompress(file, isDiskEnough, pool);
                    DecompressMainSlience.copyPowerOnOrOffLogToMessageDir(file);
                }
            }
        }
    }

    private static void copyPowerOnOrOffLogToMessageDir(File file) {
        if (file.getName().equals(MESSAGE_FILE_NAME)) {
            File[] fileArray = FileListFileFilterUtils.fileList(file, null);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File subFile = fileArray[n2];
                if (subFile.isDirectory() && (subFile.getName().contains("poweroff") || subFile.getName().contains("poweron"))) {
                    File[] fileArray2 = FileListFileFilterUtils.fileList(subFile, null);
                    int n3 = fileArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File file2 = fileArray2[n4];
                        SearcherUtils.copyFiles(file2, file, subFile.getName());
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    public static File getSystemLogPath(File file) {
        File systemLogFile;
        File tempFile = SearcherUtils.getLogPath(file);
        if (tempFile == null) {
            return null;
        }
        File[] fileArray = FileListFileFilterUtils.fileList(tempFile, null);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            systemLogFile = fileArray[n2];
            if (systemLogFile.isDirectory() && systemLogFile.getName().equals("System_log")) {
                return systemLogFile;
            }
            ++n2;
        }
        fileArray = FileListFileFilterUtils.fileList(file, null);
        n = fileArray.length;
        n2 = 0;
        while (n2 < n) {
            systemLogFile = fileArray[n2];
            if (systemLogFile.isDirectory() && systemLogFile.getName().equals("System_log")) {
                return systemLogFile;
            }
            ++n2;
        }
        return file;
    }
}

