/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.silence.decompressor;

import com.huawei.ism.tool.loganalyzer.faulttree.exception.DiskNotEnoughException;
import com.huawei.ism.tool.loganalyzer.silence.constent.SilenceApplicationContext;
import com.huawei.ism.tool.loganalyzer.silence.decompressor.DecompressResult;
import com.huawei.ism.tool.loganalyzer.util.IOUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DecompressorSilence {
    public static final String DECOMRESS_7Z_EXE = String.valueOf(SilenceApplicationContext.getInstance().getWorkPath()) + File.separator + "utils" + File.separator + "7z" + File.separator + "7za";
    private static final Logger LOGGER = LoggerFactory.getLogger(DecompressorSilence.class);
    private static final String BLACK_FILE_LIST;
    private static List<String> blackNameErrorList;
    public File file;
    protected String password;
    private File outPutDir;
    private DecompressResult decompressResult;

    static {
        blackNameErrorList = new ArrayList<String>();
        blackNameErrorList.add("ERROR");
        blackNameErrorList.add("Can not open file as archive");
        BLACK_FILE_LIST = String.valueOf(SilenceApplicationContext.getInstance().getWorkPath()) + File.separator + "packages" + File.separator + "AnalyzeLogTool" + File.separator + "conf" + File.separator + "blackfilelist.txt";
        LOGGER.info(String.valueOf(BLACK_FILE_LIST) + "=====================================");
    }

    public void decompress(File outPutPath) {
        block8: {
            Process process = null;
            try {
                try {
                    if (!this.createDir(outPutPath)) {
                        outPutPath = outPutPath.getParentFile();
                    }
                    this.outPutDir = outPutPath;
                    process = Runtime.getRuntime().exec(this.getExecCmd(this.file, outPutPath));
                    if (this.password != null) {
                        this.writePassword(process, this.password);
                    }
                    this.decompressResult = this.getDepressResult(process);
                    if (this.decompressResult != null) {
                        this.dealResult();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.destroyProcess(process);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                this.destroyProcess(process);
                throw throwable;
            }
            this.destroyProcess(process);
        }
    }

    private void destroyProcess(Process process) {
        if (process != null) {
            while (true) {
                try {
                    process.exitValue();
                    process.destroy();
                }
                catch (RuntimeException e) {
                    LOGGER.debug("this process thread has not over !");
                    continue;
                }
                catch (Throwable ee) {
                    LOGGER.debug("this process thread has been interrupted", ee);
                }
                break;
            }
        }
    }

    private void dealResult() throws IOException {
        for (String blackNameError : blackNameErrorList) {
            if (!this.decompressResult.getInfo().contains(blackNameError) && !this.decompressResult.getErrorInfo().contains(blackNameError)) continue;
            if (this.file.getParentFile().getFreeSpace() >= 0x2000000L) break;
            LOGGER.debug(String.valueOf(this.file.getParentFile().getFreeSpace()) + "disk is not enuph");
            throw new DiskNotEnoughException("disk is not enuph");
        }
    }

    public void decompress() {
        this.decompress(this.file.getParentFile());
        this.deleteFileAfterDecompress();
    }

    public void deleteFileAfterDecompress() {
        if (!this.file.delete()) {
            LOGGER.info("delete File fail After Decompress \uff1a" + this.file.getAbsolutePath());
        }
    }

    public String getFilePath(File f) {
        try {
            return f.getCanonicalPath();
        }
        catch (IOException e) {
            return f.getAbsolutePath();
        }
    }

    public void writePassword(Process process, String pwd) {
        OutputStream outs = null;
        try {
            try {
                outs = process.getOutputStream();
                outs.write(pwd.getBytes(Charset.defaultCharset()));
            }
            catch (Throwable e) {
                e.printStackTrace();
                IOUtil.close((Closeable)outs);
            }
        }
        finally {
            IOUtil.close((Closeable)outs);
        }
    }

    public String getExecCmd(File zipFile, File outPutDirFile) {
        StringBuilder cmdBuilder = new StringBuilder();
        cmdBuilder.append(DECOMRESS_7Z_EXE).append(" x ");
        String inputPath = this.getFilePath(zipFile);
        boolean isContainsWhitespace = inputPath.contains(" ");
        cmdBuilder.append(isContainsWhitespace ? "\"" : "").append(inputPath).append(isContainsWhitespace ? "\"" : "");
        cmdBuilder.append(" -x@");
        isContainsWhitespace = BLACK_FILE_LIST.contains(" ");
        cmdBuilder.append(isContainsWhitespace ? "\"" : "").append(BLACK_FILE_LIST).append(isContainsWhitespace ? "\"" : "");
        cmdBuilder.append(" -aou");
        String outputPath = this.getFilePath(outPutDirFile);
        isContainsWhitespace = outputPath.contains(" ");
        cmdBuilder.append(" -o").append(isContainsWhitespace ? "\"" : "").append(outputPath).append(isContainsWhitespace ? "\"" : "").append(" -y");
        return cmdBuilder.toString();
    }

    private DecompressResult getDepressResult(Process process) {
        try {
            String error = DecompressorSilence.inputStreamToString(process.getErrorStream());
            return new DecompressResult(DecompressorSilence.inputStreamToString(process.getInputStream()), error);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean createDir(File f) {
        if (!f.isDirectory()) {
            if (!f.mkdirs()) {
                LOGGER.info("Create dir fail:" + f.getAbsolutePath());
                return false;
            }
        } else if (f.isFile()) {
            LOGGER.info("Create dir fail\uff0cExist the file which is same name with the dir name\uff1a" + f.getAbsolutePath());
            return false;
        }
        return true;
    }

    public void setPassword(String pwd) {
        this.password = pwd;
    }

    public DecompressResult getDecompressResult() {
        return this.decompressResult;
    }

    public File getOutPutDir() {
        return this.outPutDir;
    }

    private static String inputStreamToString(InputStream in) throws Exception {
        BufferedReader bufferedReader = null;
        InputStreamReader reader = null;
        StringWriter writer = null;
        String content = null;
        try {
            reader = new InputStreamReader(in, "gbk");
            bufferedReader = new BufferedReader(reader);
            writer = new StringWriter();
            char[] buf = new char[2048];
            int len = 0;
            while ((len = bufferedReader.read(buf)) != -1) {
                writer.write(buf, 0, len);
            }
            writer.flush();
            content = writer.toString();
        }
        catch (Throwable throwable) {
            IOUtil.close((Closeable)in);
            IOUtil.close(bufferedReader);
            IOUtil.close((Closeable)reader);
            IOUtil.close(writer);
            throw throwable;
        }
        IOUtil.close((Closeable)in);
        IOUtil.close((Closeable)bufferedReader);
        IOUtil.close((Closeable)reader);
        IOUtil.close((Closeable)writer);
        return content;
    }
}

