/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.silence.decompressor.decompress;

import com.huawei.ism.tool.loganalyzer.faulttree.decompress.SystemLogPathGetter;
import com.huawei.ism.tool.loganalyzer.silence.decompressor.DecompressorSilence;
import java.io.File;
import java.util.regex.Pattern;

public class TarDecompressorSilence
extends DecompressorSilence {
    private Pattern ipPattern = Pattern.compile("\\d+\\.\\d+\\.\\d+\\.\\d+");
    private Pattern logControllerPattern = Pattern.compile("log_controller");

    public TarDecompressorSilence(File file) {
        this.file = file;
    }

    public TarDecompressorSilence(File file, String password) {
        this.file = file;
        this.password = password;
    }

    @Override
    public void decompress() {
        if (SystemLogPathGetter.getSystemLogPath().getAbsoluteFile().equals(this.file.getParentFile().getAbsoluteFile()) || this.ipPattern.matcher(this.file.getName()).find() || this.logControllerPattern.matcher(this.file.getName()).find() || this.file.getName().contains("poweroff") || this.file.getName().contains("poweron")) {
            this.decompress(new File(this.file.getParentFile(), this.file.getName().substring(0, this.file.getName().lastIndexOf(46))));
            this.deleteFileAfterDecompress();
        } else {
            super.decompress();
        }
    }
}

