/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.silence.faulttree;

import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.cache.CauseGroupCache;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.cache.FaultTypeCache;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.cache.RuleCache;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.cache.VersionSupportsCache;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.version.Model;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.cache.FileCategorizerCache;
import com.huawei.ism.tool.loganalyzer.faulttree.datematch.DateMatcherCache;
import com.huawei.ism.tool.loganalyzer.faulttree.resources.cache.ResourceCache;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public enum DeviceTypeSilence {
    UNIFINED("unifined"),
    OCEAN_STOR("oceanstor");

    private static final String CONF_PATH;
    private VersionSupportsCache versionSupportsCache = new VersionSupportsCache();
    private FileCategorizerCache fileCategorizerCache = new FileCategorizerCache();
    private DateMatcherCache dateMatcherCache = new DateMatcherCache();
    private RuleCache ruleCache = new RuleCache();
    private FaultTypeCache faultTypeCache = new FaultTypeCache();
    private CauseGroupCache causeGroupCache = new CauseGroupCache();
    private ResourceCache resourceCache = new ResourceCache();
    private String confPath;
    private String name;

    static {
        CONF_PATH = String.valueOf(ApplicationContext.getInstance().getWorkPath()) + File.separator + "packages" + File.separator + "AnalyzeLogTool" + File.separator + "conf";
    }

    private DeviceTypeSilence(String name) {
        this.name = name;
    }

    public static final void init(String rulePath) {
        DeviceTypeSilence.UNIFINED.confPath = String.valueOf(rulePath) + File.separator + DeviceTypeSilence.UNIFINED.name;
        DeviceTypeSilence.OCEAN_STOR.confPath = String.valueOf(rulePath) + File.separator + DeviceTypeSilence.OCEAN_STOR.name;
    }

    public static final Model getModel(String modelName, String versionName) {
        Model m = null;
        DeviceTypeSilence[] deviceTypeSilenceArray = DeviceTypeSilence.values();
        int n = deviceTypeSilenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceTypeSilence storageDeviceType = deviceTypeSilenceArray[n2];
            m = storageDeviceType.versionSupportsCache.getModel(modelName, versionName);
            if (m != null) {
                return m;
            }
            ++n2;
        }
        return m;
    }

    public static final Model getModel(String modelName) {
        Model m = null;
        DeviceTypeSilence[] deviceTypeSilenceArray = DeviceTypeSilence.values();
        int n = deviceTypeSilenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceTypeSilence storageDeviceType = deviceTypeSilenceArray[n2];
            m = storageDeviceType.versionSupportsCache.getModel(modelName);
            if (m != null) {
                return m;
            }
            ++n2;
        }
        return m;
    }

    public static final DeviceTypeSilence type(String modelName) {
        DeviceTypeSilence[] deviceTypeSilenceArray = DeviceTypeSilence.values();
        int n = deviceTypeSilenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceTypeSilence storageDeviceType = deviceTypeSilenceArray[n2];
            if (storageDeviceType.versionSupportsCache.getModel(modelName) != null) {
                return storageDeviceType;
            }
            ++n2;
        }
        return UNIFINED;
    }

    public static final List<Model> getModelList() {
        ArrayList<Model> modelList = new ArrayList<Model>();
        DeviceTypeSilence[] deviceTypeSilenceArray = DeviceTypeSilence.values();
        int n = deviceTypeSilenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceTypeSilence storageDeviceType = deviceTypeSilenceArray[n2];
            modelList.addAll(storageDeviceType.versionSupportsCache.getModelList());
            ++n2;
        }
        return modelList;
    }

    public VersionSupportsCache versionSupportsCache() {
        return this.versionSupportsCache;
    }

    public FileCategorizerCache fileCategorizerCache() {
        return this.fileCategorizerCache;
    }

    public RuleCache ruleCache() {
        return this.ruleCache;
    }

    public FaultTypeCache faultTypeCache() {
        return this.faultTypeCache;
    }

    public CauseGroupCache causeGroupCache() {
        return this.causeGroupCache;
    }

    public DateMatcherCache dateMatcherCache() {
        return this.dateMatcherCache;
    }

    public ResourceCache resourceCache() {
        return this.resourceCache;
    }

    public String getName() {
        return this.name;
    }

    public String getConfPath() {
        return this.confPath;
    }
}

