/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.ui;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.component.checkboxtree.CheckBoxTree;
import com.huawei.ism.tool.base.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.loganalyzer.entity.AnalyzeUserOpData;
import com.huawei.ism.tool.loganalyzer.entity.analyze.ConfigInfoEntry;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogRow;
import com.huawei.ism.tool.loganalyzer.logic.AnalyzeUserOpService;
import com.huawei.ism.tool.loganalyzer.ui.TreeCellRender;
import com.huawei.ism.tool.loganalyzer.ui.ViewDiagnoseDialog;
import com.huawei.ism.tool.loganalyzer.ui.ViewEventDialog;
import com.huawei.ism.tool.loganalyzer.ui.ViewLogDialog;
import com.huawei.ism.tool.loganalyzer.ui.faultuitree.SimpleFrame;
import com.huawei.ism.tool.loganalyzer.ui.main.MainLogAnaDialog;
import com.huawei.ism.tool.loganalyzer.util.ConfigInfoConstant;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class AdvancedAnalyzeDialog
extends SimpleFrame {
    public static final int NUMBER_1104 = 1104;
    public static final int NUMBER_640 = 640;
    public static final float NUMBER_POINT_TWO = 0.2f;
    private static final long serialVersionUID = 3321226060684437944L;
    private JLabel devicemodeLabel = UiMethod.createColonLabel((String)ResourceUtil.getString((String)"info.analyze.versiontable.head.devicemode"));
    private JLabel productversionLabel = UiMethod.createColonLabel((String)ResourceUtil.getString((String)"info.analyze.versiontable.head.productversion"));
    private JLabel devicemodeText = new JLabel();
    private JLabel productversionText = new JLabel();
    private JPanel configInfoPanel = new JPanel();
    private CardLayout configInfoLayout = new CardLayout();
    private transient List<LogRow> rows = null;
    private JTextArea controllerEncTextArea = new JTextArea();
    private JTextArea diskEncTextArea = new JTextArea();
    private JTextArea lunTextArea = new JTextArea();
    private JTextArea hostTextArea = new JTextArea();
    private JTextArea mappingViewTextArea = new JTextArea();
    private JTextArea diskDomainTextArea = new JTextArea();
    private JTextArea storagePoolTextArea = new JTextArea();
    private JTextArea portTextArea = new JTextArea();
    private JTextArea basicInfoTextArea = new JTextArea();
    private JTextArea licenseTextArea = new JTextArea();
    private ViewLogDialog viewLogDialog;

    public AdvancedAnalyzeDialog(List<LogRow> rows) {
        this.init(rows);
    }

    public void init(List<LogRow> rows1) {
        try {
            MainLogAnaDialog.getInstance().setEnabled(false);
            this.rows = rows1;
            this.viewLogDialog = new ViewLogDialog(this, rows1.get(0));
            this.setTitle(ResourceUtil.getString((String)"info.analyze.advancedAnalyzeDialog.title"));
            this.setIconImage(ResourceUtil.getImage((String)"analyze48.PNG").getImage());
            this.layoutComponents();
            this.initData();
            this.initUiListener();
            this.setDialogSize();
            SwingUtil.putScreenCenter((Window)this);
            MainLogAnaDialog.getInstance().setVisible(false);
            this.setCompName();
        }
        finally {
            MainLogAnaDialog.getInstance().setEnabled(true);
        }
    }

    private void setDialogSize() {
        Dimension dialogSize = new Dimension(1104, 640);
        this.setMinimumSize(dialogSize);
        this.setSize(dialogSize);
    }

    public void setCompName() {
        this.devicemodeText.setName("devicemodeText");
        this.productversionText.setName("productversionText");
        this.controllerEncTextArea.setName("controllerEnc");
        this.diskEncTextArea.setName("diskEnc");
        this.lunTextArea.setName("lun");
        this.hostTextArea.setName("host");
        this.mappingViewTextArea.setName("mappingView");
        this.diskDomainTextArea.setName("diskDomain");
        this.storagePoolTextArea.setName("storagePool");
        this.portTextArea.setName("port");
        this.basicInfoTextArea.setName("basicInfo");
        this.licenseTextArea.setName("license");
    }

    public void initUiListener() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AdvancedAnalyzeDialog.this.viewLogDialog.destroy();
                MainLogAnaDialog.getInstance().setEnabled(true);
                MainLogAnaDialog.getInstance().setVisible(true);
            }
        });
    }

    private void initData() {
        this.setConfigInfoFont(ConfigInfoConstant.COURIER_NEW_FONT);
        this.setConfigInfoEditable(false);
    }

    public void setConfigInfoValue(ConfigInfoEntry configInfoEntry) {
        String defaultValue = ResourceUtil.getString((String)"info.analyze.empty.defaultvalue");
        if (configInfoEntry == null) {
            configInfoEntry = new ConfigInfoEntry();
        }
        this.controllerEncTextArea.setText(StringUtils.isNULLStr((String)configInfoEntry.getControllerEnc()) ? defaultValue : configInfoEntry.getControllerEnc());
        this.diskEncTextArea.setText(StringUtils.isNULLStr((String)configInfoEntry.getDiskEnc()) ? defaultValue : configInfoEntry.getDiskEnc());
        this.lunTextArea.setText(StringUtils.isNULLStr((String)configInfoEntry.getLun()) ? defaultValue : configInfoEntry.getLun());
        this.hostTextArea.setText(StringUtils.isNULLStr((String)configInfoEntry.getHost()) ? defaultValue : configInfoEntry.getHost());
        this.mappingViewTextArea.setText(StringUtils.isNULLStr((String)configInfoEntry.getMappingView()) ? defaultValue : configInfoEntry.getMappingView());
        this.diskDomainTextArea.setText(StringUtils.isNULLStr((String)configInfoEntry.getDiskDomain()) ? defaultValue : configInfoEntry.getDiskDomain());
        this.storagePoolTextArea.setText(StringUtils.isNULLStr((String)configInfoEntry.getStoragePool()) ? defaultValue : configInfoEntry.getStoragePool());
        this.portTextArea.setText(StringUtils.isNULLStr((String)configInfoEntry.getPort()) ? defaultValue : configInfoEntry.getPort());
        this.basicInfoTextArea.setText(StringUtils.isNULLStr((String)configInfoEntry.getBasicInfo()) ? defaultValue : configInfoEntry.getBasicInfo());
        this.licenseTextArea.setText(StringUtils.isNULLStr((String)configInfoEntry.getLicense()) ? defaultValue : configInfoEntry.getLicense());
    }

    private void setConfigInfoFont(Font f) {
        this.controllerEncTextArea.setFont(f);
        this.diskEncTextArea.setFont(f);
        this.lunTextArea.setFont(f);
        this.hostTextArea.setFont(f);
        this.mappingViewTextArea.setFont(f);
        this.diskDomainTextArea.setFont(f);
        this.storagePoolTextArea.setFont(f);
        this.portTextArea.setFont(f);
        this.basicInfoTextArea.setFont(f);
        this.licenseTextArea.setFont(f);
    }

    private void setConfigInfoEditable(boolean b) {
        this.controllerEncTextArea.setEditable(b);
        this.diskEncTextArea.setEditable(b);
        this.lunTextArea.setEditable(b);
        this.hostTextArea.setEditable(b);
        this.mappingViewTextArea.setEditable(b);
        this.diskDomainTextArea.setEditable(b);
        this.storagePoolTextArea.setEditable(b);
        this.portTextArea.setEditable(b);
        this.basicInfoTextArea.setEditable(b);
        this.licenseTextArea.setEditable(b);
    }

    private JScrollPane getJTextArea(JTextArea jtextarea) {
        JScrollPane sp = new JScrollPane(jtextarea);
        sp.setVerticalScrollBarPolicy(20);
        sp.setHorizontalScrollBarPolicy(30);
        return sp;
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        JScrollPane jscrollPane = new JScrollPane(this.layoutTreeArea());
        jscrollPane.setVerticalScrollBarPolicy(20);
        jscrollPane.setHorizontalScrollBarPolicy(30);
        JSplitPane splitPane = new JSplitPane(1, false);
        splitPane.setLeftComponent(jscrollPane);
        splitPane.setRightComponent(this.layoutConfigInfoAreaMsg());
        splitPane.setBackground(Color.white);
        splitPane.setDividerLocation(120);
        splitPane.setResizeWeight(0.2f);
        splitPane.setEnabled(true);
        this.add((Component)UiMethod.buildFrameSpace((JComponent)this.layoutDescrptionArea(), (int)20), "North");
        this.add(splitPane);
    }

    private JComponent layoutDescrptionArea() {
        TableRow row = this.rows.get(0).getRow();
        this.devicemodeText.setText(row.getValueAt(1).toString());
        this.productversionText.setText(row.getValueAt(2).toString());
        JLabel maginLable = new JLabel();
        maginLable.setPreferredSize(new Dimension(30, 20));
        Box supportArea = UCD.buildHBoxLeft((int)5, (Component[])new Component[]{this.devicemodeLabel, this.devicemodeText, maginLable, this.productversionLabel, this.productversionText});
        return supportArea;
    }

    private void recordConfigItem(String itemName) {
        LogRow logRow = this.rows.get(0);
        AnalyzeUserOpData userOpData = AnalyzeUserOpService.getLogPackageUserOpData(logRow);
        userOpData.addConfigClickItem(itemName);
    }

    private JComponent layoutTreeArea() {
        CheckTreeNode treeRoot = new CheckTreeNode((Object)ResourceUtil.getString((String)"info.analyze.maindialog.btn.advancedAnalyze"));
        CheckTreeNode infoRoot = new CheckTreeNode((Object)ResourceUtil.getString((String)"info.analyze.configInfo"));
        CheckTreeNode systemNode = new CheckTreeNode((Object)ResourceUtil.getString((String)"info.analyze.system"));
        CheckTreeNode resourceNode = new CheckTreeNode((Object)ResourceUtil.getString((String)"info.analyze.provisioning"));
        CheckTreeNode configNode = new CheckTreeNode((Object)ResourceUtil.getString((String)"info.analyze.setting"));
        CheckTreeNode viewLogNode = new CheckTreeNode((Object)ResourceUtil.getString((String)"info.analyze.advanced.viewingLogs"));
        CheckTreeNode eventNode = new CheckTreeNode((Object)ResourceUtil.getString((String)"info.analyze.advanced.alarm"));
        CheckTreeNode diagnoseNode = new CheckTreeNode((Object)ResourceUtil.getString((String)"info.analyze.advanced.diagnose"));
        infoRoot.add((MutableTreeNode)systemNode);
        infoRoot.add((MutableTreeNode)resourceNode);
        infoRoot.add((MutableTreeNode)configNode);
        treeRoot.add((MutableTreeNode)infoRoot);
        treeRoot.add((MutableTreeNode)viewLogNode);
        treeRoot.add((MutableTreeNode)eventNode);
        treeRoot.add((MutableTreeNode)diagnoseNode);
        CheckBoxTree infoTree = new CheckBoxTree(treeRoot, false);
        infoTree.setShowsRootHandles(true);
        TreeCellRender cellRender = new TreeCellRender(false);
        infoTree.setCellRenderer((TreeCellRenderer)((Object)cellRender));
        infoTree.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        infoTree.setMinimumSize(new Dimension(300, 400));
        this.recordConfigItem(ResourceUtil.getString((String)"info.analyze.system"));
        this.recordConfigItem(ResourceUtil.getString((String)"info.analyze.diskEnclosure"));
        infoTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath treepath = e.getNewLeadSelectionPath();
                if (treepath == null) {
                    return;
                }
                String treeNodeName = treepath.getLastPathComponent().toString().trim();
                AdvancedAnalyzeDialog.this.recordConfigItem(treeNodeName);
                if (ResourceUtil.getString((String)"info.analyze.provisioning").equals(treeNodeName)) {
                    AdvancedAnalyzeDialog.this.recordConfigItem(ResourceUtil.getString((String)"info.analyze.host"));
                } else if (ResourceUtil.getString((String)"info.analyze.setting").equals(treeNodeName)) {
                    AdvancedAnalyzeDialog.this.recordConfigItem(ResourceUtil.getString((String)"info.analyze.basicInformation"));
                } else if (ResourceUtil.getString((String)"info.analyze.advanced.alarm").equals(treeNodeName)) {
                    ViewEventDialog.getInstance().getEventProTableModel().removeAll();
                } else if (ResourceUtil.getString((String)"info.analyze.advanced.diagnose").equals(treeNodeName)) {
                    ViewDiagnoseDialog.getInstance().getDiagnoseProTableModel().removeAll();
                }
                AdvancedAnalyzeDialog.this.configInfoLayout.show(AdvancedAnalyzeDialog.this.configInfoPanel, treepath.getLastPathComponent().toString().trim());
            }
        });
        infoTree.setRootVisible(false);
        Box supportArea = UCD.buildVBoxTop((int)12, (Component[])new Component[]{infoTree});
        supportArea.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        return supportArea;
    }

    private JComponent layoutConfigInfoAreaMsg() {
        this.configInfoPanel.setLayout(this.configInfoLayout);
        this.configInfoPanel.add((Component)this.getSystemDialog(), ResourceUtil.getString((String)"info.analyze.system"));
        this.configInfoPanel.add((Component)this.getResourceDialog(), ResourceUtil.getString((String)"info.analyze.provisioning"));
        this.configInfoPanel.add((Component)this.getConfigDialog(), ResourceUtil.getString((String)"info.analyze.setting"));
        this.configInfoPanel.add((Component)this.viewLogDialog, ResourceUtil.getString((String)"info.analyze.advanced.viewingLogs"));
        this.configInfoPanel.add((Component)ViewEventDialog.getInstance().getEventTablePanle(), ResourceUtil.getString((String)"info.analyze.advanced.alarm"));
        this.configInfoPanel.add((Component)ViewDiagnoseDialog.getInstance().getDiagnoseTablePanle(), ResourceUtil.getString((String)"info.analyze.advanced.diagnose"));
        this.configInfoPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        return this.configInfoPanel;
    }

    private JTabbedPane getSystemDialog() {
        JTabbedPane tab = new JTabbedPane();
        tab.addMouseListener(new TabClickListener(tab));
        tab.add(ResourceUtil.getString((String)"info.analyze.diskEnclosure"), this.getJTextArea(this.diskEncTextArea));
        tab.add(ResourceUtil.getString((String)"info.analyze.controllerEnclosure"), this.getJTextArea(this.controllerEncTextArea));
        return tab;
    }

    private JTabbedPane getResourceDialog() {
        JTabbedPane tab = new JTabbedPane();
        tab.addMouseListener(new TabClickListener(tab));
        tab.add(ResourceUtil.getString((String)"info.analyze.host"), this.getJTextArea(this.hostTextArea));
        tab.add(ResourceUtil.getString((String)"info.analyze.diskDomain"), this.getJTextArea(this.diskDomainTextArea));
        tab.add(ResourceUtil.getString((String)"info.analyze.storagePool"), this.getJTextArea(this.storagePoolTextArea));
        tab.add(ResourceUtil.getString((String)"info.analyze.lun"), this.getJTextArea(this.lunTextArea));
        tab.add(ResourceUtil.getString((String)"info.analyze.mappingView"), this.getJTextArea(this.mappingViewTextArea));
        tab.add(ResourceUtil.getString((String)"info.analyze.port"), this.getJTextArea(this.portTextArea));
        return tab;
    }

    private JTabbedPane getConfigDialog() {
        JTabbedPane tab = new JTabbedPane();
        tab.addMouseListener(new TabClickListener(tab));
        tab.add(ResourceUtil.getString((String)"info.analyze.basicInformation"), this.getJTextArea(this.basicInfoTextArea));
        tab.add(ResourceUtil.getString((String)"info.analyze.licenseManagement"), this.getJTextArea(this.licenseTextArea));
        return tab;
    }

    private class TabClickListener
    extends MouseAdapter {
        private JTabbedPane tab;

        public TabClickListener(JTabbedPane tab) {
            this.tab = tab;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            AdvancedAnalyzeDialog.this.recordConfigItem(this.tab.getTitleAt(this.tab.getSelectedIndex()));
        }
    }
}

