/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.ui;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.component.DateChooseField;
import com.huawei.ism.tool.base.ui.dialogs.PublicDialog;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.loganalyzer.util.LoganalyzerContext;
import com.huawei.ism.tool.loganalyzer.util.SearchConstant;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class DateSettingDialog
extends PublicDialog {
    private static final long serialVersionUID = -200718536235122293L;
    private static final Dimension DIALOG_SIZE = new Dimension(474, 220);
    private static final Dimension FIELD_SIZE = new Dimension(150, 20);
    private static final Color COLOR_BEFORE_CLICK = new Color(4359891);
    private DateChooseField beginDate = new DateChooseField();
    private DateChooseField endDate = new DateChooseField();
    private JLabel beginLabel = UiMethod.createColonLabel((String)ResourceUtil.getString((String)"info.analyze.setting.date.from"));
    private JLabel endLabel = UiMethod.createColonLabel((String)ResourceUtil.getString((String)"info.analyze.setting.date.to"));
    private JLabel dayLabel = new JLabel(ResourceUtil.getString((String)"info.analyze.setting.date.day.before"));
    private JLabel dayUtil = new JLabel(ResourceUtil.getString((String)"info.analyze.setting.date.day.util"));
    private JTextField dayTextField;
    private int curType;
    private JLabel clearLabel = new JLabel(ResourceUtil.getString((String)"info.analyze.setting.date.btn.clear"));

    public DateSettingDialog(JDialog dialog) {
        super(dialog, true);
        this.curType = SearchConstant.getInstant().getDateType();
        this.initLinistener();
        this.initJComponent();
        this.setComponentName();
    }

    public DateSettingDialog(JFrame frame) {
        super(frame, LanguageManager.getInstance().getCurrentLanguage(), true);
        this.curType = SearchConstant.getInstant().getDateType();
        this.initLinistener();
        this.initJComponent();
        this.setComponentName();
    }

    private void setComponentName() {
        this.beginDate.setName("beginDate");
        this.endDate.setName("endDate");
        this.dayTextField.setName("dayTextField");
        this.clearLabel.setName("clearLabel");
    }

    private void initJComponent() {
        this.setAppButtonVisible(false);
        this.setHelpButtonVisiable(false);
        this.setModal(true);
        this.setTitle(ResourceUtil.getString((String)"info.analyze.problemtable.detail.setdate.title"));
        this.setResizable(false);
        this.setMinimumSize(DIALOG_SIZE);
        this.add(UiMethod.buildFrameSpace((JComponent)this.buildJComponent(), (int)12));
        this.validate();
        this.pack();
        SwingUtil.putScreenCenter((Window)((Object)this));
        this.setVisible(true);
    }

    private JComponent buildJComponent() {
        JRadioButton timeButton = new JRadioButton(ResourceUtil.getString((String)"info.analyze.setting.date.time.radio"), SearchConstant.getInstant().getDateType() == 0);
        JRadioButton dayButton = new JRadioButton(ResourceUtil.getString((String)"info.analyze.setting.date.day.radio"), 1 == SearchConstant.getInstant().getDateType());
        JRadioButton allButton = new JRadioButton(ResourceUtil.getString((String)"info.analyze.setting.date.all"), 2 == SearchConstant.getInstant().getDateType());
        timeButton.setName("timeButton");
        dayButton.setName("dayButton");
        allButton.setName("allButton");
        ButtonGroup modelSelectGroup = new ButtonGroup();
        modelSelectGroup.add(timeButton);
        modelSelectGroup.add(dayButton);
        modelSelectGroup.add(allButton);
        JComponent timeComponent = this.buildDateJComponent();
        JComponent dayComponent = this.buildDayComponent();
        timeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchConstant.getInstant().setDateType(0);
                DateSettingDialog.this.dayComponentEnable(1 == SearchConstant.getInstant().getDateType());
                DateSettingDialog.this.timeComponentEnable(SearchConstant.getInstant().getDateType() == 0);
                DateSettingDialog.this.helpBtn.setEnabled(true);
            }
        });
        dayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchConstant.getInstant().setDateType(1);
                DateSettingDialog.this.dayComponentEnable(1 == SearchConstant.getInstant().getDateType());
                DateSettingDialog.this.timeComponentEnable(SearchConstant.getInstant().getDateType() == 0);
                DateSettingDialog.this.helpBtn.setEnabled(true);
            }
        });
        allButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchConstant.getInstant().setDateType(2);
                DateSettingDialog.this.dayComponentEnable(1 == SearchConstant.getInstant().getDateType());
                DateSettingDialog.this.timeComponentEnable(SearchConstant.getInstant().getDateType() == 0);
                DateSettingDialog.this.helpBtn.setEnabled(false);
            }
        });
        return UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{timeButton}), timeComponent, UCD.buildHBoxLeft((Component[])new Component[]{dayButton}), UCD.buildHBoxLeft((Component[])new Component[]{dayComponent}), UCD.buildHBoxLeft((Component[])new Component[]{allButton}), Box.createVerticalGlue()});
    }

    private JComponent buildDateJComponent() {
        this.clearLabel.setForeground(COLOR_BEFORE_CLICK);
        UiMethod.setComponentSize((Dimension)FIELD_SIZE, (Component[])new Component[]{this.beginDate, this.endDate});
        JComponent beginCom = UCD.buildHorizotalBox(null, (Component[])new Component[]{this.beginLabel, this.beginDate});
        JComponent endCom = UCD.buildHorizotalBox(null, (Component[])new Component[]{this.endLabel, this.endDate, this.clearLabel});
        this.beginDate.setDateChooseModel(2);
        this.endDate.setDateChooseModel(2);
        this.beginDate.setText(SearchConstant.getInstant().getShowStartTime());
        this.endDate.setText(SearchConstant.getInstant().getShowEndTime());
        this.timeComponentEnable(SearchConstant.getInstant().getDateType() == 0);
        return UCD.buildHorizotalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(7), beginCom, Box.createGlue(), endCom});
    }

    private JComponent buildDayComponent() {
        this.dayTextField = IsmTextField.getNameTextField((String)"[0-9]{1,3}", (String)SearchConstant.getInstant().getDate(), (int)60, (int)14);
        this.dayTextField.setMaximumSize(new Dimension(30, 21));
        this.dayComponentEnable(1 == SearchConstant.getInstant().getDateType());
        return UCD.buildHorizotalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(7), this.dayLabel, this.dayTextField, this.dayUtil});
    }

    private void initLinistener() {
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (DateSettingDialog.this.okClick()) {
                    DateSettingDialog.this.dispose();
                    ToolLoggerFactory.getLogger(this.getClass()).debug("DateSettingDialog dispose end  -------------------");
                    LoganalyzerContext.getInstance().setComfirm(true);
                }
            }
        });
        this.helpBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (SearchConstant.getInstant().getDateType() == 0) {
                    DateSettingDialog.this.beginDate.setText("");
                    DateSettingDialog.this.endDate.setText("");
                } else {
                    DateSettingDialog.this.dayTextField.setText("");
                }
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchConstant.getInstant().setDateType(DateSettingDialog.this.curType);
                DateSettingDialog.this.dispose();
                ToolLoggerFactory.getLogger(this.getClass()).debug("DateSettingDialog cancel button dispose end  -------------------");
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SearchConstant.getInstant().setDateType(DateSettingDialog.this.curType);
                DateSettingDialog.this.dispose();
                ToolLoggerFactory.getLogger(this.getClass()).debug("DateSettingDialog window closing dispose end  -------------------");
            }
        });
        this.clearLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent paramMouseEvent) {
                if (SearchConstant.getInstant().getDateType() == 0) {
                    DateSettingDialog.this.beginDate.setText("");
                    DateSettingDialog.this.endDate.setText("");
                }
                DateSettingDialog.this.repaint();
            }
        });
    }

    private boolean okClick() {
        if (SearchConstant.getInstant().getDateType() == 0) {
            String beginTime = this.beginDate.getText();
            String endTime = this.endDate.getText();
            if (StringUtils.isNULLStr((String)beginTime) && StringUtils.isNULLStr((String)endTime)) {
                DialogUtils.showInfoDialog((JDialog)((Object)this), (String)ResourceUtil.getString((String)"info.analyze.setting.date.error4"));
                ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("setting times point failed.");
                return false;
            }
            long startTimeLong = StringUtils.parseDate2Long((String)beginTime, (String)"yyyy-MM-dd HH:mm:ss");
            long endTimeLong = StringUtils.parseDate2Long((String)endTime, (String)"yyyy-MM-dd HH:mm:ss");
            if (endTimeLong < startTimeLong && endTimeLong != 0L) {
                DialogUtils.showInfoDialog((JDialog)((Object)this), (String)ResourceUtil.getString((String)"info.analyze.setting.date.error1"));
                ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("setting times point failed.");
                return false;
            }
            if (startTimeLong > System.currentTimeMillis()) {
                DialogUtils.showInfoDialog((JDialog)((Object)this), (String)ResourceUtil.getString((String)"info.analyze.setting.date.error2"));
                ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("setting times point failed.");
                return false;
            }
            SearchConstant.getInstant().setStartTime(beginTime);
            SearchConstant.getInstant().setEndTime(endTime);
            SearchConstant.getInstant().setShowStartTime(beginTime);
            SearchConstant.getInstant().setShowEndTime(endTime);
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("setting times point success.");
            return true;
        }
        if (SearchConstant.getInstant().getDateType() == 1) {
            String day = this.dayTextField.getText();
            if (StringUtils.isNULLStr((String)day)) {
                DialogUtils.showInfoDialog((JDialog)((Object)this), (String)ResourceUtil.getString((String)"info.analyze.setting.date.error3"));
                ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("setting days failed.");
                return false;
            }
            int dayInt = Integer.parseInt(day);
            if (dayInt == 0) {
                DialogUtils.showInfoDialog((JDialog)((Object)this), (String)ResourceUtil.getString((String)"info.analyze.setting.date.error3"));
                ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("setting days failed.");
                return false;
            }
            SearchConstant.getInstant().setDate(String.valueOf(dayInt));
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("setting days success.");
            return true;
        }
        SearchConstant.getInstant().setStartTime("");
        SearchConstant.getInstant().setEndTime("");
        SearchConstant.getInstant().setShowStartTime("");
        SearchConstant.getInstant().setShowEndTime("");
        SearchConstant.getInstant().setDate("");
        ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("setting all times success.");
        return true;
    }

    private void timeComponentEnable(boolean enable) {
        this.beginDate.setEnabled(enable);
        this.endDate.setEnabled(enable);
        this.beginLabel.setEnabled(enable);
        this.endLabel.setEnabled(enable);
    }

    private void dayComponentEnable(boolean enable) {
        this.dayLabel.setEnabled(enable);
        this.dayUtil.setEnabled(enable);
        this.dayTextField.setEnabled(enable);
    }
}

