/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.ui;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogRow;
import com.huawei.ism.tool.loganalyzer.entity.execresult.ExecuteResult;
import com.huawei.ism.tool.loganalyzer.ui.ImportProcessDialogLayout;
import com.huawei.ism.tool.loganalyzer.util.LoganalyzerContext;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import org.slf4j.Logger;

public final class ImportProcessDialog
extends JDialog {
    private static final long serialVersionUID = -5727935805179345319L;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ImportProcessDialog.class);
    private ImportProcessDialogLayout layout;
    private Window parent;
    private transient LogRow row;
    private List<ExecuteResult> resultList;

    public ImportProcessDialog(Window parent) {
        super(parent);
        try {
            this.setModalityType(Dialog.ModalityType.MODELESS);
            this.init();
            this.addListeners();
            new ImportProcessDialogStartThread(this).start();
        }
        catch (Exception e) {
            LOGGER.info("ImportProcessDialog setVisible error", (Throwable)e);
        }
    }

    public ImportProcessDialogLayout getDialogLayout() {
        return this.layout;
    }

    @Override
    public void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            LOGGER.info("close window...");
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"info.analyze.message.import.close"));
        } else {
            super.processWindowEvent(e);
        }
    }

    private void init() {
        this.layout = new ImportProcessDialogLayout();
        this.setLayout(new BorderLayout());
        this.add(this.layout);
        this.setTitle(ResourceUtil.getString((String)"info.analyze.importprocess.dialog.title"));
        this.pack();
        this.validate();
        this.setModal(true);
        LoganalyzerContext.LOADING_IMAGE.setImageObserver(this);
        this.setLocationRelativeTo(this.parent);
        this.toFront();
        this.setResizable(false);
        SwingUtil.putParentCenter((Window)this, (Window)this.parent);
    }

    private void addListeners() {
        this.layout.getStopBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("stop import log.....");
                ImportProcessDialog.this.stopImportDialog();
            }
        });
    }

    private void stopImportDialog() {
        WarningDialog dialog = DialogUtils.showYesNoDialog((Window)this, (String)ResourceUtil.getString((String)"info.analyze.message.is.conform.stop.log"));
        if (dialog.getValue() == 0) {
            this.stopImport();
            this.layout.getStopBtn().setEnabled(false);
        }
    }

    private void stopImport() {
        if (this.resultList == null) {
            return;
        }
        this.doRefreshImportArea(ResourceUtil.getString((String)"info.analyze.maindialog.importlog.stopping"), this.resultList, this.row, 0);
        this.stopImportLog();
    }

    private void stopImportLog() {
        LoganalyzerContext.getInstance().getImportLogRow().setStopImpot(true);
    }

    private void doRefreshProcessMessage(List<ExecuteResult> resultMsgList) {
        List<File> allPacks = LoganalyzerContext.getInstance().getImportAllPack();
        this.layout.getDescAllNum().setText("" + allPacks.size());
        JList msgList = this.layout.getDetailList();
        if (resultMsgList != null) {
            msgList.setListData(resultMsgList.toArray());
            msgList.setSelectedIndex(resultMsgList.size() - 1);
            this.layout.layoutBarToBottom();
            this.repaint();
        }
    }

    public void doRefreshImportArea(String resource, List<ExecuteResult> executeResultList, LogRow logRow, int progress) {
        if (executeResultList != null && !executeResultList.isEmpty()) {
            ExecuteResult er = executeResultList.get(executeResultList.size() - 1);
            if (logRow.getLogFile().getName().equals(er.getPackName())) {
                executeResultList.remove(executeResultList.size() - 1);
            }
        }
        this.row = logRow;
        this.resultList = executeResultList;
        if (resource != null && executeResultList != null) {
            this.freshImportArea(resource, executeResultList, progress, null);
        }
        if (executeResultList != null) {
            this.doRefreshProcessMessage(executeResultList);
        }
    }

    private void freshImportArea(String resource, List<ExecuteResult> executeResultList, int progress, ExecuteResult resultTemp) {
        if (progress == 100 || progress == 50) {
            for (ExecuteResult result : executeResultList) {
                if (!resource.equals(result.getDescription()) || result.getProgress() != 0) continue;
                resultTemp = result;
                executeResultList.remove(result);
                break;
            }
        }
        resultTemp = this.createTempResult(resource, progress, resultTemp);
        executeResultList.add(resultTemp);
    }

    private ExecuteResult createTempResult(String resource, int progress, ExecuteResult resultTemp) {
        if (resultTemp != null) {
            resultTemp.setProgress(progress);
        } else {
            String packName = LoganalyzerContext.getInstance().getImportPackName();
            resultTemp = ImportProcessDialog.createExecuteResult(resource, progress, packName);
        }
        return resultTemp;
    }

    private static ExecuteResult createExecuteResult(String description, int progress, String packName) {
        ExecuteResult result = new ExecuteResult();
        result.setDescription(description);
        result.setPackName(packName);
        result.setProgress(progress);
        return result;
    }

    public JLabel getDesc() {
        return this.layout.getDesc();
    }

    private static final class ImportProcessDialogStartThread
    extends Thread {
        private ImportProcessDialog importProcessDialog;

        public ImportProcessDialogStartThread(ImportProcessDialog importProcessDialog) {
            this.importProcessDialog = importProcessDialog;
        }

        @Override
        public void run() {
            this.importProcessDialog.setVisible(true);
        }
    }
}

