/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.ui;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.loganalyzer.exception.PathCheckException;
import com.huawei.ism.tool.loganalyzer.monitor.AutoAnalyzeTimer;
import com.huawei.ism.tool.loganalyzer.monitor.enumer.AnalysisMode;
import com.huawei.ism.tool.loganalyzer.ui.main.MainLogAnaDialog;
import com.huawei.ism.tool.loganalyzer.util.SearchConstant;
import com.huawei.ism.tool.loganalyzer.util.SearcherUtils;
import com.huawei.ism.tool.obase.filechooser.HibernateContainer;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileSystemView;
import org.slf4j.Logger;

public class SettingDirDialog
extends JDialog {
    public static final String AUTOANALYZE_PATH_DEFAULT_ID = "autoanalyze_default_path_id001";
    public static final String SAVE_AUTOANALYZE_ID = "autoanalyze_path_id001";
    private static final long serialVersionUID = -8900700478021141098L;
    private static final int PREFER_WIDTH = 200;
    private static final int LABEL_HEIGHT = 25;
    private static final String SAVEPATH_DEFAULT_ID = "analyze_saveresult_path_id001";
    private static final String TEMPSTATE_DEFAULT_ID = "analyze_temp_state_id001";
    private static final String SAVETEMPPATH_DEFAULT_ID = "analyze_savetempresult_path_id001";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SettingDirDialog.class);
    private static JLabel placeholderJLabel = new JLabel();
    private static final Dimension DIALOG_SIZE = new Dimension(510, 380);
    private JTextArea messa = new JTextArea(ResourceUtil.getString((String)"info.autoanalyze.open.message"));
    private JCheckBox keepTemp = new JCheckBox();
    private JButton confirm = UiMethod.createButton((String)ResourceUtil.getString((String)"info.analyze.setting.dir.btn.ok"), (char)'O');
    private JButton cancel = UiMethod.createButton((String)ResourceUtil.getString((String)"info.analyze.setting.dir.close"), (char)'C');
    private JButton outputLink = UiMethod.createButton((String)ResourceUtil.getString((String)"info.analyze.setting.dir.btn.Browse"), (char)'R');
    private JTextField outputPath = new JTextField();
    private JButton depressLink = UiMethod.createButton((String)ResourceUtil.getString((String)"info.analyze.setting.dir.btn.Browse"), (char)'B');
    private JTextField depressPath = new JTextField();
    private String defaultPath = String.valueOf(HibernateContainer.getInstance().get((Object)"analyze_saveresult_path_id001"));
    private JCheckBox openBox = new JCheckBox(ResourceUtil.getString((String)"info.analyze.autoanalyze.dialog.open"));
    private JTextField autoAnalyzePath = new JTextField();
    private JButton browseBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"info.analyze.autoanalyze.dialog.browse"), (char)'S');
    private String defaultAutoAnalyzePath = String.valueOf(HibernateContainer.getInstance().get((Object)"autoanalyze_default_path_id001"));

    public SettingDirDialog(Window frame) {
        super(frame);
        this.initUI();
        this.initData();
        this.addListeners();
        this.setComponentName();
    }

    private void setComponentName() {
        this.openBox.setName("openBox");
        this.autoAnalyzePath.setName("autoAnalyzePath");
        this.browseBtn.setName("browseBtn");
        this.outputLink.setName("outputLink");
        this.outputPath.setName("outputPath");
        this.depressLink.setName("depressLink");
        this.depressPath.setName("depressPath");
        this.keepTemp.setName("keepTemp");
        this.confirm.setName("confirm");
        this.cancel.setName("cancel");
    }

    public void initData() {
        String defaultTempDir = SearchConstant.getInstant().getTemp();
        this.depressPath.setText(defaultTempDir);
        this.depressPath.setToolTipText(defaultTempDir);
        String defaultAutoAnalyzePath1 = String.valueOf(HibernateContainer.getInstance().get((Object)AUTOANALYZE_PATH_DEFAULT_ID));
        if (StringUtils.isNULLStr((String)defaultAutoAnalyzePath1) || "null".equalsIgnoreCase(defaultAutoAnalyzePath1)) {
            File file = FileSystemView.getFileSystemView().getDefaultDirectory();
            this.autoAnalyzePath.setText(file.getAbsolutePath());
            this.autoAnalyzePath.setToolTipText(file.getAbsolutePath());
        } else {
            this.autoAnalyzePath.setText(defaultAutoAnalyzePath1);
            this.autoAnalyzePath.setToolTipText(defaultAutoAnalyzePath1);
        }
        String defaultPath1 = String.valueOf(HibernateContainer.getInstance().get((Object)SAVEPATH_DEFAULT_ID));
        if (StringUtils.isNULLStr((String)defaultPath1) || "null".equalsIgnoreCase(defaultPath1)) {
            File defaultFile = FileSystemView.getFileSystemView().getDefaultDirectory();
            this.outputPath.setText(defaultFile.getAbsolutePath());
            this.outputPath.setToolTipText(defaultFile.getAbsolutePath());
        } else {
            this.outputPath.setText(defaultPath1);
            this.outputPath.setToolTipText(defaultPath1);
        }
        String keepTempValue = String.valueOf(HibernateContainer.getInstance().get((Object)TEMPSTATE_DEFAULT_ID));
        String result = keepTempValue.equals("null") ? "false" : keepTempValue;
        boolean iskeep = Boolean.valueOf(result);
        this.keepTemp.setSelected(iskeep);
        HibernateContainer.getInstance().put(TEMPSTATE_DEFAULT_ID, (Object)this.keepTemp.isSelected());
        this.openBox.setSelected(false);
        if (!this.openBox.isSelected()) {
            this.autoAnalyzePath.setEnabled(false);
            this.browseBtn.setEnabled(false);
            this.messa.setText("");
        }
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.setTitle(ResourceUtil.getString((String)"info.analyze.maindialog.btn.set"));
        this.setMinimumSize(DIALOG_SIZE);
        this.pack();
        this.setResizable(false);
        this.setModal(true);
        SwingUtil.putScreenCenter((Window)this);
        placeholderJLabel.setSize(new Dimension(30, 25));
        JLabel outDirDesc = UiMethod.createLabel((String)ResourceUtil.getString((String)"info.analyze.setting.dir.output.dir"));
        JLabel depressDirDesc = UiMethod.createLabel((String)ResourceUtil.getString((String)"info.analyze.setting.dir.depress.dir"));
        JLabel autoAnalyzeDir = UiMethod.createLabel((String)ResourceUtil.getString((String)"info.analyze.autoanalyze.dialog.dir"));
        JLabel autoAnalyze = UiMethod.createLabel((String)ResourceUtil.getString((String)"info.analyze.autoanalyze.dialog.autoanalyze"));
        this.outputPath.setPreferredSize(new Dimension(200, 25));
        this.outputPath.setEditable(false);
        this.depressPath.setPreferredSize(new Dimension(200, 25));
        this.depressPath.setEditable(false);
        this.autoAnalyzePath.setPreferredSize(new Dimension(200, 25));
        this.autoAnalyzePath.setEditable(false);
        JLabel lab = new JLabel();
        lab.setPreferredSize(new Dimension(1, 35));
        JLabel blankLab = new JLabel();
        JLabel wrapLabel = new JLabel();
        JComponent mainCom = null;
        this.messa.setBorder(null);
        this.messa.setBackground(null);
        this.messa.setLineWrap(true);
        if (LanguageManager.getInstance().getCurrentLanguage().getLanguage().equalsIgnoreCase("en")) {
            this.messa.setPreferredSize(new Dimension(200, 35));
            depressDirDesc.setPreferredSize(autoAnalyzeDir.getPreferredSize());
            outDirDesc.setPreferredSize(autoAnalyzeDir.getPreferredSize());
            blankLab.setPreferredSize(new Dimension(15, 1));
            mainCom = UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{depressDirDesc, this.depressPath, this.depressLink}), wrapLabel, UCD.buildHBoxLeft((Component[])new Component[]{outDirDesc, this.outputPath, this.outputLink}), wrapLabel, UCD.buildHBoxLeft((Component[])new Component[]{autoAnalyze, blankLab, blankLab, blankLab, blankLab, this.openBox}), UCD.buildHBoxLeft((Component[])new Component[]{this.messa}), UCD.buildHBoxLeft((Component[])new Component[]{autoAnalyzeDir, this.autoAnalyzePath, this.browseBtn}), UCD.buildHBoxLeft((Component[])new Component[]{lab}), UCD.buildHBoxLeft((Component[])new Component[]{this.keepTemp})});
        } else {
            blankLab.setPreferredSize(new Dimension(0, 1));
            mainCom = UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{placeholderJLabel, depressDirDesc, this.depressPath, this.depressLink}), wrapLabel, UCD.buildHBoxLeft((Component[])new Component[]{placeholderJLabel, outDirDesc, blankLab, this.outputPath, this.outputLink}), wrapLabel, wrapLabel, UCD.buildHBoxLeft((Component[])new Component[]{placeholderJLabel, autoAnalyze, blankLab, blankLab, blankLab, this.openBox}), UCD.buildHBoxLeft((Component[])new Component[]{placeholderJLabel, this.messa}), UCD.buildHBoxLeft((Component[])new Component[]{placeholderJLabel, autoAnalyzeDir, blankLab, this.autoAnalyzePath, this.browseBtn}), UCD.buildHBoxLeft((Component[])new Component[]{placeholderJLabel, lab}), UCD.buildHBoxLeft((Component[])new Component[]{placeholderJLabel, this.keepTemp})});
        }
        this.keepTemp.setText(ResourceUtil.getString((String)"info.analyze.maindialog.checkbox.iskeep"));
        this.setLayout(new BorderLayout());
        Locale lan = Locale.ENGLISH;
        Locale currLan = LanguageManager.getInstance().getCurrentLanguage();
        Box hBox = Box.createHorizontalBox();
        if (lan.equals(currLan)) {
            hBox.add(Box.createHorizontalStrut(12));
        } else {
            hBox.add(Box.createHorizontalStrut(0));
        }
        hBox.add(mainCom);
        hBox.add(Box.createHorizontalStrut(12));
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(12));
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(12));
        this.add((Component)vBox, "North");
        JComponent jsepa = UCD.buildVerticalBox(null, (Component[])new Component[]{new JSeparator()});
        this.add((Component)UiMethod.buildFrameSpace((JComponent)jsepa, (int)0), "Center");
        JComponent jbuton = UCD.buildVerticalBox(null, (Component[])new Component[]{this.createMainPanel()});
        this.add((Component)UiMethod.buildFrameSpace((JComponent)jbuton, (int)12), "South");
    }

    private void addListeners() {
        this.confirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SettingDirDialog.this.checkPath().booleanValue()) {
                    return;
                }
                HibernateContainer.getInstance().put(SettingDirDialog.SAVEPATH_DEFAULT_ID, (Object)SettingDirDialog.this.outputPath.getText());
                SearchConstant.getInstant().setTemp(SettingDirDialog.this.depressPath.getText());
                HibernateContainer.getInstance().put(SettingDirDialog.AUTOANALYZE_PATH_DEFAULT_ID, (Object)SettingDirDialog.this.autoAnalyzePath.getText());
                HibernateContainer.getInstance().put(SettingDirDialog.TEMPSTATE_DEFAULT_ID, (Object)SettingDirDialog.this.keepTemp.isSelected());
                if (SettingDirDialog.this.openBox.isSelected()) {
                    AnalysisMode.setCurrentMode(AnalysisMode.AUTO_ANALYZE);
                    MainLogAnaDialog.getInstance().autoAnalyzeBtnDisable();
                    MainLogAnaDialog.getInstance().layout.getAutoAnalyzeLabel().setText(ResourceUtil.getString((String)"info.autoanalyze.main.label"));
                    AutoAnalyzeTimer.getInstance().start();
                }
                SettingDirDialog.this.dispose();
                LOGGER.debug("SettingDirDialog confrim dispose end-----------------------------------");
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingDirDialog.this.outputPath.setText(String.valueOf(HibernateContainer.getInstance().get((Object)SettingDirDialog.SAVEPATH_DEFAULT_ID)));
                SettingDirDialog.this.dispose();
                LOGGER.debug("SettingDirDialog cancel dispose end-----------------------------------");
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SettingDirDialog.this.outputPath.setText(String.valueOf(HibernateContainer.getInstance().get((Object)SettingDirDialog.SAVEPATH_DEFAULT_ID)));
            }
        });
        this.outputLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolLoggerFactory.getLogger(this.getClass()).debug("Operate : change report dir");
                SettingDirDialog.this.changeOutputPath();
            }
        });
        this.depressLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolLoggerFactory.getLogger(this.getClass()).debug("Operate : change temp dir");
                SettingDirDialog.this.changeDepressTempPath();
            }
        });
        this.browseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolLoggerFactory.getLogger(this.getClass()).debug("Operate : change autoAnalyze dir");
                SettingDirDialog.this.changeAutoAnalyzePath();
            }
        });
        this.openBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SettingDirDialog.this.openBox.isSelected()) {
                    SettingDirDialog.this.autoAnalyzePath.setEnabled(true);
                    SettingDirDialog.this.browseBtn.setEnabled(true);
                    SettingDirDialog.this.messa.setText(ResourceUtil.getString((String)"info.autoanalyze.open.message"));
                } else {
                    SettingDirDialog.this.autoAnalyzePath.setEnabled(false);
                    SettingDirDialog.this.browseBtn.setEnabled(false);
                    SettingDirDialog.this.messa.setText("");
                }
            }
        });
    }

    private Boolean checkPath() {
        try {
            this.validPath();
            this.checkDiskFreeSpace();
            return true;
        }
        catch (PathCheckException e) {
            LOGGER.error("checkPath occor an PathCheckException: ", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("checkPath occor an Throwable: ", (Throwable)e);
            return false;
        }
    }

    private void checkDiskFreeSpace() {
        if (!SearcherUtils.checkDiskFreeSpace(this.outputPath.getText())) {
            ToolLoggerFactory.getLogger(MainLogAnaDialog.class).error("The outputPath selected disk space is not enough.");
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"info.nanlyze.file.report.error"));
            this.outputPath.setText(String.valueOf(HibernateContainer.getInstance().get((Object)SAVEPATH_DEFAULT_ID)));
            this.outputPath.setToolTipText(String.valueOf(HibernateContainer.getInstance().get((Object)SAVEPATH_DEFAULT_ID)));
            throw new PathCheckException(" outputPath[" + this.outputPath + "] is not free ");
        }
        if (!SearcherUtils.checkDiskFreeSpace(this.depressPath.getText())) {
            ToolLoggerFactory.getLogger(MainLogAnaDialog.class).error("The depressPath selected disk space is not enough.");
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"info.nanlyze.file.depress.dir.error"));
            this.depressPath.setText(SearchConstant.getInstant().getTemp());
            this.depressPath.setToolTipText(SearchConstant.getInstant().getTemp());
            throw new PathCheckException(" outputPath[" + this.outputPath + "] is not free ");
        }
        if (this.openBox.isSelected() && !SearcherUtils.checkDiskFreeSpace(this.autoAnalyzePath.getText())) {
            LOGGER.error("The selected disk space is not enough.");
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"info.nanlyze.file.autoanalyze.dir.error"));
            throw new PathCheckException(" autoAnalyzePath[" + this.autoAnalyzePath + "] is not free ");
        }
    }

    private void validPath() {
        if (StringUtils.isNULLStr((String)this.outputPath.getText()) || StringUtils.isNULLStr((String)this.depressPath.getText()) || StringUtils.isNULLStr((String)this.autoAnalyzePath.getText())) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"info.nanlyze.file.path.black"));
            throw new PathCheckException(" outputPath, depressPath, autoAnalyzePath is empty. ");
        }
        if (!SettingDirDialog.checkSelectFile(this.outputPath.getText())) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"info.analyze.filechooser.prompt.file.error.path"));
            this.outputPath.setText(String.valueOf(HibernateContainer.getInstance().get((Object)SAVEPATH_DEFAULT_ID)));
            this.outputPath.setToolTipText(String.valueOf(HibernateContainer.getInstance().get((Object)SAVEPATH_DEFAULT_ID)));
            throw new PathCheckException(" outputPath[" + this.outputPath + "] check error ");
        }
        if (!SettingDirDialog.checkSelectFile(this.depressPath.getText())) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"info.analyze.filechooser.prompt.file.error.path"));
            this.depressPath.setText(SearchConstant.getInstant().getTemp());
            this.depressPath.setToolTipText(SearchConstant.getInstant().getTemp());
            throw new PathCheckException(" depressPath[" + this.depressPath + "] check error ");
        }
        if (!SettingDirDialog.checkSelectFile(this.autoAnalyzePath.getText())) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"info.analyze.filechooser.prompt.file.error.path"));
            throw new PathCheckException(" autoAnalyzePath[" + this.autoAnalyzePath + "] check error ");
        }
    }

    private void changeOutputPath() {
        JTextField outputJLabel;
        this.defaultPath = String.valueOf(HibernateContainer.getInstance().get((Object)SAVEPATH_DEFAULT_ID));
        File report = ToolFileChooser.selectFile((Window)this, (String)ResourceUtil.getString((String)"info.analyze.setting.dir.output.dir.upper"), (String[])new String[0], (String)"SAVEREPORT_TEMP_ID", (String)"", (int)1);
        String reportPath = this.checkPath(report, SAVEPATH_DEFAULT_ID, this.defaultPath, outputJLabel = this.getOutputPath());
        if (reportPath == null) {
            return;
        }
        outputJLabel.setText(reportPath);
        outputJLabel.setToolTipText(reportPath);
        LOGGER.info("save report dir: " + reportPath + " success.");
    }

    private void changeAutoAnalyzePath() {
        JTextField autoAnalyzeJLabel;
        this.defaultAutoAnalyzePath = String.valueOf(HibernateContainer.getInstance().get((Object)AUTOANALYZE_PATH_DEFAULT_ID));
        File report = ToolFileChooser.selectFile((Window)this, (String)ResourceUtil.getString((String)"info.analyze.autoanalyze.dialog.title"), (String[])new String[0], (String)"SAVE_AUTOANALYZE_ID", (String)"", (int)1);
        String autoAnalyzePath1 = this.checkPath(report, AUTOANALYZE_PATH_DEFAULT_ID, this.defaultAutoAnalyzePath, autoAnalyzeJLabel = this.getAutoAnalyzePath());
        if (autoAnalyzePath1 == null) {
            return;
        }
        autoAnalyzeJLabel.setText(autoAnalyzePath1);
        autoAnalyzeJLabel.setToolTipText(autoAnalyzePath1);
        LOGGER.info("save autoAnalyze dir: " + autoAnalyzePath1 + " success.");
    }

    private void changeDepressTempPath() {
        JTextField depressDirJLabel;
        String defaultTempPath = SearchConstant.getInstant().getTemp();
        File depressTempDir = ToolFileChooser.selectFile((Window)this, (String)ResourceUtil.getString((String)"info.analyze.setting.dir.depress.dir.upper"), (String[])new String[0], (String)SAVETEMPPATH_DEFAULT_ID, (String)"", (int)1);
        String tempPath = this.checkPath(depressTempDir, SAVETEMPPATH_DEFAULT_ID, defaultTempPath, depressDirJLabel = this.getDepressPath());
        if (tempPath == null) {
            return;
        }
        String tempPathString = this.setSeparator(tempPath);
        if (!SettingDirDialog.checkSelectFile(tempPathString)) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"info.analyze.filechooser.prompt.file.error.path"));
            if (tempPathString.equalsIgnoreCase(defaultTempPath)) {
                depressDirJLabel.setText("");
                depressDirJLabel.setToolTipText("");
            }
            return;
        }
        depressDirJLabel.setText(tempPathString);
        depressDirJLabel.setToolTipText(tempPathString);
        LOGGER.info("save temp dir: " + tempPath + " success.");
    }

    private static boolean checkSelectFile(String path) {
        File checkFile = new File(String.valueOf(path) + File.separator + "CheckFile");
        if (checkFile.isDirectory() && !checkFile.delete()) {
            return false;
        }
        boolean checkSucc = checkFile.mkdirs();
        if (!checkSucc) {
            return false;
        }
        if (!checkFile.delete()) {
            LOGGER.error("Delete checkFile failed.");
        }
        return true;
    }

    private String checkPath(File report, String defaultId, String defaultPath1, JTextField outputJLabel) {
        String reportPath;
        if (report == null) {
            return null;
        }
        try {
            reportPath = report.getCanonicalPath();
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("get" + report + "path error!", (Throwable)e);
            reportPath = "";
        }
        if (StringUtils.isNULLStr((String)reportPath)) {
            return null;
        }
        if (!SearcherUtils.checkSpecialChar(reportPath)) {
            ToolLoggerFactory.getLogger(MainLogAnaDialog.class).error("The selected path is invalid.");
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"info.nanlyze.file.path.specialcharacter"));
            HibernateContainer.getInstance().put(defaultId, (Object)defaultPath1);
            outputJLabel.setText(defaultPath1);
            LOGGER.error("save dir: " + reportPath + "  failed.");
            return null;
        }
        if (!SearcherUtils.checkBlankSpace(reportPath)) {
            ToolLoggerFactory.getLogger(MainLogAnaDialog.class).error("The selected path include blank.");
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"info.nanlyze.file.path.black"));
            HibernateContainer.getInstance().put(defaultId, (Object)defaultPath1);
            outputJLabel.setText(defaultPath1);
            LOGGER.error("save dir: " + reportPath + "  failed.");
            return null;
        }
        if (!SearcherUtils.checkDiskFreeSpace(reportPath)) {
            ToolLoggerFactory.getLogger(MainLogAnaDialog.class).error("The selected disk space in not enough.");
            if (SAVETEMPPATH_DEFAULT_ID.equalsIgnoreCase(defaultId)) {
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"info.nanlyze.file.depress.dir.error"));
            } else if (AUTOANALYZE_PATH_DEFAULT_ID.equalsIgnoreCase(defaultId)) {
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"info.nanlyze.file.autoanalyze.dir.error"));
            } else {
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"info.nanlyze.file.report.error"));
            }
            HibernateContainer.getInstance().put(defaultId, (Object)defaultPath1);
            outputJLabel.setText(defaultPath1);
            outputJLabel.setToolTipText(defaultPath1);
            LOGGER.error("save dir: " + reportPath + "  failed.");
            return null;
        }
        if (!SearcherUtils.checkPathDeep(report.getAbsolutePath())) {
            ToolLoggerFactory.getLogger(MainLogAnaDialog.class).error("The path is too long.");
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"info.nanlyze.file.path.max.length"));
            HibernateContainer.getInstance().put(defaultId, (Object)defaultPath1);
            outputJLabel.setText(defaultPath1);
            LOGGER.error("save dir: " + reportPath + "  failed.");
            return null;
        }
        return report.getAbsolutePath();
    }

    private String setSeparator(String selectDir) {
        boolean hasSeparator = selectDir.endsWith("\\");
        String tempPathString = hasSeparator ? String.valueOf(selectDir) + "temp" : String.valueOf(selectDir) + File.separator + "temp";
        return tempPathString;
    }

    private JComponent createMainPanel() {
        return UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHBoxRight((Component[])new Component[]{this.confirm, this.cancel})});
    }

    public JButton getOutputLink() {
        return this.outputLink;
    }

    public JTextField getOutputPath() {
        return this.outputPath;
    }

    public JButton getDepressLink() {
        return this.depressLink;
    }

    public JTextField getDepressPath() {
        return this.depressPath;
    }

    public JCheckBox getKeepTemp() {
        return this.keepTemp;
    }

    public void setKeepTemp(JCheckBox keepTemp) {
        this.keepTemp = keepTemp;
    }

    public JTextField getAutoAnalyzePath() {
        return this.autoAnalyzePath;
    }

    public void setAutoAnalyzePath(JTextField autoAnalyzePath) {
        this.autoAnalyzePath = autoAnalyzePath;
    }
}

