/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.ui;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.KeyValue;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.loganalyzer.entity.analyze.AnalyzeResult;
import com.huawei.ism.tool.loganalyzer.entity.analyze.HelpKey;
import com.huawei.ism.tool.loganalyzer.entity.config.ModulePIDInfoMap;
import com.huawei.ism.tool.loganalyzer.util.SearcherUtils;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class ShowLogDetailDialog
extends JDialog {
    private static final long serialVersionUID = 4546043291707548046L;
    private static final int WIDH = 476;
    private static final int DIALOG_WIDH = 500;
    private JButton closeBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"info.analyze.close"), (char)'C');
    private transient AnalyzeResult result = null;
    private JFrame frame = null;

    public ShowLogDetailDialog(JFrame frame, AnalyzeResult ret) {
        super((Frame)frame, true);
        this.frame = frame;
        this.result = ret;
        this.init();
        this.initListener();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setTitle(ResourceUtil.getString((String)"info.analyze.maindialog.problemtable.detail"));
        this.add(this.initPanel());
        this.setSize(500, 500);
        this.setResizable(false);
        this.validate();
        this.setDefaultCloseOperation(2);
        SwingUtil.putParentCenter((Window)this, (Window)this.frame);
    }

    public Box encaJPanel(AnalyzeResult anaResult) {
        List<KeyValue<String, String>> keyvalueList = this.getKeyValueList(anaResult);
        ArrayList<Box> boxList = new ArrayList<Box>();
        String keyString = this.getKey(keyvalueList);
        Map<String, List<HelpKey>> helpKeys = SearcherUtils.getHelpKeys(keyString);
        StringBuffer helpPath = new StringBuffer();
        helpPath.append(ApplicationContext.getInstance().getPackagesPath());
        helpPath.append(File.separator).append("AnalyzeLogTool").append(File.separator).append("products").append(File.separator).append(anaResult.getProduvtModel());
        for (KeyValue<String, String> line : keyvalueList) {
            String key = (String)line.getKey();
            if ("rule_id".equals(key)) continue;
            String value = (String)line.getValue();
            if ("helphref".equals(key) || "issue_no".equals(key) || "prod_list".equals(key) || "issue_ver".equals(key)) continue;
            JLabel keyLabel = new JLabel(String.valueOf(ResourceUtil.getString((String)("info.analyze.problemtable.detail." + key))) + ":");
            if ("issue_desc".equals(key)) {
                JLabel valueJLabel = new JLabel(value);
                valueJLabel.setMaximumSize(new Dimension(400, 21));
                boxList.add(this.getBox(keyLabel, valueJLabel));
            }
            if ("moduleInfo".equals(key)) {
                String valueStr = this.getValueString(value);
                JTextArea textArea = UiMethod.createJTextArea((String)valueStr);
                textArea.setName("moduleInfo");
                JEditorPane caseReference = new JEditorPane();
                caseReference.setEditable(false);
                caseReference.setFocusable(true);
                caseReference.setContentType("text/html;charset=\"UTF-8\"");
                caseReference.setText(this.getHtml(valueStr));
                JScrollPane resultPan = new JScrollPane(caseReference);
                UiMethod.setComponentSize((Dimension)new Dimension(476, 35), (Component[])new Component[]{resultPan});
                textArea.setCaretPosition(0);
                boxList.add(this.buildBox(keyLabel, resultPan));
                caseReference.setName("diagnose_jeditorpane_module_info");
                resultPan.setName("diagnose_jscrollpane_module_info");
                keyLabel.setName("diagnose_keylabel_module_info");
                continue;
            }
            if ("root_cause".equals(key)) {
                JTextArea textArea = UiMethod.createJTextArea((String)value);
                JEditorPane caseReference = new JEditorPane();
                caseReference.setEditable(false);
                caseReference.setFocusable(true);
                caseReference.setContentType("text/html;charset=\"UTF-8\"");
                caseReference.setText(this.getHtml(value));
                JScrollPane resultPan = new JScrollPane(caseReference);
                UiMethod.setComponentSize((Dimension)new Dimension(476, 100), (Component[])new Component[]{resultPan});
                textArea.setCaretPosition(0);
                boxList.add(this.buildBox(keyLabel, resultPan));
                caseReference.setName("diagnose_jeditorpane_root_cause");
                resultPan.setName("diagnose_jscrollpane_root_cause");
                keyLabel.setName("diagnose_keylabel_root_cause");
                continue;
            }
            if (!"action".equals(key)) continue;
            JEditorPane reference = new JEditorPane();
            reference.setEditable(false);
            reference.setFocusable(true);
            reference.setContentType("text/html;charset=\"UTF-8\"");
            String valueWithLink = SearcherUtils.replaceKeysByMap(value, helpPath.toString(), helpKeys);
            reference.setText(this.getHtml(valueWithLink));
            reference.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    ShowLogDetailDialog.this.doHyperLinkEvent(e);
                }
            });
            JScrollPane refPan = new JScrollPane(reference);
            UiMethod.setComponentSize((Dimension)new Dimension(476, 130), (Component[])new Component[]{refPan});
            reference.setCaretPosition(0);
            boxList.add(this.buildBox(keyLabel, refPan));
            reference.setName("diagnose_jeditorpane_action");
            refPan.setName("diagnose_jscrollpane_action");
            keyLabel.setName("diagnose_keylabel_action");
        }
        return this.verticalLayOutBox(boxList);
    }

    private String getValueString(String value) {
        value = value.replace("\n", "");
        String moduleName = ModulePIDInfoMap.get(value);
        String valueStr = ResourceUtil.getStringWithParams((String)"info.analyze.problemtable.detail.moduleId", (Object[])new Object[]{value, moduleName});
        return valueStr;
    }

    private Box verticalLayOutBox(List<Box> boxList) {
        Box box = Box.createVerticalBox();
        for (Box singleBox : boxList) {
            box.add(singleBox);
            box.add(Box.createVerticalStrut(6));
        }
        return box;
    }

    private Box getBox(JComponent boxfor, JLabel desc) {
        desc.setName("diagnose_issue_desc_key");
        boxfor.setName("diagnose_issue_desc_value");
        return UCD.buildHBoxLeft((Component[])new Component[]{boxfor, desc, Box.createHorizontalStrut(12)});
    }

    public Box buildBox(JComponent boxfor, JComponent component) {
        Box boxarea = Box.createVerticalBox();
        boxarea.add(UCD.buildHBoxLeft((Component[])new Component[]{boxfor}));
        boxarea.add(Box.createVerticalStrut(8));
        boxarea.add(UCD.buildHBoxLeft((Component[])new Component[]{component, Box.createHorizontalStrut(0)}));
        return boxarea;
    }

    private List<KeyValue<String, String>> getKeyValueList(AnalyzeResult anaresult) {
        ArrayList<KeyValue<String, String>> keyvalueList = new ArrayList<KeyValue<String, String>>();
        for (KeyValue<String, String> keyvalueline : anaresult.getViewInfoTable()) {
            String key = (String)keyvalueline.getKey();
            String value = (String)keyvalueline.getValue();
            if ("prod_list".equals(key)) {
                keyvalueList.add(2, (KeyValue<String, String>)new KeyValue((Object)key, (Object)this.getInterfaceValue(value)));
                continue;
            }
            keyvalueList.add((KeyValue<String, String>)new KeyValue((Object)key, (Object)this.getInterfaceValue(value)));
        }
        return keyvalueList;
    }

    private String getInterfaceValue(String initValue) {
        Locale lan = LanguageManager.getInstance().getCurrentLanguage();
        String value = initValue;
        if (StringUtils.isNULLStr((String)value)) {
            value = "";
        }
        boolean isContains = value.contains("##");
        boolean isEqualEN = "en".equals(lan.toString());
        boolean isEqualZH = "zh_CN".equals(lan.toString());
        if (isContains && isEqualEN) {
            value = value.substring(value.indexOf("##") + 1, value.length());
        } else if (isContains && isEqualZH) {
            value = value.substring(0, value.indexOf("##"));
        }
        return SearcherUtils.newLine(value, false);
    }

    private void initListener() {
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowLogDetailDialog.this.dispose();
            }
        });
    }

    private void doHyperLinkEvent(HyperlinkEvent e) {
        if (HyperlinkEvent.EventType.ACTIVATED == e.getEventType()) {
            try {
                boolean www;
                String url = e.getDescription();
                if (StringUtils.isNULLStr((String)url)) {
                    DialogUtils.showErrorDialog((JDialog)this, (String)ResourceUtil.getString((String)"inspect.case.link"));
                    return;
                }
                ToolLoggerFactory.getLogger(this.getClass()).debug("open url : " + url);
                boolean http = url.startsWith("http") || url.startsWith("HTTP");
                boolean bl = www = url.startsWith("www.") || url.startsWith("WWW.");
                if (http || www) {
                    FileUtils.openHtmlFile((String)url);
                    return;
                }
                OSCmdUtils.explorerFile((String)url);
            }
            catch (Exception ex) {
                ToolLoggerFactory.getLogger(this.getClass()).error("open the file failed", (Throwable)ex);
            }
        }
    }

    private String getHtml(String value) {
        StringBuffer refText = new StringBuffer();
        StringBuffer context = new StringBuffer();
        refText.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" ").append("\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n").append("<html xmlns=\"http://www.w3.org/1999/xhtml\">\n").append("<head>\n").append("<style type= \"text/css\">").append("body{ font-size:8px;color:#464646;}").append(".exp{font-size:9px;color:#252525;}").append(".link{color:#4286d3;}").append("selected::selection{color:#ffffff;background:#990000;}").append("selected::-moz-selection{background:#990000;}").append("</style>\n").append("</head>\n").append("<body>\n");
        context.append("<div class=\"exp\">").append(value).append("</div>");
        refText.append(context.toString().replaceAll("\n", "<br>"));
        refText.append("</body>");
        refText.append("</html>");
        return refText.toString();
    }

    private String getKey(List<KeyValue<String, String>> keyvalueList) {
        String value = "";
        for (KeyValue<String, String> line : keyvalueList) {
            if (!"helphref".equals(line.getKey())) continue;
            value = (String)line.getValue();
            break;
        }
        return value;
    }

    private JComponent initPanel() {
        JPanel logPan = new JPanel(new BorderLayout());
        logPan.add((Component)this.encaJPanel(this.result), "North");
        JComponent btnArea = UiMethod.buildFrameSpace((JComponent)UiMethod.buildCompsRight((Component[])new Component[]{this.closeBtn}), (int)12);
        JComponent northArea = UiMethod.buildFrameSpace((JComponent)logPan, (int)12);
        northArea.remove(2);
        btnArea.remove(0);
        return UCD.buildVerticalBox(null, (Component[])new Component[]{northArea, new JSeparator(), btnArea});
    }
}

