/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.ui;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.entity.analyze.AnalyzeResult;
import com.huawei.ism.tool.loganalyzer.entity.config.SingleLogSearchRule;
import com.huawei.ism.tool.loganalyzer.entity.log.Log;
import com.huawei.ism.tool.loganalyzer.worktaker.impl.LogWorkTakerImpl;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.slf4j.Logger;

public class ShowLogReadDialog
extends JDialog {
    private static final long serialVersionUID = -3385594782087557775L;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(LogWorkTakerImpl.class);
    private transient Map<SingleLogSearchRule, List<Log>> ruleLogResult = null;
    private JButton closeBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"info.analyze.close"), (char)'C');
    private JEditorPane textPane = null;
    private JFrame frame = null;

    public ShowLogReadDialog(JFrame frame, Map<SingleLogSearchRule, List<Log>> ruleLogResultMap, final AnalyzeResult result) {
        super((Frame)frame, true);
        this.frame = frame;
        this.ruleLogResult = ruleLogResultMap;
        if (result.getOriginalLogs().size() > 1000) {
            AsyncExcutor.execute((Window)frame, (Callable[])new Callable[]{new Callable<Object>(){

                @Override
                public Object call() {
                    ShowLogReadDialog.this.init(result.getProduvtModel());
                    ShowLogReadDialog.this.initListener();
                    return true;
                }
            }});
        } else {
            this.init(result.getProduvtModel());
            this.initListener();
        }
    }

    private void init(String produvtModel) {
        this.setLayout(new BorderLayout());
        this.setTitle(ResourceUtil.getString((String)"info.analyze.maindialog.problemtable.log"));
        this.layoutComponent(produvtModel);
        this.setSize(700, 500);
        this.setResizable(false);
        this.validate();
        this.setDefaultCloseOperation(2);
        SwingUtil.putParentCenter((Window)this, (Window)this.frame);
    }

    private void layoutComponent(String produvtModel) {
        JPanel logPan = new JPanel(new BorderLayout());
        String logsString = this.getLogsString(this.ruleLogResult, produvtModel);
        logPan.add((Component)this.encapJTextArea(logsString), "Center");
        this.add(UiMethod.buildFrameSpace((JComponent)UCD.buildVerticalBox(null, (Component[])new Component[]{logPan, UiMethod.buildCompsRight((Component[])new Component[]{this.closeBtn})}), (int)12));
    }

    public JComponent encapJTextArea(String pragraph) {
        this.textPane = new JEditorPane();
        this.textPane.setContentType("text/html;charset=\"UTF-8\"");
        this.textPane.setText(pragraph);
        this.textPane.setEditable(false);
        JScrollPane scroll = new JScrollPane(this.textPane);
        scroll.setVerticalScrollBarPolicy(20);
        scroll.setHorizontalScrollBarPolicy(30);
        Box scrollbox = Box.createHorizontalBox();
        scrollbox.add(scroll);
        this.textPane.setCaretPosition(0);
        this.textPane.setName("link_textpane");
        scroll.setName("link_scroll");
        return scrollbox;
    }

    private String getLogsString(Map<SingleLogSearchRule, List<Log>> logResultMap, String produvtModel) {
        ArrayList<List<Log>> allLogList = new ArrayList<List<Log>>();
        allLogList.addAll(logResultMap.values());
        ArrayList allLogs = new ArrayList();
        for (List list : allLogList) {
            allLogs.addAll(list);
        }
        StringBuffer stringBuffer = new StringBuffer();
        String line = null;
        stringBuffer.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n").append("</head>\n<body>\n");
        if (allLogs.isEmpty()) {
            stringBuffer.append(ResourceUtil.getStringWithParams((String)"info.analyze.message.no.log", (Object[])new Object[]{produvtModel}));
            stringBuffer.append("</body>");
            stringBuffer.append("</html>");
            return stringBuffer.toString();
        }
        stringBuffer.append("<table>");
        for (Log singlelog : allLogs) {
            stringBuffer.append("<tr>");
            stringBuffer.append("<td nowrap>");
            stringBuffer.append("<a href=\"" + singlelog.getLogPath() + "\" target=\"new\">");
            stringBuffer.append(new File(singlelog.getLogPath()).getName());
            stringBuffer.append("</a>");
            stringBuffer.append("</td>");
            line = singlelog.getOriginalStr();
            stringBuffer.append("<td nowrap>");
            stringBuffer.append("<pre>" + line + "</pre>");
            stringBuffer.append("</td>");
            stringBuffer.append("</tr>");
        }
        stringBuffer.append("</table>");
        stringBuffer.append("</body>");
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }

    private void doHyperLinkEvent(HyperlinkEvent e) {
        if (HyperlinkEvent.EventType.ACTIVATED == e.getEventType()) {
            try {
                String url = e.getDescription();
                ToolLoggerFactory.getLogger(this.getClass()).debug("open url : " + url);
                OSCmdUtils.explorerFile((String)url);
            }
            catch (Exception ex) {
                LOGGER.error("open the file failed", (Throwable)ex);
            }
        }
    }

    private void initListener() {
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowLogReadDialog.this.dispose();
            }
        });
        this.textPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                ShowLogReadDialog.this.doHyperLinkEvent(e);
            }
        });
    }
}

