/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.ui;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.version.Model;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.version.Version;
import com.huawei.ism.tool.loganalyzer.faulttree.model.DeviceType;
import com.huawei.ism.tool.loganalyzer.ui.ShowVerDetailDialog;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.table.TableModel;

public class ShowVersionDialog
extends JDialog {
    private static final long serialVersionUID = 7287732492588519431L;
    private static final Dimension DIALOG_SIZE = new Dimension(400, 450);
    private String[] header = new String[]{ResourceUtil.getString((String)"info.analyze.versiontable.head.devicemode"), ResourceUtil.getString((String)"info.analyze.versiontable.head.productversion"), ResourceUtil.getString((String)"info.analyze.versiontable.head.title")};
    private DefaultTableModel tableModel = new DefaultTableModel(this.header, new int[0]);
    private IsmTable versionTable = null;
    private JButton closeBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"info.analyze.support.dialog.okbtn"), (char)'C');

    public ShowVersionDialog(Window parent) {
        super(parent);
        this.initUI();
        this.initData();
    }

    private void initUI() {
        this.setTitle(ResourceUtil.getString((String)"info.analyze.support.dialog.title"));
        this.setModal(true);
        this.setResizable(false);
        this.validate();
        this.pack();
        this.setMinimumSize(DIALOG_SIZE);
        SwingUtil.putScreenCenter((Window)this);
        JLabel desc = UiMethod.createLabel((String)ResourceUtil.getString((String)"info.analyze.support.dialog.desc"));
        JComponent mainCom = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((Component[])new Component[]{desc}), this.buildTablePanel(), this.bulidButtonPanel()});
        this.setLayout(new BorderLayout());
        this.add(UiMethod.buildFrameSpace((JComponent)mainCom, (int)12));
    }

    public JComponent buildTablePanel() {
        this.versionTable = new IsmTable((TableModel)this.tableModel);
        return new TableScrollPane(this.versionTable);
    }

    public JComponent bulidButtonPanel() {
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ShowVersionDialog.this.dispose();
            }
        });
        return UCD.buildHBoxRight((Component[])new Component[]{this.closeBtn});
    }

    private void initData() {
        List<Model> modelList = DeviceType.getModelList();
        for (Model model : modelList) {
            TableRow<String, String> row = this.createDeviceTableRow(model.getName(), model.getVersionList());
            this.tableModel.addRow(new TableRow[]{row});
        }
    }

    private TableRow<String, String> createDeviceTableRow(String key, List<Version> list) {
        DefaultTableRow row = new DefaultTableRow(this.tableModel.getColumnCount(), (Object)key, (Object)key);
        StringBuffer sb = new StringBuffer();
        ArrayList<String> vList = new ArrayList<String>();
        int i = 0;
        while (i < list.size()) {
            Version version = list.get(i);
            vList.add(version.getValue());
            if (i == list.size() - 1) {
                sb.append(version.getValue()).append(". ");
            } else {
                sb.append(version.getValue()).append(", ");
            }
            ++i;
        }
        row.setValueAt(0, (Object)key);
        row.setValueAt(1, (Object)sb.toString());
        row.setValueAt(2, (Object)new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"info.analyze.support.dialog.table.check"), (ActionListener)new VeiwLinkAction(vList)));
        return row;
    }

    private class VeiwLinkAction
    implements ActionListener {
        private List<String> values;

        public VeiwLinkAction(List<String> values) {
            this.values = values;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new ShowVerDetailDialog((Window)ShowVersionDialog.this, this.values).setVisible(true);
        }
    }
}

