/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.ui;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.entity.AnalyzeUserOpData;
import com.huawei.ism.tool.loganalyzer.entity.SearchKeyword;
import com.huawei.ism.tool.loganalyzer.entity.analyze.AdvancedSearchResult;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogFileSearchBean;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogRow;
import com.huawei.ism.tool.loganalyzer.entity.analyze.SearchResult;
import com.huawei.ism.tool.loganalyzer.entity.execresult.SearchResultListCellRender;
import com.huawei.ism.tool.loganalyzer.logic.AnalyzeUserOpService;
import com.huawei.ism.tool.loganalyzer.logic.logsearcher.ExportLogFileTread;
import com.huawei.ism.tool.loganalyzer.logic.logsearcher.ViewLogService;
import com.huawei.ism.tool.loganalyzer.ui.DateChooseField;
import com.huawei.ism.tool.loganalyzer.ui.FileDirTreeFile;
import com.huawei.ism.tool.loganalyzer.ui.JprogressBar;
import com.huawei.ism.tool.loganalyzer.util.CheckBoxTree;
import com.huawei.ism.tool.loganalyzer.util.FileListFileFilterUtils;
import com.huawei.ism.tool.loganalyzer.util.SearchConstant;
import com.huawei.ism.tool.loganalyzer.util.SearcherUtils;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeCellEditor;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;

public class ViewLogDialog
extends JComponent {
    public static final int NEGATIVE_NUMBER_ONE = -1;
    public static final int NUMBER_ZERO = 0;
    public static final int NUMBER_ONE = 1;
    public static final int NUMBER_TWO = 2;
    public static final int NUMBER_TEN = 10;
    public static final int NUMBER_FIVE = 5;
    public static final int NUMBER_TWENTY = 20;
    public static final int NUMBER_THREE_HUNDRED = 300;
    public static final int NUMBER_HUNDRED = 100;
    public static final int NUMBER_HUNDRED_FIFTY = 150;
    public static final int NUMBER_HUNDRED_FIFTY_FOUR = 154;
    public static final int NUMBER_FIFTY = 50;
    public static final int SEARCHRESULT_PAGESIZE = 500;
    public static final int NUMBER_FIVE_THOUSAND = 5000;
    public static final float NUMBER_POINT_EIGHT = 0.8f;
    public static final float NUMBER_POINT_TWO = 0.2f;
    private static final long serialVersionUID = -9078214491097150708L;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ViewLogDialog.class);
    private static final Color COLOR_BEFORE_CLICK = new Color(4359891);
    private static final Dimension PAGECURRENT_SIZE = new Dimension(40, 20);
    private static final Dimension SEARCHTEXT_SIZE = new Dimension(180, 20);
    private DateChooseField beginDate;
    private DateChooseField endDate;
    private JTextArea fileContentArea = new JTextArea();
    private Window frame;
    private JButton pagePrevBtn = new JButton(ResourceUtil.getString((String)"info.analyze.advanced.prevPage"));
    private JButton pageNextBtn = new JButton(ResourceUtil.getString((String)"info.analyze.advanced.nextPage"));
    private JButton pageFirstBtn = new JButton(ResourceUtil.getString((String)"info.analyze.advanced.firstPage"));
    private JButton pageLastBtn = new JButton(ResourceUtil.getString((String)"info.analyze.advanced.lastPage"));
    private JButton pageGoBtn = new JButton(ResourceUtil.getString((String)"info.analyze.advanced.go"));
    private JLabel splitLabel = new JLabel("/");
    private JLabel origSplitLabel = new JLabel("/");
    private JFormattedTextField pageCurrent = new JFormattedTextField(new DecimalFormat("#0"));
    private JLabel pageTotal = new JLabel();
    private JButton origFilePrevBtn = new JButton(ResourceUtil.getString((String)"info.analyze.advanced.prevFile"));
    private JButton origFileNextBtn = new JButton(ResourceUtil.getString((String)"info.analyze.advanced.nextFile"));
    private JButton origPageFirstBtn = new JButton(ResourceUtil.getString((String)"info.analyze.advanced.firstPage"));
    private JButton origPageLastBtn = new JButton(ResourceUtil.getString((String)"info.analyze.advanced.lastPage"));
    private JButton origPageGoBtn = new JButton(ResourceUtil.getString((String)"info.analyze.advanced.go"));
    private JFormattedTextField origPageCurrent = new JFormattedTextField(new DecimalFormat("#0"));
    private JLabel origPageTotal = new JLabel();
    private transient LogRow row;
    private transient LogFileSearchBean downloadSearchBean = null;
    private transient ViewLogService viewLogService;
    private JList searchResultJList;
    private DefaultListModel<SearchResult> searchResultmodel = new DefaultListModel();
    private JScrollPane fileContentSP;
    private List<File> originalFileList;
    private Set<File> originalFileSet = new HashSet<File>();
    private transient AdvancedSearchResult searchReasult;
    private CheckBoxTree fileDirTree;
    private DefaultTreeModel treeModel;
    private JButton exportButton = UiMethod.createButton((String)ResourceUtil.getString((String)"info.analyze.advanced.exportingLogs"));
    private JButton searchButton = UiMethod.createButton((String)ResourceUtil.getString((String)"info.analyze.advanced.search"));
    private JButton resetButton = UiMethod.createButton((String)ResourceUtil.getString((String)"info.analyze.advanced.reset"));
    private JLabel dateLable = UiMethod.createColonLabel((String)ResourceUtil.getString((String)"info.analyze.advanced.screeningTime"));
    private JLabel clearLabel = new JLabel(ResourceUtil.getString((String)"info.analyze.setting.date.btn.clear"));
    private JLabel bakLabel = new JLabel("");
    private JLabel keyWordLable = UiMethod.createColonLabel((String)ResourceUtil.getString((String)"info.analyze.advanced.keyword"));
    private JLabel includeLable = new JLabel(ResourceUtil.getString((String)"info.analyze.advanced.included"));
    private JLabel excludeKeyWordLable = new JLabel(ResourceUtil.getString((String)"info.analyze.advanced.excludedKeyword"));
    private JTextField keyWordText = new JTextField(ResourceUtil.getString((String)"info.analyze.advanced.separateKeyword"));
    private JTextField excludeKeyWordText = new JTextField(ResourceUtil.getString((String)"info.analyze.advanced.separateKeyword"));
    private JLabel recordNumLable = UiMethod.createColonLabel((String)ResourceUtil.getString((String)"info.analyze.advanced.total"));
    private JLabel recordNum = new JLabel();
    private JLabel toLable = new JLabel("-");

    public ViewLogDialog(Window frame, LogRow row) {
        this.viewLogService = new ViewLogService();
        this.row = row;
        this.frame = frame;
        this.originalFileList = new ArrayList<File>();
        this.initFileDirTree();
        this.initUI();
        this.initData();
        this.initUiListener();
        this.setComponentName();
    }

    private void setComponentName() {
        this.beginDate.setName("beginDate");
        this.endDate.setName("endDate");
        this.clearLabel.setName("clearLabel");
        this.keyWordText.setName("keyWordText");
        this.excludeKeyWordText.setName("excludeKeyWordText");
        this.fileContentArea.setName("fileContentArea");
        this.searchResultJList.setName("searchResultJList");
        this.origPageFirstBtn.setName("origpagefirstbtn");
        this.origPageLastBtn.setName("origpagelastbtn");
        this.origPageGoBtn.setName("origpagegobtn");
        this.origPageCurrent.setName("origpagecurrent");
        this.origPageTotal.setName("origpagetotal");
        this.origFilePrevBtn.setName("origpageprevbtn");
        this.origFileNextBtn.setName("origpagenextbtn");
        this.pageTotal.setName("pageTotal");
        this.pageCurrent.setName("pageCurrent");
        this.pagePrevBtn.setName("pagePrevBtn");
        this.pageNextBtn.setName("pagenextbtn");
        this.pageFirstBtn.setName("pageFirstBtn");
        this.pageLastBtn.setName("pageLastBtn");
        this.pageGoBtn.setName("pageGoBtn");
        this.exportButton.setName("exportButton");
        this.recordNum.setName("recordNum");
    }

    public ViewLogService getViewLogService() {
        return this.viewLogService;
    }

    public void setViewLogService(ViewLogService viewLogService) {
        this.viewLogService = viewLogService;
    }

    private void initData() {
        this.pageCurrent.setText(String.valueOf(1));
        this.pageTotal.setText(String.valueOf(0));
        this.recordNum.setText(String.valueOf(0));
        this.origPageCurrent.setText(String.valueOf(1));
        this.origPageTotal.setText(String.valueOf(0));
        this.keyWordText.setForeground(Color.gray);
        this.excludeKeyWordText.setForeground(Color.gray);
        this.fileContentArea.setSelectionColor(this.searchResultJList.getSelectionBackground());
        this.operateOrigFilePowers();
        this.resetButton.setEnabled(false);
        this.exportButton.setEnabled(false);
        this.operatePowers();
        String separateKeyword = String.valueOf(ResourceUtil.getString((String)"info.analyze.advanced.separateKeyword")) + ResourceUtil.getString((String)"info.analyze.advanced.includingMeaning");
        this.keyWordText.setText(separateKeyword);
        this.keyWordAppend(this.keyWordText, separateKeyword);
        String excludeSeparateKeyword = String.valueOf(ResourceUtil.getString((String)"info.analyze.advanced.separateKeyword")) + ResourceUtil.getString((String)"info.analyze.advanced.excludingMeaning");
        this.excludeKeyWordText.setText(excludeSeparateKeyword);
        this.keyWordAppend(this.excludeKeyWordText, excludeSeparateKeyword);
    }

    private LogFileSearchBean getSearchBean() {
        LogFileSearchBean searchBean = new LogFileSearchBean();
        searchBean.setCurPage(Integer.parseInt(this.pageCurrent.getText()));
        searchBean.setPageSize(500);
        searchBean.setStartDate(searchBean.parseDate2Long(this.beginDate.getText(), "yyyy-MM-dd HH:mm:ss"));
        searchBean.setEndDate(searchBean.parseDate2Long(this.endDate.getText(), "yyyy-MM-dd HH:mm:ss"));
        String separateKeyword = String.valueOf(ResourceUtil.getString((String)"info.analyze.advanced.separateKeyword")) + ResourceUtil.getString((String)"info.analyze.advanced.includingMeaning");
        String excludeSeparateKeyword = String.valueOf(ResourceUtil.getString((String)"info.analyze.advanced.separateKeyword")) + ResourceUtil.getString((String)"info.analyze.advanced.excludingMeaning");
        if (!separateKeyword.equals(this.keyWordText.getText()) && !StringUtils.isNULLStr((String)this.keyWordText.getText())) {
            searchBean.setContainKeywords(Arrays.asList(this.keyWordText.getText().split(";")));
        }
        if (!excludeSeparateKeyword.equals(this.excludeKeyWordText.getText()) && !StringUtils.isNULLStr((String)this.excludeKeyWordText.getText())) {
            searchBean.setNotContainKeywords(Arrays.asList(this.excludeKeyWordText.getText().split(";")));
        }
        return searchBean;
    }

    private void initUI() {
        this.beginDate = new DateChooseField();
        this.beginDate.init(this.frame);
        this.endDate = new DateChooseField();
        this.endDate.init(this.frame);
        UiMethod.setComponentSize((Dimension)new Dimension(154, 20), (Component[])new Component[]{this.beginDate, this.endDate});
        UiMethod.setComponentSize((Dimension)PAGECURRENT_SIZE, (Component[])new Component[]{this.pageCurrent, this.origPageCurrent});
        this.layoutComponents();
    }

    private void doSearch(final LogFileSearchBean searchBean, final boolean reLoadFlag) {
        String resultStr = this.onSearch();
        if (!StringUtils.isNULLStr((String)resultStr)) {
            DialogUtils.showInfoDialog((Window)this.frame, (String)resultStr);
        } else {
            this.recordKeywords(searchBean.getContainKeywords(), true);
            this.recordKeywords(searchBean.getNotContainKeywords(), false);
            AsyncExcutor.execute((Window)this.frame, (Callable[])new Callable[]{new Callable<Object>(){

                @Override
                public Object call() {
                    if (reLoadFlag) {
                        ViewLogDialog.this.searchReasult = ViewLogDialog.this.viewLogService.getSearchResult(ViewLogDialog.this.originalFileList, searchBean);
                    }
                    ViewLogDialog.this.loadFileContent(searchBean);
                    return true;
                }
            }});
            this.resetButton.setEnabled(true);
            this.exportButton.setEnabled(Integer.parseInt(this.pageTotal.getText()) > 0);
            this.operatePowers();
        }
    }

    private void recordKeywords(List<String> keywords, boolean isContain) {
        try {
            AnalyzeUserOpData userOpData = AnalyzeUserOpService.getLogPackageUserOpData(this.row);
            if (keywords != null && !keywords.isEmpty()) {
                for (String keyword : keywords) {
                    SearchKeyword searchKeyword = new SearchKeyword();
                    searchKeyword.setKeyword(keyword);
                    searchKeyword.setContain(isContain);
                    userOpData.getSearchKeywords().add(searchKeyword);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Recourd Advanced Analyze Search Keyword Error", (Throwable)e);
        }
    }

    private void doSearchOrigialFile() {
        AsyncExcutor.execute((Window)this.frame, (Callable[])new Callable[]{new Callable<Object>(){

            @Override
            public Object call() {
                ViewLogDialog.this.loadOrigialFile();
                return true;
            }
        }});
    }

    private void exportLogFile(String filePath) {
        if (this.downloadSearchBean != null) {
            JprogressBar bar = new JprogressBar(this.frame);
            ExportLogFileTread exportLogFileTread = new ExportLogFileTread(filePath, this.searchReasult.getFileList(), this.viewLogService, this.downloadSearchBean, bar);
            exportLogFileTread.setName("exportLogFileThread");
            exportLogFileTread.start();
            bar.setVisible(true);
        }
    }

    private void addClearLabelListener() {
        this.clearLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent paramMouseEvent) {
                if (2 == SearchConstant.getInstant().getDateType()) {
                    ViewLogDialog.this.beginDate.setText("");
                    ViewLogDialog.this.endDate.setText("");
                }
                ViewLogDialog.this.repaint();
            }
        });
    }

    private void addSearchButtonListener() {
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewLogDialog.this.pageCurrent.setText(String.valueOf(1));
                ViewLogDialog.this.pageTotal.setText(String.valueOf(0));
                ViewLogDialog.this.recordNum.setText(String.valueOf(0));
                LogFileSearchBean searchBean = ViewLogDialog.this.getSearchBean();
                ViewLogDialog.this.downloadSearchBean = searchBean;
                if (ViewLogDialog.this.checkTime()) {
                    ViewLogDialog.this.doSearch(searchBean, true);
                }
            }
        });
    }

    private void addResetButtonListener() {
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewLogDialog.this.beginDate.setText("");
                ViewLogDialog.this.endDate.setText("");
                ViewLogDialog.this.keyWordText.setForeground(Color.GRAY);
                ViewLogDialog.this.excludeKeyWordText.setForeground(Color.GRAY);
                ViewLogDialog.this.keyWordText.setText("");
                ViewLogDialog.this.excludeKeyWordText.setText("");
                ViewLogDialog.this.clearSearchResult();
                ViewLogDialog.this.resetButton.setEnabled(false);
                String separateKeyword = String.valueOf(ResourceUtil.getString((String)"info.analyze.advanced.separateKeyword")) + ResourceUtil.getString((String)"info.analyze.advanced.includingMeaning");
                ViewLogDialog.this.keyWordText.setText(separateKeyword);
                ViewLogDialog.this.keyWordAppend(ViewLogDialog.this.keyWordText, separateKeyword);
                String excludeSeparateKeyword = String.valueOf(ResourceUtil.getString((String)"info.analyze.advanced.separateKeyword")) + ResourceUtil.getString((String)"info.analyze.advanced.excludingMeaning");
                ViewLogDialog.this.excludeKeyWordText.setText(excludeSeparateKeyword);
                ViewLogDialog.this.keyWordAppend(ViewLogDialog.this.excludeKeyWordText, excludeSeparateKeyword);
            }
        });
    }

    private void addExportButtonListener() {
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String filePath = SearcherUtils.getSaveFilePath(ResourceUtil.getString((String)"info.analyze.advanced.exportingLogs"), "txt", ViewLogDialog.this.frame, "", "default_viewlog_export_id", true, 2);
                if (StringUtils.isNULLStr((String)filePath)) {
                    return;
                }
                ViewLogDialog.this.exportLogFile(filePath);
            }
        });
    }

    private void addPagePrevBtnListener() {
        this.pagePrevBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int pageCurrentNum;
                int n = pageCurrentNum = StringUtils.isNULLStr((String)ViewLogDialog.this.pageCurrent.getText()) ? 1 : Integer.parseInt(ViewLogDialog.this.pageCurrent.getText());
                if (pageCurrentNum > 1) {
                    ViewLogDialog.this.pageCurrent.setText(String.valueOf(pageCurrentNum - 1));
                } else {
                    ViewLogDialog.this.pageCurrent.setText(String.valueOf(1));
                }
                ViewLogDialog.this.downloadSearchBean.setCurPage(Integer.parseInt(ViewLogDialog.this.pageCurrent.getText()));
                ViewLogDialog.this.doSearch(ViewLogDialog.this.downloadSearchBean, false);
            }
        });
    }

    private void addPageNextBtnListener() {
        this.pageNextBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int pageTotalNum;
                int pageCurrentNum = StringUtils.isNULLStr((String)ViewLogDialog.this.pageCurrent.getText()) ? 0 : Integer.parseInt(ViewLogDialog.this.pageCurrent.getText());
                if (pageCurrentNum < (pageTotalNum = Integer.parseInt(ViewLogDialog.this.pageTotal.getText()))) {
                    ViewLogDialog.this.pageCurrent.setText(String.valueOf(pageCurrentNum + 1));
                } else {
                    ViewLogDialog.this.pageCurrent.setText(String.valueOf(pageTotalNum));
                }
                ViewLogDialog.this.downloadSearchBean.setCurPage(Integer.parseInt(ViewLogDialog.this.pageCurrent.getText()));
                ViewLogDialog.this.doSearch(ViewLogDialog.this.downloadSearchBean, false);
            }
        });
    }

    private void addPageFirstBtnListener() {
        this.pageFirstBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewLogDialog.this.pageCurrent.setText(String.valueOf(1));
                ViewLogDialog.this.downloadSearchBean.setCurPage(Integer.parseInt(ViewLogDialog.this.pageCurrent.getText()));
                ViewLogDialog.this.doSearch(ViewLogDialog.this.downloadSearchBean, false);
            }
        });
    }

    private void addPageLastBtnListener() {
        this.pageLastBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int pageTotalNum = Integer.parseInt(ViewLogDialog.this.pageTotal.getText());
                ViewLogDialog.this.pageCurrent.setText(String.valueOf(pageTotalNum));
                ViewLogDialog.this.downloadSearchBean.setCurPage(Integer.parseInt(ViewLogDialog.this.pageCurrent.getText()));
                ViewLogDialog.this.doSearch(ViewLogDialog.this.downloadSearchBean, false);
            }
        });
    }

    private void addPageGoBtnListener() {
        this.pageGoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewLogDialog.this.downloadSearchBean.setCurPage(Integer.parseInt(ViewLogDialog.this.pageCurrent.getText()));
                ViewLogDialog.this.doSearch(ViewLogDialog.this.downloadSearchBean, false);
            }
        });
    }

    private void addPageCurrentListener() {
        this.pageCurrent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                String old = ViewLogDialog.this.pageCurrent.getText();
                if (old.length() >= 8 || StringUtils.isNULLStr((String)old)) {
                    ViewLogDialog.this.pageCurrent.setText(String.valueOf(1));
                }
                JFormattedTextField.AbstractFormatter formatter = ViewLogDialog.this.pageCurrent.getFormatter();
                if (!"".equals(old) && formatter != null) {
                    try {
                        ViewLogDialog.this.validatePageCurrent(formatter);
                    }
                    catch (ParseException pe) {
                        ViewLogDialog.this.pageCurrent.setText(String.valueOf(1));
                    }
                }
            }
        });
        this.pageCurrent.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    JFormattedTextField.AbstractFormatter formatter = ViewLogDialog.this.pageCurrent.getFormatter();
                    ViewLogDialog.this.validatePageCurrent(formatter);
                }
                catch (ParseException pe) {
                    ViewLogDialog.this.pageCurrent.setText(String.valueOf(1));
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
    }

    private void clearSearchResult() {
        this.searchResultJList.setListData(new ArrayList().toArray());
        this.pageCurrent.setText(String.valueOf(1));
        this.pageTotal.setText(String.valueOf(0));
        this.recordNum.setText(String.valueOf(0));
        this.exportButton.setEnabled(false);
        this.operatePowers();
    }

    private void addKeyWordTextListener() {
        this.keyWordText.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                String separateKeyword = String.valueOf(ResourceUtil.getString((String)"info.analyze.advanced.separateKeyword")) + ResourceUtil.getString((String)"info.analyze.advanced.includingMeaning");
                ViewLogDialog.this.keyWordAppend(ViewLogDialog.this.keyWordText, separateKeyword);
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (ViewLogDialog.this.keyWordText.getText().contains(ResourceUtil.getString((String)"info.analyze.advanced.separateKeyword"))) {
                    ViewLogDialog.this.keyWordText.setForeground(Color.BLACK);
                    ViewLogDialog.this.keyWordText.setText("");
                }
            }
        });
        this.keyWordText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    ViewLogDialog.this.pageCurrent.setText(String.valueOf(1));
                    ViewLogDialog.this.pageTotal.setText(String.valueOf(0));
                    ViewLogDialog.this.recordNum.setText(String.valueOf(0));
                    LogFileSearchBean searchBean = ViewLogDialog.this.getSearchBean();
                    ViewLogDialog.this.downloadSearchBean = searchBean;
                    if (ViewLogDialog.this.checkTime()) {
                        ViewLogDialog.this.doSearch(searchBean, true);
                    }
                }
            }
        });
    }

    private void addNotContainKeyWordTextListener() {
        this.excludeKeyWordText.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                String separateKeyword = String.valueOf(ResourceUtil.getString((String)"info.analyze.advanced.separateKeyword")) + ResourceUtil.getString((String)"info.analyze.advanced.excludingMeaning");
                ViewLogDialog.this.keyWordAppend(ViewLogDialog.this.excludeKeyWordText, separateKeyword);
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (ViewLogDialog.this.excludeKeyWordText.getText().contains(ResourceUtil.getString((String)"info.analyze.advanced.separateKeyword"))) {
                    ViewLogDialog.this.excludeKeyWordText.setForeground(Color.BLACK);
                    ViewLogDialog.this.excludeKeyWordText.setText("");
                }
            }
        });
        this.excludeKeyWordText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    ViewLogDialog.this.pageCurrent.setText(String.valueOf(1));
                    ViewLogDialog.this.pageTotal.setText(String.valueOf(0));
                    ViewLogDialog.this.recordNum.setText(String.valueOf(0));
                    LogFileSearchBean searchBean = ViewLogDialog.this.getSearchBean();
                    ViewLogDialog.this.downloadSearchBean = searchBean;
                    if (ViewLogDialog.this.checkTime()) {
                        ViewLogDialog.this.doSearch(searchBean, true);
                    }
                }
            }
        });
    }

    private void addSearchResultListListener() {
        this.searchResultJList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Object obj;
                if (evt.getClickCount() == 2 && (obj = ViewLogDialog.this.searchResultJList.getSelectedValue()) instanceof SearchResult) {
                    SearchResult result = (SearchResult)obj;
                    ViewLogDialog.this.refreshOriginalFileContent(result);
                }
            }
        });
    }

    private void addFileContentAreaListener() {
        this.fileContentArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    ViewLogDialog.this.fileContentArea.getHighlighter().removeAllHighlights();
                    String keyword = ViewLogDialog.this.fileContentArea.getSelectedText();
                    if (keyword != null) {
                        SearcherUtils.addHighlight(ViewLogDialog.this.fileContentArea, keyword, Color.green);
                    }
                }
            }
        });
    }

    private void refreshOriginalFileContent(SearchResult result) {
        int fileIndex;
        int pageIndex = Integer.parseInt(this.origPageCurrent.getText());
        if (pageIndex != (fileIndex = this.getoriginalFileBySearchResult(result))) {
            this.origPageCurrent.setText(String.valueOf(fileIndex));
            this.doSearchOrigialFile();
        }
        String line = result.getOriginal();
        this.fileContentArea.requestFocusInWindow();
        JScrollBar jscrollBar = this.fileContentSP.getVerticalScrollBar();
        if (jscrollBar != null) {
            jscrollBar.setValue(jscrollBar.getMaximum());
        }
        try {
            int startIndex = this.fileContentArea.getLineStartOffset(result.getLogLine() - 1);
            this.fileContentArea.select(startIndex, startIndex + line.length());
        }
        catch (BadLocationException e) {
            LOGGER.error("fileContentArea select line failed", (Throwable)e);
        }
    }

    private int getoriginalFileBySearchResult(SearchResult result) {
        int i = 0;
        while (i < this.originalFileList.size()) {
            if (this.originalFileList.get(i).getAbsolutePath().equals(result.getFile().getAbsolutePath())) {
                return i + 1;
            }
            ++i;
        }
        return 1;
    }

    private void addOrigPagePrevBtnListener() {
        this.origFilePrevBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int pageCurrentNum;
                int n = pageCurrentNum = StringUtils.isNULLStr((String)ViewLogDialog.this.origPageCurrent.getText()) ? 1 : Integer.parseInt(ViewLogDialog.this.origPageCurrent.getText());
                if (pageCurrentNum > 1) {
                    ViewLogDialog.this.origPageCurrent.setText(String.valueOf(pageCurrentNum - 1));
                } else {
                    ViewLogDialog.this.origPageCurrent.setText(String.valueOf(1));
                }
                ViewLogDialog.this.doSearchOrigialFile();
            }
        });
    }

    private void addOrigPageNextBtnListener() {
        this.origFileNextBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int pageTotalNum;
                int pageCurrentNum = StringUtils.isNULLStr((String)ViewLogDialog.this.origPageCurrent.getText()) ? 0 : Integer.parseInt(ViewLogDialog.this.origPageCurrent.getText());
                if (pageCurrentNum < (pageTotalNum = Integer.parseInt(ViewLogDialog.this.origPageTotal.getText()))) {
                    ViewLogDialog.this.origPageCurrent.setText(String.valueOf(pageCurrentNum + 1));
                } else {
                    ViewLogDialog.this.origPageCurrent.setText(String.valueOf(pageTotalNum));
                }
                ViewLogDialog.this.doSearchOrigialFile();
            }
        });
    }

    private void addOrigPageFirstBtnListener() {
        this.origPageFirstBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewLogDialog.this.origPageCurrent.setText(String.valueOf(1));
                ViewLogDialog.this.doSearchOrigialFile();
            }
        });
    }

    private void addOrigPageLastBtnListener() {
        this.origPageLastBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int pageTotalNum = Integer.parseInt(ViewLogDialog.this.origPageTotal.getText());
                ViewLogDialog.this.origPageCurrent.setText(String.valueOf(pageTotalNum));
                ViewLogDialog.this.doSearchOrigialFile();
            }
        });
    }

    private void addOrigPageGoBtnListener() {
        this.origPageGoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewLogDialog.this.doSearchOrigialFile();
            }
        });
    }

    private void addOrigPageCurrentListener() {
        this.origPageCurrent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                String old = ViewLogDialog.this.origPageCurrent.getText();
                if (old.length() >= 8 || StringUtils.isNULLStr((String)old)) {
                    ViewLogDialog.this.origPageCurrent.setText(String.valueOf(1));
                }
                JFormattedTextField.AbstractFormatter formatter = ViewLogDialog.this.origPageCurrent.getFormatter();
                if (!"".equals(old) && formatter != null) {
                    try {
                        ViewLogDialog.this.validateOrigPageCurrent(formatter);
                    }
                    catch (ParseException pe) {
                        ViewLogDialog.this.origPageCurrent.setText(String.valueOf(1));
                    }
                }
            }
        });
        this.origPageCurrent.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    JFormattedTextField.AbstractFormatter formatter = ViewLogDialog.this.origPageCurrent.getFormatter();
                    ViewLogDialog.this.validateOrigPageCurrent(formatter);
                }
                catch (ParseException pe) {
                    ViewLogDialog.this.origPageCurrent.setText(String.valueOf(1));
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
    }

    private void initOrigFileListener() {
        this.addOrigPagePrevBtnListener();
        this.addOrigPageNextBtnListener();
        this.addOrigPageFirstBtnListener();
        this.addOrigPageLastBtnListener();
        this.addOrigPageGoBtnListener();
        this.addOrigPageCurrentListener();
    }

    private void initUiListener() {
        this.addClearLabelListener();
        this.addSearchButtonListener();
        this.addResetButtonListener();
        this.addExportButtonListener();
        this.addPagePrevBtnListener();
        this.addPageNextBtnListener();
        this.addPageFirstBtnListener();
        this.addPageLastBtnListener();
        this.addPageGoBtnListener();
        this.addPageCurrentListener();
        this.addKeyWordTextListener();
        this.addNotContainKeyWordTextListener();
        this.addSearchResultListListener();
        this.initOrigFileListener();
        this.addFileDirTreeListener();
        this.addFileDirTreeMouseListener();
        this.addFileContentAreaListener();
    }

    private void addFileDirTreeListener() {
        TreeCellEditor cellEditor = this.fileDirTree.getCellEditor();
        cellEditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                CheckTreeCellEditor treeCellEditor = (CheckTreeCellEditor)e.getSource();
                Object userObject = treeCellEditor.getCellEditorValue();
                CheckTreeNode checkTreeNode = null;
                checkTreeNode = userObject == ViewLogDialog.this.fileDirTree.getRootNode().getUserObject() ? ViewLogDialog.this.fileDirTree.getRootNode() : ViewLogDialog.this.fileDirTree.getTreeNodeByUserObj(userObject);
                if (checkTreeNode != null) {
                    ViewLogDialog.this.checkBoxClicked(checkTreeNode);
                }
                ViewLogDialog.this.operateOrigFilePowers();
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
    }

    private void addFileDirTreeMouseListener() {
        this.fileDirTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                TreePath path = event.getPath();
                CheckTreeNode node = (CheckTreeNode)path.getLastPathComponent();
                FileDirTreeFile file = (FileDirTreeFile)node.getUserObject();
                if (file != null) {
                    ViewLogDialog.this.addFileNode(node, file);
                    ViewLogDialog.this.fileDirTree.repaint();
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }
        });
    }

    private void checkBoxClicked(CheckTreeNode checkTreeNode) {
        File searchFile = (File)checkTreeNode.getUserObject();
        if (!searchFile.isDirectory()) {
            if (checkTreeNode.isSelected()) {
                this.originalFileList.add(searchFile);
                this.originalFileSet.add(searchFile);
            } else {
                this.originalFileList.remove(searchFile);
                this.originalFileSet.remove(searchFile);
            }
        } else if (checkTreeNode.isSelected()) {
            this.parentNodeChoiced(searchFile);
        } else {
            this.parentNodeCanceled(searchFile);
        }
        this.doSearchOrigialFile();
    }

    private void parentNodeChoiced(File searchFile) {
        File[] fileArray = FileListFileFilterUtils.fileList(searchFile, null);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName;
            File f = fileArray[n2];
            if (f.isDirectory()) {
                this.parentNodeChoiced(f);
            } else if (!(this.originalFileSet.contains(f) || !f.isFile() || (fileName = f.getName().toLowerCase(Locale.ENGLISH)).endsWith(".tgz") || fileName.endsWith(".tar") || fileName.endsWith(".tar.gz") || fileName.endsWith(".zip") || fileName.endsWith(".7z") || fileName.endsWith(".rar") || fileName.endsWith(".bz2"))) {
                this.originalFileList.add(f);
                this.originalFileSet.add(f);
            }
            ++n2;
        }
    }

    private void parentNodeCanceled(File searchFile) {
        File[] fileArray = FileListFileFilterUtils.fileList(searchFile, null);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                this.parentNodeCanceled(f);
            } else if (this.originalFileSet.contains(f)) {
                this.originalFileList.remove(f);
                this.originalFileSet.remove(f);
            }
            ++n2;
        }
    }

    private void validatePageCurrent(JFormattedTextField.AbstractFormatter formatter) throws ParseException {
        try {
            String str = this.pageCurrent.getText();
            long page = (Long)formatter.stringToValue(str);
            if (!StringUtils.isNULLStr((String)this.pageTotal.getText()) && Integer.parseInt(this.pageTotal.getText()) != 0) {
                if (page > (long)Integer.parseInt(this.pageTotal.getText())) {
                    this.pageCurrent.setText(this.pageTotal.getText());
                } else if (page <= 1L) {
                    this.pageCurrent.setText(String.valueOf(1));
                } else {
                    this.pageCurrent.setText(String.valueOf(page));
                }
            } else {
                this.pageCurrent.setText(String.valueOf(1));
            }
        }
        catch (ClassCastException cce) {
            this.pageCurrent.setText(String.valueOf(1));
        }
    }

    private void validateOrigPageCurrent(JFormattedTextField.AbstractFormatter formatter) throws ParseException {
        try {
            String str = this.origPageCurrent.getText();
            long page = (Long)formatter.stringToValue(str);
            if (!StringUtils.isNULLStr((String)this.origPageTotal.getText()) && Integer.parseInt(this.origPageTotal.getText()) != 0) {
                if (page > (long)Integer.parseInt(this.origPageTotal.getText())) {
                    this.origPageCurrent.setText(this.origPageTotal.getText());
                } else if (page <= 1L) {
                    this.origPageCurrent.setText(String.valueOf(1));
                } else {
                    this.origPageCurrent.setText(String.valueOf(page));
                }
            } else {
                this.origPageCurrent.setText(String.valueOf(1));
            }
        }
        catch (ClassCastException cce) {
            this.origPageCurrent.setText(String.valueOf(1));
        }
    }

    private JPanel layoutRightComponents() {
        JPanel rightJPanel = new JPanel();
        rightJPanel.setLayout(new BorderLayout());
        JSplitPane rightSplitPane = new JSplitPane(0, false);
        rightSplitPane.setTopComponent(this.layoutTopComponent());
        rightSplitPane.setBottomComponent(this.layoutBottomComponent());
        rightSplitPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        rightSplitPane.setResizeWeight(0.8f);
        rightSplitPane.setEnabled(true);
        rightJPanel.add((Component)UiMethod.buildFrameSpace((JComponent)this.layoutConditionArea(), (int)10), "North");
        rightJPanel.add(rightSplitPane);
        return rightJPanel;
    }

    public void initFileDirTree() {
        File file = this.row.getLogDeCompressDir().getDeDeCompressRandomDir();
        CheckTreeNode fileTreeNodeFather = new CheckTreeNode((Object)new FileDirTreeFile(file.getAbsolutePath()), true, false);
        ViewLogDialog.initFileDirNode(fileTreeNodeFather, file);
        this.fileDirTree = new CheckBoxTree(fileTreeNodeFather, true);
        this.treeModel = new DefaultTreeModel((TreeNode)fileTreeNodeFather);
        this.fileDirTree.setModel(this.treeModel);
        this.fileDirTree.setShowsRootHandles(true);
        this.fileDirTree.setRootVisible(true);
        if (!file.exists()) {
            this.fileDirTree.setRootVisible(false);
        }
    }

    private static void initFileDirNode(CheckTreeNode checkTreeNode, File file) {
        boolean isFirst = true;
        if (!file.exists()) {
            return;
        }
        File[] fileArray = FileListFileFilterUtils.fileList(file, null);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            FileDirTreeFile dirTreeFile = new FileDirTreeFile(f.getAbsolutePath());
            if (f.isDirectory()) {
                if (f.listFiles().length != 0) {
                    CheckTreeNode treeNode = new CheckTreeNode((Object)dirTreeFile, true, false);
                    treeNode.setAllowsChildren(true);
                    checkTreeNode.add((MutableTreeNode)treeNode);
                    ViewLogDialog.initFileDirNode(treeNode, f);
                }
            } else if (isFirst) {
                String fileName = f.getName().toLowerCase(Locale.ENGLISH);
                if (!(fileName.endsWith(".tgz") || fileName.endsWith(".tar") || fileName.endsWith(".tar.gz") || fileName.endsWith(".zip") || fileName.endsWith(".7z") || fileName.endsWith(".rar") || fileName.endsWith(".bz2"))) {
                    CheckTreeNode treeNode = new CheckTreeNode((Object)dirTreeFile, true, false);
                    checkTreeNode.add((MutableTreeNode)treeNode);
                }
                isFirst = false;
            }
            ++n2;
        }
    }

    private void addFileNode(CheckTreeNode checkTreeNode, File file) {
        Enumeration childrens = checkTreeNode.children();
        ArrayList<CheckTreeNode> old = new ArrayList<CheckTreeNode>();
        while (childrens.hasMoreElements()) {
            CheckTreeNode node = (CheckTreeNode)childrens.nextElement();
            old.add(node);
        }
        for (CheckTreeNode node : old) {
            FileDirTreeFile f = (FileDirTreeFile)node.getUserObject();
            if (!f.isFile()) continue;
            this.treeModel.removeNodeFromParent((MutableTreeNode)node);
        }
        File[] fileArray = FileListFileFilterUtils.fileList(file, null);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName;
            File f = fileArray[n2];
            FileDirTreeFile dirTreeFile = new FileDirTreeFile(f.getAbsolutePath());
            if (!(!f.isFile() || (fileName = f.getName().toLowerCase(Locale.ENGLISH)).endsWith(".tgz") || fileName.endsWith(".tar") || fileName.endsWith(".tar.gz") || fileName.endsWith(".zip") || fileName.endsWith(".7z") || fileName.endsWith(".rar"))) {
                CheckTreeNode treeNode = new CheckTreeNode((Object)dirTreeFile, true, checkTreeNode.isSelected());
                this.treeModel.insertNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)checkTreeNode, 0);
            }
            ++n2;
        }
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        JSplitPane splitPane = new JSplitPane(1, false);
        JScrollPane jscrollPane = new JScrollPane(this.fileDirTree);
        jscrollPane.setVerticalScrollBarPolicy(20);
        jscrollPane.setHorizontalScrollBarPolicy(30);
        splitPane.setRightComponent(this.layoutRightComponents());
        splitPane.setLeftComponent(jscrollPane);
        splitPane.setResizeWeight(0.2f);
        splitPane.setDividerLocation(150);
        splitPane.setEnabled(true);
        this.add(splitPane);
    }

    private JComponent layoutTopComponent() {
        JPanel topComponent = new JPanel();
        topComponent.setLayout(new BorderLayout());
        topComponent.add((Component)this.createFileContentArea(), "Center");
        topComponent.add((Component)UiMethod.buildFrameSpace((JComponent)this.layoutOrigPageBarArea(), (int)5), "South");
        return topComponent;
    }

    private JComponent layoutBottomComponent() {
        JPanel bottomComponent = new JPanel();
        bottomComponent.setLayout(new BorderLayout());
        bottomComponent.add((Component)this.layoutSearchResult(), "Center");
        bottomComponent.add((Component)UiMethod.buildFrameSpace((JComponent)this.layoutPageBarArea(), (int)5), "South");
        return bottomComponent;
    }

    private JComponent layoutSearchResult() {
        this.searchResultJList = new JList<SearchResult>(this.searchResultmodel);
        this.searchResultJList.setCellRenderer(new SearchResultListCellRender());
        this.searchResultJList.setSelectionMode(0);
        JScrollPane searchResultScrolPane = new JScrollPane(this.searchResultJList);
        searchResultScrolPane.setPreferredSize(new Dimension(950, 160));
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add(ResourceUtil.getString((String)"info.analyze.advanced.searchResult"), searchResultScrolPane);
        return tabbedPane;
    }

    private JComponent layoutConditionArea() {
        this.clearLabel.setForeground(COLOR_BEFORE_CLICK);
        ArrayList<Pair> datePairList = new ArrayList<Pair>();
        ArrayList<Pair> keyWordPairList = new ArrayList<Pair>();
        JLabel maginLable = new JLabel();
        maginLable.setPreferredSize(new Dimension(30, 20));
        this.keyWordLable.setPreferredSize(this.dateLable.getPreferredSize());
        Pair datePair = new Pair((Object)UCD.buildHBoxRight((Component[])new Component[]{this.dateLable}), (Object)UCD.buildHBoxLeft((Component[])new Component[]{this.beginDate, this.toLable, this.endDate, this.clearLabel, this.bakLabel, maginLable}));
        Pair keyWordPair = new Pair((Object)UCD.buildHBoxRight((Component[])new Component[]{this.keyWordLable}), (Object)UCD.buildHBoxLeft((Component[])new Component[]{this.includeLable, this.keyWordText, maginLable, this.excludeKeyWordLable, this.excludeKeyWordText}));
        datePairList.add(datePair);
        keyWordPairList.add(keyWordPair);
        UiMethod.setComponentSize((Dimension)SEARCHTEXT_SIZE, (Component[])new Component[]{this.keyWordText, this.excludeKeyWordText});
        JComponent conditionArea = UCD.buildVerticalBox(null, (int)15, (Component[])new Component[]{UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{UCD.createRightKVPane((int)8, datePairList)}), UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{UCD.createRightKVPane((int)8, keyWordPairList), UCD.buildHBoxLeft((Component[])new Component[]{this.searchButton, this.resetButton})})});
        return conditionArea;
    }

    private JComponent layoutPageBarArea() {
        JPanel pageBarArea = new JPanel();
        pageBarArea.setLayout(new BorderLayout());
        pageBarArea.add((Component)UCD.buildHBoxLeft((int)10, (Component[])new Component[]{this.recordNumLable, this.recordNum}), "West");
        pageBarArea.add((Component)UCD.buildHBoxRight((int)5, (Component[])new Component[]{this.pageFirstBtn, this.pagePrevBtn, this.pageCurrent, this.splitLabel, this.pageTotal, this.pageNextBtn, this.pageLastBtn, this.pageGoBtn, this.exportButton}), "East");
        return pageBarArea;
    }

    private JComponent layoutOrigPageBarArea() {
        JPanel pageBarArea = new JPanel();
        pageBarArea.setLayout(new BorderLayout());
        pageBarArea.add((Component)UCD.buildHBoxRight((int)5, (Component[])new Component[]{this.origPageFirstBtn, this.origFilePrevBtn, this.origPageCurrent, this.origSplitLabel, this.origPageTotal, this.origFileNextBtn, this.origPageLastBtn, this.origPageGoBtn}), "East");
        return pageBarArea;
    }

    private JScrollPane createFileContentArea() {
        this.fileContentSP = new JScrollPane(this.fileContentArea);
        this.fileContentArea.setEditable(false);
        this.fileContentSP.setVerticalScrollBarPolicy(20);
        this.fileContentSP.setHorizontalScrollBarPolicy(30);
        return this.fileContentSP;
    }

    private void loadFileContent(LogFileSearchBean searchBean) {
        try {
            List<SearchResult> resultList = this.viewLogService.pageQuery(this.searchReasult.getFileList(), searchBean);
            int pageSize = searchBean.getPageSize();
            int records = this.searchReasult.getTotalCount();
            int pageNum = records % pageSize == 0 ? records / pageSize : records / pageSize + 1;
            this.pageTotal.setText(String.valueOf(pageNum));
            this.recordNum.setText(String.valueOf(records));
            this.searchResultJList.setListData(resultList.toArray());
        }
        catch (Exception e) {
            LOGGER.error("query log content failed", (Throwable)e);
        }
    }

    private void loadOrigialFile() {
        try {
            int pageIndex = Integer.parseInt(this.origPageCurrent.getText());
            if (this.originalFileList.size() >= pageIndex) {
                this.viewLogService.getOriginalfileContent(this.originalFileList.get(pageIndex - 1), this.fileContentArea);
                this.origPageTotal.setText(String.valueOf(this.originalFileList.size()));
                this.operateOrigFilePowers();
            } else {
                this.origPageCurrent.setText(String.valueOf(1));
                this.origPageTotal.setText(String.valueOf(this.originalFileList.size()));
                if (!this.originalFileList.isEmpty()) {
                    this.viewLogService.getOriginalfileContent(this.originalFileList.get(1), this.fileContentArea);
                } else {
                    this.fileContentArea.setText("");
                }
                this.origPageTotal.setText(String.valueOf(this.originalFileList.size()));
            }
        }
        catch (Exception e) {
            LOGGER.error("query log content failed", (Throwable)e);
        }
    }

    private void operatePowers() {
        if (!StringUtils.isNULLStr((String)this.pageTotal.getText()) && Integer.parseInt(this.pageTotal.getText()) <= 1) {
            this.pagePrevBtn.setEnabled(false);
            this.pageNextBtn.setEnabled(false);
            this.pageFirstBtn.setEnabled(false);
            this.pageLastBtn.setEnabled(false);
            this.pageGoBtn.setEnabled(false);
        } else {
            this.pageGoBtn.setEnabled(true);
            if (Integer.parseInt(this.pageCurrent.getText()) == 1) {
                this.pagePrevBtn.setEnabled(false);
                this.pageFirstBtn.setEnabled(false);
                this.pageNextBtn.setEnabled(true);
                this.pageLastBtn.setEnabled(true);
            } else if (Integer.parseInt(this.pageCurrent.getText()) >= Integer.parseInt(this.pageTotal.getText())) {
                this.pageNextBtn.setEnabled(false);
                this.pageLastBtn.setEnabled(false);
                this.pagePrevBtn.setEnabled(true);
                this.pageFirstBtn.setEnabled(true);
            } else {
                this.pagePrevBtn.setEnabled(true);
                this.pageNextBtn.setEnabled(true);
                this.pageFirstBtn.setEnabled(true);
                this.pageLastBtn.setEnabled(true);
            }
        }
    }

    private void operateOrigFilePowers() {
        this.origPageTotal.setText(String.valueOf(this.originalFileList.size()));
        if (!StringUtils.isNULLStr((String)this.origPageTotal.getText()) && Integer.parseInt(this.origPageTotal.getText()) <= 1) {
            this.origFilePrevBtn.setEnabled(false);
            this.origFileNextBtn.setEnabled(false);
            this.origPageFirstBtn.setEnabled(false);
            this.origPageLastBtn.setEnabled(false);
            this.origPageGoBtn.setEnabled(false);
        } else {
            this.origPageGoBtn.setEnabled(true);
            if (Integer.parseInt(this.origPageCurrent.getText()) == 1) {
                this.origFilePrevBtn.setEnabled(false);
                this.origPageFirstBtn.setEnabled(false);
                this.origFileNextBtn.setEnabled(true);
                this.origPageLastBtn.setEnabled(true);
            } else if (Integer.parseInt(this.origPageCurrent.getText()) >= Integer.parseInt(this.origPageTotal.getText())) {
                this.origFileNextBtn.setEnabled(false);
                this.origPageLastBtn.setEnabled(false);
                this.origFilePrevBtn.setEnabled(true);
                this.origPageFirstBtn.setEnabled(true);
            } else {
                this.origFilePrevBtn.setEnabled(true);
                this.origFileNextBtn.setEnabled(true);
                this.origPageFirstBtn.setEnabled(true);
                this.origPageLastBtn.setEnabled(true);
            }
        }
    }

    private void keyWordAppend(JTextField keyWordText1, String separateKeyword) {
        if (keyWordText1.getText().contains("info.analyze.advanced.separateKeyword") || StringUtils.isNULLStr((String)keyWordText1.getText())) {
            keyWordText1.setText(separateKeyword);
            keyWordText1.setForeground(Color.GRAY);
        }
        keyWordText1.setCaretPosition(0);
        keyWordText1.setToolTipText(keyWordText1.getText());
    }

    private String onSearch() {
        String keyWord;
        int n;
        int n2;
        String[] stringArray;
        String result = null;
        if (this.isNULLKeyword()) {
            return null;
        }
        if (!StringUtils.isNULLStr((String)this.keyWordText.getText().trim())) {
            String[] keyArray;
            stringArray = keyArray = this.keyWordText.getText().split(";");
            n2 = keyArray.length;
            n = 0;
            while (n < n2) {
                keyWord = stringArray[n];
                if (keyWord.trim().length() <= 1) {
                    result = ResourceUtil.getString((String)"info.analyze.advanced.keywordLength");
                    break;
                }
                ++n;
            }
        }
        if (!StringUtils.isNULLStr((String)this.excludeKeyWordText.getText().trim())) {
            String[] excludeKeyArray;
            stringArray = excludeKeyArray = this.excludeKeyWordText.getText().split(";");
            n2 = excludeKeyArray.length;
            n = 0;
            while (n < n2) {
                keyWord = stringArray[n];
                if (keyWord.trim().length() <= 1) {
                    result = ResourceUtil.getString((String)"info.analyze.advanced.keywordLength");
                    break;
                }
                ++n;
            }
        }
        return result;
    }

    private boolean isNULLKeyword() {
        boolean includeKeyWordFlag;
        boolean excludeKeyWordFlag = this.excludeKeyWordText.getText().trim().equals("") || this.excludeKeyWordText.getText().contains(ResourceUtil.getString((String)"info.analyze.advanced.separateKeyword"));
        boolean bl = includeKeyWordFlag = this.keyWordText.getText().trim().equals("") || this.keyWordText.getText().contains(ResourceUtil.getString((String)"info.analyze.advanced.separateKeyword"));
        return excludeKeyWordFlag && includeKeyWordFlag;
    }

    private boolean checkTime() {
        long endTimeLong;
        long startTimeLong = StringUtils.isNULLStr((String)this.beginDate.getText()) ? 0L : StringUtils.parseDate2Long((String)this.beginDate.getText(), (String)"yyyy-MM-dd HH:mm:ss");
        long l = endTimeLong = StringUtils.isNULLStr((String)this.endDate.getText()) ? Long.MAX_VALUE : StringUtils.parseDate2Long((String)this.endDate.getText(), (String)"yyyy-MM-dd HH:mm:ss");
        if (endTimeLong < startTimeLong && endTimeLong != 0L) {
            DialogUtils.showInfoDialog((Window)this.frame, (String)ResourceUtil.getString((String)"info.analyze.setting.date.error1"));
            ToolLoggerFactory.getLogger(this.getClass()).error("setting times point failed.");
            return false;
        }
        return true;
    }

    public void destroy() {
        this.fileContentArea.removeAll();
        this.originalFileList.clear();
        this.searchResultJList.removeAll();
        this.originalFileList.clear();
        this.originalFileSet.clear();
    }
}

