/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.ui.action;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.common.ui.IStartAction;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.loganalyzer.entity.config.ConfigInfoRule;
import com.huawei.ism.tool.loganalyzer.faulttree.initialization.FaultTreeInitializtion;
import com.huawei.ism.tool.loganalyzer.faulttree.model.DeviceType;
import com.huawei.ism.tool.loganalyzer.logic.configloader.AnalyzeRulesReader;
import com.huawei.ism.tool.loganalyzer.logic.configloader.ConfigInfoReader;
import com.huawei.ism.tool.loganalyzer.logic.configloader.ModulePIDReader;
import com.huawei.ism.tool.loganalyzer.persist.util.DaoFactory;
import com.huawei.ism.tool.loganalyzer.ui.main.MainLogAnaDialog;
import com.huawei.ism.tool.loganalyzer.util.LoganalyzerContext;
import com.huawei.ism.tool.loganalyzer.util.SearchConstant;
import com.huawei.ism.tool.loganalyzer.util.WaitingProgressDialogUtil;
import com.huawei.ism.tool.obase.filechooser.HibernateContainer;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JFrame;
import javax.swing.filechooser.FileSystemView;
import org.slf4j.Logger;

public class LogAnaMainAction
implements IStartAction {
    private static final long serialVersionUID = 425283972214424815L;
    private static final long MAX_SIZE = 524288000L;
    private static final String TEMP = "temp";
    private static final String LANGUAGE = "language";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(LogAnaMainAction.class);

    public void actionPerformed(Window parent, ActionEvent e) {
        try {
            File tempDecompressDirFile = new File(ApplicationContext.getInstance().getWorkPath(), TEMP);
            if (!tempDecompressDirFile.exists()) {
                FileUtils.createDir((File)tempDecompressDirFile);
            }
            MainLogAnaDialog mainDialog = new MainLogAnaDialog(parent);
            FaultTreeInitializtion.getInstance().initialize();
            AnalyzeRulesReader arr = new AnalyzeRulesReader();
            arr.parsePythonRuleFiles();
            ConfigInfoRule configRule = ConfigInfoRule.getConfigRuleInstance();
            ConfigInfoRule clicmdRule = ConfigInfoRule.getCilcmdRuleInstance();
            if (!ConfigInfoReader.checkConfigInfoRule(configRule) || !ConfigInfoReader.checkConfigInfoRule(clicmdRule)) {
                throw new RuntimeException("the configInformation.xml parse error:" + configRule.getParseErrorInfo() + clicmdRule.getParseErrorInfo());
            }
            ModulePIDReader read = new ModulePIDReader();
            if (!read.readPidExcel()) {
                ToolLoggerFactory.getLogger(this.getClass()).error("parse ModulePID.xls occor an error");
            }
            if (DeviceType.getModelList().isEmpty()) {
                DialogUtils.showInfoDialog((Frame)((Object)mainDialog), (String)ResourceUtil.getString((String)"info.analyze.message.no.package"));
                LoganalyzerContext.getInstance().fireToolStopped();
                return;
            }
            LoganalyzerContext.getInstance().setLoadingImageObserver((ImageObserver)((Object)mainDialog));
            LoganalyzerContext.getInstance().setMainLogAnaDialog(mainDialog);
            this.setTempToDisk();
            mainDialog.layout.initData();
            mainDialog.setVisible(true);
            DaoFactory.initialize();
            if (!LanguageManager.getInstance().getCurrentLanguage().toString().equals(HibernateContainer.getInstance().get((Object)LANGUAGE))) {
                FileUtils.deleteAllInFolder((String)(String.valueOf(ApplicationContext.getInstance().getWorkPath()) + File.separator + "tmp" + File.separator + "report"));
                mainDialog.deleteAllTempFile();
            } else {
                List<?> result = WaitingProgressDialogUtil.execute((JFrame)((Object)mainDialog), ResourceUtil.getString((String)"info.analyze.prompt.data.loading"), 300, new Callable<Object>(){

                    @Override
                    public Object call() {
                        return "success";
                    }
                });
                MainLogAnaDialog.getInstance().refreshDetailList(MainLogAnaDialog.getInstance().isAction() || MainLogAnaDialog.getInstance().isFinish());
                LOGGER.debug("AsyncExcutor execute info : " + result.get(0));
            }
            HibernateContainer.getInstance().put(LANGUAGE, (Object)LanguageManager.getInstance().getCurrentLanguage().toString());
            LOGGER.info("Initialize AnalyzeLog success!");
            mainDialog.setEnabled(true);
        }
        catch (Exception e2) {
            LOGGER.error("Initialize AnalyzeLog error!" + e2);
        }
    }

    public static long getSerialversionuid() {
        return 425283972214424815L;
    }

    private void setTempToDisk() {
        long size = 0L;
        long cSize = 0L;
        File diskC = null;
        File diskOther = null;
        FileSystemView fileSys = FileSystemView.getFileSystemView();
        if (File.listRoots() != null) {
            File[] fileArray = File.listRoots();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                block11: {
                    File file = fileArray[n2];
                    if (fileSys.getSystemDisplayName(file).contains("C:")) {
                        cSize = file.getFreeSpace();
                        diskC = file;
                    } else if (size < file.getFreeSpace() && file.canWrite()) {
                        File writeFile = new File(file, "test" + String.valueOf(System.nanoTime()));
                        try {
                            if (!writeFile.createNewFile()) break block11;
                            boolean ret = writeFile.delete();
                            ToolLoggerFactory.getLogger(this.getClass()).info("delete test file " + ret);
                        }
                        catch (IOException e) {
                            ToolLoggerFactory.getLogger(this.getClass()).error("Writer test file failed.", (Throwable)e);
                            break block11;
                        }
                        size = file.getFreeSpace();
                        diskOther = file;
                    }
                }
                ++n2;
            }
            if (size < 524288000L && cSize > 524288000L || size == 0L) {
                if (diskC != null) {
                    SearchConstant.getInstant().setTemp(String.valueOf(diskC.getAbsolutePath()) + TEMP);
                }
            } else if (diskOther != null) {
                SearchConstant.getInstant().setTemp(String.valueOf(diskOther.getAbsolutePath()) + TEMP);
            }
            ToolLoggerFactory.getLogger(this.getClass()).debug("save temp file path : " + SearchConstant.getInstant().getTemp() + TEMP);
        }
    }
}

