/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.ui.faultuitree;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogRow;
import com.huawei.ism.tool.loganalyzer.entity.analyze.PythonRule;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.cause.Cause;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.cause.CauseGroup;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.cause.CauseGroupList;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.pheno.FaultType;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.pheno.Pheno;
import com.huawei.ism.tool.loganalyzer.faulttree.model.DeviceType;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.CauseMatchResult;
import com.huawei.ism.tool.loganalyzer.ui.faultuitree.FaultTree;
import com.huawei.ism.tool.loganalyzer.ui.faultuitree.FaultTreeCellRenderer;
import com.huawei.ism.tool.loganalyzer.ui.faultuitree.FaultTreeNode;
import com.huawei.ism.tool.loganalyzer.ui.faultuitree.FaultTreeRootCauseDialog;
import com.huawei.ism.tool.loganalyzer.ui.faultuitree.MainFaultTree;
import com.huawei.ism.tool.loganalyzer.ui.faultuitree.TreeNodeData;
import com.huawei.ism.tool.loganalyzer.util.SearcherUtils;
import com.huawei.ism.util.UCD;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailFaultTree
extends MainFaultTree {
    private static final long serialVersionUID = 3578987313994027345L;
    private static final String KEY_CAUSE_ID = "causeId";
    private static final String KEY_CAUSE_GROUP_ID = "causeGroupId";
    private static final Logger LOGGER = LoggerFactory.getLogger(DetailFaultTree.class);
    private FaultTreeRootCauseDialog causeAnalysisDialog;
    private transient LogRow logRow = new LogRow();
    private FaultTree faultTree;
    private FaultTree versionFaultTree;
    private FaultTree faultTreeMatched;
    private transient Map<String, List<TreeNodeData>> phenoCauseDataMap = null;

    public DetailFaultTree(LogRow row, FaultTreeNode assignTree) {
        this.copyRow(row);
        this.type = row.getDeviceType();
        this.phenoCauseDataMap = new HashMap<String, List<TreeNodeData>>();
        try {
            this.initUI();
            this.init();
            this.initFaultTree(assignTree);
            this.setComponentName();
        }
        catch (Exception e) {
            LOGGER.error("refresh fault tree failed !" + e);
        }
    }

    private void setComponentName() {
        this.faultTree.setName("cause_tree_default");
        this.faultTreeMatched.setName("cause_tree_matched");
        this.versionFaultTree.setName("cause_tree_version");
    }

    private void initFaultTree(FaultTreeNode assignTree) {
        FaultTreeNode faultTreeNodeFather = new FaultTreeNode(new TreeNodeData("root", true, ""), true, false, false);
        FaultTreeNode versionFaultTreeNodeFather = new FaultTreeNode(new TreeNodeData("root", true, ""), true, false, false);
        FaultTreeNode faultTreeMatchedFather = new FaultTreeNode(new TreeNodeData("root", true, ""), true, false, false);
        for (FaultType faultType : this.type.faultTypeCache().getList()) {
            faultTreeNodeFather.add(this.getPhenomenonGroupNode(faultType));
            FaultTreeNode faultTypeTreeNode = this.getMatchedPhenomenonGroupNode(faultType);
            if (faultTypeTreeNode.getChildCount() > 0) {
                faultTreeMatchedFather.add(faultTypeTreeNode);
            }
            FaultTreeNode versionFaultTypeTreeNode = this.getVersionPhenomenonGroupNode(faultType);
            versionFaultTreeNodeFather.add(versionFaultTypeTreeNode);
        }
        this.getFaultTree(assignTree, faultTreeNodeFather);
        this.getVersionFaultTree(assignTree, versionFaultTreeNodeFather);
        this.getFaultTreeMatched(assignTree, faultTreeMatchedFather);
        this.repaint();
    }

    private FaultTreeNode getVersionPhenomenonGroupNode(FaultType faultType) {
        TreeNodeData pMr = new TreeNodeData(faultType.getId(), this.type, false);
        pMr.setIsMatched(this.getIsMatched(faultType.getPhenoList()));
        FaultTreeNode phenomenonGroupNode = new FaultTreeNode(pMr, false);
        for (Pheno pheno : faultType.getPhenoList()) {
            TreeNodeData treeNodeData = (TreeNodeData)this.phenoDataMap.get(pheno.getId());
            treeNodeData = treeNodeData == null ? new TreeNodeData(pheno.getId(), this.type, false) : treeNodeData;
            FaultTreeNode ftn = new FaultTreeNode(treeNodeData, false);
            ArrayList<TreeNodeData> nodeCauseDataList = new ArrayList<TreeNodeData>();
            this.filterCause(pheno, nodeCauseDataList);
            Collections.sort(nodeCauseDataList);
            this.addCauseNodes(ftn, nodeCauseDataList);
            phenomenonGroupNode.add(ftn);
        }
        return phenomenonGroupNode;
    }

    private void filterCause(Pheno pheno, List<TreeNodeData> nodeCauseDataList) {
        List<Cause> filterCauseList = this.filterCauseByModelVersion(this.logRow, this.type);
        try {
            CauseGroupList causeGroupList = this.type.causeGroupCache().get(pheno.getId());
            if (causeGroupList != null) {
                this.addCauseNode(nodeCauseDataList, filterCauseList, causeGroupList);
            }
        }
        catch (Exception e) {
            LOGGER.error("init Root Cause Data failed !");
        }
    }

    private void addCauseNode(List<TreeNodeData> nodeCauseDataList, List<Cause> filterCauseList, CauseGroupList causeGroupList) {
        for (CauseGroup causeGroup : causeGroupList.getCauseGroupList()) {
            for (Cause cause : causeGroup.getCauseList()) {
                if (!filterCauseList.contains(cause)) continue;
                TreeNodeData treeNodeCauseData = new TreeNodeData(cause.getId(), cause.getGroupId(), this.type, true);
                boolean isMatched = this.getCauseIsMatched(cause.getId());
                treeNodeCauseData.setIsMatched(isMatched);
                nodeCauseDataList.add(treeNodeCauseData);
            }
        }
    }

    private List<Cause> filterCauseByModelVersion(LogRow row, DeviceType type) {
        ArrayList<Cause> causeList = new ArrayList<Cause>();
        for (CauseGroupList causeGroupList : type.causeGroupCache().getCauseGroupLists()) {
            for (CauseGroup causeGroup : causeGroupList.getCauseGroupList()) {
                for (Cause cause : causeGroup.getCauseList()) {
                    if (!cause.valid(row.getType(), row.getVersion()) && !this.validPythonRule(row, cause)) continue;
                    causeList.add(cause);
                }
            }
        }
        return causeList;
    }

    private boolean validPythonRule(LogRow row, Cause cause) {
        List<PythonRule> pythonRules = row.getPythonRules();
        if (pythonRules == null) {
            return false;
        }
        for (PythonRule pr : pythonRules) {
            if (!pr.getId().equals(cause.getId())) continue;
            return true;
        }
        return false;
    }

    private void getVersionFaultTree(FaultTreeNode assignTree, FaultTreeNode faultTreeNodeFather) {
        this.versionFaultTree = new FaultTree(faultTreeNodeFather, false, assignTree, false);
        this.versionFaultTree.setMaximumSize(new Dimension(1600, 500));
        this.versionFaultTree.setSize(new Dimension(1600, 500));
        this.versionFaultTree.setMinimumSize(new Dimension(700, 500));
        FaultTreeCellRenderer faultTreeCellRenderer = new FaultTreeCellRenderer(false, false);
        this.versionFaultTree.setCellRenderer(faultTreeCellRenderer);
        this.versionFaultTree.setShowsRootHandles(true);
        this.addFaultTreeListener(this.versionFaultTree);
    }

    private void getFaultTreeMatched(FaultTreeNode assignTree, FaultTreeNode faultTreeMatchedFather) {
        this.faultTreeMatched = new FaultTree(faultTreeMatchedFather, false, assignTree, true);
        this.faultTreeMatched.setMaximumSize(new Dimension(1600, 500));
        this.faultTreeMatched.setSize(new Dimension(1600, 500));
        this.faultTreeMatched.setMinimumSize(new Dimension(700, 500));
        FaultTreeCellRenderer faultTreeCellRendererMatched = new FaultTreeCellRenderer(false, false);
        this.faultTreeMatched.setCellRenderer(faultTreeCellRendererMatched);
        this.faultTreeMatched.setShowsRootHandles(true);
        this.addMatchedFaultTreeListener();
    }

    private void getFaultTree(FaultTreeNode assignTree, FaultTreeNode faultTreeNodeFather) {
        this.faultTree = new FaultTree(faultTreeNodeFather, false, assignTree, false);
        this.faultTree.setMaximumSize(new Dimension(1600, 500));
        this.faultTree.setSize(new Dimension(1600, 500));
        this.faultTree.setMinimumSize(new Dimension(700, 500));
        FaultTreeCellRenderer faultTreeCellRenderer = new FaultTreeCellRenderer(false, false);
        this.faultTree.setCellRenderer(faultTreeCellRenderer);
        this.faultTree.setShowsRootHandles(true);
        this.addFaultTreeListener(this.faultTree);
    }

    private void clearSelectNode(TreePath parent) {
        FaultTreeNode node = (FaultTreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                FaultTreeNode n = (FaultTreeNode)e.nextElement();
                n.setHilight(false);
                TreePath path = parent.pathByAddingChild(n);
                this.clearSelectNode(path);
            }
        }
    }

    private void addFaultTreeListener(final FaultTree tree) {
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath treepath = e.getNewLeadSelectionPath();
                if (treepath == null) {
                    return;
                }
                FaultTreeNode node = (FaultTreeNode)tree.getLastSelectedPathComponent();
                if (e.getSource() == tree && node != null) {
                    try {
                        FaultTreeNode root = tree.getRootNode();
                        TreePath parent = new TreePath(root);
                        DetailFaultTree.this.clearSelectNode(parent);
                        node.setHilight(true);
                        DetailFaultTree.this.clickCauseLeafNode(node);
                    }
                    catch (Exception e2) {
                        LOGGER.error("click Cause Leaf Node Error !");
                    }
                }
            }
        });
    }

    private void addMatchedFaultTreeListener() {
        this.faultTreeMatched.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                FaultTreeNode root = DetailFaultTree.this.faultTreeMatched.getRootNode();
                TreePath parent = new TreePath(root);
                DetailFaultTree.this.clearSelectNode(parent);
                TreePath treepath = e.getNewLeadSelectionPath();
                if (treepath == null) {
                    return;
                }
                FaultTreeNode node = (FaultTreeNode)DetailFaultTree.this.faultTreeMatched.getLastSelectedPathComponent();
                if (e.getSource() == DetailFaultTree.this.faultTreeMatched && node != null) {
                    try {
                        node.setHilight(true);
                        DetailFaultTree.this.clickCauseLeafNode(node);
                    }
                    catch (Exception e2) {
                        LOGGER.error("click Cause Leaf Node Error !");
                    }
                }
            }
        });
    }

    private void init() {
        try {
            this.phenoDataMap.clear();
            for (CauseGroupList groupList : this.type.causeGroupCache().getCauseGroupLists()) {
                for (CauseGroup causeGroup : groupList.getCauseGroupList()) {
                    this.initPhenoMap(groupList, causeGroup);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("init root cause matched number error !");
        }
    }

    private void initPhenoMap(CauseGroupList groupList, CauseGroup causeGroup) {
        for (Cause cause : causeGroup.getCauseList()) {
            CauseMatchResult causeMatchResult = this.logRow.getCauseMatchResultMap().get(cause.getId());
            if (causeMatchResult == null) continue;
            TreeNodeData treeNodeData = (TreeNodeData)this.phenoDataMap.get(groupList.getPheno().getId());
            if (treeNodeData == null) {
                treeNodeData = new TreeNodeData(groupList.getPheno().getId(), this.type, false);
                this.phenoDataMap.put(groupList.getPheno().getId(), treeNodeData);
            }
            if (causeMatchResult.getDateInfo() == null) {
                treeNodeData.addMatchNum();
                continue;
            }
            if (!SearcherUtils.isOnSetDate(causeMatchResult.getDateInfo().getTime())) continue;
            treeNodeData.addMatchNum();
        }
    }

    private void clickCauseLeafNode(FaultTreeNode node) {
        TreeNodeData matchResult = (TreeNodeData)node.getUserObject();
        if (this.isPhenoNode(matchResult.getId())) {
            try {
                TreeNode treeNode = node.getFirstChild();
                if (treeNode instanceof FaultTreeNode) {
                    FaultTreeNode firstChildNode = (FaultTreeNode)treeNode;
                    TreeNodeData firstChildMatchResult = (TreeNodeData)firstChildNode.getUserObject();
                    this.causeAnalysisDialog.refreshData(this.logRow, firstChildMatchResult.getId(), firstChildMatchResult.getCauseGroupId());
                }
            }
            catch (NoSuchElementException e) {
                this.causeAnalysisDialog.refreshBlankData();
                LOGGER.info("node has no children !");
            }
        }
        if (this.isCauseRootNode(matchResult.getId())) {
            this.causeAnalysisDialog.refreshData(this.logRow, matchResult.getId(), matchResult.getCauseGroupId());
        }
    }

    private boolean isCauseRootNode(String id) {
        HashSet<String> causeIdSet = new HashSet<String>();
        if (this.phenoCauseDataMap == null) {
            return false;
        }
        for (Map.Entry<String, List<TreeNodeData>> entry : this.phenoCauseDataMap.entrySet()) {
            for (TreeNodeData node : entry.getValue()) {
                causeIdSet.add(node.getId());
            }
        }
        return causeIdSet.contains(id);
    }

    private boolean isPhenoNode(String id) {
        return this.phenoCauseDataMap.keySet().contains(id);
    }

    @Override
    public FaultTreeNode getPhenomenonGroupNode(FaultType faultType) {
        TreeNodeData pMr = new TreeNodeData(faultType.getId(), this.type, false);
        pMr.setIsMatched(this.getIsMatched(faultType.getPhenoList()));
        FaultTreeNode phenomenonGroupNode = new FaultTreeNode(pMr, false);
        for (Pheno pheno : faultType.getPhenoList()) {
            TreeNodeData treeNodeData = (TreeNodeData)this.phenoDataMap.get(pheno.getId());
            treeNodeData = treeNodeData == null ? new TreeNodeData(pheno.getId(), this.type, false) : treeNodeData;
            FaultTreeNode ftn = new FaultTreeNode(treeNodeData, false);
            ArrayList<TreeNodeData> nodeCauseDataList = new ArrayList<TreeNodeData>();
            this.initCauseData(pheno, nodeCauseDataList, false);
            Collections.sort(nodeCauseDataList);
            this.phenoCauseDataMap.put(pheno.getId(), nodeCauseDataList);
            this.addCauseNodes(ftn, nodeCauseDataList);
            phenomenonGroupNode.add(ftn);
        }
        return phenomenonGroupNode;
    }

    public FaultTreeNode getMatchedPhenomenonGroupNode(FaultType faultType) {
        TreeNodeData pMr = new TreeNodeData(faultType.getId(), this.type, false);
        pMr.setIsMatched(this.getIsMatched(faultType.getPhenoList()));
        FaultTreeNode phenomenonGroupNode = new FaultTreeNode(pMr, false);
        try {
            for (Pheno p : faultType.getPhenoList()) {
                TreeNodeData treeNodeData = (TreeNodeData)this.phenoDataMap.get(p.getId());
                if (treeNodeData == null || treeNodeData.getMatchNum() <= 0) continue;
                FaultTreeNode ftn = new FaultTreeNode(treeNodeData, false);
                phenomenonGroupNode.add(ftn);
                ArrayList<TreeNodeData> nodeCauseDataList = new ArrayList<TreeNodeData>();
                this.initCauseData(p, nodeCauseDataList, true);
                Collections.sort(nodeCauseDataList);
                this.addCauseNodes(ftn, nodeCauseDataList);
            }
        }
        catch (Exception e) {
            LOGGER.error("obtain Phenomenon data node error !");
        }
        return phenomenonGroupNode;
    }

    private void initCauseData(Pheno pheno, List<TreeNodeData> nodeCauseDataList, boolean needMatched) {
        try {
            CauseGroupList causeGroupList = this.type.causeGroupCache().get(pheno.getId());
            if (causeGroupList != null) {
                for (CauseGroup causeGroup : causeGroupList.getCauseGroupList()) {
                    this.initCauseDataList(nodeCauseDataList, needMatched, causeGroup);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("init Root Cause Data failed !");
        }
    }

    private void initCauseDataList(List<TreeNodeData> nodeCauseDataList, boolean needMatched, CauseGroup causeGroup) {
        for (Cause cause : causeGroup.getCauseList()) {
            TreeNodeData treeNodeCauseData = new TreeNodeData(cause.getId(), cause.getGroupId(), this.type, true);
            boolean isMatched = this.getCauseIsMatched(cause.getId());
            treeNodeCauseData.setIsMatched(isMatched);
            if (needMatched && isMatched) {
                nodeCauseDataList.add(treeNodeCauseData);
            }
            if (needMatched) continue;
            nodeCauseDataList.add(treeNodeCauseData);
        }
    }

    private void addCauseNodes(FaultTreeNode ftn, List<TreeNodeData> nodeCauseDataList) {
        for (TreeNodeData treeNodeData : nodeCauseDataList) {
            ftn.add(new FaultTreeNode(treeNodeData, false));
        }
    }

    private Boolean getCauseIsMatched(String causeId) {
        Map<String, CauseMatchResult> causeMatchResultMap = this.logRow.getCauseMatchResultMap();
        CauseMatchResult causeMatchResult = causeMatchResultMap.get(causeId);
        if (causeMatchResult != null) {
            if (causeMatchResult.getDateInfo() == null) {
                return true;
            }
            return SearcherUtils.isOnSetDate(causeMatchResult.getDateInfo().getTime());
        }
        return false;
    }

    public JComponent getFaultTreeComponent(FaultTree faultTree1) {
        JSplitPane faultTreeComponent = new JSplitPane(1, true);
        this.setTreeStyle(faultTreeComponent);
        JScrollPane faultTreeScrolPane = new JScrollPane(faultTree1);
        faultTreeScrolPane.setBorder(BorderFactory.createEmptyBorder());
        faultTreeScrolPane.setPreferredSize(new Dimension(950, 160));
        faultTreeComponent.setLeftComponent(this.getBlankPanel());
        faultTreeComponent.setRightComponent(UCD.buildHorizotalBox(null, (int)5, (Component[])new Component[]{faultTreeScrolPane}));
        return faultTreeComponent;
    }

    private void setTreeStyle(JSplitPane faultTreeComponent) {
        faultTreeComponent.setDividerSize(0);
        faultTreeComponent.setDividerLocation(15);
        faultTreeComponent.setEnabled(false);
    }

    private JPanel getBlankPanel() {
        JPanel blankLabel = new JPanel();
        blankLabel.setBackground(Color.WHITE);
        return blankLabel;
    }

    public FaultTreeRootCauseDialog getCauseAnalysisDialog() {
        return this.causeAnalysisDialog;
    }

    public void setCauseAnalysisDialog(FaultTreeRootCauseDialog causeAnalysisDialog) {
        this.causeAnalysisDialog = causeAnalysisDialog;
    }

    public void refreshCauseDetail(FaultTreeNode node) {
        HashMap<String, String> causeMap = new HashMap<String, String>();
        this.getFirstCauseIdByPheno(node, causeMap);
        if (!StringUtils.isNULLStr((String)((String)causeMap.get(KEY_CAUSE_ID)))) {
            this.causeAnalysisDialog.refreshData(this.logRow, (String)causeMap.get(KEY_CAUSE_ID), (String)causeMap.get(KEY_CAUSE_GROUP_ID));
        } else {
            this.causeAnalysisDialog.refreshBlankData();
        }
    }

    private void getFirstCauseIdByPheno(FaultTreeNode node, Map<String, String> causeMap) {
        List<TreeNodeData> causeNodeDataList;
        if (node == null) {
            return;
        }
        TreeNodeData phenoNodeData = (TreeNodeData)node.getUserObject();
        String phenoId = phenoNodeData.getId();
        TreeNodeData faultTreeMatchedNode = (TreeNodeData)this.faultTreeMatched.getRootNode().getFirstLeaf().getUserObject();
        if (phenoNodeData.getMatchNum() == 0 && this.faultTreeMatched.getRootNode().getFirstLeaf() != this.faultTreeMatched.getRootNode()) {
            FaultTreeNode matchedTreeNode = (FaultTreeNode)this.faultTreeMatched.getRootNode().getFirstLeaf().getParent();
            TreeNodeData matchedTreeNodeData = (TreeNodeData)matchedTreeNode.getUserObject();
            phenoId = matchedTreeNodeData.getId();
        }
        if ((causeNodeDataList = this.phenoCauseDataMap.get(phenoId)) != null && !causeNodeDataList.isEmpty()) {
            causeMap.put(KEY_CAUSE_ID, causeNodeDataList.get(0).getId());
            causeMap.put(KEY_CAUSE_GROUP_ID, causeNodeDataList.get(0).getCauseGroupId());
        } else {
            causeMap.put(KEY_CAUSE_ID, faultTreeMatchedNode.getId());
            causeMap.put(KEY_CAUSE_GROUP_ID, faultTreeMatchedNode.getCauseGroupId());
        }
    }

    public void setSelectNode(FaultTree faultTree1, TreePath parent, String phenoId) {
        FaultTreeNode node = (FaultTreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                FaultTreeNode n = (FaultTreeNode)e.nextElement();
                TreeNodeData matchResult = (TreeNodeData)n.getUserObject();
                if (matchResult.getId().equals(phenoId)) {
                    n.setHilight(true);
                    n.getCheckLabelPanel().getTreeLabel().setSelected(true);
                    faultTree1.setSelectionPath(new TreePath(n));
                    return;
                }
                TreePath path = parent.pathByAddingChild(n);
                this.setSelectNode(faultTree1, path, phenoId);
            }
        }
    }

    public FaultTree getVersionFaultTree() {
        return this.versionFaultTree;
    }

    public void setVersionFaultTree(FaultTree versionFaultTree) {
        this.versionFaultTree = versionFaultTree;
    }

    public FaultTree getFaultTree() {
        return this.faultTree;
    }

    public FaultTree getFaultTreeMatched() {
        return this.faultTreeMatched;
    }

    public LogRow getLogRow() {
        return this.logRow;
    }

    public void copyRow(LogRow row) {
        this.logRow.setLogID(row.getLogID());
        this.logRow.getCauseMatchResultMap().clear();
        this.logRow.getCauseMatchResultMap().putAll(row.getCauseMatchResultMap());
        this.logRow.setLogFile(row.getLogFile());
        this.logRow.setDeviceType(row.getDeviceType());
        this.logRow.setProductInfo(row.getProductInfo());
        this.logRow.setStauts(row.getStauts());
        this.logRow.setRow(row.getRow());
        this.logRow.setSelectRow(row.getSelectRow());
        this.logRow.setReportTmpFile(row.getReportTmpFile());
        this.logRow.setLogDeCompressDir(row.getLogDeCompressDir());
        this.logRow.setListModel(row.getListModel());
        this.logRow.setIndexDir(row.getIndexDir());
        this.logRow.setCtrlNames(row.getCtrlNames());
    }
}

