/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.ui.faultuitree;

import com.huawei.ism.tool.loganalyzer.ui.faultuitree.FaultTreeNode;
import com.huawei.ism.tool.loganalyzer.ui.faultuitree.TreeNodeData;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FaultTree
extends JTree {
    private static final long serialVersionUID = 3727243641491788680L;
    private FaultTreeNode rootNode;

    public FaultTree(FaultTreeNode rootNode, boolean isMainPage, FaultTreeNode assignTree, boolean needMatched) {
        super(rootNode, true);
        this.rootNode = rootNode;
        TreeNodeData pmr = (TreeNodeData)rootNode.getUserObject();
        this.setRootVisible(false);
        this.setEnabled(true);
        if (!needMatched) {
            this.expandMatchedNode(pmr, isMainPage, assignTree);
        } else {
            this.expandNeedMatchedNode(pmr);
        }
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    private void expandNeedMatchedNode(TreeNodeData pmr) {
        FaultTreeNode root = (FaultTreeNode)this.getModel().getRoot();
        if (root == null) {
            return;
        }
        this.expandMatchPath(new TreePath(root), pmr);
    }

    private void expandMatchedNode(TreeNodeData pmr, boolean isMainPage, FaultTreeNode clickTree) {
        FaultTreeNode root = (FaultTreeNode)this.getModel().getRoot();
        if (root == null) {
            return;
        }
        if (isMainPage) {
            this.expandMatchPath(new TreePath(root), pmr);
        } else {
            Set<String> expandNodeIdSet = this.getParentAndBrotherNodeId(clickTree, root);
            this.expandAssignTree(new TreePath(root), expandNodeIdSet);
        }
    }

    private Set<String> getParentAndBrotherNodeId(FaultTreeNode clickTree, FaultTreeNode root) {
        HashSet<String> expandNodeIdSet = new HashSet<String>();
        FaultTreeNode clickTreeParent = (FaultTreeNode)clickTree.getParent();
        TreeNodeData matchResult = (TreeNodeData)clickTreeParent.getUserObject();
        Enumeration<TreeNode> e = root.children();
        while (e.hasMoreElements()) {
            FaultTreeNode n = (FaultTreeNode)e.nextElement();
            TreeNodeData nodeData = (TreeNodeData)n.getUserObject();
            if (!matchResult.getId().equals(nodeData.getId())) continue;
            expandNodeIdSet.add(matchResult.getId());
            this.addChildIds(expandNodeIdSet, n);
        }
        return expandNodeIdSet;
    }

    private void addChildIds(Set<String> expandNodeIdSet, FaultTreeNode faultTreeNode) {
        Enumeration<TreeNode> en = faultTreeNode.children();
        while (en.hasMoreElements()) {
            FaultTreeNode node = (FaultTreeNode)en.nextElement();
            TreeNodeData matchResult = (TreeNodeData)node.getUserObject();
            expandNodeIdSet.add(matchResult.getId());
            this.addChildIds(expandNodeIdSet, node);
        }
    }

    private void expandAssignTree(TreePath treePath, Set<String> expandNodeIdSet) {
        TreeNodeData matchResult;
        FaultTreeNode node = (FaultTreeNode)treePath.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                FaultTreeNode n = (FaultTreeNode)e.nextElement();
                TreePath path = treePath.pathByAddingChild(n);
                this.expandAssignTree(path, expandNodeIdSet);
            }
        }
        if (expandNodeIdSet.contains((matchResult = (TreeNodeData)node.getUserObject()).getId()) || "root".equals(matchResult.getName()) || node.isLeaf()) {
            this.expandPath(treePath);
        } else {
            this.collapsePath(treePath);
        }
    }

    private void expandMatchPath(TreePath parent, TreeNodeData pmr) {
        FaultTreeNode node = (FaultTreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                FaultTreeNode n = (FaultTreeNode)e.nextElement();
                TreeNodeData matchResult = (TreeNodeData)n.getUserObject();
                TreePath path = parent.pathByAddingChild(n);
                this.expandMatchPath(path, matchResult);
            }
        }
        if (pmr.getIsMatched() != null && pmr.getIsMatched().booleanValue() || node.isLeaf() || pmr.getMatchNum() > 0) {
            this.expandPath(parent);
        } else {
            this.collapsePath(parent);
        }
    }

    public FaultTreeNode getRootNode() {
        return this.rootNode;
    }
}

