/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.ui.faultuitree;

import com.huawei.ism.tool.base.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.loganalyzer.ui.faultuitree.FaultTreeLabelPanel;
import com.huawei.ism.tool.loganalyzer.ui.faultuitree.FaultTreeNode;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreeCellEditor;

public class FaultTreeCellEditor
extends AbstractCellEditor
implements TreeCellEditor {
    private static final long serialVersionUID = 6569096298893444931L;
    protected JComponent editorComponent;
    protected EditorDelegate delegate;
    private int clickCountToStart = 1;

    @ConstructorProperties(value={"component"})
    public FaultTreeCellEditor(final ToolHyperLinkLabel jLabel) {
        this.editorComponent = jLabel;
        this.clickCountToStart = 1;
        this.delegate = new EditorDelegate(this){
            private static final long serialVersionUID = 1L;

            @Override
            public void setValue(Object value) {
                jLabel.setText(value != null ? value.toString() : "");
            }

            @Override
            public Object getCellEditorValue() {
                return jLabel.getText();
            }
        };
    }

    @Override
    public Component getTreeCellEditorComponent(JTree jTree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        FaultTreeNode node = (FaultTreeNode)value;
        FaultTreeLabelPanel checkLabel = node.getCheckLabelPanel();
        checkLabel.getDetailLabel().setEnabled(true);
        checkLabel.getTreeLabel().setSelected(false);
        return checkLabel;
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    protected class EditorDelegate
    implements ActionListener,
    ItemListener,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected Object value;

        protected EditorDelegate() {
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= FaultTreeCellEditor.this.clickCountToStart;
            }
            return true;
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        public boolean startCellEditing(EventObject anEvent) {
            return true;
        }

        public boolean stopCellEditing() {
            FaultTreeCellEditor.this.fireEditingStopped();
            return true;
        }

        public void cancelCellEditing() {
            FaultTreeCellEditor.this.fireEditingCanceled();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.stopCellEditing();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.stopCellEditing();
        }
    }
}

