/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.ui.faultuitree;

import com.huawei.ism.tool.base.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.loganalyzer.ui.faultuitree.TreeLabel;
import com.huawei.ism.tool.loganalyzer.ui.faultuitree.TreeNodeData;
import com.huawei.ism.ui.swing.TernaryCheckBox;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class FaultTreeLabelPanel
extends JPanel {
    private static final long serialVersionUID = 6674282584652272476L;
    private boolean hasCheckBox;
    private TernaryCheckBox check;
    private TreeLabel label;
    private TreeLabel rootReasonNumLabel;
    private transient ToolHyperLinkLabel detailLabel;
    private transient TreeNodeData pmr;
    private int width;
    private boolean isMainPage;

    public FaultTreeLabelPanel(boolean hasCheckBox, TreeNodeData pmr, int width, boolean isMainPage) {
        this.setOpaque(false);
        this.pmr = pmr;
        this.width = width;
        this.hasCheckBox = hasCheckBox;
        this.isMainPage = isMainPage;
        this.initUI();
    }

    protected void setHasCheckBox(boolean has) {
        if (!has) {
            this.hasCheckBox = false;
            this.removeAll();
            this.initUI();
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dlabel = this.label.getPreferredSize();
        return new Dimension(dlabel.width, dlabel.height);
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.check = new TernaryCheckBox();
        this.label = new TreeLabel();
        this.rootReasonNumLabel = new TreeLabel();
        this.detailLabel = new ToolHyperLinkLabel();
        this.setSize(this.getPreferredSize());
        JComponent view = null;
        this.setName(this.pmr.getName(), this.pmr.getMatchNum(), this.pmr.getIsMatched());
        this.setMatchNum(this.pmr.getMatchNum());
        this.setDetail(this.pmr.getDetail());
        int compMargin = (this.width - this.label.getWidth() - this.rootReasonNumLabel.getWidth() - this.detailLabel.getWidth()) / 3;
        view = this.hasCheckBox ? UCD.buildHorizotalBox(null, (int)5, (Component[])new Component[]{this.check, this.label, Box.createHorizontalGlue()}) : UCD.buildHorizotalBox(null, (int)compMargin, (Component[])new Component[]{this.label, Box.createHorizontalGlue()});
        this.add((Component)view, "Center");
    }

    public TernaryCheckBox getCheckBox() {
        return this.check;
    }

    public TreeLabel getTreeLabel() {
        return this.label;
    }

    public TreeLabel getRootReasonNumLabel() {
        return this.rootReasonNumLabel;
    }

    public ToolHyperLinkLabel getDetailLabel() {
        return this.detailLabel;
    }

    public void setName(String name, int number, Boolean isMatched) {
        if (number > 0) {
            String showName = String.valueOf(name) + ResourceUtil.getString((String)"info.analyze.faultTree.ui.discover.text") + number + ResourceUtil.getString((String)"info.analyze.faultTree.ui.problem.text");
            this.label.setText(showName);
            this.label.setForeground(Color.RED);
        } else {
            if (isMatched != null && isMatched.booleanValue()) {
                this.label.setForeground(Color.RED);
            }
            this.label.setText(name);
        }
        if (!this.isMainPage) {
            this.setToolTipText(this.label.getText());
        } else {
            this.setToolTipText(ResourceUtil.getStringWithParams((String)"info.analyze.faultTree.ui.node.details", (Object[])new Object[]{name.toLowerCase(Locale.ENGLISH)}));
        }
    }

    public String addUnderLine(String name) {
        return "<html><div style='text-decoration: underline;'>" + name + "</div></html>";
    }

    public void setMatchNum(int number) {
        this.rootReasonNumLabel.setText(String.valueOf(number));
    }

    public void setDetail(String detail) {
        this.detailLabel.setText(detail);
    }
}

