/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.ui.faultuitree;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.loganalyzer.faulttree.model.SearchProgress;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class FaultTreeProgressBar {
    private static final int CONTAINERHEIGHT = 75;
    private static final int NUMBER_729 = 729;
    private static final int NUMBER_2 = 2;
    private static final int LEFTMARGIN = 25;
    private static final int OFFSETTOP = 10;
    private JPanel topContainer = new JPanel();
    private JPanel bottomContainer = new JPanel();
    private JPanel containerJPanel = new JPanel();
    private JComponent box;
    private JProgressBar progressBar;
    private JLabel fileTypeLabel = new JLabel();
    private JLabel progressImage = new JLabel();
    private JLabel pregressLabel = new JLabel("0%");
    private final int screenWidth = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
    private final int screenHeight = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
    private JComponent parentContainer;

    public JComponent initUI(JComponent jc) {
        this.parentContainer = jc;
        this.progressBarUI();
        this.box = Box.createVerticalBox();
        this.containerJPanel.setPreferredSize(new Dimension(jc.getWidth(), 75));
        this.containerJPanel.setMaximumSize(new Dimension(this.screenWidth, 75));
        this.containerJPanel.setMinimumSize(new Dimension(729, 75));
        this.topContainer.setPreferredSize(new Dimension(jc.getWidth(), jc.getHeight() / 2 - 75 + 10));
        this.topContainer.setMaximumSize(new Dimension(this.screenWidth, this.screenHeight));
        this.topContainer.setMinimumSize(new Dimension(729, 22));
        this.bottomContainer.setPreferredSize(new Dimension(jc.getWidth(), jc.getHeight() / 2 - 10));
        this.bottomContainer.setMaximumSize(new Dimension(this.screenWidth, this.screenHeight));
        this.bottomContainer.setMinimumSize(new Dimension(729, 78));
        this.box.add(this.topContainer);
        this.box.add(this.containerJPanel);
        this.box.add(this.bottomContainer);
        this.setCenterContainer(this.containerJPanel);
        this.initListener();
        this.setComponentName();
        this.containerJPanel.setBackground(Color.WHITE);
        this.topContainer.setBackground(Color.WHITE);
        this.bottomContainer.setBackground(Color.WHITE);
        return this.box;
    }

    public void clearProgressData() {
        this.setRealTimeProgress("", 0, 0);
    }

    public void setProgress(SearchProgress searchProgress) {
        this.setRealTimeProgress(searchProgress.getInfo(), searchProgress.getCurrent(), searchProgress.getTotal());
    }

    private void setRealTimeProgress(String fileType, int analyzeFiles, int totalFiles) {
        this.fileTypeLabel.setText(fileType);
        this.pregressLabel.setText(String.valueOf(ResourceUtil.getString((String)"info.analyze.faultTree.ui.total.progress")) + this.countPregressRate(analyzeFiles, totalFiles) + "%");
        this.progressBar.setValue(this.countPregressRate(analyzeFiles, totalFiles));
    }

    private int countPregressRate(int analyzeFiles, int totalFiles) {
        if (totalFiles > 0 && analyzeFiles >= 0) {
            return (int)((double)analyzeFiles / (double)totalFiles * 100.0);
        }
        return 0;
    }

    private void setCenterContainer(JComponent jc) {
        jc.setLayout(new BorderLayout());
        JPanel leftPanel = new JPanel();
        leftPanel.setPreferredSize(new Dimension(25, 75));
        leftPanel.setMinimumSize(new Dimension(25, 75));
        leftPanel.setMaximumSize(new Dimension(25, 75));
        JPanel rightPanel = new JPanel();
        rightPanel.setPreferredSize(new Dimension(35, 75));
        rightPanel.setMinimumSize(new Dimension(35, 75));
        rightPanel.setMaximumSize(new Dimension(35, 75));
        Box centerBox = Box.createVerticalBox();
        centerBox.add(this.setTopUiComponent());
        centerBox.add(this.progressBar);
        leftPanel.setBackground(Color.WHITE);
        rightPanel.setBackground(Color.WHITE);
        jc.add((Component)leftPanel, "West");
        jc.add((Component)rightPanel, "East");
        jc.add((Component)centerBox, "Center");
    }

    private JComponent setTopUiComponent() {
        JPanel jp = new JPanel();
        jp.setBackground(Color.WHITE);
        jp.setLayout(new BorderLayout());
        jp.setMaximumSize(new Dimension(this.screenWidth - 50, 60));
        this.progressImage.setIcon(new ImageIcon(FaultTreeProgressBar.class.getClassLoader().getResource("config/loganalyzer/images/FaultCheck.png")));
        this.fileTypeLabel.setFont(new Font("Dialog", 0, 13));
        this.pregressLabel.setFont(new Font("Dialog", 0, 13));
        Box leftBox = UCD.buildHBoxLeft((Component[])new Component[]{this.progressImage, this.fileTypeLabel, Box.createHorizontalStrut(12)});
        jp.add((Component)leftBox, "West");
        Box rightBox = Box.createVerticalBox();
        rightBox.add(Box.createVerticalStrut(15));
        Box processBox = Box.createHorizontalBox();
        processBox.add(UCD.buildHBoxRight((int)0, (Component[])new Component[]{this.pregressLabel}));
        processBox.add(Box.createHorizontalStrut(10));
        rightBox.add(processBox);
        jp.add((Component)rightBox, "East");
        return jp;
    }

    private void progressBarUI() {
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setPreferredSize(new Dimension(0, 15));
        this.progressBar.setBackground(new Color(228, 228, 228));
        this.progressBar.setForeground(new Color(0, 192, 0));
        this.progressBar.setBorderPainted(false);
        this.progressBar.setStringPainted(false);
        this.progressBar.setVisible(true);
    }

    private void initListener() {
        this.parentContainer.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                FaultTreeProgressBar.this.countComponentSize();
            }
        });
    }

    private void countComponentSize() {
        int boxWidth = this.parentContainer.getWidth();
        int boxHeight = this.parentContainer.getHeight();
        int relativeHeight = boxHeight / 2;
        this.topContainer.setSize(boxWidth, relativeHeight - 75 + 10);
        this.containerJPanel.setSize(boxWidth, 75);
        this.bottomContainer.setSize(boxWidth, boxHeight - this.topContainer.getHeight() - this.containerJPanel.getHeight());
    }

    private void setComponentName() {
        this.progressBar.setName("faulttree_progressbar");
        this.fileTypeLabel.setName("faulttree_filetypelabel");
        this.pregressLabel.setName("faulttree_pregresslabel");
    }
}

