/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.ui.faultuitree;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.loganalyzer.entity.analyze.HelpKey;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogRow;
import com.huawei.ism.tool.loganalyzer.faulttree.command.model.DateInfo;
import com.huawei.ism.tool.loganalyzer.faulttree.resources.cache.ResourceCache;
import com.huawei.ism.tool.loganalyzer.faulttree.resources.model.Issue;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.CauseMatchResult;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.RecordInfo;
import com.huawei.ism.tool.loganalyzer.ui.faultuitree.DetailFaultTree;
import com.huawei.ism.tool.loganalyzer.ui.faultuitree.FaultTree;
import com.huawei.ism.tool.loganalyzer.ui.faultuitree.FaultTreeNode;
import com.huawei.ism.tool.loganalyzer.ui.faultuitree.LogDetailPanel;
import com.huawei.ism.tool.loganalyzer.ui.faultuitree.SimpleFrame;
import com.huawei.ism.tool.loganalyzer.ui.faultuitree.TreeNodeData;
import com.huawei.ism.tool.loganalyzer.ui.main.MainLogAnaDialog;
import com.huawei.ism.tool.loganalyzer.util.ComponentDefine;
import com.huawei.ism.tool.loganalyzer.util.SearcherUtils;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;

public class FaultTreeRootCauseDialog
extends SimpleFrame {
    public static final int INT830 = 830;
    public static final int INT410 = 410;
    private static final long serialVersionUID = 3321226060684437944L;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(FaultTreeRootCauseDialog.class);
    private static final Dimension DIALOG_SIZE = new Dimension(980, 660);
    private JPanel rootInfoPanel = new JPanel();
    private List<Box> boxList = new ArrayList<Box>();
    private JLabel dateLabel = UiMethod.createColonLabel((String)ResourceUtil.getString((String)"info.analyze.faultTree.ui.startTime.name"));
    private JLabel startDateLabel = new JLabel("NA");
    private JLabel problemDescriptionLabel = UiMethod.createColonLabel((String)ResourceUtil.getString((String)"info.analyze.faultTree.ui.problem.describe"));
    private JLabel descriptionContentLabel = new JLabel("NA");
    private JLabel rootCauseLabel = UiMethod.createColonLabel((String)ResourceUtil.getString((String)"info.analyze.faultTree.ui.reason.analyze"));
    private JEditorPane rootCausePane = new JEditorPane();
    private JLabel advicedActionLabel = UiMethod.createColonLabel((String)ResourceUtil.getString((String)"info.analyze.faultTree.ui.repair.suggest"));
    private JEditorPane advicedActionPane = new JEditorPane();
    private LogDetailPanel logDetailsPane = new LogDetailPanel();
    private JLabel logDetailsLabel = UiMethod.createColonLabel((String)ResourceUtil.getString((String)"info.analyze.faultTree.ui.log.detail"));
    private JScrollPane rootCauseScroll;
    private JScrollPane advicedActionScroll;
    private JScrollPane logDetailScroll;
    private JSplitPane leftSplitPane;
    private DetailFaultTree detailFaultTree;
    private JSplitPane splitPane;
    private JComboBox<String> jcb;
    private FaultTree faultTree;

    public FaultTreeRootCauseDialog(FaultTree faultTree, DetailFaultTree detailFaultTree, String phenoId) {
        this.faultTree = faultTree;
        this.inti(detailFaultTree, phenoId);
    }

    public void inti(DetailFaultTree detailFaultTree1, String phenoId) {
        this.detailFaultTree = detailFaultTree1;
        this.setTitle(ResourceUtil.getString((String)"info.analyze.faultTree.ui.rootCause.analyze"));
        this.setIconImage(ResourceUtil.getImage((String)"analyze48.PNG").getImage());
        this.layoutComponents();
        this.setMinimumSize(DIALOG_SIZE);
        SwingUtil.putScreenCenter((Window)this);
        this.initListener();
        this.setSize(DIALOG_SIZE);
        this.setDefaultCloseOperation(2);
        SwingUtil.putScreenCenter((Window)this);
        this.setCompName();
    }

    public void refreshData(LogRow row, String causeId, String causeGroupId) {
        try {
            ResourceCache resourceCache = row.getDeviceType().resourceCache();
            Issue issue = resourceCache.getIssue(causeId);
            this.descriptionContentLabel.setText(StringUtils.isNULLStr((String)issue.getName()) ? "NA" : issue.getName());
            this.rootCausePane.setText(this.getHtml(issue.getCause()));
            Map<String, List<HelpKey>> helpKeys = this.getHelpMap(issue);
            String helpPath = this.getHelpPath(row);
            String valueWithLink = SearcherUtils.replaceKeysByMap(issue.getAction(), helpPath, helpKeys);
            this.advicedActionPane.setText(this.getHtml(valueWithLink));
            CauseMatchResult causeMatchResult = row.getFilterCauseMatchResultMap().get(causeId);
            if (causeMatchResult != null) {
                DateInfo dateInfo = causeMatchResult.getDateInfo();
                if (dateInfo == null || "--".equals(dateInfo.getDate())) {
                    this.startDateLabel.setText("NA");
                } else {
                    this.startDateLabel.setText(dateInfo.getDate());
                }
                Map<String, List<RecordInfo>> recordInfoMap = causeMatchResult.getRecordInfoMap();
                ArrayList<RecordInfo> recordInfoAll = new ArrayList<RecordInfo>();
                for (Map.Entry<String, List<RecordInfo>> entry : recordInfoMap.entrySet()) {
                    recordInfoAll.addAll((Collection<RecordInfo>)entry.getValue());
                }
                Collections.sort(recordInfoAll);
                this.logDetailsPane.refreshLogDetail(recordInfoAll, causeMatchResult.getCauseId());
            } else {
                this.startDateLabel.setText("NA");
                this.logDetailsPane.clearData();
            }
            this.setComponentCarePosition();
            this.reDivided();
        }
        catch (Exception e) {
            this.descriptionContentLabel.setText("NA");
            this.rootCausePane.setText(this.getHtml("NA"));
            this.advicedActionPane.setText(this.getHtml("NA"));
            this.startDateLabel.setText("NA");
            this.logDetailsPane.clearData();
            LOGGER.error("refresh data error!");
        }
    }

    public void reDivided() {
        int dividerLocation = this.splitPane.getDividerLocation();
        this.splitPane.setDividerLocation(dividerLocation + 1);
        this.repaint();
        int curDividerLocation = this.splitPane.getDividerLocation();
        this.splitPane.setDividerLocation(curDividerLocation - 1);
        this.repaint();
    }

    private void setComponentCarePosition() {
        this.rootCausePane.setCaretPosition(0);
        this.advicedActionPane.setCaretPosition(0);
        JScrollBar horizontalScrollBar = this.logDetailScroll.getHorizontalScrollBar();
        JScrollBar verticalScrollBar = this.logDetailScroll.getVerticalScrollBar();
        if (horizontalScrollBar != null) {
            horizontalScrollBar.setValue(horizontalScrollBar.getMinimum());
        }
        if (verticalScrollBar != null) {
            verticalScrollBar.setValue(verticalScrollBar.getMinimum());
        }
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        this.leftSplitPane = new JSplitPane(0, false);
        this.leftSplitPane.setDividerLocation(35);
        this.leftSplitPane.setDividerSize(1);
        this.leftSplitPane.setEnabled(false);
        JComponent checkBox = this.createCheckBox();
        this.leftSplitPane.setTopComponent(checkBox);
        FaultTree faultTree1 = this.detailFaultTree.getFaultTreeMatched();
        if (faultTree1.getRootNode().getFirstLeaf() != faultTree1.getRootNode()) {
            FaultTreeNode root = this.detailFaultTree.getFaultTreeMatched().getRootNode();
            if (root == null) {
                return;
            }
            this.jcb.setSelectedItem(ResourceUtil.getString((String)"info.analyze.faultTree.ui.jcombobox.found"));
            this.leftSplitPane.setBottomComponent(this.detailFaultTree.getFaultTreeComponent(faultTree1));
        } else {
            this.jcb.removeItem(ResourceUtil.getString((String)"info.analyze.faultTree.ui.jcombobox.found"));
            this.jcb.setSelectedItem(ResourceUtil.getString((String)"info.analyze.faultTree.ui.jcombobox.all"));
            FaultTreeNode root = this.detailFaultTree.getFaultTree().getRootNode();
            if (root == null) {
                return;
            }
            this.leftSplitPane.setBottomComponent(this.detailFaultTree.getFaultTreeComponent(this.detailFaultTree.getFaultTree()));
        }
        this.splitPane = new JSplitPane(1, true);
        if (LanguageManager.getInstance().getCurrentLanguage().getLanguage().equalsIgnoreCase("en")) {
            this.splitPane.setDividerLocation(430);
        } else {
            this.splitPane.setDividerLocation(330);
        }
        this.splitPane.setLeftComponent(this.leftSplitPane);
        this.splitPane.setRightComponent(this.layoutRightComponents());
        this.splitPane.setBackground(Color.white);
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.splitPane.setEnabled(true);
        this.add(this.splitPane);
    }

    private JComponent createCheckBox() {
        JLabel textLabel = new JLabel(String.valueOf(ResourceUtil.getString((String)"info.analyze.faultTree.ui.jcombobox.display")) + ":");
        textLabel.setName("fault_tree_ui_jcombobox_label");
        this.jcb = new JComboBox();
        this.jcb.addItem(ResourceUtil.getString((String)"info.analyze.faultTree.ui.jcombobox.found"));
        this.jcb.addItem(ResourceUtil.getString((String)"info.analyze.faultTree.ui.jcombobox.version"));
        this.jcb.addItem(ResourceUtil.getString((String)"info.analyze.faultTree.ui.jcombobox.all"));
        if (LanguageManager.getInstance().getCurrentLanguage().getLanguage().equalsIgnoreCase("en")) {
            this.jcb.setPreferredSize(new Dimension(300, 25));
            this.jcb.setMaximumSize(new Dimension(300, 25));
            this.jcb.setMinimumSize(new Dimension(300, 25));
            this.jcb.setFocusable(false);
            return this.arrayJComponent(textLabel, this.jcb, 430);
        }
        this.jcb.setPreferredSize(new Dimension(200, 25));
        this.jcb.setMaximumSize(new Dimension(200, 25));
        this.jcb.setMinimumSize(new Dimension(200, 25));
        this.jcb.setFocusable(false);
        return this.arrayJComponent(textLabel, this.jcb, 330);
    }

    private JComponent arrayJComponent(JLabel textLabel, JComponent box, int width) {
        JPanel boxPanel = new JPanel();
        boxPanel.setLayout(new BorderLayout());
        JLabel blankLabel = new JLabel();
        blankLabel.setPreferredSize(new Dimension(15, 35));
        blankLabel.setMaximumSize(new Dimension(15, 35));
        blankLabel.setMinimumSize(new Dimension(15, 35));
        boxPanel.add(UCD.buildHorizotalBox(null, (int)5, (Component[])new Component[]{blankLabel, textLabel, box}));
        boxPanel.setPreferredSize(new Dimension(width, 35));
        boxPanel.setMaximumSize(new Dimension(width, 35));
        boxPanel.setMinimumSize(new Dimension(width, 35));
        boxPanel.setBackground(Color.WHITE);
        return boxPanel;
    }

    public void refreshLeftTree(JComponent causeFaultTree) {
        this.leftSplitPane.setBottomComponent(causeFaultTree);
        this.repaint();
    }

    public void refreshBlankData() {
        this.descriptionContentLabel.setText("NA");
        this.rootCausePane.setText(this.getHtml("NA"));
        this.advicedActionPane.setText(this.getHtml("NA"));
        this.logDetailsPane.clearData();
        this.startDateLabel.setText("NA");
    }

    private Map<String, List<HelpKey>> getHelpMap(Issue issue) {
        String[] valueArray;
        HashMap<String, List<HelpKey>> helpMap = new HashMap<String, List<HelpKey>>();
        HashMap<String, String> issueHelpKeyValue = new HashMap<String, String>();
        String issueName = issue.getCaseName();
        String issueHelp = issue.getCaseHref();
        if (StringUtils.isNULLStr((String)issueName) || StringUtils.isNULLStr((String)issueHelp)) {
            return helpMap;
        }
        String[] keyArray = issueName.split("&&");
        if (keyArray.length != (valueArray = issueHelp.split("&&")).length) {
            return helpMap;
        }
        int i = 0;
        while (i < keyArray.length) {
            if (!StringUtils.isNULLStr((String)keyArray[i])) {
                issueHelpKeyValue.put(keyArray[i].trim(), valueArray[i].trim());
            }
            ++i;
        }
        if (!issueHelpKeyValue.isEmpty()) {
            for (Map.Entry entry : issueHelpKeyValue.entrySet()) {
                String helpKey = (String)entry.getKey();
                String[] helpArray = ((String)entry.getValue()).split(",");
                ArrayList<HelpKey> helpKeyList = new ArrayList<HelpKey>();
                int index = 1;
                String[] stringArray = helpArray;
                int n = helpArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String url = stringArray[n2];
                    HelpKey helpKeyModel = new HelpKey();
                    helpKeyModel.setKey(helpKey);
                    helpKeyModel.setUrl(url);
                    helpKeyModel.setLocation(index++);
                    helpKeyList.add(helpKeyModel);
                    ++n2;
                }
                helpMap.put(helpKey, helpKeyList);
            }
        }
        return helpMap;
    }

    private String getHtml(String value) {
        if (StringUtils.isNULLStr((String)value)) {
            return "NA";
        }
        StringBuffer refText = new StringBuffer();
        StringBuffer context = new StringBuffer();
        refText.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" ").append("\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n").append("<html xmlns=\"http://www.w3.org/1999/xhtml\">\n").append("<head>\n").append("<style type= \"text/css\">").append("body{ font-size:8px;color:#464646;}").append(".exp{font-size:9px;color:#252525;}").append(".link{color:#4286d3;}").append("selected::selection{color:#ffffff;background:#990000;}").append("selected::-moz-selection{background:#990000;}").append("</style>\n").append("</head>\n").append("<body>\n");
        context.append("<div class=\"exp\">").append(value).append("</div>");
        refText.append(context.toString().replaceAll("\n", "<br>"));
        refText.append("</body>");
        refText.append("</html>");
        return refText.toString();
    }

    private String getHelpPath(LogRow row) {
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isNULLStr((String)this.getProductName(row))) {
            sb.append(ComponentDefine.CONFIG_PATH);
            sb.append(File.separator);
            sb.append(this.getProductName(row));
            return sb.toString();
        }
        return "";
    }

    private String getProductName(LogRow row) {
        return row.getDeviceType().versionSupportsCache().getModel(row.getRow().getValueAt(1).toString()).get(row.getVersionWithoutSPC()).getPackageName();
    }

    private JComponent layoutRightComponents() {
        JComponent topArea = UiMethod.buildFrameSpace((JComponent)UiMethod.buildCompsLeft((Component[])new Component[]{this.topBox()}), (int)12);
        this.issueDescBox();
        this.rootCauseBox();
        this.advicedActionBox();
        this.logDetailsBox();
        JPanel jpanel = new JPanel();
        jpanel.setLayout(new BorderLayout());
        jpanel.add((Component)this.verticalLayOutBox(this.boxList), "Center");
        JComponent contentArea = UiMethod.buildFrameSpace((JComponent)jpanel, (int)12);
        this.rootInfoPanel.setLayout(new BorderLayout());
        this.rootInfoPanel.add((Component)UCD.buildVerticalBox(null, (Component[])new Component[]{topArea, new JSeparator(), contentArea}), "Center");
        this.rootInfoPanel.setSize(new Dimension(700, 830));
        return this.rootInfoPanel;
    }

    private Box topBox() {
        this.startDateLabel.setMaximumSize(new Dimension(300, 21));
        this.startDateLabel.setMinimumSize(new Dimension(300, 21));
        this.startDateLabel.setPreferredSize(new Dimension(300, 21));
        return UCD.buildHBoxLeft((Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{this.dateLabel, this.startDateLabel, Box.createHorizontalStrut(12)})});
    }

    private void issueDescBox() {
        this.descriptionContentLabel.setMaximumSize(new Dimension((int)this.getScreenMaxSize().getWidth() - 400, 21));
        this.descriptionContentLabel.setMinimumSize(new Dimension(300, 21));
        this.descriptionContentLabel.setPreferredSize(new Dimension((int)this.getScreenMaxSize().getWidth() - 400, 21));
        this.boxList.add(this.getBox(this.problemDescriptionLabel, this.descriptionContentLabel));
    }

    private void rootCauseBox() {
        this.rootCausePane.setEditable(false);
        this.rootCausePane.setFocusable(true);
        this.rootCausePane.setContentType("text/html;charset=\"UTF-8\"");
        this.rootCauseScroll = new JScrollPane(this.rootCausePane);
        this.rootCauseScroll.setVerticalScrollBarPolicy(20);
        this.rootCauseScroll.setHorizontalScrollBarPolicy(30);
        this.rootCauseScroll.setPreferredSize(new Dimension((int)this.getScreenMaxSize().getWidth() - 300, 160));
        this.rootCausePane.setCaretPosition(0);
        this.boxList.add(this.buildBox(this.rootCauseLabel, this.rootCauseScroll));
    }

    private void advicedActionBox() {
        this.advicedActionPane.setEditable(false);
        this.advicedActionPane.setFocusable(true);
        this.advicedActionPane.setContentType("text/html;charset=\"UTF-8\"");
        this.advicedActionPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                FaultTreeRootCauseDialog.this.doAdvicedActionHyperLinkEvent(e);
            }
        });
        this.advicedActionScroll = new JScrollPane(this.advicedActionPane);
        this.advicedActionScroll.setVerticalScrollBarPolicy(20);
        this.advicedActionScroll.setHorizontalScrollBarPolicy(30);
        this.advicedActionScroll.setPreferredSize(new Dimension((int)this.getScreenMaxSize().getWidth() - 300, 160));
        this.advicedActionPane.setCaretPosition(0);
        this.boxList.add(this.buildBox(this.advicedActionLabel, this.advicedActionScroll));
    }

    private void logDetailsBox() {
        this.logDetailScroll = new JScrollPane(this.logDetailsPane);
        this.logDetailScroll.setVerticalScrollBarPolicy(20);
        this.logDetailScroll.setHorizontalScrollBarPolicy(30);
        this.logDetailScroll.setPreferredSize(new Dimension((int)this.getScreenMaxSize().getWidth() - 300, 410));
        this.boxList.add(this.buildBox(this.logDetailsLabel, this.logDetailScroll));
    }

    private void doAdvicedActionHyperLinkEvent(HyperlinkEvent e) {
        if (HyperlinkEvent.EventType.ACTIVATED == e.getEventType()) {
            try {
                boolean www;
                String url = e.getDescription();
                if (StringUtils.isNULLStr((String)url)) {
                    DialogUtils.showErrorDialog((Window)this, (String)ResourceUtil.getString((String)"inspect.case.link"));
                    return;
                }
                ToolLoggerFactory.getLogger(this.getClass()).debug("open url : " + url);
                boolean http = url.startsWith("http") || url.startsWith("HTTP");
                boolean bl = www = url.startsWith("www.") || url.startsWith("WWW.");
                if (http || www) {
                    FileUtils.openHtmlFile((String)url);
                    return;
                }
                OSCmdUtils.explorerFile((String)url);
            }
            catch (Exception ex) {
                ToolLoggerFactory.getLogger(this.getClass()).error("open the file failed", (Throwable)ex);
            }
        }
    }

    private Box getBox(JComponent boxfor, JLabel desc) {
        return UCD.buildHBoxLeft((Component[])new Component[]{boxfor, desc, Box.createHorizontalStrut(12)});
    }

    public Box buildBox(JComponent boxfor, JComponent component) {
        Box boxarea = Box.createVerticalBox();
        boxarea.add(UCD.buildHBoxLeft((Component[])new Component[]{boxfor}));
        boxarea.add(Box.createVerticalStrut(8));
        boxarea.add(UCD.buildHBoxLeft((Component[])new Component[]{component, Box.createHorizontalStrut(0)}));
        return boxarea;
    }

    private Box verticalLayOutBox(List<Box> boxList1) {
        Box box = Box.createVerticalBox();
        for (Box singleBox : boxList1) {
            box.add(singleBox);
            box.add(Box.createVerticalStrut(6));
        }
        return box;
    }

    public void setCompName() {
        this.dateLabel.setName("date_label");
        this.startDateLabel.setName("start_date_label");
        this.problemDescriptionLabel.setName("problem_description_label");
        this.descriptionContentLabel.setName("description_content_label");
        this.rootCauseLabel.setName("root_cause_label");
        this.rootCausePane.setName("root_cause_pane");
        this.advicedActionLabel.setName("adviced_action_label");
        this.advicedActionPane.setName("adviced_action_pane");
        this.logDetailsLabel.setName("log_details_label");
        this.logDetailsPane.setName("log_details_pane");
        this.logDetailScroll.setName("log_details_scroll");
        this.jcb.setName("fault_tree_ui_jcombobox");
    }

    private Dimension getScreenMaxSize() {
        Dimension location = Toolkit.getDefaultToolkit().getScreenSize();
        return new Dimension(location.width, location.height - 40);
    }

    private void initListener() {
        WindowCloser wc = new WindowCloser();
        wc.setFtrc(this);
        this.addWindowListener(wc);
        this.jcb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (1 == e.getStateChange()) {
                    FaultTreeRootCauseDialog.this.refreshLeftAreaTree();
                }
            }
        });
        this.jcb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FaultTreeRootCauseDialog.this.jcb.setFocusable(false);
            }
        });
    }

    private void refreshLeftAreaTree() {
        if (ResourceUtil.getString((String)"info.analyze.faultTree.ui.jcombobox.found").equals(this.jcb.getSelectedItem().toString())) {
            FaultTree faultTreeMatched = this.detailFaultTree.getFaultTreeMatched();
            this.changeTree(faultTreeMatched);
        } else if (ResourceUtil.getString((String)"info.analyze.faultTree.ui.jcombobox.version").equals(this.jcb.getSelectedItem().toString())) {
            FaultTree versionTreeMatched = this.detailFaultTree.getVersionFaultTree();
            this.changeTree(versionTreeMatched);
        } else {
            FaultTree faultTree1 = this.detailFaultTree.getFaultTree();
            this.changeTree(faultTree1);
        }
        this.repaint();
    }

    private void changeTree(FaultTree faultTree1) {
        this.refreshLeftTree(this.detailFaultTree.getFaultTreeComponent(faultTree1));
        FaultTreeNode node = (FaultTreeNode)faultTree1.getLastSelectedPathComponent();
        if (node == null) {
            DefaultMutableTreeNode defaultMutableTreeNode = faultTree1.getRootNode().getFirstLeaf();
            if (defaultMutableTreeNode instanceof FaultTreeNode) {
                node = (FaultTreeNode)defaultMutableTreeNode;
                this.refreshDataByNode(faultTree1, node);
            }
        } else {
            this.refreshDataByNode(faultTree1, node);
        }
    }

    private void refreshDataByNode(FaultTree tree, FaultTreeNode node) {
        TreeNodeData data = (TreeNodeData)node.getUserObject();
        if (this.isPhenoNode(data, tree.getRootNode())) {
            if (node.getChildCount() > 0) {
                DefaultMutableTreeNode defaultMutableTreeNode = node.getFirstLeaf();
                if (defaultMutableTreeNode instanceof FaultTreeNode) {
                    node = (FaultTreeNode)defaultMutableTreeNode;
                    data = (TreeNodeData)node.getUserObject();
                    this.refreshData(this.detailFaultTree.getLogRow(), data.getId(), data.getCauseGroupId());
                }
            } else {
                this.refreshBlankData();
            }
        } else {
            this.refreshData(this.detailFaultTree.getLogRow(), data.getId(), data.getCauseGroupId());
        }
    }

    private boolean isPhenoNode(TreeNodeData leafNode, FaultTreeNode rootNode) {
        FaultTreeNode node = (FaultTreeNode)new TreePath(rootNode).getLastPathComponent();
        if (node.getChildCount() > 0) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                FaultTreeNode n = (FaultTreeNode)e.nextElement();
                FaultTreeNode subNode = (FaultTreeNode)new TreePath(n).getLastPathComponent();
                if (subNode.getChildCount() == 0) continue;
                Enumeration<TreeNode> en = subNode.children();
                while (en.hasMoreElements()) {
                    FaultTreeNode nn = (FaultTreeNode)en.nextElement();
                    TreeNodeData rootNodeData = (TreeNodeData)nn.getUserObject();
                    if (!leafNode.getId().equals(rootNodeData.getId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static class WindowCloser
    extends WindowAdapter {
        private FaultTreeRootCauseDialog ftrc;

        public FaultTreeRootCauseDialog getFtrc() {
            return this.ftrc;
        }

        public void setFtrc(FaultTreeRootCauseDialog ftrc) {
            this.ftrc = ftrc;
        }

        @Override
        public void windowClosed(WindowEvent paramWindowEvent) {
            this.ftrc.logDetailsPane.releaseResources();
            MainLogAnaDialog.getInstance().setVisible(true);
            this.ftrc.faultTree.setSelectionPath(null);
        }
    }
}

