/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.ui.faultuitree;

import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.RecordInfo;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class LogDetailPanel
extends JComponent {
    private static final long serialVersionUID = 8667123517179023847L;
    private static final Font COURIER_NEW_FONT = new Font("\u5b8b\u4f53", 0, 13);
    private static int rowhight = 14;
    private static final int DEFALT_ROWCOUNT = 25;
    private static int divisor = 30;
    private Box logDetailPanelBox = Box.createVerticalBox();
    private String causeId = "";

    public LogDetailPanel() {
        this.setLayout(new BorderLayout());
        this.add(this.logDetailPanelBox);
    }

    public void refreshLogDetail(List<RecordInfo> recordInfoAll, String cauId) {
        if (cauId.equals(this.causeId)) {
            return;
        }
        this.causeId = cauId;
        this.logDetailPanelBox.removeAll();
        Map<File, StringBuilder> logDetailMap = this.dealLogDetail(recordInfoAll);
        int rowCount = 0;
        for (Map.Entry<File, StringBuilder> entry : logDetailMap.entrySet()) {
            JEditorPane editorPane = this.getEditorPane();
            editorPane.setText(this.getLogsString(entry.getKey()));
            JTextArea contentArea = new JTextArea();
            contentArea.setFont(COURIER_NEW_FONT);
            String content = entry.getValue().toString();
            content = content.replace("&gt;", ">").replace("&lt;", "<");
            contentArea.setText(content);
            contentArea.setEditable(false);
            rowCount += contentArea.getLineCount();
            JSplitPane jsp = this.commonJSplitPan(1, 250);
            JSplitPane jspBottom = this.commonJSplitPan(0, 11);
            JPanel label = new JPanel();
            label.setBackground(Color.WHITE);
            jspBottom.setTopComponent(label);
            jspBottom.setBottomComponent(contentArea);
            jsp.setLeftComponent(editorPane);
            jsp.setRightComponent(jspBottom);
            this.logDetailPanelBox.add(UCD.buildHBoxLeft((Component[])new Component[]{jsp}));
            jsp.repaint();
        }
        this.addBlankPanel(rowCount);
        this.repaint();
    }

    private void addBlankPanel(int rowCount) {
        if (rowCount < 25) {
            int hight = (25 - rowCount) * rowhight;
            JPanel jpanel = new JPanel();
            jpanel.setPreferredSize(new Dimension(250, hight));
            jpanel.setMaximumSize(new Dimension(250, hight));
            jpanel.setMinimumSize(new Dimension(250, hight));
            jpanel.setBackground(Color.WHITE);
            this.logDetailPanelBox.add(jpanel);
        }
    }

    public void releaseResources() {
        this.logDetailPanelBox.removeAll();
    }

    public void clearData() {
        this.releaseResources();
        this.causeId = "";
        JTextArea contentArea = new JTextArea(" NA");
        contentArea.setEditable(false);
        this.logDetailPanelBox.add(contentArea);
    }

    private JSplitPane commonJSplitPan(int newOrientation, int divederSize) {
        JSplitPane splitPaneLeft = new JSplitPane(newOrientation, true);
        splitPaneLeft.setBackground(Color.WHITE);
        splitPaneLeft.setBorder(BorderFactory.createEmptyBorder());
        splitPaneLeft.setDividerSize(0);
        splitPaneLeft.setDividerLocation(divederSize);
        splitPaneLeft.setEnabled(false);
        return splitPaneLeft;
    }

    private JEditorPane getEditorPane() {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setPreferredSize(new Dimension(250, 50));
        editorPane.setMaximumSize(new Dimension(250, 50));
        editorPane.setMinimumSize(new Dimension(250, 50));
        editorPane.setEditable(false);
        editorPane.setFocusable(true);
        HTMLEditorKit kit = new HTMLEditorKit();
        editorPane.setEditorKit(kit);
        StyleSheet styleSheet = kit.getStyleSheet();
        styleSheet.addRule("table td{font-size: 11px}");
        editorPane.setContentType("text/html;charset=\"UTF-8\"");
        editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                LogDetailPanel.this.doLogDetailsHyperLinkEvent(e);
            }
        });
        return editorPane;
    }

    private void doLogDetailsHyperLinkEvent(HyperlinkEvent e) {
        if (HyperlinkEvent.EventType.ACTIVATED == e.getEventType()) {
            try {
                String url = e.getDescription();
                ToolLoggerFactory.getLogger(this.getClass()).debug("open url : " + url);
                OSCmdUtils.explorerFile((String)url);
            }
            catch (Exception ex) {
                ToolLoggerFactory.getLogger(this.getClass()).error("open the file failed", (Throwable)ex);
            }
        }
    }

    private Map<File, StringBuilder> dealLogDetail(List<RecordInfo> recordInfoAll) {
        HashMap<File, StringBuilder> logDetailMap = new HashMap<File, StringBuilder>();
        for (RecordInfo recordInfo : recordInfoAll) {
            StringBuilder recordInfoTotol = (StringBuilder)logDetailMap.get(new File(recordInfo.getFilePath()));
            if (recordInfoTotol == null) {
                if (recordInfo.getContent() == null || StringUtils.isNULLStr((String)recordInfo.getContent().toString().trim())) continue;
                recordInfoTotol = new StringBuilder();
                recordInfoTotol.append(recordInfo.getContent() + "\n");
                logDetailMap.put(new File(recordInfo.getFilePath()), recordInfoTotol);
                continue;
            }
            recordInfoTotol.append(recordInfo.getContent() + "\n");
        }
        return logDetailMap;
    }

    private String getLogsString(File recordInfo) {
        StringBuffer sb = new StringBuffer();
        sb.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n").append("</head>\n<body>\n");
        sb.append("<table>");
        sb.append("<tr>");
        sb.append("<td nowrap>");
        sb.append("<a href=\"" + recordInfo.getAbsolutePath() + "\" target=\"new\">");
        sb.append(this.hyperlinkLineFeed(recordInfo.getName()));
        sb.append("</a>");
        sb.append("</td>");
        sb.append("<td nowrap>");
        sb.append("</td>");
        sb.append("</table>");
        sb.append("</body>");
        sb.append("</html>");
        return sb.toString();
    }

    private String hyperlinkLineFeed(String fileLength) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNULLStr((String)fileLength)) {
            return "";
        }
        int count = fileLength.length() / divisor;
        int temp = 0;
        if (count > 0) {
            int i = 0;
            while (i < fileLength.length() / divisor) {
                sb.append(fileLength.substring(temp, temp += divisor));
                sb.append("<br/>");
                ++i;
            }
            sb.append(fileLength.substring(fileLength.length() - fileLength.length() % divisor, fileLength.length()));
        } else {
            sb.append(fileLength);
        }
        return sb.toString();
    }

    public Box getLogDetailPanelBox() {
        return this.logDetailPanelBox;
    }

    public void setLogDetailPanelBox(Box logDetailPanelBox) {
        this.logDetailPanelBox = logDetailPanelBox;
    }
}

