/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.ui.faultuitree;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.loganalyzer.entity.AnalyzeUserOpData;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogRow;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.cause.Cause;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.cause.CauseGroup;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.cause.CauseGroupList;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.pheno.FaultType;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.pheno.Pheno;
import com.huawei.ism.tool.loganalyzer.faulttree.model.DeviceType;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.CauseMatchResult;
import com.huawei.ism.tool.loganalyzer.logic.AnalyzeUserOpService;
import com.huawei.ism.tool.loganalyzer.ui.faultuitree.DetailFaultTree;
import com.huawei.ism.tool.loganalyzer.ui.faultuitree.FaultTree;
import com.huawei.ism.tool.loganalyzer.ui.faultuitree.FaultTreeCellRenderer;
import com.huawei.ism.tool.loganalyzer.ui.faultuitree.FaultTreeNode;
import com.huawei.ism.tool.loganalyzer.ui.faultuitree.FaultTreeProgressBar;
import com.huawei.ism.tool.loganalyzer.ui.faultuitree.FaultTreeRootCauseDialog;
import com.huawei.ism.tool.loganalyzer.ui.faultuitree.TreeNodeData;
import com.huawei.ism.tool.loganalyzer.ui.main.MainLogAnaDialog;
import com.huawei.ism.tool.loganalyzer.util.SearcherUtils;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainFaultTree
extends JComponent {
    private static final int NUMBER_932 = 932;
    private static final long serialVersionUID = -1641729093628337005L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MainFaultTree.class);
    private static final String UI_FAULT_TREE = "faultTree";
    private static final String KEY_HOUR = "hour";
    private static final String KEY_MINUTE = "minute";
    private static final String KEY_SECOND = "second";
    public DeviceType type;
    public transient Map<String, TreeNodeData> phenoDataMap = new HashMap<String, TreeNodeData>(10);
    private transient FaultTreeProgressBar faultTreeProgressBar;
    private transient Map<String, CauseMatchResult> causeMatchResultMap = new HashMap<String, CauseMatchResult>();
    private transient LogRow row;
    private FaultTree faultTree;
    private CardLayout faultTreeLayout = new CardLayout();
    private JPanel faultTreePanel = new JPanel();

    public MainFaultTree() {
        this.initUI();
    }

    public void refreshFaultTree(LogRow lr) {
        this.row = lr;
        DeviceType tp = DeviceType.type(lr.getType());
        lr.setDeviceType(tp);
        this.type = lr.getDeviceType();
        if (this.causeMatchResultMap.size() != 0) {
            this.causeMatchResultMap.clear();
        }
        this.row.setCauseMatchResultMap(this.causeMatchResultMap);
        try {
            this.init();
            this.initFaultTree();
            this.faultTreeLayout.show(this.faultTreePanel, UI_FAULT_TREE);
            this.setComponentName();
        }
        catch (Exception e) {
            LOGGER.error("refresh fault tree failed!" + e);
        }
    }

    private void setComponentName() {
        this.faultTree.setName("pheno_tree_mainpage");
    }

    public void showProcess() {
        this.faultTreeLayout.show(this.faultTreePanel, "progressBar");
    }

    public void showDefaultPanel() {
        this.faultTreeLayout.show(this.faultTreePanel, "defaultPanel");
    }

    private void init() {
        try {
            this.phenoDataMap.clear();
            for (CauseGroupList groupList : this.type.causeGroupCache().getCauseGroupLists()) {
                for (CauseGroup causeGroup : groupList.getCauseGroupList()) {
                    this.initPhenoDataMap(groupList, causeGroup);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("init root cause matched number error!");
        }
    }

    private void initPhenoDataMap(CauseGroupList groupList, CauseGroup causeGroup) {
        for (Cause cause : causeGroup.getCauseList()) {
            CauseMatchResult causeMatchResult = this.row.getCauseMatchResultMap().get(cause.getId());
            if (causeMatchResult == null) continue;
            TreeNodeData treeNodeData = this.phenoDataMap.get(groupList.getPheno().getId());
            if (treeNodeData == null) {
                treeNodeData = new TreeNodeData(groupList.getPheno().getId(), this.type, false);
                this.phenoDataMap.put(groupList.getPheno().getId(), treeNodeData);
            }
            if (causeMatchResult.getDateInfo() == null) {
                treeNodeData.addMatchNum();
                continue;
            }
            if (!SearcherUtils.isOnSetDate(causeMatchResult.getDateInfo().getTime())) continue;
            treeNodeData.addMatchNum();
        }
    }

    private JComponent layoutFaultTreePanel() {
        try {
            this.faultTreePanel.setLayout(this.faultTreeLayout);
            this.faultTreePanel.add((Component)this.getDefaultComponent(), "defaultPanel");
            FaultTreeProgressBar pbr = new FaultTreeProgressBar();
            this.setFaultTreeProgressBar(pbr);
            this.faultTreePanel.add((Component)pbr.initUI(this.faultTreePanel), "progressBar");
            this.faultTreePanel.setBorder(BorderFactory.createEmptyBorder());
            this.faultTreePanel.setPreferredSize(new Dimension(950, 160));
            this.faultTreePanel.setMinimumSize(new Dimension(500, 200));
        }
        catch (Exception e) {
            LOGGER.error("init Layout Fault Tree Panel error!");
        }
        return this.faultTreePanel;
    }

    private JComponent getDefaultComponent() {
        JPanel defaultPanel = new JPanel();
        defaultPanel.setBackground(Color.WHITE);
        return defaultPanel;
    }

    private JComponent createfaultTreeComp() {
        JSplitPane splitPane = new JSplitPane(0, true);
        splitPane.setDividerSize(1);
        splitPane.setDividerLocation(35);
        splitPane.setEnabled(false);
        JScrollPane faultTreeScrolPane = new JScrollPane(this.faultTree);
        faultTreeScrolPane.setBorder(BorderFactory.createEmptyBorder());
        faultTreeScrolPane.setPreferredSize(new Dimension(950, 160));
        splitPane.add(this.getMatchedTotalNumPane());
        splitPane.add(faultTreeScrolPane);
        return splitPane;
    }

    private void initFaultTree() {
        FaultTreeNode faultTreeNodeFather = new FaultTreeNode(new TreeNodeData("root", true, ""), true, false, true);
        for (FaultType faultType : this.type.faultTypeCache().getList()) {
            faultTreeNodeFather.add(this.getPhenomenonGroupNode(faultType));
        }
        this.faultTree = new FaultTree(faultTreeNodeFather, true, null, false);
        this.faultTree.setMaximumSize(new Dimension(1600, 500));
        this.faultTree.setSize(new Dimension(932, 500));
        this.faultTree.setMinimumSize(new Dimension(700, 500));
        FaultTreeCellRenderer faultTreeCellRenderer = new FaultTreeCellRenderer(false, true);
        this.faultTree.setCellRenderer(faultTreeCellRenderer);
        this.faultTree.setShowsRootHandles(true);
        this.faultTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath treepath = e.getNewLeadSelectionPath();
                if (treepath == null) {
                    return;
                }
                FaultTreeNode node = (FaultTreeNode)MainFaultTree.this.faultTree.getLastSelectedPathComponent();
                if (e.getSource() == MainFaultTree.this.faultTree && node != null && node.isLeaf()) {
                    MainFaultTree.this.clickLeafNode(node, treepath);
                }
            }
        });
        this.faultTreePanel.add((Component)this.createfaultTreeComp(), UI_FAULT_TREE);
        this.repaint();
    }

    public void clickLeafNode(FaultTreeNode node, TreePath treepath) {
        TreeNodeData phenoNodeData = (TreeNodeData)node.getUserObject();
        final String phenoId = phenoNodeData.getId();
        final FaultTreeNode node1 = node;
        AsyncExcutor.execute((Window)((Object)MainLogAnaDialog.getInstance()), (Callable[])new Callable[]{new Callable<Object>(){

            @Override
            public Object call() {
                DetailFaultTree detailFaultTree = new DetailFaultTree(MainFaultTree.this.row, node1);
                MainFaultTree.this.highLightFaultTree(detailFaultTree, node1);
                FaultTreeRootCauseDialog causeAnalysisDialog = new FaultTreeRootCauseDialog(MainFaultTree.this.faultTree, detailFaultTree, phenoId);
                detailFaultTree.setCauseAnalysisDialog(causeAnalysisDialog);
                detailFaultTree.refreshCauseDetail(node1);
                causeAnalysisDialog.setVisible(true);
                return true;
            }
        }});
        AnalyzeUserOpData userOpData = AnalyzeUserOpService.getLogPackageUserOpData(this.row);
        userOpData.increMatchCauseClickNum();
        MainLogAnaDialog.getInstance().setVisible(false);
    }

    private void highLightFaultTree(DetailFaultTree detailFaultTree, FaultTreeNode node) {
        TreeNodeData phenoNodeData = (TreeNodeData)node.getUserObject();
        String phenoId = phenoNodeData.getId();
        detailFaultTree.setSelectNode(detailFaultTree.getFaultTree(), new TreePath(detailFaultTree.getFaultTree().getRootNode()), phenoId);
        detailFaultTree.setSelectNode(detailFaultTree.getVersionFaultTree(), new TreePath(detailFaultTree.getVersionFaultTree().getRootNode()), phenoId);
        if (detailFaultTree.getFaultTreeMatched().getRootNode().getFirstLeaf() != detailFaultTree.getFaultTreeMatched().getRootNode()) {
            if (phenoNodeData.getMatchNum() == 0) {
                FaultTreeNode matchedTreeNode = (FaultTreeNode)detailFaultTree.getFaultTreeMatched().getRootNode().getFirstLeaf().getParent();
                TreeNodeData matchedTreeNodeData = (TreeNodeData)matchedTreeNode.getUserObject();
                phenoId = matchedTreeNodeData.getId();
            }
            detailFaultTree.setSelectNode(detailFaultTree.getFaultTreeMatched(), new TreePath(detailFaultTree.getFaultTreeMatched().getRootNode()), phenoId);
        }
    }

    public FaultTreeNode getPhenomenonGroupNode(FaultType faultType) {
        TreeNodeData pMr = new TreeNodeData(faultType.getId(), this.type, false);
        pMr.setIsMatched(this.getIsMatched(faultType.getPhenoList()));
        FaultTreeNode phenomenonGroupNode = new FaultTreeNode(pMr, true);
        try {
            for (Pheno p : faultType.getPhenoList()) {
                TreeNodeData treeNodeData = this.phenoDataMap.get(p.getId());
                treeNodeData = treeNodeData == null ? new TreeNodeData(p.getId(), this.type, false) : treeNodeData;
                phenomenonGroupNode.add(new FaultTreeNode(treeNodeData, true));
            }
        }
        catch (Exception e) {
            LOGGER.error("obtain Phenomenon data node error !");
        }
        return phenomenonGroupNode;
    }

    public Boolean getIsMatched(List<Pheno> phenoList) {
        for (Pheno p : phenoList) {
            TreeNodeData treeNodeData = this.phenoDataMap.get(p.getId());
            if (treeNodeData == null || treeNodeData.getMatchNum() <= 0) continue;
            return true;
        }
        return false;
    }

    public void initUI() {
        this.setLayout(new BorderLayout());
        this.add(UCD.buildHorizotalBox(null, (int)5, (Component[])new Component[]{Box.createHorizontalStrut(5), this.layoutFaultTreePanel()}));
    }

    private JSplitPane getMatchedTotalNumPane() {
        JLabel analyseLabel = new JLabel();
        analyseLabel.setText(ResourceUtil.getString((String)"info.analyze.faultTree.ui.analyzeOverInfo"));
        analyseLabel.setFont(new Font("Dialog", 0, 15));
        JLabel problemNumLabel = new JLabel();
        problemNumLabel.setText(this.getTotalProblemNum());
        problemNumLabel.setForeground(Color.red);
        problemNumLabel.setFont(new Font("Dialog", 1, 15));
        JLabel problemLabel = new JLabel();
        problemLabel.setText(ResourceUtil.getString((String)"info.analyze.faultTree.ui.problemInfo"));
        problemLabel.setFont(new Font("Dialog", 0, 15));
        JSplitPane matchedTotalNumPane = new JSplitPane(1, true);
        matchedTotalNumPane.setBackground(Color.WHITE);
        matchedTotalNumPane.setEnabled(true);
        matchedTotalNumPane.setDividerSize(0);
        matchedTotalNumPane.setDividerLocation(400);
        Box area = UCD.buildHBoxLeft((int)5, (Component[])new Component[]{analyseLabel, problemNumLabel, problemLabel});
        JComponent rightPanel = this.getRightPanel(this.getSpendTime());
        matchedTotalNumPane.setBorder(BorderFactory.createEmptyBorder());
        matchedTotalNumPane.add(area);
        matchedTotalNumPane.add(rightPanel);
        this.setTotalNumPaneName(analyseLabel, problemNumLabel, problemLabel);
        return matchedTotalNumPane;
    }

    private void setTotalNumPaneName(JLabel analyseLabel, JLabel problemNumLabel, JLabel problemLabel) {
        analyseLabel.setName("analyze_over_label");
        problemNumLabel.setName("problem_num_label");
        problemLabel.setName("problem_label");
    }

    private long getSpendTime() {
        long spendTime = 0L;
        try {
            spendTime = (this.row.getSearchProgress().getEndTime() - this.row.getSearchProgress().getStartTime()) / 1000L;
        }
        catch (Exception e) {
            LOGGER.error("compute spend time error!");
        }
        return spendTime;
    }

    private JComponent getRightPanel(long spendTime) {
        Map<String, Long> spendTimeMap = this.convertSpendTime(spendTime);
        JLabel consumeTimePanel = new JLabel();
        consumeTimePanel.setName("analyze_spend_time");
        String consumeTimePanelText = ResourceUtil.getString((String)"info.analyze.faultTree.ui.analyzeSpendTime");
        consumeTimePanel.setText(consumeTimePanelText);
        consumeTimePanel.setFont(new Font("Dialog", 0, 15));
        if (LanguageManager.getInstance().getCurrentLanguage().getLanguage().equalsIgnoreCase("en")) {
            consumeTimePanel.setPreferredSize(new Dimension(consumeTimePanelText.length() * 9, 30));
        } else {
            consumeTimePanel.setPreferredSize(new Dimension(98, 30));
        }
        JLabel hourPanel = new JLabel();
        hourPanel.setName("hour_panel");
        hourPanel.setText(String.valueOf(spendTimeMap.get(KEY_HOUR)));
        this.setLabelStyle(hourPanel, true);
        JLabel hourTextPanel = new JLabel();
        hourTextPanel.setName("hour_text_panel");
        hourTextPanel.setText(ResourceUtil.getString((String)"info.analyze.faultTree.ui.hour"));
        this.setLabelStyle(hourTextPanel, false);
        JLabel minPanel = new JLabel();
        minPanel.setName("min_panel");
        minPanel.setText(String.valueOf(spendTimeMap.get(KEY_MINUTE)));
        this.setLabelStyle(minPanel, true);
        JLabel minTextPanel = new JLabel();
        minTextPanel.setName("min_text_panel");
        minTextPanel.setText(ResourceUtil.getString((String)"info.analyze.faultTree.ui.minute"));
        this.setLabelStyle(minTextPanel, false);
        JLabel secondPanel = new JLabel();
        secondPanel.setName("second_panel");
        secondPanel.setText(String.valueOf(spendTimeMap.get(KEY_SECOND)));
        this.setLabelStyle(secondPanel, true);
        JLabel secondTextPanel = new JLabel();
        secondTextPanel.setName("second_text_panel");
        secondTextPanel.setText(ResourceUtil.getString((String)"info.analyze.faultTree.ui.second"));
        this.setLabelStyle(secondTextPanel, false);
        Box area = null;
        area = spendTimeMap.get(KEY_HOUR) > 0L ? UCD.buildHBoxRight((int)5, (Component[])new Component[]{consumeTimePanel, hourPanel, hourTextPanel, minPanel, minTextPanel, secondPanel, secondTextPanel}) : (spendTimeMap.get(KEY_HOUR) == 0L && spendTimeMap.get(KEY_MINUTE) > 0L ? UCD.buildHBoxRight((int)5, (Component[])new Component[]{consumeTimePanel, minPanel, minTextPanel, secondPanel, secondTextPanel}) : UCD.buildHBoxRight((int)5, (Component[])new Component[]{consumeTimePanel, secondPanel, secondTextPanel}));
        return area;
    }

    private void setLabelStyle(JLabel destLabel, boolean needRedColor) {
        if (needRedColor) {
            destLabel.setFont(new Font("Dialog", 1, 15));
            destLabel.setForeground(Color.red);
        } else {
            destLabel.setFont(new Font("Dialog", 0, 15));
        }
    }

    private Map<String, Long> convertSpendTime(long spendTime) {
        HashMap<String, Long> spendTimeMap = new HashMap<String, Long>();
        if (spendTime > 0L) {
            long hour = spendTime / 3600L;
            long min = spendTime % 3600L / 60L;
            long scend = spendTime % 3600L % 60L;
            spendTimeMap.put(KEY_HOUR, hour);
            spendTimeMap.put(KEY_MINUTE, min);
            spendTimeMap.put(KEY_SECOND, scend);
        } else {
            spendTimeMap.put(KEY_HOUR, 0L);
            spendTimeMap.put(KEY_MINUTE, 0L);
            spendTimeMap.put(KEY_SECOND, 1L);
        }
        return spendTimeMap;
    }

    public String getTotalProblemNum() {
        int totalProblemNum = 0;
        try {
            for (TreeNodeData td : this.phenoDataMap.values()) {
                totalProblemNum += td.getMatchNum();
            }
        }
        catch (Exception e) {
            LOGGER.error("Compute Problem Number Error !");
        }
        return String.valueOf(totalProblemNum);
    }

    public void destroy() {
    }

    public FaultTreeProgressBar getFaultTreeProgressBar() {
        return this.faultTreeProgressBar;
    }

    public void setFaultTreeProgressBar(FaultTreeProgressBar faultTreeProgressBar) {
        this.faultTreeProgressBar = faultTreeProgressBar;
    }
}

