/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.ui.faultuitree;

import com.huawei.ism.tool.loganalyzer.faulttree.model.DeviceType;
import com.huawei.ism.tool.obase.utils.StringUtils;

public class TreeNodeData
implements Comparable<TreeNodeData> {
    private String id;
    private String causeGroupId;
    private String name;
    private int matchNum;
    private String detail;
    private Boolean isMatched;

    public TreeNodeData(String id, DeviceType type, boolean isCauseData) {
        if (isCauseData) {
            this.name = type.resourceCache().getIssue(id).getName();
            if (StringUtils.isNULLStr((String)this.name)) {
                this.name = id;
            }
            this.id = id;
        } else {
            this.name = type.resourceCache().getValue(String.valueOf(id) + ".name");
            if (StringUtils.isNULLStr((String)this.name)) {
                this.name = id;
            }
            this.id = id;
        }
    }

    public TreeNodeData(String id, String causeGroupId, DeviceType type, boolean isCauseData) {
        this(id, type, isCauseData);
        this.causeGroupId = causeGroupId;
    }

    public TreeNodeData(String name, Boolean isMatched, String detail) {
        this.name = name;
        this.isMatched = isMatched;
        this.detail = detail;
    }

    public int getMatchNum() {
        return this.matchNum;
    }

    public void addMatchNum() {
        ++this.matchNum;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public String toString() {
        return this.name;
    }

    public Boolean getIsMatched() {
        return this.isMatched;
    }

    public void setIsMatched(Boolean isMatched) {
        this.isMatched = isMatched;
    }

    public String getId() {
        return this.id;
    }

    public String getCauseGroupId() {
        return this.causeGroupId;
    }

    @Override
    public int compareTo(TreeNodeData o) {
        if (this.getIsMatched() != null && o.getIsMatched() != null) {
            int res = this.getIsMatched().compareTo(o.getIsMatched());
            if (res > 0) {
                return -1;
            }
            if (res == 0) {
                return 0;
            }
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

