/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.ui.listener;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.entity.AnalyzeUserOpData;
import com.huawei.ism.tool.loganalyzer.entity.analyze.AnalyzeResult;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogRow;
import com.huawei.ism.tool.loganalyzer.entity.config.SingleLogSearchRule;
import com.huawei.ism.tool.loganalyzer.entity.log.Log;
import com.huawei.ism.tool.loganalyzer.logic.AnalyzeUserOpService;
import com.huawei.ism.tool.loganalyzer.ui.ShowLogReadDialog;
import com.huawei.ism.tool.loganalyzer.ui.main.LogResultType;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;

public class ShowLogReadListener
implements ActionListener {
    private Map<SingleLogSearchRule, List<Log>> ruleLogResult = null;
    private JFrame frame = null;
    private AnalyzeResult result;
    private LogRow logRow;
    private LogResultType resultType;

    public ShowLogReadListener(JFrame frame, Map<SingleLogSearchRule, List<Log>> ruleLogResult, AnalyzeResult result, LogRow logRow) {
        this.frame = frame;
        this.ruleLogResult = ruleLogResult;
        this.result = result;
        this.logRow = logRow;
    }

    public ShowLogReadListener(JFrame frame, Map<SingleLogSearchRule, List<Log>> ruleLogResult, AnalyzeResult result, LogRow logRow, LogResultType resultType) {
        this.frame = frame;
        this.ruleLogResult = ruleLogResult;
        this.result = result;
        this.logRow = logRow;
        this.resultType = resultType;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AnalyzeUserOpData userOpData = AnalyzeUserOpService.getLogPackageUserOpData(this.logRow);
        switch (this.resultType) {
            case ALARM: {
                userOpData.increAlarmClickNum();
                break;
            }
            case DIAGNOSE: {
                userOpData.increDiagnoseClickNum();
                break;
            }
        }
        ToolLoggerFactory.getLogger(this.getClass()).debug("Operate : open ShowLogReadDialog");
        ShowLogReadDialog readDialog = new ShowLogReadDialog(this.frame, this.ruleLogResult, this.result);
        readDialog.setVisible(true);
    }
}

