/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.ui.main;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogRow;
import com.huawei.ism.tool.loganalyzer.exception.AnalyzingFailedException;
import com.huawei.ism.tool.loganalyzer.exception.AnalyzingStopedException;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.version.Version;
import com.huawei.ism.tool.loganalyzer.faulttree.model.DeviceType;
import com.huawei.ism.tool.loganalyzer.faulttree.model.SearchProgress;
import com.huawei.ism.tool.loganalyzer.logic.AnalyzeUserOpService;
import com.huawei.ism.tool.loganalyzer.monitor.enumer.AnalysisMode;
import com.huawei.ism.tool.loganalyzer.ui.main.MainLogAnaDialog;
import com.huawei.ism.tool.loganalyzer.util.LoganalyzerContext;
import com.huawei.ism.tool.loganalyzer.util.SearcherUtils;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;

public class DoLogAnalyze
extends Thread {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DoLogAnalyze.class);
    private List<LogRow> rows;

    public DoLogAnalyze(List<LogRow> rows) {
        this.rows = rows;
    }

    @Override
    public void run() {
        MainLogAnaDialog.getInstance().setAction(true);
        MainLogAnaDialog.getInstance().componentDisable();
        MainLogAnaDialog.getInstance().setFinish(false);
        this.execLogAnalyze();
        if (!AnalysisMode.isAutoAnalysisMode()) {
            MainLogAnaDialog.getInstance().layout.getStopButton().setEnabled(false);
        }
        MainLogAnaDialog.getInstance().setAction(false);
        MainLogAnaDialog.getInstance().componentEnable();
        MainLogAnaDialog.getInstance().setFinish(true);
    }

    private void execLogAnalyze() {
        boolean flag = false;
        for (LogRow row : this.rows) {
            try {
                if ((double)SearcherUtils.remainderMemory() < 80.0 && !flag) {
                    flag = true;
                    AnalysisMode.current().getStopAnalyzingInterface().outOfMemoryStop();
                    DialogUtils.showInfoDialog((Frame)((Object)MainLogAnaDialog.getInstance()), (String)ResourceUtil.getString((String)"info.analyze.stop.ramoverflow"));
                }
                if (this.findWriteStatus(row).booleanValue()) {
                    this.refreshComponent(row);
                    DialogUtils.showInfoDialog((Frame)((Object)MainLogAnaDialog.getInstance()), (String)ResourceUtil.getString((String)"info.analyze.check.message.empty"));
                    this.revert(row);
                    continue;
                }
                AnalyzeUserOpService.preAnalyzeRecord(row);
                MainLogAnaDialog.getInstance().setRow(row);
                row.setSearchProgress(new SearchProgress());
                row.getSearchProgress().setInfo(ResourceUtil.getString((String)"info.analyze.faultTree.progress.createsort"));
                MainLogAnaDialog.getInstance().layout.getMainFaultTree().getFaultTreeProgressBar().setProgress(row.getSearchProgress());
                this.doLogAnalyzing(row);
                row.setStauts("info.nanlyze.tabel.type.done");
                MainLogAnaDialog.getInstance().layout.getSearchedProTableModel().addRows(row.getDetailList());
                row.analyzeInterruptedFromStopCommand();
                AnalyzeUserOpService.afterAnalyzeRecord(row);
                SearcherUtils.doRefreshFaultTreeArea(MainLogAnaDialog.getInstance(), row);
                row.getRow().setValueAt(3, (Object)ResourceUtil.getString((String)"info.nanlyze.tabel.type.done"));
                this.revert(row);
                MainLogAnaDialog.getInstance().refreshScanReportBtn(row);
            }
            catch (AnalyzingStopedException e) {
                row.waitStopThreadFinish();
                AnalyzeUserOpService.stopAnalyzeRecord(row);
                this.handleStopCase(row);
                this.refreshStatus(row);
                LOGGER.info("The analyze log is stopped success : " + e.getMessage(), (Throwable)e);
            }
            catch (AnalyzingFailedException e) {
                this.doAnalyzedFailed(row, e);
            }
            catch (Exception e) {
                AnalyzeUserOpService.failedAnalyzeRecord(row);
                this.doOtherAnalyzedFailed(row, e);
            }
        }
        MainLogAnaDialog.getInstance().refreshDetailList(MainLogAnaDialog.getInstance().isAction() || MainLogAnaDialog.getInstance().isFinish());
    }

    private void refreshStatus(LogRow row) {
        row.getRow().setValueAt(3, (Object)ResourceUtil.getString((String)"info.nanlyze.tabel.type.stopped"));
        row.setStauts("info.nanlyze.tabel.type.stopped");
    }

    private void doOtherAnalyzedFailed(LogRow row, Throwable e) {
        row.getRow().setValueAt(3, (Object)ResourceUtil.getString((String)"info.nanlyze.tabel.type.faild"));
        LOGGER.error("Analyzing the log package occors an error ", e);
        if (!AnalysisMode.isAutoAnalysisMode()) {
            DialogUtils.showInfoDialog((Frame)((Object)MainLogAnaDialog.getInstance()), (String)ResourceUtil.getString((String)"info.nanlyze.doing.error"));
            SearcherUtils.doRefreshDefaultArea(MainLogAnaDialog.getInstance());
        }
        this.deleteIndexDir(row);
    }

    private void doAnalyzedFailed(LogRow row, AnalyzingFailedException e) {
        row.getRow().setValueAt(3, (Object)ResourceUtil.getString((String)"info.nanlyze.tabel.type.faild"));
        row.setStauts("info.nanlyze.tabel.type.faild");
        LOGGER.error("analyze log " + row.getLogFile() + "failed.", (Throwable)e);
        if (!AnalysisMode.isAutoAnalysisMode()) {
            DialogUtils.showInfoDialog((Frame)((Object)MainLogAnaDialog.getInstance()), (String)ResourceUtil.getString((String)e.getErrorSourceID()));
            SearcherUtils.doRefreshDefaultArea(MainLogAnaDialog.getInstance());
        }
        this.deleteIndexDir(row);
        AnalyzeUserOpService.failedAnalyzeRecord(row);
    }

    private void deleteIndexDir(LogRow row) {
        if (!StringUtils.isNULLStr((String)row.getIndexDir())) {
            SearcherUtils.deleteTempFile(new File(row.getIndexDir()));
        }
    }

    private void doLogAnalyzing(LogRow row) throws ToolException, IOException {
        row.setAnalyzeStartTime(System.currentTimeMillis());
        row.analyzeInterruptedFromStopCommand();
        this.deleteAndUpdateReportTmpDir(row);
        new LogAnalyzeQueryCallable(row).call();
        row.analyzeInterruptedFromStopCommand();
    }

    private void deleteAndUpdateReportTmpDir(LogRow row) {
        if (!StringUtils.isNULLStr((String)row.getReportTmpFile())) {
            FileUtils.deleteFile((File)new File(row.getReportTmpFile()));
        }
        if (!new File(row.getReportTmpFile()).mkdirs()) {
            LOGGER.error("create dir fail:" + row.getReportTmpFile());
        }
    }

    private Boolean findWriteStatus(LogRow row) {
        Boolean flag = (Boolean)LoganalyzerContext.getInstance().getWriteVersionMap().get(row.getLogFile().getAbsolutePath());
        if (flag != null && flag.booleanValue() && StringUtils.isNULLStr((String)row.getVersion())) {
            return true;
        }
        return false;
    }

    private void refreshComponent(LogRow row) {
        row.getRow().setValueAt(3, (Object)ResourceUtil.getString((String)"info.nanlyze.tabel.type.before"));
        row.setStauts("info.nanlyze.tabel.type.before");
        if (!AnalysisMode.isAutoAnalysisMode()) {
            MainLogAnaDialog.getInstance().layout.getStopButton().setEnabled(false);
        }
        MainLogAnaDialog.getInstance().setAction(false);
        MainLogAnaDialog.getInstance().componentEnable();
        MainLogAnaDialog.getInstance().setFinish(true);
    }

    private void handleStopCase(LogRow row) {
        FileAssistant.clearDir((String)row.getIndexDir());
        this.revert(row);
        MainLogAnaDialog.getInstance().refreshScanReportBtn(row);
    }

    private void revert(LogRow row) {
        TableRow tableRow = row.getRow();
        String writeVersion = row.getVersion();
        if (row.isTypeGetByCell()) {
            List<String> items = MainLogAnaDialog.getInstance().layout.getComboBoxItems();
            IsmTableCell.ComboBoxCell cell = new IsmTableCell.ComboBoxCell(items.toArray(), (Object)items.get(items.indexOf(row.getType())));
            tableRow.setValueAt(1, (Object)cell);
            ArrayList versions = new ArrayList();
            ArrayList<String> vList = new ArrayList<String>();
            List<Version> versionList = DeviceType.getModel(row.getType()).getVersionList();
            for (Version version : versionList) {
                vList.add(version.getValue());
            }
            versions.addAll(vList);
            IsmTableCell.ComboBoxCell verCell = new IsmTableCell.ComboBoxCell(versions.toArray(), versions.get(versions.indexOf(versions.get(0))));
            verCell.getComboBox().setEditable(true);
            IsmTableCell.ComboBoxCell writeVersionCell = new IsmTableCell.ComboBoxCell(versions.toArray(), (Object)writeVersion);
            writeVersionCell.getComboBox().setEditable(true);
            SearcherUtils.linkage(cell.getComboBox(), verCell, (TableRow<Integer, Long>)tableRow, 0);
            tableRow.setValueAt(2, (Object)writeVersionCell);
        }
    }

    public static final class LogAnalyzeQueryCallable
    implements Callable<Object> {
        private LogRow row;

        public LogAnalyzeQueryCallable(LogRow row) {
            this.row = row;
        }

        @Override
        public Object call() throws ToolException, IOException {
            TableRow tableRow = this.row.getRow();
            this.printLog((TableRow<Integer, File>)tableRow);
            this.initEvn();
            MainLogAnaDialog.getInstance().doAnalyzeOperation(this.row);
            if (this.row.isResultNotEmpty()) {
                MainLogAnaDialog.getInstance().setCreateReport(this.row);
            }
            this.row.getSearchProgress().setInfo(ResourceUtil.getString((String)"info.analyze.faultTree.progress.buildreport"));
            MainLogAnaDialog.getInstance().layout.getMainFaultTree().getFaultTreeProgressBar().setProgress(this.row.getSearchProgress());
            MainLogAnaDialog.getInstance().exportReport(this.row);
            this.row.getSearchProgress().setEndTime(System.currentTimeMillis());
            this.row.getSearchProgress().add(5);
            MainLogAnaDialog.getInstance().layout.getMainFaultTree().getFaultTreeProgressBar().setProgress(this.row.getSearchProgress());
            SearcherUtils.doRefreshFaultTreeArea(MainLogAnaDialog.getInstance(), this.row);
            return true;
        }

        private void printLog(TableRow<Integer, File> tableRow) {
            LOGGER.debug(tableRow.getValueAt(0) + " device type is " + tableRow.getValueAt(1));
            LOGGER.debug(tableRow.getValueAt(0) + " device version is " + tableRow.getValueAt(2));
        }

        private void initEvn() {
            MainLogAnaDialog.getInstance().setLoading(this.row);
            MainLogAnaDialog.getInstance().clearData(this.row);
            MainLogAnaDialog.getInstance().refreshScanReportBtn(this.row);
            MainLogAnaDialog.getInstance().deleteTmp(this.row);
        }

        public LogRow getRow() {
            return this.row;
        }

        public void setRow(LogRow row) {
            this.row = row;
        }
    }
}

