/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.ui.main;

import com.huawei.ism.tool.base.ui.task.TaskResult;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.WorktakerUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.entity.analyze.ConfigInfoEntry;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogRow;
import com.huawei.ism.tool.loganalyzer.entity.log.LogDeCompressDir;
import com.huawei.ism.tool.loganalyzer.exception.StopImportException;
import com.huawei.ism.tool.loganalyzer.faulttree.decompress.threadpool.DiskIsEnoughThread;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.DiskNotEnoughException;
import com.huawei.ism.tool.loganalyzer.faulttree.util.FileUtil;
import com.huawei.ism.tool.loganalyzer.faulttree.versionsearch.ProductInfo;
import com.huawei.ism.tool.loganalyzer.logic.logsearcher.SoftHardwareConfiginfoSearch;
import com.huawei.ism.tool.loganalyzer.ui.main.MainLogAnaDialog;
import com.huawei.ism.tool.loganalyzer.ui.main.MainLogAnaLayout;
import com.huawei.ism.tool.loganalyzer.util.LoganalyzerContext;
import com.huawei.ism.tool.loganalyzer.util.SearchConstant;
import com.huawei.ism.tool.loganalyzer.util.SearcherUtils;
import com.huawei.ism.tool.loganalyzer.worktaker.IDeCompressPkgWorktaker;
import com.huawei.ism.tool.obase.filechooser.HibernateContainer;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public class DoLogPackage {
    private LogRow logRow;
    private TaskResult taskResult;
    private MainLogAnaLayout layout;

    public DoLogPackage(LogRow rows) {
        this.layout = MainLogAnaDialog.getInstance().layout;
        this.logRow = rows;
    }

    public TaskResult doPressPackage() {
        try {
            new DoPressThread().run();
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("do press thread error.", (Throwable)e);
        }
        return this.taskResult;
    }

    class DoPressThread {
        DoPressThread() {
        }

        public void run() {
            String name = Thread.currentThread().getName();
            Thread.currentThread().setName("Thread_logDepressaction");
            DoLogPackage.this.taskResult = new TaskResult(TaskResult.Result.FAILED);
            DoLogPackage.this.taskResult.setErrorLocaleDescription("stop");
            LoganalyzerContext.getInstance().getImportLogRow().stopImportAnClick();
            if (!StringUtils.isNULLStr((String)DoLogPackage.this.logRow.getReportTmpFile())) {
                FileUtils.deleteFile((File)new File(DoLogPackage.this.logRow.getReportTmpFile()));
            }
            DoLogPackage.this.logRow.setReportTmpFile(SearcherUtils.getTmpResultFilePath().getAbsolutePath());
            LogAnalyzeQueryCallable callable = new LogAnalyzeQueryCallable(DoLogPackage.this.logRow);
            DoLogPackage.this.taskResult = (TaskResult)callable.call();
            Thread.currentThread().setName(name);
        }
    }

    public final class LogAnalyzeQueryCallable
    implements Callable<Object> {
        private LogRow row;

        public LogAnalyzeQueryCallable(LogRow row) {
            this.row = row;
        }

        @Override
        public Object call() {
            TaskResult taskRes = null;
            try {
                taskRes = this.depressFile();
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(this.getClass()).error(" method name:LogAnalyzeQueryTask ", (Throwable)e);
                taskRes = this.handleDecompressError();
            }
            return taskRes;
        }

        private TaskResult handleDecompressError() {
            TaskResult taskRes = new TaskResult(TaskResult.Result.FAILED);
            taskRes.setErrorLocaleDescription("decompress error");
            this.initTmpFiles();
            return taskRes;
        }

        private TaskResult depressFile() {
            TaskResult task;
            String defaultTempPath = SearchConstant.getInstant().getTemp();
            File tempFile = new File(defaultTempPath);
            DiskIsEnoughThread isDiskEnough = new DiskIsEnoughThread(tempFile);
            IDeCompressPkgWorktaker decompressworktaker = (IDeCompressPkgWorktaker)WorktakerUtil.getWorktaker(IDeCompressPkgWorktaker.class);
            LogDeCompressDir logDeCompressDir = new LogDeCompressDir();
            try {
                Long size = FileUtil.getDirSize(tempFile);
                double msize = (double)size.longValue() / 1.073741824E9;
                if (msize > 40.0) {
                    TaskResult task2 = new TaskResult(TaskResult.Result.FAILED);
                    task2.setErrorLocaleDescription("The temp decompress space reaches the upper limit");
                    TaskResult taskResult = task2;
                    return taskResult;
                }
                isDiskEnough.start();
                decompressworktaker.convertLogDir(this.row, logDeCompressDir, isDiskEnough);
                this.row.setLogDeCompressDir(logDeCompressDir);
                if (logDeCompressDir.getDeDeCompressDir() == null) {
                    TaskResult task3 = new TaskResult(TaskResult.Result.FAILED);
                    task3.setErrorLocaleDescription("Can not open file as archive");
                    this.initTmpFiles();
                    TaskResult taskResult = task3;
                    return taskResult;
                }
                if ("too big".equals(logDeCompressDir.getDeDeCompressDir().getName())) {
                    TaskResult task4 = new TaskResult(TaskResult.Result.FAILED);
                    task4.setErrorLocaleDescription("too big");
                    this.initTmpFiles();
                    TaskResult taskResult = task4;
                    return taskResult;
                }
                try {
                    LoganalyzerContext.getInstance().getImportLogRow().stopImportAnClick();
                    String decompressPath = SearcherUtils.getLogPath(logDeCompressDir.getDeDeCompressDir()).getAbsolutePath();
                    this.row.setDatecollect(decompressPath.contains("DataCollect") || decompressPath.contains("System_log"));
                    LoganalyzerContext.getInstance().getImportLogRow().stopImportAnClick();
                    this.handleSuccSituation();
                    File deCompressRandomDir = DoLogPackage.this.logRow.getLogDeCompressDir().getDeDeCompressRandomDir();
                    this.configInfoEntry(deCompressRandomDir);
                    task = new TaskResult(TaskResult.Result.SUCCESS);
                    LoganalyzerContext.getInstance().getDecompressLogFile().put(this.row.getLogFile().getName(), logDeCompressDir.getDeDeCompressDir());
                    ToolLoggerFactory.getLogger(this.getClass()).debug("filepath:" + logDeCompressDir.getDeDeCompressDir().getPath());
                }
                catch (DiskNotEnoughException e) {
                    task = new TaskResult(TaskResult.Result.FAILED);
                    task.setErrorLocaleDescription("The disk is not enough");
                    SearcherUtils.deleteTempFile((File)HibernateContainer.getInstance().get((Object)this.row.getLogFile().getName()));
                }
                catch (StopImportException e) {
                    new RandomDirDeleteThread(logDeCompressDir).start();
                    TaskResult task5 = new TaskResult(TaskResult.Result.FAILED);
                    task5.setErrorLocaleDescription("stop");
                    TaskResult taskResult = task5;
                    return taskResult;
                }
            }
            finally {
                isDiskEnough.setDecompressed(true);
            }
            return task;
        }

        private void configInfoEntry(File deCompressRandomDir) {
            if (deCompressRandomDir != null && deCompressRandomDir.exists()) {
                List<File> files = SearcherUtils.showConfigInfoFiles(deCompressRandomDir);
                SoftHardwareConfiginfoSearch searcher = new SoftHardwareConfiginfoSearch();
                ConfigInfoEntry configInfoEntry = searcher.search(files);
            }
        }

        private void initTmpFiles() {
            if (this.row != null && !StringUtils.isNULLStr((String)this.row.getLogDeCompressDir().getDeDeCompressRandomDir().getAbsolutePath())) {
                SearcherUtils.deleteTempFile(new File(this.row.getLogDeCompressDir().getDeDeCompressRandomDir().getAbsolutePath()));
            }
        }

        private void handleSuccSituation() {
            ArrayList<DefaultTableRow> hasPorductRows = new ArrayList<DefaultTableRow>();
            ArrayList<DefaultTableRow> nonPorductRows = new ArrayList<DefaultTableRow>();
            ArrayList<DefaultTableRow> allPorductRows = new ArrayList<DefaultTableRow>();
            File tempPackage = DoLogPackage.this.logRow.getLogFile();
            DefaultTableRow tr = new DefaultTableRow(4, (Object)DoLogPackage.this.logRow.getLogID());
            tr.setValueAt(0, (Object)tempPackage.getName());
            tr.setValueAt(3, (Object)ResourceUtil.getString((String)"info.nanlyze.tabel.type.before"));
            DoLogPackage.this.logRow.setStauts("info.nanlyze.tabel.type.before");
            ProductInfo productInfo = new ProductInfo(DoLogPackage.this.logRow.getLogDeCompressDir().getDeDeCompressRandomDir());
            DoLogPackage.this.logRow.setProductInfo(productInfo);
            if (this.isModelAndVersionNull(productInfo)) {
                LoganalyzerContext.getInstance().getWriteVersionMap().put(tempPackage.getAbsolutePath(), true);
                List<String> items = DoLogPackage.this.layout.getComboBoxItems();
                IsmTableCell.ComboBoxCell cell = new IsmTableCell.ComboBoxCell(items.toArray(), (Object)items.get(0));
                tr.setValueAt(1, (Object)cell);
                tr.setValueAt(2, (Object)ResourceUtil.getString((String)"info.nanlyze.package.version"));
                List<String> versions = DoLogPackage.this.layout.getComboBoxVersions();
                IsmTableCell.ComboBoxCell versionCell = new IsmTableCell.ComboBoxCell(versions.toArray(), (Object)versions.get(0));
                SearcherUtils.linkage(cell.getComboBox(), versionCell, (TableRow<Integer, Long>)tr, 0);
                nonPorductRows.add(tr);
            } else {
                tr.setValueAt(1, (Object)productInfo.getModel());
                tr.setValueAt(2, (Object)productInfo.getVersion());
                hasPorductRows.add(tr);
            }
            if (DoLogPackage.this.layout.getPackageProTableModel().getRowCount() != 0) {
                allPorductRows.clear();
            }
            allPorductRows.addAll(nonPorductRows);
            allPorductRows.addAll(hasPorductRows);
            LoganalyzerContext.getInstance().getImportLogRow().stopImportAnClick();
            DoLogPackage.this.layout.getPackageProTableModel().addRows(allPorductRows);
            DoLogPackage.this.layout.getPackageTable().addRowSelectionInterval(0, DoLogPackage.this.layout.getPackageProTableModel().getRowCount() - 1);
            DoLogPackage.this.logRow.setRow((TableRow)tr);
            this.deleteOldLog(DoLogPackage.this.logRow);
            LoganalyzerContext.getInstance().getCurLogRows().add(DoLogPackage.this.logRow);
        }

        private boolean isModelAndVersionNull(ProductInfo productInfo) {
            String model = productInfo.getModel();
            String version = productInfo.getVersion();
            return StringUtils.isNULLStr((String)model) || StringUtils.isNULLStr((String)version);
        }

        private void deleteOldLog(LogRow lr) {
            for (LogRow tmpLogRow : LoganalyzerContext.getInstance().getCurLogRows()) {
                if (!tmpLogRow.getLogFile().getAbsolutePath().equals(lr.getLogFile().getAbsolutePath())) continue;
                if (!StringUtils.isNULLStr((String)tmpLogRow.getReportTmpFile())) {
                    FileUtils.deleteFile((File)new File(tmpLogRow.getReportTmpFile()));
                }
                LoganalyzerContext.getInstance().getCurLogRows().remove(tmpLogRow);
                break;
            }
        }
    }

    private static final class RandomDirDeleteThread
    extends Thread {
        private LogDeCompressDir logDeCompressDir;

        private RandomDirDeleteThread(LogDeCompressDir logDeCompressDir) {
            this.logDeCompressDir = logDeCompressDir;
        }

        @Override
        public void run() {
            int count = 0;
            block2: while (true) {
                try {
                    while (true) {
                        Thread.sleep(2000L);
                        if (!this.logDeCompressDir.getDeDeCompressRandomDir().exists() || ++count >= 20) break block2;
                        FileAssistant.clearDir((String)this.logDeCompressDir.getDeDeCompressRandomDir().getAbsolutePath());
                    }
                }
                catch (InterruptedException e) {
                    ToolLoggerFactory.getLogger(this.getClass()).error("logDeCompressDir is error:", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

