/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.ui.main;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.base.ui.dialogs.HelpTitleFrame;
import com.huawei.ism.tool.base.ui.task.TaskResult;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.KeyValue;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.WorktakerUtil;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.loganalyzer.entity.EventIssue;
import com.huawei.ism.tool.loganalyzer.entity.analyze.AnalyzeResult;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogRow;
import com.huawei.ism.tool.loganalyzer.entity.analyze.ReportLog;
import com.huawei.ism.tool.loganalyzer.entity.config.ModulePIDInfoMap;
import com.huawei.ism.tool.loganalyzer.entity.config.PackageInfo;
import com.huawei.ism.tool.loganalyzer.entity.config.SingleLogSearchRule;
import com.huawei.ism.tool.loganalyzer.entity.execresult.ExecuteResult;
import com.huawei.ism.tool.loganalyzer.entity.log.Log;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.version.Model;
import com.huawei.ism.tool.loganalyzer.faulttree.model.DeviceType;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.RecordInfo;
import com.huawei.ism.tool.loganalyzer.faulttree.util.FileUtil;
import com.huawei.ism.tool.loganalyzer.logic.AnalyzeUserOpService;
import com.huawei.ism.tool.loganalyzer.monitor.enumer.AnalysisMode;
import com.huawei.ism.tool.loganalyzer.persist.data.DiagnoseInfo;
import com.huawei.ism.tool.loganalyzer.persist.data.DiagnoseInfos;
import com.huawei.ism.tool.loganalyzer.persist.data.EventInfo;
import com.huawei.ism.tool.loganalyzer.persist.data.EventInfos;
import com.huawei.ism.tool.loganalyzer.ui.AdvancedAnalyzeDialog;
import com.huawei.ism.tool.loganalyzer.ui.ClearPackeageInfoDialog;
import com.huawei.ism.tool.loganalyzer.ui.DateSettingDialog;
import com.huawei.ism.tool.loganalyzer.ui.ImportInfoDialog;
import com.huawei.ism.tool.loganalyzer.ui.ImportProcessDialog;
import com.huawei.ism.tool.loganalyzer.ui.SettingDirDialog;
import com.huawei.ism.tool.loganalyzer.ui.listener.MainDailogClickListener;
import com.huawei.ism.tool.loganalyzer.ui.listener.MainDailogStopListener;
import com.huawei.ism.tool.loganalyzer.ui.listener.ShowLogDetailListener;
import com.huawei.ism.tool.loganalyzer.ui.listener.ShowLogEventDetailListener;
import com.huawei.ism.tool.loganalyzer.ui.listener.ShowLogReadListener;
import com.huawei.ism.tool.loganalyzer.ui.main.DoLogPackage;
import com.huawei.ism.tool.loganalyzer.ui.main.LogResultType;
import com.huawei.ism.tool.loganalyzer.ui.main.MainLogAnaLayout;
import com.huawei.ism.tool.loganalyzer.ui.main.MessageListner;
import com.huawei.ism.tool.loganalyzer.ui.main.ShieldEventOrTime;
import com.huawei.ism.tool.loganalyzer.ui.main.UiRefresher;
import com.huawei.ism.tool.loganalyzer.util.ComparatorUtils;
import com.huawei.ism.tool.loganalyzer.util.ComponentDefine;
import com.huawei.ism.tool.loganalyzer.util.FileListFileFilterUtils;
import com.huawei.ism.tool.loganalyzer.util.LoganalyzerContext;
import com.huawei.ism.tool.loganalyzer.util.SearchConstant;
import com.huawei.ism.tool.loganalyzer.util.SearcherBomUtils;
import com.huawei.ism.tool.loganalyzer.util.SearcherUtils;
import com.huawei.ism.tool.loganalyzer.worktaker.ILogWorkTaker;
import com.huawei.ism.tool.loganalyzer.worktaker.callback.ILogListener;
import com.huawei.ism.tool.loganalyzer.worktaker.impl.LoadRuleFileConfig;
import com.huawei.ism.tool.obase.filechooser.HibernateContainer;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;

public class MainLogAnaDialog
extends HelpTitleFrame
implements ILogListener {
    public static final int STAUTS = 3;
    public static final int PACKAGE = 0;
    public static final int PRODUCT = 1;
    public static final int VERSION = 2;
    public static final int COLUMNS = 4;
    public static final int LOG_NUM_MAX = 100;
    public static final int TEMP_SPACE_MAX = 40;
    private static final long serialVersionUID = 6455861848158960091L;
    private static final String IMPORTPATH_DEFAULT_ID = "analyze_importlog_path_id001";
    private static final String PACKAGE_TYPES = "*.tar, *.7z, *.tgz,*, *.bz2, *.zip";
    private static final String[] TYPES = new String[]{"tar", "7z", "tgz", "bz2", "zip"};
    private static final String HELP_NAME_ZH = "\u65e5\u5fd7\u5206\u6790\u5e2e\u52a9.chm";
    private static final String HELP_NAME_EN = "AnalyzeLog_en.chm";
    private static final String TEMPSTATE_DEFAULT_ID = "analyze_temp_state_id001";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(MainLogAnaDialog.class);
    private static final File TEMP_PATH_FILE = new File(ApplicationContext.getInstance().getTmpPath(), "all_TempDecompress_Dir.txt");
    private static final String NEW_LINE = "\n";
    private static MainLogAnaDialog mainLogAnaDialogObject;
    public MainLogAnaLayout layout;
    private String reportFile;
    private boolean action = false;
    private transient LogRow row;
    private boolean finish = true;
    private transient List<ExecuteResult> resultMessgList = null;
    private transient ILogWorkTaker logworktaker = (ILogWorkTaker)WorktakerUtil.getWorktaker(ILogWorkTaker.class);
    private String logDirPath = "";
    private String packName;
    private Window frame;
    private SettingDirDialog settingDirDialog;

    public MainLogAnaDialog(Window frame) {
        MainLogAnaDialog.setMainLogAnaDialog(this);
        this.settingDirDialog = new SettingDirDialog((Window)((Object)this));
        this.resultMessgList = new ArrayList<ExecuteResult>();
        this.frame = frame;
        this.init();
        this.initUiListener();
    }

    public MainLogAnaDialog() {
        MainLogAnaDialog.setMainLogAnaDialog(this);
        this.resultMessgList = new ArrayList<ExecuteResult>();
    }

    public List<ExecuteResult> getResultMessgList() {
        return this.resultMessgList;
    }

    private static final synchronized void setMainLogAnaDialog(MainLogAnaDialog mainLogAnaDialog) {
        if (mainLogAnaDialog != null) {
            mainLogAnaDialogObject = mainLogAnaDialog;
        }
    }

    public static final MainLogAnaDialog getInstance() {
        return mainLogAnaDialogObject;
    }

    private void init() {
        this.layout = new MainLogAnaLayout();
        this.setLayout(new BorderLayout());
        this.add(this.layout);
        this.setTitle(ResourceUtil.getString((String)"info.analyze.titlename"));
        this.setIconImage(ResourceUtil.getImage((String)"analyze48.PNG").getImage());
        this.setResizable(true);
        this.pack();
        this.toFront();
        SwingUtil.putParentCenter((Window)((Object)this), (Window)this.frame);
        this.setDefaultCloseOperation(2);
        this.initListener();
    }

    private void initUiListener() {
        JButton browsLogBtn = this.layout.getBrowsLogBtn();
        JButton analyzeBtn = this.layout.getAnalyzeBtn();
        JButton reportBtn = this.layout.getChangePathBtn();
        JButton scanReportBtn = this.layout.getScanReportBtn();
        JButton stopButton = this.layout.getStopButton();
        JButton setDirBtn = this.layout.getSetDirButton();
        JButton removeBtn = this.layout.getRemoveButton();
        JButton advancedAnalyzeBtn = this.layout.getAdvancedAnalyzeButton();
        this.setAdvancedListener(advancedAnalyzeBtn);
        JButton closeBtn = this.layout.getCloseButton();
        ToolHyperLinkLabel supportLink = this.layout.getSupportLink();
        scanReportBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolLoggerFactory.getLogger(this.getClass()).debug("Operate : open report file");
                MainLogAnaDialog.this.openReport();
            }
        });
        ActionListener changePathBtnListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.debug("Operate : open report dir");
                OSCmdUtils.explorerFile((String)MainLogAnaDialog.this.settingDirDialog.getOutputPath().getText());
            }
        };
        reportBtn.addActionListener(changePathBtnListener);
        ActionListener browsLogBtnListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.debug("Operate : import log package");
                String defaultReportPath = MainLogAnaDialog.this.settingDirDialog.getOutputPath().getText();
                Set<LogRow> curLogRows = LoganalyzerContext.getInstance().getCurLogRows();
                if (curLogRows.size() > 100) {
                    DialogUtils.showInfoDialog((Frame)((Object)MainLogAnaDialog.this), (String)ResourceUtil.getString((String)"info.analyze.prompt.file.num.limit"));
                    return;
                }
                String defaultTempPath = SearchConstant.getInstant().getTemp();
                File tempFile = new File(defaultTempPath);
                Long size = FileUtil.getDirSize(tempFile);
                double msize = (double)size.longValue() / 1.073741824E9;
                if (msize > 40.0) {
                    DialogUtils.showInfoDialog((Frame)((Object)MainLogAnaDialog.this), (String)ResourceUtil.getString((String)"info.analyze.prompt.file.space.limit"));
                    return;
                }
                if (!MainLogAnaDialog.checkSelectFile(defaultReportPath) || !MainLogAnaDialog.checkSelectFile(defaultTempPath)) {
                    DialogUtils.showInfoDialog((Frame)((Object)MainLogAnaDialog.this), (String)ResourceUtil.getString((String)"info.analyze.filechooser.prompt.file.error.path"));
                    return;
                }
                MainLogAnaDialog.this.importLog();
            }
        };
        browsLogBtn.addActionListener(browsLogBtnListener);
        IsmTable table = this.layout.getPackageTable();
        ListSelectionModel selectionModel = table.getSelectionModel();
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                try {
                    Thread.sleep(50L);
                    MainLogAnaDialog.this.refreshDetailList(MainLogAnaDialog.this.action || MainLogAnaDialog.this.finish);
                }
                catch (Exception e1) {
                    LOGGER.debug("Thread sleep fail.");
                }
            }
        });
        analyzeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String defaultReportPath = MainLogAnaDialog.this.settingDirDialog.getOutputPath().getText();
                String defaultTempPath = SearchConstant.getInstant().getTemp();
                if (!MainLogAnaDialog.checkSelectFile(defaultReportPath) || !MainLogAnaDialog.checkSelectFile(defaultTempPath)) {
                    DialogUtils.showInfoDialog((Frame)((Object)MainLogAnaDialog.this), (String)ResourceUtil.getString((String)"info.analyze.filechooser.prompt.file.error.path"));
                    return;
                }
                MainLogAnaDialog.this.dateSetting();
                LOGGER.debug("Operate : start analyze");
                if (LoganalyzerContext.getInstance().isComfirm()) {
                    List<LogRow> types = MainLogAnaDialog.this.getTypes();
                    MessageListner analyzeAction = new MessageListner(types);
                    analyzeAction.actionPerformed(e);
                    LoganalyzerContext.getInstance().setComfirm(false);
                }
            }
        });
        supportLink.addClickListener((ToolHyperLinkLabel.ClickListener)new MainDailogClickListener(this));
        stopButton.addActionListener(new MainDailogStopListener());
        closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.debug("Operate : close analyzelog tool.");
                MainLogAnaDialog.this.dispose();
            }
        });
        removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainLogAnaDialog.this.removeLogPackage();
            }
        });
        setDirBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainLogAnaDialog.this.settingDirDialog.initData();
                MainLogAnaDialog.this.settingDirDialog.setVisible(true);
            }
        });
    }

    private void setAdvancedListener(JButton advancedAnalyzeBtn) {
        advancedAnalyzeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("Operate : start Advanced Analyze.");
                List<LogRow> logRows = MainLogAnaDialog.this.getSelectedRows();
                if (logRows.size() == 1) {
                    double remainderMemory = SearcherUtils.remainderMemory();
                    if (remainderMemory < 100.0 || MainLogAnaDialog.this.isRamNotEnough(remainderMemory)) {
                        DialogUtils.showInfoDialog((Frame)((Object)MainLogAnaDialog.getInstance()), (String)ResourceUtil.getString((String)"info.analyze.stop.ramoverflow"));
                    } else {
                        new AdvancedAnalyzeDialog(logRows).setVisible(true);
                    }
                } else if (logRows.isEmpty()) {
                    DialogUtils.showInfoDialog((Frame)((Object)MainLogAnaDialog.this), (String)ResourceUtil.getString((String)"info.nanlyze.import.empty.event"));
                } else {
                    DialogUtils.showInfoDialog((Frame)((Object)MainLogAnaDialog.this), (String)ResourceUtil.getString((String)"info.nanlyze.import.morethanone.event"));
                }
            }
        });
    }

    private boolean isRamNotEnough(double remainderMemory) {
        return this.isAnalyzeRun() && 100.0 < remainderMemory && remainderMemory < 120.0;
    }

    private boolean isAnalyzeRun() {
        Set<LogRow> logRows = LoganalyzerContext.getInstance().getCurLogRows();
        boolean isAnalyzeFlag = false;
        if (logRows != null) {
            for (LogRow logRow : logRows) {
                if (!ResourceUtil.getString((String)"info.nanlyze.tabel.type.doing").equals(logRow.getRow().getValueAt(3).toString())) continue;
                isAnalyzeFlag = true;
                break;
            }
        }
        return isAnalyzeFlag;
    }

    private static boolean checkSelectFile(String path) {
        File checkFile = new File(String.valueOf(path) + File.separator + "CheckFile");
        if (checkFile.isDirectory() && !checkFile.delete()) {
            return false;
        }
        boolean checkSucc = checkFile.mkdirs();
        if (!checkSucc) {
            return false;
        }
        if (!checkFile.delete()) {
            LOGGER.error("Delete checkFile failed.");
        }
        return true;
    }

    public void removeLogPackage() {
        final ArrayList<TableRow> logRows = new ArrayList<TableRow>();
        final ArrayList<TableRow<Long, Object>> selectedLogRows = new ArrayList<TableRow<Long, Object>>();
        int[] rowIndexs = this.layout.getPackageTable().getSelectedRows();
        if (rowIndexs.length == 0) {
            DialogUtils.showInfoDialog((Frame)((Object)this), (String)ResourceUtil.getString((String)"info.nanlyze.tabel.deletelog"));
            return;
        }
        this.changeUIRow2LogRow(logRows, selectedLogRows, rowIndexs);
        if (!this.checkFileWriteAndRead(selectedLogRows)) {
            DialogUtils.showInfoDialog((Frame)((Object)this), (String)ResourceUtil.getString((String)"info.nanlyze.tabel.deletelog.faile"));
            return;
        }
        if (!this.checkRemoveCondition(selectedLogRows)) {
            return;
        }
        WarningDialog isDeleteLog = DialogUtils.showYesNoDialog((Window)((Object)this), (String)ResourceUtil.getString((String)"info.analyze.message.is.conform.delete.log"));
        if (isDeleteLog.getValue() == 0) {
            AsyncExcutor.execute((JFrame)((Object)MainLogAnaDialog.getInstance()), (String)ResourceUtil.getString((String)"info.analyze.prompt.data.cleaning"), (int)300, (Callable[])new Callable[]{new Callable<Object>(){

                @Override
                public Object call() {
                    MainLogAnaDialog.this.handleYesCondition(logRows, selectedLogRows);
                    return true;
                }
            }});
            SearcherUtils.doRefreshDefaultArea(mainLogAnaDialogObject);
        }
    }

    private boolean checkFileWriteAndRead(List<TableRow<Long, Object>> selectedLogRows) {
        for (TableRow<Long, Object> logRow : selectedLogRows) {
            File tmpDecompressPath;
            String selectedTempFile = logRow.getValueAt(0).toString();
            Map<String, File> logMappingName = LoganalyzerContext.getInstance().getLogTempMap();
            if (!logMappingName.containsKey(selectedTempFile) || !(tmpDecompressPath = logMappingName.get(selectedTempFile)).isDirectory()) continue;
            File[] fileList = tmpDecompressPath.listFiles();
            if (fileList == null) {
                return false;
            }
            if (MainLogAnaDialog.checkSelectFile(tmpDecompressPath.getAbsolutePath())) continue;
            return false;
        }
        return true;
    }

    private void changeUIRow2LogRow(List<TableRow> rows, List<TableRow<Long, Object>> selectedLogRows, int[] rowIndexs) {
        int[] nArray = rowIndexs;
        int n = rowIndexs.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            index = this.layout.getPackageTable().convertRowIndexToModel(index);
            TableRow row1 = this.layout.getPackageProTableModel().getRow(index);
            selectedLogRows.add((TableRow<Long, Object>)row1);
            rows.add(row1);
            ++n2;
        }
    }

    private void handleYesCondition(List<TableRow> logRows, List<TableRow<Long, Object>> selectedLogRows) {
        this.layout.getPackageProTableModel().removeRow(logRows);
        List allRows = this.layout.getPackageProTableModel().getAllRows();
        this.layout.getPackageProTableModel().updateRow(allRows);
        this.asynDeleteLog(selectedLogRows);
        this.refreshDetailList(true);
    }

    private boolean checkRemoveCondition(List<TableRow<Long, Object>> selectedLogRows) {
        if (selectedLogRows.isEmpty()) {
            DialogUtils.showInfoDialog((Frame)((Object)this), (String)ResourceUtil.getString((String)"info.nanlyze.tabel.deletelog"));
            return false;
        }
        if (this.isHasRunLog(selectedLogRows)) {
            DialogUtils.showInfoDialog((Frame)((Object)this), (String)ResourceUtil.getString((String)"info.analyze.message.log.run.not.remove"));
            return false;
        }
        return true;
    }

    public void asynDeleteLog(List<TableRow<Long, Object>> selectedLogRows) {
        for (final TableRow<Long, Object> logRow : selectedLogRows) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    MainLogAnaDialog.this.deleteSelectedTmp(logRow.getValueAt(0).toString());
                }
            }).start();
            this.refreshCurLogRow(logRow);
            LOGGER.info("remove log package :" + logRow.getValueAt(0).toString() + "success");
        }
    }

    public void refreshCurLogRow(TableRow<Long, Object> logRows) {
        String selectLogRowName = logRows.getValueAt(0).toString();
        Iterator<LogRow> curLogRowIterea = LoganalyzerContext.getInstance().getCurLogRows().iterator();
        HashSet<LogRow> deleteLogRows = new HashSet<LogRow>();
        while (curLogRowIterea.hasNext()) {
            LogRow logRow = curLogRowIterea.next();
            if (!logRow.getLogFile().getName().equals(selectLogRowName)) continue;
            deleteLogRows.add(logRow);
        }
        LoganalyzerContext.getInstance().getCurLogRows().removeAll(deleteLogRows);
        LoganalyzerContext.getInstance().refreshRowIndex();
    }

    private boolean isHasRunLog(List<TableRow<Long, Object>> logRows) {
        for (TableRow<Long, Object> logRow : logRows) {
            String logStauts = logRow.getValueAt(3).toString();
            if (!logStauts.equals(ResourceUtil.getString((String)"info.nanlyze.tabel.type.doing")) && !logStauts.equals(ResourceUtil.getString((String)"info.nanlyze.tabel.type.stopping")) && !logStauts.equals(ResourceUtil.getString((String)"info.nanlyze.tabel.type.report")) && !logStauts.equals(ResourceUtil.getString((String)"info.nanlyze.tabel.type.wait"))) continue;
            return true;
        }
        return false;
    }

    protected void deleteSelectedTmp(String selectedTempFile) {
        Map<String, File> logMappingName = LoganalyzerContext.getInstance().getLogTempMap();
        if (logMappingName.isEmpty()) {
            return;
        }
        for (Map.Entry<String, File> logMapEntry : logMappingName.entrySet()) {
            if (!selectedTempFile.equals(logMapEntry.getKey())) continue;
            File tmpDecompressPath = logMapEntry.getValue();
            SearcherUtils.deleteTempFile(tmpDecompressPath);
        }
    }

    public void setAction(boolean action) {
        this.action = action;
    }

    public void setRow(LogRow row) {
        this.row = row;
    }

    private void dateSetting() {
        LOGGER.debug("Operate : open DateSettingDialog");
        this.layout.initData();
        new DateSettingDialog((JFrame)((Object)this));
        String startTime = SearchConstant.getInstant().getShowStartTime();
        String endTime = SearchConstant.getInstant().getShowEndTime();
        JLabel setDateDesc = this.layout.getSetDateDesc();
        String day = SearchConstant.getInstant().getDate();
        if (1 == SearchConstant.getInstant().getDateType()) {
            String dayMsg = ResourceUtil.getStringWithParams((String)"info.analyze.setting.date.day", (Object[])new Object[]{day});
            setDateDesc.setText(dayMsg);
            return;
        }
        if (!StringUtils.isNULLStr((String)startTime) && !StringUtils.isNULLStr((String)endTime)) {
            String date = ResourceUtil.getStringWithParams((String)"info.analyze.setting.date.begin&end", (Object[])new Object[]{startTime, endTime});
            setDateDesc.setText(date);
        } else if (!StringUtils.isNULLStr((String)startTime) && StringUtils.isNULLStr((String)endTime)) {
            String date = ResourceUtil.getStringWithParams((String)"info.analyze.setting.date.begin", (Object[])new Object[]{startTime});
            setDateDesc.setText(date);
        } else if (StringUtils.isNULLStr((String)startTime) && !StringUtils.isNULLStr((String)endTime)) {
            String date = ResourceUtil.getStringWithParams((String)"info.analyze.setting.date.end", (Object[])new Object[]{endTime});
            setDateDesc.setText(date);
        } else {
            setDateDesc.setText(ResourceUtil.getString((String)"info.analyze.setting.date.all"));
        }
    }

    public List<LogRow> getTypes() {
        ArrayList<LogRow> types = new ArrayList<LogRow>();
        int[] selectRows = this.layout.getPackageTable().getSelectedRows();
        if (selectRows.length == 0) {
            return types;
        }
        int[] nArray = selectRows;
        int n = selectRows.length;
        int n2 = 0;
        while (n2 < n) {
            int selectRow = nArray[n2];
            for (LogRow logRow : LoganalyzerContext.getInstance().getCurLogRows()) {
                if (logRow.getSelectRow() != this.layout.getPackageTable().convertRowIndexToModel(selectRow)) continue;
                DefaultTableModel defaultTableModel = this.layout.getPackageProTableModel();
                IsmTable table = this.layout.getPackageTable();
                TableRow row3 = defaultTableModel.getRow(table.convertRowIndexToModel(selectRow));
                logRow.setRow(row3);
                logRow.clearAllCache();
                types.add(logRow);
            }
            ++n2;
        }
        return types;
    }

    public List<LogRow> getSelectedRows() {
        ArrayList<LogRow> types = new ArrayList<LogRow>();
        int[] selectRows = this.layout.getPackageTable().getSelectedRows();
        if (selectRows.length == 0) {
            return types;
        }
        int[] nArray = selectRows;
        int n = selectRows.length;
        int n2 = 0;
        while (n2 < n) {
            int selectRow = nArray[n2];
            for (LogRow logRow : LoganalyzerContext.getInstance().getCurLogRows()) {
                if (logRow.getSelectRow() != this.layout.getPackageTable().convertRowIndexToModel(selectRow)) continue;
                DefaultTableModel defaultTableModel = this.layout.getPackageProTableModel();
                IsmTable table = this.layout.getPackageTable();
                TableRow tr = defaultTableModel.getRow(table.convertRowIndexToModel(selectRow));
                logRow.setRow(tr);
                types.add(logRow);
            }
            ++n2;
        }
        return types;
    }

    private void importLog() {
        String defaultPath = String.valueOf(HibernateContainer.getInstance().get((Object)IMPORTPATH_DEFAULT_ID));
        List selectFiles = ToolFileChooser.selectFiles((Window)((Object)this), (String)ResourceUtil.getString((String)"info.analyze.maindialog.btn.browslog"), (String[])TYPES, (String)IMPORTPATH_DEFAULT_ID, (String)PACKAGE_TYPES, (int)0);
        if (selectFiles == null) {
            return;
        }
        Set<LogRow> curLogRows = LoganalyzerContext.getInstance().getCurLogRows();
        int size = curLogRows.size();
        if ((size += selectFiles.size()) > 100) {
            DialogUtils.showInfoDialog((Frame)((Object)this), (String)ResourceUtil.getString((String)"info.analyze.prompt.file.num.limit"));
            return;
        }
        ArrayList<File> packages = new ArrayList<File>();
        ArrayList<File> logPackages = new ArrayList<File>();
        for (File file : selectFiles) {
            String importtPath;
            try {
                importtPath = file.getCanonicalPath();
            }
            catch (IOException e) {
                LOGGER.error("get report path error!", (Throwable)e);
                importtPath = "";
            }
            if (StringUtils.isNULLStr((String)importtPath)) {
                return;
            }
            if (!SearcherUtils.checkPathDeep(importtPath)) {
                ToolLoggerFactory.getLogger(MainLogAnaDialog.class).error("The selected path is too long.");
                DialogUtils.showInfoDialog((Frame)((Object)this), (String)ResourceUtil.getString((String)"info.nanlyze.file.path.max.length"));
                HibernateContainer.getInstance().put(IMPORTPATH_DEFAULT_ID, (Object)defaultPath);
                return;
            }
            this.refreshScanReportBtn(this.row);
            this.logDirPath = file.getAbsolutePath();
            if (selectFiles.size() == 1) {
                this.layout.getBrowsLogField().setText(this.logDirPath);
                this.layout.getBrowsLogField().setToolTipText(this.logDirPath);
            } else {
                this.layout.getBrowsLogField().setText(file.getParent());
                this.layout.getBrowsLogField().setToolTipText(file.getParent());
            }
            packages.add(file);
            logPackages.add(file);
        }
        LoganalyzerContext.getInstance().setImportAllPack(packages);
        if (!this.layout.getPackageTable().getAllRows().isEmpty()) {
            this.refreshTableBytemp();
            try {
                if (!this.handleIsEmptyLog(packages, curLogRows)) {
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.error("import exist Package :", (Throwable)e);
            }
        }
        List<Map<String, String>> logMessage = LoganalyzerContext.getInstance().getMessageMap();
        HashMap<String, String> messageInfoMap = new HashMap<String, String>();
        if (packages.isEmpty() && !logMessage.isEmpty()) {
            for (Map<String, String> message : logMessage) {
                this.isRepeatImport(logPackages, messageInfoMap, message);
            }
            new ImportInfoDialog((Window)((Object)this), messageInfoMap).setVisible(true);
            return;
        }
        if (!packages.isEmpty()) {
            this.doDecompressLogPkg(packages);
        }
    }

    private synchronized boolean handleIsEmptyLog(List<File> packages, Set<LogRow> curLogRows) {
        if (curLogRows.isEmpty()) {
            return true;
        }
        for (LogRow logRow : curLogRows) {
            if (this.selectImportLog(packages, logRow, curLogRows)) continue;
            return false;
        }
        return true;
    }

    private void doDecompressLogPkg(final List<File> packages) {
        final ImportProcessDialog importProcessDialog = new ImportProcessDialog((Window)((Object)this));
        this.resultMessgList.clear();
        this.refreshDetailList(true);
        new Thread(new Runnable(){

            @Override
            public void run() {
                MainLogAnaDialog.this.addTableRow(packages, importProcessDialog);
            }
        }, "Thread_decompressLogPkg").start();
    }

    private void isRepeatImport(List<File> logPackages, Map<String, String> messageInfoMap, Map<String, String> message) {
        for (Map.Entry<String, String> messageEntry : message.entrySet()) {
            for (File file : logPackages) {
                if (!file.getName().equals(messageEntry.getKey())) continue;
                messageInfoMap.put(messageEntry.getKey(), messageEntry.getValue());
            }
        }
    }

    private boolean selectImportLog(final List<File> packages, LogRow fileName, final Set<LogRow> curLogRows) {
        String existFile = fileName.getLogFile().getName();
        LOGGER.info("exist file path is :" + existFile);
        for (File selectFile : packages) {
            String selectFilePath = selectFile.getName();
            LOGGER.info("selected file path is :" + selectFilePath);
            if (!existFile.equals(selectFilePath)) continue;
            ClearPackeageInfoDialog clearPackeageInfoDialog = new ClearPackeageInfoDialog((JFrame)((Object)this));
            clearPackeageInfoDialog.setVisible(true);
            if (!clearPackeageInfoDialog.isClickOk()) {
                return false;
            }
            if (1 == clearPackeageInfoDialog.getDialogValue()) {
                AsyncExcutor.execute((JFrame)((Object)MainLogAnaDialog.getInstance()), (String)ResourceUtil.getString((String)"info.analyze.prompt.data.cleaning"), (int)300, (Callable[])new Callable[]{new Callable<Object>(){

                    @Override
                    public Object call() {
                        MainLogAnaDialog.this.clearExistLog(curLogRows, packages);
                        return true;
                    }
                }});
                break;
            }
            if (clearPackeageInfoDialog.getDialogValue() != 0) continue;
            this.deleteExistingLog(packages);
            break;
        }
        return true;
    }

    private void clearExistLog(Set<LogRow> curLogRows, List<File> packages) {
        ArrayList<TableRow> tableRows = new ArrayList<TableRow>();
        HashSet<PackageInfo> logInfos = new HashSet<PackageInfo>();
        ArrayList<TableRow<LogRow, Long>> selectedLogRows = new ArrayList<TableRow<LogRow, Long>>();
        this.clearExistlogRows(curLogRows, packages, tableRows, logInfos, selectedLogRows);
        LoganalyzerContext.getInstance().getPackageInfos().removeAll(logInfos);
        this.clearLogPackage(tableRows, selectedLogRows);
    }

    private void clearExistlogRows(Set<LogRow> curLogRows, List<File> packages, List<TableRow> tableRows, Set<PackageInfo> logInfos, List<TableRow<LogRow, Long>> selectedLogRows) {
        for (LogRow logRow : curLogRows) {
            this.handleRepeatLog(packages, tableRows, logInfos, logRow, selectedLogRows);
        }
    }

    private void handleRepeatLog(List<File> packages, List<TableRow> tableRows, Set<PackageInfo> logInfos, LogRow logRow, List<TableRow<LogRow, Long>> selectedLogRows) {
        String existLog = logRow.getLogFile().getName();
        for (File selectLog : packages) {
            if (!existLog.equals(selectLog.getName())) continue;
            tableRows.add(logRow.getRow());
            selectedLogRows.add((TableRow<LogRow, Long>)logRow.getRow());
            logRow.setListModel(new DefaultListModel());
            SearcherUtils.clearData(logRow, this.layout, this.action);
            this.handlePackageInfo(logInfos, logRow);
        }
    }

    private void handlePackageInfo(Set<PackageInfo> logInfos, LogRow logRow) {
        for (PackageInfo info : LoganalyzerContext.getInstance().getPackageInfos()) {
            if (!info.getLogFileName().equals(logRow.getLogFile().getAbsolutePath())) continue;
            logInfos.add(info);
        }
    }

    private void refreshTableBytemp() {
        Map<String, File> logTempDir = LoganalyzerContext.getInstance().getLogTempMap();
        ArrayList<TableRow> logRows = new ArrayList<TableRow>();
        List tableRow = this.layout.getPackageTable().getAllRows();
        for (Map.Entry<String, File> logTempDirEntry : logTempDir.entrySet()) {
            String tempLogName = logTempDirEntry.getKey();
            File tempFile = logTempDirEntry.getValue();
            if (tempFile.exists()) continue;
            for (TableRow table : tableRow) {
                String logName = (String)table.getValueAt(0);
                int logIndex = this.layout.getPackageProTableModel().getRowIndex(table);
                TableRow row4 = this.layout.getPackageProTableModel().getRow(logIndex);
                if (!tempLogName.equals(logName)) continue;
                logRows.add(row4);
            }
        }
        if (logRows.isEmpty()) {
            return;
        }
        this.refreshLogTableByTemp(logRows);
    }

    private void refreshLogTableByTemp(List<TableRow> logRows) {
        this.layout.getPackageProTableModel().removeRow(logRows);
        List allRows = this.layout.getPackageProTableModel().getAllRows();
        this.layout.getPackageProTableModel().updateRow(allRows);
        HashSet<LogRow> deleteLogRows = new HashSet<LogRow>();
        Set<LogRow> curLogRows = LoganalyzerContext.getInstance().getCurLogRows();
        for (LogRow row5 : curLogRows) {
            for (TableRow tableLogRow : logRows) {
                String curLogName = row5.getLogFile().getName();
                if (!curLogName.equals(tableLogRow.getValueAt(0).toString())) continue;
                deleteLogRows.add(row5);
            }
        }
        curLogRows.removeAll(deleteLogRows);
    }

    private void deleteExistingLog(List<File> packages) {
        Set<LogRow> curLogRow = LoganalyzerContext.getInstance().getCurLogRows();
        for (LogRow curLog : curLogRow) {
            Iterator<File> iterPack = packages.iterator();
            while (iterPack.hasNext()) {
                File packFile = iterPack.next();
                if (!packFile.getName().equals(curLog.getLogFile().getName())) continue;
                iterPack.remove();
            }
        }
        LoganalyzerContext.getInstance().setImportAllPack(packages);
    }

    private void clearLogPackage(List<TableRow> tableRows, List<TableRow<LogRow, Long>> selectedLogRows) {
        this.exitEdit();
        this.layout.getPackageProTableModel().removeRow(tableRows);
        List allRows = this.layout.getPackageProTableModel().getAllRows();
        this.layout.getPackageProTableModel().updateRow(allRows);
        SearcherUtils.deleteExistTemp(selectedLogRows);
        FileUtils.deleteAllInFolder((String)(String.valueOf(com.huawei.ism.tool.obase.utils.ApplicationContext.getInstance().getTmpPath()) + File.separator + "report"));
    }

    private void addTableRow(List<File> packages, ImportProcessDialog importProcessDialog) {
        if (packages.isEmpty()) {
            DialogUtils.showInfoDialog((Frame)((Object)this), (String)ResourceUtil.getString((String)"info.nanlyze.import.log.empty"));
            return;
        }
        HashMap<String, String> messages = new HashMap<String, String>();
        try {
            int packNum = 0;
            ArrayList<ExecuteResult> resultMessgList1 = new ArrayList<ExecuteResult>();
            for (File tempPackage : packages) {
                LogRow logRow = new LogRow();
                importProcessDialog.getDesc().setText("" + ++packNum);
                this.packName = tempPackage.getName();
                LoganalyzerContext.getInstance().setImportPackName(this.packName);
                LogRow curImportLogRow = LoganalyzerContext.getInstance().getImportLogRow();
                if (curImportLogRow != null && curImportLogRow.isStopImpot()) {
                    logRow.setStopImpot(true);
                }
                LoganalyzerContext.getInstance().setImportLogRow(logRow);
                logRow.setLogFile(tempPackage);
                importProcessDialog.doRefreshImportArea(ResourceUtil.getString((String)"info.analyze.maindialog.importlog.import"), resultMessgList1, logRow, 0);
                DoLogPackage doPackageThread = new DoLogPackage(logRow);
                TaskResult result = doPackageThread.doPressPackage();
                if (!TaskResult.Result.SUCCESS.equals((Object)result.getResult())) {
                    importProcessDialog.doRefreshImportArea(ResourceUtil.getString((String)"info.analyze.maindialog.importlog.depress"), resultMessgList1, logRow, 50);
                }
                if (TaskResult.Result.SUCCESS.equals((Object)result.getResult())) {
                    importProcessDialog.doRefreshImportArea(ResourceUtil.getString((String)"info.analyze.maindialog.importlog.import.done"), resultMessgList1, logRow, 100);
                    if (logRow.isDatecollect()) {
                        messages.put(tempPackage.getName(), ResourceUtil.getString((String)"info.nanlyze.import.log.success"));
                        LOGGER.info("import log " + tempPackage.getName() + " success.");
                        continue;
                    }
                    messages.put(tempPackage.getName(), ResourceUtil.getString((String)"info.nanlyze.import.nodatecollect.log.success"));
                    LOGGER.info("import log " + tempPackage.getName() + " success.");
                    continue;
                }
                if ("The temp decompress space reaches the upper limit".equals(result.getErrorLocaleDescription())) {
                    this.handleSpaceLimit(importProcessDialog, messages, tempPackage, logRow);
                    continue;
                }
                if ("Can not open file as archive".equals(result.getErrorLocaleDescription())) {
                    this.handleCannotOpenFile(importProcessDialog, messages, tempPackage, logRow);
                    continue;
                }
                if ("file name contain specialcharacter".equals(result.getErrorLocaleDescription())) {
                    this.handleSpecialCharactor(importProcessDialog, messages, tempPackage, logRow);
                    continue;
                }
                if ("The package is incorrectness".equals(result.getErrorLocaleDescription())) {
                    this.handleNoLogPackage(importProcessDialog, messages, tempPackage, logRow);
                    continue;
                }
                if ("too big".equals(result.getErrorLocaleDescription())) {
                    this.handleBigPackage(importProcessDialog, messages, tempPackage, logRow);
                    continue;
                }
                if ("stop".equals(result.getErrorLocaleDescription())) {
                    this.hanleStopSituation(importProcessDialog);
                    LoganalyzerContext.getInstance().getMessageMap().add(messages);
                    LoganalyzerContext.getInstance().setImportLogRow(null);
                    return;
                }
                if ("decompress error".equals(result.getErrorLocaleDescription())) {
                    this.handleDecompressError(importProcessDialog, messages, tempPackage, logRow);
                    continue;
                }
                this.processNormal(importProcessDialog, messages, tempPackage, logRow);
                LoganalyzerContext.getInstance().setImportLogRow(null);
                break;
            }
        }
        catch (Exception e) {
            LOGGER.info("deCompress log package exception", (Throwable)e);
        }
        LoganalyzerContext.getInstance().setImportLogRow(null);
        if (messages.isEmpty()) {
            DialogUtils.showInfoDialog((Frame)((Object)this), (String)ResourceUtil.getString((String)"info.nanlyze.import.log.empty"));
            return;
        }
        LoganalyzerContext.getInstance().refreshRowIndex();
        this.refreshDetailList(true);
        importProcessDialog.setVisible(false);
        LoganalyzerContext.getInstance().getMessageMap().add(messages);
        new ImportInfoDialog((Window)((Object)this), messages).setVisible(true);
    }

    private void handleDecompressError(ImportProcessDialog importProcessDialog, Map<String, String> messages, File tempPackage, LogRow logRow) {
        messages.put(tempPackage.getName(), ResourceUtil.getStringWithParams((String)"info.analyze.maindialog.importlog.import.fail", (Object[])new Object[]{tempPackage.getName()}));
        if (!this.resultMessgList.isEmpty()) {
            this.resultMessgList.remove(this.resultMessgList.size() - 1);
        }
        importProcessDialog.doRefreshImportArea(ResourceUtil.getString((String)"info.analyze.maindialog.importlog.import.fail"), this.resultMessgList, logRow, 50);
        LOGGER.error("import log " + tempPackage.getName() + " failed.");
    }

    private void processNormal(ImportProcessDialog importProcessDialog, Map<String, String> messages, File tempPackage, LogRow logRow) {
        String defaultTempPath = SearchConstant.getInstant().getTemp();
        messages.put(tempPackage.getName(), ResourceUtil.getStringWithParams((String)"info.nanlyze.file.disk.not.enough2", (Object[])new Object[]{defaultTempPath.substring(0, 1)}));
        if (!this.resultMessgList.isEmpty()) {
            this.resultMessgList.remove(this.resultMessgList.size() - 1);
        }
        importProcessDialog.doRefreshImportArea(ResourceUtil.getString((String)"info.analyze.maindialog.importlog.import.fail"), this.resultMessgList, logRow, 50);
        LOGGER.error("import log " + tempPackage.getName() + " failed.");
        importProcessDialog.setVisible(false);
    }

    private void hanleStopSituation(ImportProcessDialog importProcessDialog) {
        LoganalyzerContext.getInstance().refreshRowIndex();
        importProcessDialog.setVisible(false);
        LoganalyzerContext.getInstance().setStopImportEnd(false);
        DialogUtils.showInfoDialog((Frame)((Object)this), (String)(String.valueOf(ResourceUtil.getString((String)"info.nanlyze.tabel.type.stopped")) + "."));
        LOGGER.error("stop success....");
    }

    private void handleBigPackage(ImportProcessDialog importProcessDialog, Map<String, String> messages, File tempPackage, LogRow logRow) {
        messages.put(tempPackage.getName(), ResourceUtil.getStringWithParams((String)"info.nanlyze.file.too.big", (Object[])new Object[]{tempPackage.getName()}));
        if (!this.resultMessgList.isEmpty()) {
            this.resultMessgList.remove(this.resultMessgList.size() - 1);
        }
        importProcessDialog.doRefreshImportArea(ResourceUtil.getString((String)"info.analyze.maindialog.importlog.import.fail"), this.resultMessgList, logRow, 50);
        LOGGER.error("import log " + tempPackage.getName() + " failed.");
    }

    private void handleNoLogPackage(ImportProcessDialog importProcessDialog, Map<String, String> messages, File tempPackage, LogRow logRow) {
        messages.put(tempPackage.getName(), ResourceUtil.getStringWithParams((String)"info.nanlyze.file.incorrectness", (Object[])new Object[]{tempPackage.getName()}));
        if (!this.resultMessgList.isEmpty()) {
            this.resultMessgList.remove(this.resultMessgList.size() - 1);
        }
        importProcessDialog.doRefreshImportArea(ResourceUtil.getString((String)"info.analyze.maindialog.importlog.import.fail"), this.resultMessgList, logRow, 50);
        LOGGER.error("import log " + tempPackage.getName() + " failed.");
    }

    private void handleSpecialCharactor(ImportProcessDialog importProcessDialog, Map<String, String> messages, File tempPackage, LogRow logRow) {
        messages.put(tempPackage.getName(), ResourceUtil.getStringWithParams((String)"info.nanlyze.file.contain.specialcharacter", (Object[])new Object[]{tempPackage.getName()}));
        if (!this.resultMessgList.isEmpty()) {
            this.resultMessgList.remove(this.resultMessgList.size() - 1);
        }
        importProcessDialog.doRefreshImportArea(ResourceUtil.getString((String)"info.analyze.maindialog.importlog.import.fail"), this.resultMessgList, logRow, 50);
        LOGGER.error("import log " + tempPackage.getName() + " failed.");
    }

    private void handleCannotOpenFile(ImportProcessDialog importProcessDialog, Map<String, String> messages, File tempPackage, LogRow logRow) {
        messages.put(tempPackage.getName(), ResourceUtil.getStringWithParams((String)"info.nanlyze.file.cannot.open", (Object[])new Object[]{tempPackage.getName()}));
        if (!this.resultMessgList.isEmpty()) {
            this.resultMessgList.remove(this.resultMessgList.size() - 1);
        }
        importProcessDialog.doRefreshImportArea(ResourceUtil.getString((String)"info.analyze.maindialog.importlog.import.fail"), this.resultMessgList, logRow, 50);
        LOGGER.error("import log " + tempPackage.getName() + " failed.");
    }

    private void handleSpaceLimit(ImportProcessDialog importProcessDialog, Map<String, String> messages, File tempPackage, LogRow logRow) {
        messages.put(tempPackage.getName(), ResourceUtil.getStringWithParams((String)"info.analyze.prompt.file.space.limit", (Object[])new Object[]{tempPackage.getName()}));
        if (!this.resultMessgList.isEmpty()) {
            this.resultMessgList.remove(this.resultMessgList.size() - 1);
        }
        importProcessDialog.doRefreshImportArea(ResourceUtil.getString((String)"info.analyze.maindialog.importlog.import.fail"), this.resultMessgList, logRow, 50);
        LOGGER.error("import log " + tempPackage.getName() + " failed.");
    }

    private void exitEdit() {
        for (TableRow row5 : this.layout.getPackageTable().getAllRows()) {
            Object version;
            Object object = row5.getValueAt(1);
            if (object instanceof IsmTableCell.ComboBoxCell) {
                IsmTableCell.ComboBoxCell cell = (IsmTableCell.ComboBoxCell)object;
                cell.getEditor().stopCellEditing();
            }
            if (!((version = row5.getValueAt(2)) instanceof IsmTableCell.ComboBoxCell)) continue;
            IsmTableCell.ComboBoxCell versionCell = (IsmTableCell.ComboBoxCell)version;
            versionCell.getEditor().stopCellEditing();
        }
    }

    private String selectRuleFile(String ruleName) {
        String rulePath = String.valueOf(ComponentDefine.CONFIG_PATH) + File.separator + ruleName + File.separator + "AnalyzeRule.xml";
        LoganalyzerContext.getInstance().setDataworkbookPath(String.valueOf(ComponentDefine.CONFIG_PATH) + File.separator + ruleName + File.separator + "vermap.ini");
        ShieldEventOrTime shieldEventOrTime = new ShieldEventOrTime(this.layout, new File(rulePath));
        shieldEventOrTime.shieldFunction();
        return rulePath;
    }

    boolean checkAnalyzeFile(List<LogRow> rows) {
        if (rows.isEmpty()) {
            DialogUtils.showInfoDialog((Frame)((Object)this), (String)ResourceUtil.getString((String)"info.nanlyze.import.empty.event"));
            return false;
        }
        if (!this.checkDeviceType(rows, ResourceUtil.getString((String)"info.analyze.maindialog.btn.browsxml"))) {
            DialogUtils.showInfoDialog((Frame)((Object)this), (String)ResourceUtil.getString((String)"info.nanlyze.import.empty"));
            return false;
        }
        if (!this.checkVersion(rows)) {
            DialogUtils.showInfoDialog((Frame)((Object)this), (String)ResourceUtil.getString((String)"info.analyze.check.message.error"));
            return false;
        }
        return true;
    }

    private boolean checkDeviceType(List<LogRow> rows, String target) {
        for (LogRow row6 : rows) {
            String productType = row6.getType();
            if (!productType.equals(target)) continue;
            return false;
        }
        return true;
    }

    private boolean checkVersion(List<LogRow> rows) {
        for (LogRow row7 : rows) {
            boolean isMatchFlag = false;
            Model model = DeviceType.getModel(row7.getType());
            if (model.validVersion(row7.getVersion())) {
                isMatchFlag = true;
            }
            if (isMatchFlag) continue;
            return false;
        }
        return true;
    }

    boolean checkEventFile(List<LogRow> rows) {
        if (rows.isEmpty()) {
            DialogUtils.showInfoDialog((Frame)((Object)this), (String)ResourceUtil.getString((String)"info.nanlyze.import.empty.event"));
            return false;
        }
        if (!this.checkDeviceType(rows, ResourceUtil.getString((String)"info.analyze.maindialog.btn.browsxml"))) {
            DialogUtils.showInfoDialog((Frame)((Object)this), (String)ResourceUtil.getString((String)"info.nanlyze.import.empty"));
            return false;
        }
        List<String> unSupportEvents = LoadRuleFileConfig.getInstance().getUnSupportFunction("RESOLVE_EVENT");
        for (String temp : unSupportEvents) {
            if (this.checkDeviceType(rows, temp)) continue;
            DialogUtils.showInfoDialog((Frame)((Object)this), (String)ResourceUtil.getStringWithParams((String)"info.nanlyze.import.unsupport.event", (Object[])new Object[]{LoadRuleFileConfig.getInstance().getUnSupEventMsg()}));
            return false;
        }
        return true;
    }

    void doAnalyzeOperation(LogRow row7) throws ToolException {
        File xmlFile = new File(this.selectRuleFile(DeviceType.getModel(row7.getType()).get(row7.getVersion()).getPackageName()));
        this.layout.getTabbedPane().setSelectedIndex(0);
        row7.setListener(this);
        this.logworktaker.doAnalyzeAction(row7, xmlFile);
    }

    @Override
    public void doRereshTable(final Map<SingleLogSearchRule, List<Log>> ruleLogResult, final AnalyzeResult result, final LogRow row8) {
        if (row8.isAttempt()) {
            return;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    MainLogAnaDialog.this.paintTableMessage(ruleLogResult, result, row8);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Reresh table failed.", (Throwable)e);
        }
    }

    private void paintTableMessage(Map<SingleLogSearchRule, List<Log>> ruleLogResult, AnalyzeResult result, LogRow logRow) {
        List<KeyValue<String, String>> viewInfoTable = result.getViewInfoTable();
        Log singLog = new Log("", "", "", "", "", "", "");
        DefaultTableRow row9 = new DefaultTableRow(this.layout.getMessageTableHeaders().length, (Object)new AnalyzeResult(), null);
        String ruleId = this.problemDescription(viewInfoTable, (TableRow<AnalyzeResult, String>)row9);
        this.dateDesc(ruleLogResult, singLog);
        String date = singLog.getDate();
        if (!date.isEmpty()) {
            row9.setValueAt(1, (Object)date);
        } else {
            row9.setValueAt(1, (Object)"--");
        }
        String detailDesc = ResourceUtil.getString((String)"info.analyze.maindialog.problemtable.detail");
        ShowLogDetailListener detailActionListener = new ShowLogDetailListener((JFrame)((Object)this), result, logRow, LogResultType.KNOWNRISK);
        IsmTableCell.HyperlinkCell detailCell = new IsmTableCell.HyperlinkCell(detailDesc, (ActionListener)detailActionListener);
        row9.setValueAt(2, (Object)detailCell);
        if (this.layout.isSelectRow(logRow)) {
            this.layout.getSearchedProTableModel().addRow(new TableRow[]{row9});
        }
        String logDesc = ResourceUtil.getString((String)"info.analyze.maindialog.problemtable.log");
        ShowLogReadListener logListener = new ShowLogReadListener((JFrame)((Object)this), ruleLogResult, result, logRow, LogResultType.KNOWNRISK);
        IsmTableCell.HyperlinkCell cell = new IsmTableCell.HyperlinkCell(logDesc, (ActionListener)logListener);
        row9.setValueAt(3, (Object)cell);
        logRow.getDetailList().add((TableRow)row9);
        ReportLog reportLog = this.getReportLogFormRiskRow((TableRow<AnalyzeResult, String>)row9);
        reportLog.setDetail(this.getDetail(result, logRow, ruleLogResult));
        reportLog.setRecordInfos(this.getLogLink(ruleLogResult, logRow));
        reportLog.setNo(ruleId);
        logRow.addKnownRiskLogs(reportLog);
    }

    private String problemDescription(List<KeyValue<String, String>> viewInfoTable, TableRow<AnalyzeResult, String> tableRow) {
        String key = null;
        String value = null;
        String ruleId = null;
        for (KeyValue<String, String> singleKeyValue : viewInfoTable) {
            key = (String)singleKeyValue.getKey();
            value = (String)singleKeyValue.getValue();
            if ("issue_desc".equals(key)) {
                tableRow.setValueAt(0, (Object)this.getInterfaceValue(value));
            }
            if (!"rule_id".equals(key)) continue;
            ruleId = this.getInterfaceValue(value);
        }
        return ruleId;
    }

    private ReportLog getReportLogFormRiskRow(TableRow<AnalyzeResult, String> tr) {
        ReportLog reportLog = new ReportLog();
        reportLog.setName(tr.getValueAt(0).toString());
        reportLog.setOccurTime(tr.getValueAt(1).toString());
        return reportLog;
    }

    /*
     * WARNING - void declaration
     */
    private void dateDesc(Map<SingleLogSearchRule, List<Log>> ruleLogResult, Log singLog) {
        ArrayList<List<Log>> allLogList = new ArrayList<List<Log>>();
        allLogList.addAll(ruleLogResult.values());
        ArrayList allLogs = new ArrayList();
        for (List list : allLogList) {
            allLogs.addAll(list);
        }
        Collections.sort(allLogs, ComparatorUtils.LOG_DATE_ASC);
        String string = "";
        for (Log singleLog : allLogs) {
            String tempLogDate;
            String lineInfo = singleLog.getOriginalStr();
            boolean isComLogLine = SearcherUtils.isCommonLogLine(lineInfo);
            if (!isComLogLine || StringUtils.isNULLStr((String)(tempLogDate = StringUtils.findMatchStr((String)lineInfo, (String)"(\\d{4}-[0-1]\\d-[0-3]\\d [0-5]\\d:[0-5]\\d:[0-5]\\d)")))) continue;
            String string2 = tempLogDate;
        }
        String startOperationDate = "";
        boolean isStartOperation = false;
        for (Log singleLog : allLogs) {
            String tempDate = singleLog.getStartOperationDate();
            if (tempDate == null) break;
            isStartOperation = true;
            if (!StringUtils.isNULLStr((String)startOperationDate)) {
                if (StringUtils.isNULLStr((String)tempDate) || startOperationDate.compareTo(tempDate) >= 0) continue;
                startOperationDate = tempDate;
                continue;
            }
            startOperationDate = tempDate;
        }
        if (isStartOperation) {
            singLog.setDate(startOperationDate);
        } else {
            void var5_8;
            singLog.setDate((String)var5_8);
        }
    }

    private List<RecordInfo> getLogLink(Map<SingleLogSearchRule, List<Log>> ruleLogResult, LogRow logRow) {
        ArrayList<List<Log>> allLogList = new ArrayList<List<Log>>();
        allLogList.addAll(ruleLogResult.values());
        ArrayList allLogs = new ArrayList();
        for (List list : allLogList) {
            allLogs.addAll(list);
        }
        ArrayList<RecordInfo> arrayList = new ArrayList<RecordInfo>();
        for (Log singlelog : allLogs) {
            File logFile = new File(singlelog.getLogPath());
            String tmpReportPath = String.valueOf(logRow.getReportTmpFile()) + File.separator + "data" + File.separator + "detail" + File.separator + "files";
            String tmpFileName = "";
            tmpFileName = logFile.getAbsolutePath().contains("InfoAnalyzer_LogSrcDir") ? logFile.getAbsolutePath().replace(SearcherUtils.getSameStr(logFile.getAbsolutePath(), String.valueOf(SearcherUtils.getLogPath(logRow.getLogDeCompressDir().getDeDeCompressDir()).getAbsolutePath()) + File.separator, 0, 0, 1), "") : logFile.getAbsolutePath().replace(SearcherUtils.getSameStr(logFile.getAbsolutePath(), String.valueOf(SearcherUtils.getLogPath(new File(LoganalyzerContext.getInstance().getIndexFileString())).getAbsolutePath()) + File.separator, 0, 0, 1), "");
            File tmpReportFile = new File(tmpReportPath, tmpFileName);
            if (!tmpReportFile.getParentFile().exists()) {
                FileUtils.createDir((File)tmpReportFile.getParentFile());
                StreamUtils.copyFile((File)new File(singlelog.getLogPath()), (File)tmpReportFile);
                LOGGER.info("copy" + logFile.getName() + "to temp report success" + tmpReportFile.getAbsolutePath());
            }
            singlelog.setLogPath(FileUtil.getFilePath(tmpReportFile));
            RecordInfo recordInfo = new RecordInfo();
            recordInfo.setFilePath(FileUtil.getFilePath(logFile));
            recordInfo.setContent(singlelog.getOriginalStr());
            arrayList.add(recordInfo);
        }
        return arrayList;
    }

    private EventIssue getDetail(AnalyzeResult result, LogRow logRow, Map<SingleLogSearchRule, List<Log>> ruleLogResult) {
        EventIssue detail = new EventIssue();
        String bom = SearcherBomUtils.getInstance().searchBomCode(logRow, result, ruleLogResult);
        for (KeyValue<String, String> keyvalueline : result.getViewInfoTable()) {
            String key = (String)keyvalueline.getKey();
            String value = (String)keyvalueline.getValue();
            if (key.contains("issue_desc")) {
                detail.setName(value);
                continue;
            }
            if (key.contains("root_cause")) {
                detail.setCause(value);
                continue;
            }
            if (key.contains("detail_info")) {
                detail.setBom(bom);
                continue;
            }
            if (key.contains("issue_ver")) {
                detail.setVersion(value);
                continue;
            }
            if (key.contains("action")) {
                detail.setAction(value);
                continue;
            }
            if (key.contains("helphref")) {
                String[] splitResult = SearcherUtils.splitHelpHref(value);
                detail.setCaseHref(splitResult[0]);
                detail.setCaseName(splitResult[1]);
                continue;
            }
            if (!key.contains("prod_list")) continue;
            detail.setModle(value);
        }
        return detail;
    }

    private String getInterfaceValue(String value) {
        String valueDesc = value;
        if (StringUtils.isNULLStr((String)value)) {
            return "";
        }
        Locale loc = LanguageManager.getInstance().getCurrentLanguage();
        boolean isContains = value.contains("##");
        boolean isEqualLanEn = "en".equals(loc.toString());
        boolean isEqualLanZH = "zh_CN".equals(loc.toString());
        if (isContains && isEqualLanEn) {
            valueDesc = value.substring(value.indexOf("##") + 1, value.length());
        } else if (isContains && isEqualLanZH) {
            valueDesc = value.substring(0, value.indexOf("##"));
        }
        return valueDesc;
    }

    @Override
    public void fillEventAndDiagnoseData(Map<SingleLogSearchRule, List<Log>> ruleLogResult, AnalyzeResult result, LogRow logRow, EventInfos eventInfos, DiagnoseInfos diagnoseInfos) {
        if (logRow.isAttempt()) {
            return;
        }
        try {
            this.fillEventData(ruleLogResult, result, logRow, eventInfos);
            this.fillDiagnoseData(ruleLogResult, result, logRow, diagnoseInfos);
        }
        catch (Exception e) {
            LOGGER.error("Reresh event table failed.", (Throwable)e);
        }
    }

    private void fillDiagnoseData(Map<SingleLogSearchRule, List<Log>> ruleLogResult, AnalyzeResult result, LogRow logRow, DiagnoseInfos diagnoseInfos) {
        List<KeyValue<String, String>> viewInfoTable = result.getViewInfoTable();
        DefaultTableRow diagnoseRow = new DefaultTableRow(this.layout.getDiagnoseTableHeaders().length, (Object)new AnalyzeResult(), null);
        String modelPId = "--";
        DiagnoseInfo diagnoseInfo = new DiagnoseInfo();
        for (Map.Entry<SingleLogSearchRule, List<Log>> ruleEntries : ruleLogResult.entrySet()) {
            List<Log> logList = ruleEntries.getValue();
            for (Log log : logList) {
                int logType = log.getType();
                if (logType != 2) {
                    return;
                }
                this.setDiagnose((TableRow<AnalyzeResult, String>)diagnoseRow, log, diagnoseInfo);
                if (StringUtils.isNULLStr((String)log.getpId())) continue;
                String string = modelPId = ModulePIDInfoMap.get(log.getpId()).equals("--") ? log.getpId() : ModulePIDInfoMap.get(log.getpId());
            }
        }
        this.problemDesc(viewInfoTable, (TableRow<AnalyzeResult, String>)diagnoseRow, diagnoseInfo);
        this.linkDiagnoseCell(ruleLogResult, result, logRow, (TableRow<AnalyzeResult, String>)diagnoseRow, modelPId, diagnoseInfo);
        diagnoseInfos.getDetailDiagnoseList().add(diagnoseInfo);
    }

    private void linkDiagnoseCell(Map<SingleLogSearchRule, List<Log>> ruleLogResult, AnalyzeResult result, LogRow logRow, TableRow<AnalyzeResult, String> trw, String modelPId, DiagnoseInfo diagnoseInfo) {
        String detailDesc = ResourceUtil.getString((String)"info.analyze.maindialog.problemtable.detail");
        ShowLogDetailListener detailActionListener = new ShowLogDetailListener((JFrame)((Object)this), result, logRow, LogResultType.DIAGNOSE);
        IsmTableCell.HyperlinkCell detailCell = new IsmTableCell.HyperlinkCell(detailDesc, (ActionListener)detailActionListener);
        trw.setValueAt(4, (Object)detailCell);
        String logDesc = ResourceUtil.getString((String)"info.analyze.maindialog.problemtable.log");
        ShowLogReadListener logListener = new ShowLogReadListener((JFrame)((Object)this), ruleLogResult, result, logRow, LogResultType.DIAGNOSE);
        IsmTableCell.HyperlinkCell logDetailCell = new IsmTableCell.HyperlinkCell(logDesc, (ActionListener)logListener);
        trw.setValueAt(5, (Object)logDetailCell);
        diagnoseInfo.setAnalyzeResult(result);
        diagnoseInfo.setRuleLogResult(ruleLogResult);
        ReportLog reportLog = this.getReportLogFormDiagnoseRow(trw, modelPId);
        reportLog.setDetail(this.getDetail(result, logRow, ruleLogResult));
        reportLog.setRecordInfos(this.getLogLink(ruleLogResult, logRow));
        logRow.addDiagnoseInfoLogs(reportLog);
    }

    private void problemDesc(List<KeyValue<String, String>> viewInfoTable, TableRow<AnalyzeResult, String> diagnoseRow, DiagnoseInfo diagnoseInfo) {
        for (KeyValue<String, String> singleKeyValue : viewInfoTable) {
            String key = (String)singleKeyValue.getKey();
            String value = (String)singleKeyValue.getValue();
            if (!"issue_desc".equals(key)) continue;
            diagnoseRow.setValueAt(0, (Object)this.getInterfaceValue(value));
            diagnoseInfo.setIssueDesc(this.getInterfaceValue(value));
        }
    }

    private void fillEventData(Map<SingleLogSearchRule, List<Log>> ruleLogResult, AnalyzeResult result, LogRow logRow, EventInfos eventInfos) {
        List<KeyValue<String, String>> viewInfoTable = result.getViewInfoTable();
        DefaultTableRow tar = new DefaultTableRow(this.layout.getEventTableHeaders().length, (Object)new AnalyzeResult(), null);
        EventInfo eventInfo = new EventInfo();
        for (Map.Entry<SingleLogSearchRule, List<Log>> ruleEntries : ruleLogResult.entrySet()) {
            List<Log> logList = ruleEntries.getValue();
            for (Log log : logList) {
                int logType = log.getType();
                if (logType == 2) {
                    return;
                }
                this.setEventData((TableRow<AnalyzeResult, String>)tar, log, eventInfo);
            }
        }
        String key = null;
        String value = null;
        for (KeyValue<String, String> singleKeyValue : viewInfoTable) {
            key = (String)singleKeyValue.getKey();
            value = (String)singleKeyValue.getValue();
            if (!"issue_desc".equals(key)) continue;
            tar.setValueAt(1, (Object)this.getInterfaceValue(value));
            eventInfo.setIssueDesc(this.getInterfaceValue(value));
        }
        this.linkEventCell(ruleLogResult, result, logRow, (TableRow<AnalyzeResult, String>)tar, eventInfo);
        eventInfos.getDetailEventList().add(eventInfo);
    }

    private void linkEventCell(Map<SingleLogSearchRule, List<Log>> ruleLogResult, AnalyzeResult result, LogRow logRow, TableRow<AnalyzeResult, String> tabr, EventInfo eventInfo) {
        String detailDesc = ResourceUtil.getString((String)"info.analyze.maindialog.problemtable.detail");
        ShowLogEventDetailListener detailActionListener = new ShowLogEventDetailListener((JFrame)((Object)this), result, ruleLogResult, logRow);
        IsmTableCell.HyperlinkCell detailCell = new IsmTableCell.HyperlinkCell(detailDesc, (ActionListener)detailActionListener);
        tabr.setValueAt(6, (Object)detailCell);
        String logDesc = ResourceUtil.getString((String)"info.analyze.maindialog.problemtable.log");
        ShowLogReadListener logListener = new ShowLogReadListener((JFrame)((Object)this), ruleLogResult, result, logRow, LogResultType.ALARM);
        IsmTableCell.HyperlinkCell logDetailCell = new IsmTableCell.HyperlinkCell(logDesc, (ActionListener)logListener);
        tabr.setValueAt(7, (Object)logDetailCell);
        eventInfo.setRuleLogResult(ruleLogResult);
        eventInfo.setAnalyzeResult(result);
        ReportLog reportLog = this.getReportLogFormAlarmRow(tabr);
        reportLog.setDetail(this.getDetail(result, logRow, ruleLogResult));
        reportLog.setRecordInfos(this.getLogLink(ruleLogResult, logRow));
        logRow.addAlarmInfoLogs(reportLog);
    }

    private ReportLog getReportLogFormAlarmRow(TableRow<AnalyzeResult, String> tabrw) {
        ReportLog reportLog = new ReportLog();
        reportLog.setLevel(tabrw.getValueAt(0).toString());
        reportLog.setName(tabrw.getValueAt(1).toString());
        reportLog.setId(tabrw.getValueAt(2).toString());
        reportLog.setSequence(tabrw.getValueAt(3).toString());
        reportLog.setOccurTime(tabrw.getValueAt(4).toString());
        reportLog.setRecoverTime(tabrw.getValueAt(5).toString());
        return reportLog;
    }

    private ReportLog getReportLogFormDiagnoseRow(TableRow<AnalyzeResult, String> tarow, String modelPId) {
        ReportLog reportLog = new ReportLog();
        reportLog.setName(tarow.getValueAt(0).toString());
        reportLog.setId(tarow.getValueAt(1).toString());
        reportLog.setSequence(tarow.getValueAt(2).toString());
        reportLog.setOccurTime(tarow.getValueAt(3).toString());
        reportLog.setModuleName(modelPId);
        return reportLog;
    }

    private void setEventData(TableRow<AnalyzeResult, String> tr2, Log log, EventInfo eventInfo) {
        String alarmLevel = log.getLevel();
        tr2.setValueAt(0, (Object)SearcherUtils.alarmLevel(alarmLevel));
        eventInfo.setAlarmLevel(SearcherUtils.alarmLevelI18n(alarmLevel));
        tr2.setValueAt(2, (Object)log.getId());
        eventInfo.setEventId(log.getId());
        tr2.setValueAt(3, (Object)log.getSequence());
        eventInfo.setSequenceNo(log.getSequence());
        tr2.setValueAt(4, (Object)log.getDate());
        eventInfo.setCreateDate(log.getDate());
        String recoveredTime = log.getRecoveredLocalTime();
        if (recoveredTime.equals("None")) {
            tr2.setValueAt(5, (Object)"--");
            eventInfo.setRecoveredLocalTime("--");
        } else {
            tr2.setValueAt(5, (Object)recoveredTime);
            eventInfo.setRecoveredLocalTime(recoveredTime);
        }
    }

    private void setDiagnose(TableRow<AnalyzeResult, String> diagnoseRow, Log log, DiagnoseInfo diagnoseInfo) {
        diagnoseRow.setValueAt(1, (Object)log.getId());
        diagnoseInfo.setDiagnoseId(log.getId());
        diagnoseRow.setValueAt(2, (Object)log.getSequence());
        diagnoseInfo.setSequenceNo(log.getSequence());
        diagnoseRow.setValueAt(3, (Object)log.getDate());
        diagnoseInfo.setCreateDate(log.getDate());
    }

    @Override
    public void doRefreshProcessMessage(List<ExecuteResult> resultMsgList, LogRow logRow) {
        if (this.layout.isSelectRow(logRow) && !logRow.isAttempt()) {
            SwingUtilities.invokeLater(new UiRefresher.ResultListRefresher(resultMsgList, this.layout));
        }
    }

    @Override
    public void doRefreshProcessEvent(List<ExecuteResult> resultEventList, LogRow logRow) {
        if (this.layout.isSelectRow(logRow) && !logRow.isAttempt()) {
            UiRefresher.ResultListRefresher refresher = new UiRefresher.ResultListRefresher(resultEventList, this.layout);
            SwingUtilities.invokeLater(refresher);
        }
    }

    @Override
    public void doRemoveTable(Callable<Object> serviceTask) {
        SwingUtilities.invokeLater(new UiRefresher.DataRemover(serviceTask, this.layout));
    }

    private void initListener() {
        this.addWindowListener(new UiRefresher.WindowCloser());
    }

    public void doHelpActionWork() {
        String workDir = ApplicationContext.getInstance().getWorkPath();
        File helpFilePath = new File(String.valueOf(workDir) + File.separator + ApplicationContext.getInstance().getHelpPath());
        File helpFile = null;
        helpFile = LanguageManager.getInstance().getCurrentLanguage().equals(Locale.CHINA) ? new File(helpFilePath, HELP_NAME_ZH) : new File(helpFilePath, HELP_NAME_EN);
        ToolLoggerFactory.getLogger(FileUtils.class).debug("explorer help file:" + helpFile.getName());
        if (!helpFile.exists()) {
            if (ApplicationContext.getInstance().isJunit()) {
                return;
            }
            DialogUtils.showErrorDialog((Window)((Object)this), (String)ResourceUtil.getString((String)"info.analyze.errordialog.messagename"));
        } else {
            OSCmdUtils.explorerFile((File)helpFile);
        }
    }

    public void initTmpFiles() {
        String tempFilePath = SearchConstant.getInstant().getTemp();
        File indexTmpDir = new File(tempFilePath, "infoAnalyzerIndexDir");
        SearcherUtils.deleteTempFile(indexTmpDir);
    }

    void exportReport(LogRow lr) throws ToolException, IOException {
        this.reportFile = this.logworktaker.doReport(lr);
        if (this.reportFile.equals("ERROR")) {
            lr.analyzeInterruptedFromAnError("info.nanlyze.tabel.type.stopped");
        }
    }

    protected void deleteTmp(LogRow row1) {
        String filePath = String.valueOf(row1.getReportTmpFile()) + File.separator + "data" + File.separator + "detail" + File.separator + "files";
        FileUtils.clearDir((String)filePath);
        FileUtils.createDir((String)filePath);
    }

    public void dispose() {
        this.handleDispose();
    }

    private void handleDispose() {
        if (this.action) {
            AnalyzeUserOpService.stopAnalyzeRecord(this.row);
        }
        AnalyzeUserOpService.saveAnalyzeUserOpData();
        String keepTempValue = String.valueOf(HibernateContainer.getInstance().get((Object)TEMPSTATE_DEFAULT_ID));
        String result = keepTempValue.equals("null") ? "false" : keepTempValue;
        boolean iskeep = Boolean.valueOf(result);
        if (TEMP_PATH_FILE.exists() && !Boolean.valueOf(iskeep).booleanValue()) {
            AsyncExcutor.execute((JFrame)((Object)MainLogAnaDialog.getInstance()), (String)ResourceUtil.getString((String)"info.analyze.prompt.data.cleaning"), (int)300, (Callable[])new Callable[]{new Callable<Object>(){

                @Override
                public Object call() {
                    FileUtils.deleteAllInFolder((String)(String.valueOf(ApplicationContext.getInstance().getWorkPath()) + File.separator + "tmp" + File.separator + "report"));
                    MainLogAnaDialog.this.deleteAllTempFile();
                    return true;
                }
            }});
        }
        LoganalyzerContext.getInstance().fireToolStopped();
    }

    public void deleteAllTempFile() {
        String pathString = StreamUtils.readStringFormFile((File)TEMP_PATH_FILE).trim();
        String[] allPath = pathString.split(NEW_LINE);
        TreeSet<String> pathSet = new TreeSet<String>();
        int pathNum = 0;
        while (pathNum < allPath.length) {
            pathSet.add(allPath[pathNum].trim());
            ++pathNum;
        }
        for (String path : pathSet) {
            File[] fileList = new File(path).listFiles();
            if (fileList == null) continue;
            File[] fileArray = fileList;
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                File filePath = fileArray[n2];
                if (MainLogAnaDialog.checkSelectFile(filePath.getAbsolutePath())) {
                    MainLogAnaDialog.deleteFile(filePath);
                }
                ++n2;
            }
        }
        if (TEMP_PATH_FILE.delete()) {
            LOGGER.info("delete dir fail. ");
        }
    }

    public static void deleteFile(File file) {
        if (file.isDirectory()) {
            try {
                File[] fileList;
                File[] fileArray = fileList = FileListFileFilterUtils.fileList(file, null);
                int n = fileList.length;
                int n2 = 0;
                while (n2 < n) {
                    File tmpFile = fileArray[n2];
                    MainLogAnaDialog.deleteFile(tmpFile);
                    ++n2;
                }
                if (!file.delete()) {
                    ToolLoggerFactory.getLogger(FileUtils.class).error("Delete file error" + file.getName());
                }
            }
            catch (Exception e) {
                LOGGER.debug("Delete file error:", (Throwable)e);
            }
        } else if (!file.delete()) {
            ToolLoggerFactory.getLogger(FileUtils.class).error("Delete file error");
        }
    }

    void clearData(LogRow lgr) {
        LoganalyzerContext.getInstance().getEvents().clear();
        this.layout.getMessageDetailList().setModel(lgr.getListModel());
        if (this.action) {
            this.layout.getPackageTable().clearSelection();
            int index = 0;
            int tmp = 0;
            while (tmp < this.layout.getPackageTable().getAllRows().size()) {
                if (lgr.getSelectRow() == this.layout.getPackageTable().convertRowIndexToModel(tmp)) {
                    index = tmp;
                }
                ++tmp;
            }
            this.layout.getPackageTable().addRowSelectionInterval(index, index);
        }
        LoganalyzerContext.getInstance().setHasDoAnalyzeEvent(true);
        this.layout.getSearchedProTableModel().removeAll();
        LoganalyzerContext.getInstance().setHasDoAnalyzeLog(true);
    }

    void componentDisable() {
        if (!AnalysisMode.isAutoAnalysisMode()) {
            this.layout.getBrowsLogBtn().setEnabled(false);
            this.layout.getAnalyzeBtn().setEnabled(false);
            this.layout.getSetDateLink().setEnabled(false);
            this.layout.getOutputLink().setEnabled(false);
            this.layout.getSetDirButton().setEnabled(false);
            this.layout.getPackageTable().clearSelection();
        }
    }

    void componentEnable() {
        if (!AnalysisMode.isAutoAnalysisMode()) {
            this.layout.getBrowsLogBtn().setEnabled(true);
            this.layout.getAnalyzeBtn().setEnabled(true);
            this.layout.getSetDateLink().setEnabled(true);
            this.layout.getSetDirButton().setEnabled(true);
            this.layout.getOutputLink().setEnabled(true);
        }
    }

    void setLoading(LogRow lr2) {
        ImageIcon icon = ResourceUtil.getImage((String)"loading.gif");
        icon.setImageObserver((ImageObserver)((Object)this));
        TableRow tableRow = lr2.getRow();
        IsmTableCell.IconCell cell = new IsmTableCell.IconCell((Icon)icon, ResourceUtil.getString((String)"info.nanlyze.tabel.type.doing"));
        tableRow.setValueAt(3, (Object)cell);
        lr2.setRow(tableRow);
        lr2.setStauts("info.nanlyze.tabel.type.doing");
    }

    void setCreateReport(LogRow lr3) {
        ImageIcon icon = ResourceUtil.getImage((String)"loading.gif");
        icon.setImageObserver((ImageObserver)((Object)this));
        IsmTableCell.IconCell cell = new IsmTableCell.IconCell((Icon)icon, ResourceUtil.getString((String)"info.nanlyze.tabel.type.report"));
        lr3.getRow().setValueAt(3, (Object)cell);
        lr3.setStauts("info.nanlyze.tabel.type.report");
    }

    public void setWait(List<LogRow> rows) {
        for (LogRow lr : rows) {
            TableRow tableRow = lr.getRow();
            tableRow.setValueAt(3, (Object)ResourceUtil.getString((String)"info.nanlyze.tabel.type.wait"));
            lr.setStauts("info.nanlyze.tabel.type.wait");
            this.changeRuleName(lr);
        }
    }

    private void changeRuleName(LogRow lr) {
        this.exitEdit();
        if (!(lr.getRow().getValueAt(1) instanceof String)) {
            IsmTableCell.ComboBoxCell cell = (IsmTableCell.ComboBoxCell)lr.getRow().getValueAt(1);
            lr.getRow().setValueAt(1, (Object)cell.toString());
            IsmTableCell.ComboBoxCell verCell = (IsmTableCell.ComboBoxCell)lr.getRow().getValueAt(2);
            lr.getRow().setValueAt(2, (Object)verCell.toString());
            lr.setTypeGetByCell(true);
        }
    }

    public boolean isFinish() {
        return this.finish;
    }

    public void setFinish(boolean finish) {
        this.finish = finish;
    }

    public boolean isAction() {
        return this.action;
    }

    public void refreshDetailList(boolean isRefresh) {
        if (!isRefresh) {
            return;
        }
        this.layout.getMessageDetailList().setModel(new DefaultListModel());
        this.layout.getSearchedProTableModel().removeAll();
        int[] selectRows = this.layout.getPackageTable().getSelectedRows();
        if (!AnalysisMode.isAutoAnalysisMode()) {
            this.setStopBtnEnable(selectRows);
        }
        if (selectRows.length != 1) {
            this.layout.getScanReportBtn().setEnabled(false);
            this.layout.getAdvancedAnalyzeButton().setEnabled(false);
            SearcherUtils.doRefreshDefaultArea(MainLogAnaDialog.getInstance());
            Set<LogRow> rows = LoganalyzerContext.getInstance().getCurLogRows();
            for (LogRow logRow : rows) {
                logRow.clearLogFaultTree();
            }
            return;
        }
        this.setSelectedLogRowBtnStatus();
    }

    private void setSelectedLogRowBtnStatus() {
        LogRow logRow = null;
        Set<LogRow> rows = LoganalyzerContext.getInstance().getCurLogRows();
        for (LogRow temp : rows) {
            if (this.layout.isSelectRow(temp)) {
                logRow = temp;
                continue;
            }
            temp.clearLogFaultTree();
        }
        if (logRow == null) {
            return;
        }
        DefaultListModel<?> listModel = logRow.getListModel();
        if (listModel == null) {
            this.layout.getMessageDetailList().setModel(new DefaultListModel());
        } else {
            this.layout.getMessageDetailList().setModel(logRow.getListModel());
        }
        this.refreshScanReportBtn(logRow);
        this.layout.getSearchedProTableModel().addRows(logRow.getDetailList());
        SearcherUtils.doRefreshFaultTreeArea(mainLogAnaDialogObject, logRow);
    }

    private void setStopBtnEnable(int[] selectRows) {
        int[] nArray = selectRows;
        int n = selectRows.length;
        int n2 = 0;
        while (n2 < n) {
            int selectRow = nArray[n2];
            for (LogRow logRow : LoganalyzerContext.getInstance().getCurLogRows()) {
                boolean enbale = this.isStopBtnEnable(selectRow, logRow);
                if (!enbale) continue;
                this.layout.getStopButton().setEnabled(enbale);
                return;
            }
            ++n2;
        }
        this.layout.getStopButton().setEnabled(false);
    }

    void refreshScanReportBtn(LogRow logRow) {
        if (logRow == null || logRow.getRow() == null) {
            this.layout.getScanReportBtn().setEnabled(false);
            this.layout.getAdvancedAnalyzeButton().setEnabled(false);
            return;
        }
        if (!this.layout.isSelectRow(logRow)) {
            return;
        }
        if (logRow.getRow().getValueAt(3) == null) {
            this.layout.getScanReportBtn().setEnabled(false);
            this.layout.getAdvancedAnalyzeButton().setEnabled(false);
        } else {
            this.layout.getScanReportBtn().setEnabled(this.isAllowScanReport(logRow));
            this.layout.getAdvancedAnalyzeButton().setEnabled(ResourceUtil.getString((String)"info.nanlyze.tabel.type.done").equals(logRow.getRow().getValueAt(3).toString()));
        }
    }

    public boolean isAllowScanReport(LogRow lr) {
        return ResourceUtil.getString((String)"info.nanlyze.tabel.type.done").equals(lr.getRow().getValueAt(3).toString()) && lr.isResultNotEmpty();
    }

    private void openReport() {
        LogRow logRow = null;
        Set<LogRow> rows = LoganalyzerContext.getInstance().getCurLogRows();
        for (LogRow temp : rows) {
            if (!this.layout.isSelectRow(temp)) continue;
            logRow = temp;
            break;
        }
        if (logRow != null) {
            File report = new File(logRow.getReportTmpFile());
            if (!report.exists()) {
                DialogUtils.showInfoDialog((Frame)((Object)this), (String)ResourceUtil.getString((String)"info.analyze.report.no.package"));
                return;
            }
            OSCmdUtils.explorerFile((File)new File(logRow.getReportTmpFile(), "index.html"));
        }
    }

    private boolean isStopBtnEnable(int selectRow, LogRow logRow) {
        if (logRow.getSelectRow() == this.layout.getPackageTable().convertRowIndexToModel(selectRow) && (!(logRow.getRow().getValueAt(3) instanceof String) || logRow.getRow().getValueAt(3).toString().equals(ResourceUtil.getString((String)"info.nanlyze.tabel.type.wait")))) {
            return !logRow.isStop();
        }
        return false;
    }

    public SettingDirDialog getSettingDirDialog() {
        return this.settingDirDialog;
    }

    public void autoAnalyzeBtnDisable() {
        this.layout.getBrowsLogBtn().setEnabled(false);
        this.layout.getAnalyzeBtn().setEnabled(false);
        this.layout.getSetDateLink().setEnabled(false);
        this.layout.getOutputLink().setEnabled(false);
        this.layout.getSetDirButton().setEnabled(false);
        this.layout.getRemoveButton().setEnabled(false);
        this.layout.getStopButton().setEnabled(true);
        this.layout.getPackageTable().clearSelection();
    }

    public void autoAnalyzeBtnEnable() {
        this.layout.getBrowsLogBtn().setEnabled(true);
        this.layout.getAnalyzeBtn().setEnabled(true);
        this.layout.getSetDateLink().setEnabled(true);
        this.layout.getSetDirButton().setEnabled(true);
        this.layout.getOutputLink().setEnabled(true);
        this.layout.getRemoveButton().setEnabled(true);
        this.layout.getStopButton().setEnabled(false);
    }
}

