/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.util;

import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckLabelPanel;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeCellEditor;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNodeRenderer;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CheckBoxTree
extends JTree {
    private static final long serialVersionUID = 7804675481950571764L;
    private CheckTreeNodeRenderer checkTreeNodeRenderer;
    private CheckTreeNode rootNode;

    public CheckBoxTree(CheckTreeNode rootNode, boolean hasCheckBox) {
        super((TreeNode)rootNode, true);
        this.rootNode = rootNode;
        this.installRenderer(hasCheckBox);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public String getToolTipText(MouseEvent ev) {
        CheckTreeNode node;
        String tips;
        if (ev == null) {
            return null;
        }
        TreePath path = this.getPathForLocation(ev.getX(), ev.getY());
        if (path != null && (tips = (node = (CheckTreeNode)path.getLastPathComponent()).getToolTips()) != null && !tips.isEmpty()) {
            return tips;
        }
        return null;
    }

    private void installRenderer(boolean hasCheckBox) {
        this.checkTreeNodeRenderer = new CheckTreeNodeRenderer(hasCheckBox);
        this.setCellRenderer((TreeCellRenderer)this.checkTreeNodeRenderer);
        this.setCheckTreeNodeRenderer(this.checkTreeNodeRenderer);
        CheckTreeCellEditor cellEditor = new CheckTreeCellEditor(new CheckLabelPanel(hasCheckBox));
        this.setCellEditor((TreeCellEditor)cellEditor);
        this.setEditable(true);
        this.setRootVisible(false);
        this.setEnabled(true);
    }

    @Override
    public JToolTip createToolTip() {
        JToolTip tip = new JToolTip();
        return tip;
    }

    public CheckTreeNodeRenderer getCheckTreeNodeRenderer() {
        return this.checkTreeNodeRenderer;
    }

    public void setCheckTreeNodeRenderer(CheckTreeNodeRenderer checkTreeNodeRenderer) {
        this.checkTreeNodeRenderer = checkTreeNodeRenderer;
    }

    public void expandAll(boolean isExpanded) {
        CheckTreeNode root = (CheckTreeNode)this.getModel().getRoot();
        if (root == null) {
            return;
        }
        this.expandPath(new TreePath(root), isExpanded);
    }

    public CheckTreeNode getRootNode() {
        return this.rootNode;
    }

    private void expandPath(TreePath parent, boolean expand) {
        CheckTreeNode node = (CheckTreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration e = node.children();
            while (e.hasMoreElements()) {
                CheckTreeNode n = (CheckTreeNode)e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandPath(path, expand);
            }
        }
        if (expand) {
            this.expandPath(parent);
        } else {
            this.collapsePath(parent);
        }
    }

    public Set<CheckTreeNode> getAllSelectedNodes(CheckTreeNode rootNode1) {
        HashSet<CheckTreeNode> allNodes = new HashSet<CheckTreeNode>();
        if (rootNode1.getChildCount() >= 0) {
            Enumeration e = rootNode1.children();
            while (e.hasMoreElements()) {
                CheckTreeNode n = (CheckTreeNode)e.nextElement();
                if (n.isSelected()) {
                    allNodes.add(n);
                }
                allNodes.addAll(this.getAllSelectedNodes(n));
            }
        }
        return allNodes;
    }

    public Set<CheckTreeNode> getAllNodes(CheckTreeNode rootNode1) {
        HashSet<CheckTreeNode> allNodes = new HashSet<CheckTreeNode>();
        if (rootNode1.getChildCount() >= 0) {
            Enumeration e = rootNode1.children();
            while (e.hasMoreElements()) {
                CheckTreeNode n = (CheckTreeNode)e.nextElement();
                allNodes.add(n);
                allNodes.addAll(this.getAllNodes(n));
            }
        }
        return allNodes;
    }

    public CheckTreeNode getTreeNodeByUserObj(Object userObj) {
        Set<CheckTreeNode> allNode = this.getAllNodes((CheckTreeNode)this.getModel().getRoot());
        for (CheckTreeNode node : allNode) {
            if (userObj != node.getUserObject()) continue;
            return node;
        }
        return null;
    }
}

