/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.util;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.loganalyzer.entity.analyze.Event;
import com.huawei.ism.tool.loganalyzer.entity.analyze.FileSearchResult;
import com.huawei.ism.tool.loganalyzer.entity.analyze.ReportLog;
import com.huawei.ism.tool.loganalyzer.entity.log.Log;
import java.io.File;
import java.util.Comparator;

public class ComparatorUtils {
    public static final Comparator<Event> DOANALYZEEVENTS_EVENT_TIME_SORT = new Comparator<Event>(){

        @Override
        public int compare(Event o1, Event o2) {
            long otherTime = StringUtils.parseDate2Long((String)o2.getLocalTime(), (String)"yyyy-MM-dd HH:mm:ss");
            long thisTime = StringUtils.parseDate2Long((String)o1.getLocalTime(), (String)"yyyy-MM-dd HH:mm:ss");
            if (thisTime > otherTime) {
                return 1;
            }
            if (thisTime < otherTime) {
                return -1;
            }
            return 0;
        }
    };
    public static final Comparator<File> LOADLOGTIME_FILE_TIME_SORT = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            String time1String = StringUtils.findMatchStr((String)o1.getName(), (String)"((\\d{4})([0-1]\\d)([0-3]\\d)([0-5]\\d)([0-5]\\d)([0-5]\\d))");
            String time2String = StringUtils.findMatchStr((String)o2.getName(), (String)"((\\d{4})([0-1]\\d)([0-3]\\d)([0-5]\\d)([0-5]\\d)([0-5]\\d))");
            long time1 = 0L;
            long time2 = 0L;
            if (!StringUtils.isNULLStr((String)time1String)) {
                time1 = Long.parseLong(time1String);
            }
            if (!StringUtils.isNULLStr((String)time2String)) {
                time2 = Long.parseLong(time2String);
            }
            if (time1 - time2 > 0L) {
                return 1;
            }
            if (time1 - time2 < 0L) {
                return -1;
            }
            return 0;
        }
    };
    public static final Comparator<FileSearchResult> SEARCH_FILE_TIME_SORT = new Comparator<FileSearchResult>(){

        @Override
        public int compare(FileSearchResult o1, FileSearchResult o2) {
            String time1String = StringUtils.findMatchStr((String)o1.getFile().getName(), (String)"((\\d{4})([0-1]\\d)([0-3]\\d)([0-5]\\d)([0-5]\\d)([0-5]\\d))");
            String time2String = StringUtils.findMatchStr((String)o2.getFile().getName(), (String)"((\\d{4})([0-1]\\d)([0-3]\\d)([0-5]\\d)([0-5]\\d)([0-5]\\d))");
            long time1 = 0L;
            long time2 = 0L;
            if (!StringUtils.isNULLStr((String)time1String)) {
                time1 = Long.parseLong(time1String);
            }
            if (!StringUtils.isNULLStr((String)time2String)) {
                time2 = Long.parseLong(time2String);
            }
            if (time1 - time2 > 0L) {
                return 1;
            }
            if (time1 - time2 < 0L) {
                return -1;
            }
            return 0;
        }
    };
    public static final Comparator<Log> LOG_DATE_ASC = new Comparator<Log>(){

        @Override
        public int compare(Log o1, Log o2) {
            String o1LineStr = o1.getOriginalStr();
            String o2LineStr = o2.getOriginalStr();
            String o1DateStr = StringUtils.findMatchStr((String)o1LineStr, (String)"(\\d{4}-[0-1]\\d-[0-3]\\d [0-5]\\d:[0-5]\\d:[0-5]\\d)");
            String o2DateStr = StringUtils.findMatchStr((String)o2LineStr, (String)"(\\d{4}-[0-1]\\d-[0-3]\\d [0-5]\\d:[0-5]\\d:[0-5]\\d)");
            long time1 = 0L;
            long time2 = 0L;
            if (!StringUtils.isNULLStr((String)o1DateStr)) {
                time1 = StringUtils.parseDate2Long((String)o1DateStr, (String)"yyyy-MM-dd HH:mm:ss");
            }
            if (!StringUtils.isNULLStr((String)o2DateStr)) {
                time2 = StringUtils.parseDate2Long((String)o2DateStr, (String)"yyyy-MM-dd HH:mm:ss");
            }
            if (time1 - time2 > 0L) {
                return 1;
            }
            if (time1 - time2 < 0L) {
                return -1;
            }
            return 0;
        }
    };
    public static final Comparator<ReportLog> REPORTLOG_SEQUENCE_ASC = new Comparator<ReportLog>(){

        @Override
        public int compare(ReportLog rep1, ReportLog rep2) {
            return rep2.getSequence().compareTo(rep1.getSequence());
        }
    };
}

