/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.util;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.loganalyzer.util.OSCmdUtils;
import java.io.File;
import java.io.IOException;

public class FileUtils {
    private static final int DEFAULT_CMD_TIMEOUT = 6;

    public static void setFilePermissions(File file) {
        if (file == null || !file.exists()) {
            ToolLoggerFactory.getLogger(FileUtils.class).debug("Set file permissions failed.");
            return;
        }
        String path = "";
        try {
            path = file.getCanonicalPath();
            String userAccount = ApplicationContext.getInstance().getCurToolkitUser();
            String allUserGroup = OSCmdUtils.executeCmd("net localgroup");
            int start = allUserGroup.indexOf("*Administrators");
            int end = allUserGroup.lastIndexOf("*Users");
            if (start != -1 && end != -1) {
                allUserGroup = allUserGroup.substring(allUserGroup.indexOf("*Administrators"), allUserGroup.lastIndexOf("*Users") + 6);
                String[] groups = allUserGroup.split("\r\n");
                FileUtils.setPermissions(path, userAccount, groups);
                ToolLoggerFactory.getLogger(FileUtils.class).debug("Set file permissions success!");
            }
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(FileUtils.class).debug("cannonical path if failed", (Throwable)e);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(FileUtils.class).debug("catch exception when setPermissions", (Throwable)e);
        }
    }

    private static void setPermissions(String path, String userAccount, String[] groups) {
        OSCmdUtils.executeCmd("icacls \"" + path + "\" /inheritance:d");
        String[] stringArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if ((string = string.replace("*", "").trim()).contains("user") || string.contains("guest") || string.contains("User") || string.contains("Guest")) {
                String s = "icacls \"" + path + "\" /remove:g \"" + string + "\"";
                OSCmdUtils.executeCmd(s);
            }
            ++n2;
        }
        OSCmdUtils.executeCmd("icacls \"" + path + "\" /remove:g \"Authenticated users\"");
        OSCmdUtils.executeCmd("icacls \"" + path + "\" /grant Administrators:f");
        OSCmdUtils.executeCmd("icacls \"" + path + "\" /grant china\\" + userAccount + ":f");
        OSCmdUtils.executeCmd("icacls \"" + path + "\" /grant " + userAccount + ":f");
    }
}

