/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.util;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.logic.pkgdecompress.ExecuteCmdProcess;
import java.io.IOException;
import java.text.Normalizer;
import org.slf4j.Logger;

public class OSCmdUtils {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(OSCmdUtils.class);
    private static final int DEFAULT_CMD_TIMEOUT = 30;

    public static String executeCmd(String cmd) {
        return OSCmdUtils.executeCmd(cmd, 30);
    }

    public static String executeCmd(String cmd, int timeoutSecond) {
        cmd = Normalizer.normalize(cmd, Normalizer.Form.NFKC);
        String result = "";
        try {
            Process pro = OSCmdUtils.createCmdProcess(cmd);
            ExecuteCmdProcess streamClear = new ExecuteCmdProcess(pro);
            result = streamClear.call();
        }
        catch (Exception e1) {
            LOGGER.error("Clear cmd output stream error :", (Throwable)e1);
        }
        return result;
    }

    public static Process createCmdProcess(String ... cmd) throws IOException {
        if (cmd.length > 1) {
            return Runtime.getRuntime().exec(cmd);
        }
        return Runtime.getRuntime().exec(cmd[0]);
    }
}

