/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.util;

import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class RegexStrTranferUtil {
    private static final Map<String, String> REG_EXP_CHAR_MAP = new HashMap<String, String>();
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(RegexStrTranferUtil.class);

    static {
        REG_EXP_CHAR_MAP.put("+", "\\+");
        REG_EXP_CHAR_MAP.put("-", "\\-");
        REG_EXP_CHAR_MAP.put("^", "\\^");
        REG_EXP_CHAR_MAP.put("$", "\\$");
        REG_EXP_CHAR_MAP.put("(", "\\(");
        REG_EXP_CHAR_MAP.put(")", "\\)");
        REG_EXP_CHAR_MAP.put("[", "\\[");
        REG_EXP_CHAR_MAP.put("]", "\\]");
        REG_EXP_CHAR_MAP.put("{", "\\{");
        REG_EXP_CHAR_MAP.put("}", "\\}");
        REG_EXP_CHAR_MAP.put(".", "\\.");
        REG_EXP_CHAR_MAP.put("*", ".*");
        REG_EXP_CHAR_MAP.put("|", "\\|");
        REG_EXP_CHAR_MAP.put("~", "\\~");
        REG_EXP_CHAR_MAP.put("?", "\\?");
    }

    public static final Pattern transfer(String logKey) {
        try {
            logKey = logKey.replaceAll("^\\*|\\*$", "");
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < logKey.length()) {
                String k = String.valueOf(logKey.charAt(i));
                String val = REG_EXP_CHAR_MAP.get(k);
                sb.append(val != null ? val : k);
                ++i;
            }
            return Pattern.compile(sb.toString());
        }
        catch (Exception e) {
            LOGGER.error("Pattern.compile fail:", (Throwable)e);
            return null;
        }
    }
}

