/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.util;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.entity.analyze.AnalyzeResult;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogRow;
import com.huawei.ism.tool.loganalyzer.entity.config.SingleLogSearchRule;
import com.huawei.ism.tool.loganalyzer.entity.log.Log;
import com.huawei.ism.tool.loganalyzer.util.LoganalyzerContext;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;

public class SearcherBomUtils {
    private static final String DISK_ENCLOSURE = "Disk Enclosure";
    private static final String CONTROLLER_ENCLOSURE = "Controller Enclosure";
    private static final String ENGINE = "Engine";
    private static final String SLOT = "slot";
    private static final String SLOTID = "slot ID";
    private static final String SLOT_ID = "slot-id:";
    private static final String SERIAL_NUM = "serial number";
    private static final String SERIAL_NUM_SER = "serial-number";
    private static final String SN_NUM = " sn ";
    private static final String SN_NUM_SN = "SN:";
    private static final String HORIZONTAL = "--";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SearcherBomUtils.class);
    private static SearcherBomUtils context = new SearcherBomUtils();
    private ConcurrentMap<String, Map<String, String>> allBomCodeMap = LoganalyzerContext.getInstance().getBomCodeConcurrentMap();

    public static SearcherBomUtils getInstance() {
        return context;
    }

    public String searchBomCode(LogRow logRow, AnalyzeResult anaResult, Map<SingleLogSearchRule, List<Log>> ruleLogResult) {
        HashMap<String, String> bomValue = new HashMap<String, String>();
        String original = this.getOriginalInfo(ruleLogResult);
        String bomCode = this.matchBomCode(original, logRow, bomValue);
        String bom = this.getValue(bomCode, bomValue);
        return bom;
    }

    private String getOriginalInfo(Map<SingleLogSearchRule, List<Log>> ruleLogResult) {
        String original = null;
        for (Map.Entry<SingleLogSearchRule, List<Log>> ruleEntries : ruleLogResult.entrySet()) {
            List<Log> logList = ruleEntries.getValue();
            for (Log log : logList) {
                original = log.getDesc();
            }
        }
        return original;
    }

    private String getValue(String bomNum, Map<String, String> bomValue) {
        String diskEnclosureNum = bomValue.get(DISK_ENCLOSURE);
        String diskSlotNum = bomValue.get(SLOTID);
        if (diskEnclosureNum == null || diskSlotNum == null) {
            diskEnclosureNum = HORIZONTAL;
            diskSlotNum = HORIZONTAL;
            bomNum = HORIZONTAL;
        }
        String value = ResourceUtil.getStringWithParams((String)"info.analyze.problemtable.detail.bom", (Object[])new Object[]{diskEnclosureNum, diskSlotNum, bomNum});
        return value;
    }

    private String matchBomCode(String original, LogRow logRow, Map<String, String> bomValue) {
        String bomCodeString;
        block3: {
            bomCodeString = null;
            if (original != null && this.containsIgnoreCase(original, SLOT)) break block3;
            return HORIZONTAL;
        }
        try {
            int leftIndex = original.indexOf(40);
            int rightIndex = original.indexOf(41);
            rightIndex = rightIndex == -1 ? original.length() : rightIndex;
            String originalInfo = original.substring(leftIndex + 1, rightIndex);
            bomCodeString = this.findBomByInfo(logRow, bomValue, originalInfo);
            bomCodeString = bomCodeString == null ? HORIZONTAL : bomCodeString;
        }
        catch (Exception e) {
            LOGGER.error("match bom code is error : " + e);
        }
        return bomCodeString;
    }

    private String getValueByKeyWord(String originalInfo, String keyWrod) {
        String result = null;
        if (originalInfo.contains(keyWrod)) {
            String[] splitByKeyWord = org.apache.commons.lang3.StringUtils.splitByWholeSeparatorPreserveAllTokens((String)originalInfo, (String)keyWrod);
            String[] splitByComma = org.apache.commons.lang3.StringUtils.splitByWholeSeparatorPreserveAllTokens((String)splitByKeyWord[1], (String)",");
            result = splitByComma[0].trim();
        } else if (this.containsIgnoreCase(originalInfo, keyWrod)) {
            String[] splitByKeyWord = org.apache.commons.lang3.StringUtils.splitByWholeSeparatorPreserveAllTokens((String)originalInfo.toLowerCase(Locale.ENGLISH), (String)keyWrod.toLowerCase(Locale.ENGLISH));
            String[] splitByComma = org.apache.commons.lang3.StringUtils.splitByWholeSeparatorPreserveAllTokens((String)splitByKeyWord[1], (String)",");
            result = splitByComma[0].trim().toUpperCase(Locale.ENGLISH);
        }
        if (HORIZONTAL.equals(result)) {
            result = null;
        }
        return result;
    }

    private String findBomByInfo(LogRow logRow, Map<String, String> bomValue, String originalInfo) {
        String diskEnclosureNum = this.getValueByKeyWord(originalInfo, DISK_ENCLOSURE);
        String controllerEnclosureNum = this.getValueByKeyWord(originalInfo, CONTROLLER_ENCLOSURE);
        String engineNum = this.getValueByKeyWord(originalInfo, ENGINE);
        String[] enclosureNum = new String[]{diskEnclosureNum, controllerEnclosureNum, engineNum};
        String enclosureNumResult = this.getEfficValue(enclosureNum);
        bomValue.put(DISK_ENCLOSURE, enclosureNumResult);
        String slotIDNum = this.getValueByKeyWord(originalInfo, SLOTID);
        String slotIdNum = this.getValueByKeyWord(originalInfo, SLOT_ID);
        String slotNum = this.getValueByKeyWord(originalInfo, SLOT);
        String[] slotIdNums = new String[]{slotIDNum, slotIdNum, slotNum};
        String slotIdNumResult = this.getEfficValue(slotIdNums);
        bomValue.put(SLOTID, slotIdNumResult);
        String serialNumber = this.getValueByKeyWord(originalInfo, SERIAL_NUM);
        String seriaNumber = this.getValueByKeyWord(originalInfo, SERIAL_NUM_SER);
        String snNumStr = this.getValueByKeyWord(originalInfo, SN_NUM_SN);
        String snNum = this.getValueByKeyWord(originalInfo, SN_NUM);
        String[] serialNum = new String[]{serialNumber, seriaNumber, snNumStr, snNum};
        String serialNumReslut = this.getEfficValue(serialNum);
        bomValue.put(SERIAL_NUM, serialNumReslut);
        return this.searchBomCode(enclosureNumResult, slotIdNumResult, serialNumReslut, logRow);
    }

    private String getEfficValue(String[] valueStrings) {
        String[] stringArray = valueStrings;
        int n = valueStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string != null) {
                return string;
            }
            ++n2;
        }
        return null;
    }

    private String searchBomCode(String enclosureNum, String slotIdNum, String serialNum, LogRow logRow) {
        boolean enclosureOrSlot;
        String diskEnclosureSlot = String.valueOf(enclosureNum) + "." + slotIdNum;
        boolean bl = enclosureOrSlot = StringUtils.isNULLStr((String)slotIdNum) || StringUtils.isNULLStr((String)enclosureNum);
        if (enclosureOrSlot) {
            return HORIZONTAL;
        }
        Map allBomMap = (Map)this.allBomCodeMap.get(logRow.getLogFile().getAbsolutePath());
        String bomCode = null;
        if (allBomMap != null && (bomCode = (String)allBomMap.get(diskEnclosureSlot)) == null) {
            bomCode = (String)allBomMap.get(serialNum);
        }
        return bomCode;
    }

    private boolean containsIgnoreCase(String source, String containedString) {
        return source.toLowerCase(Locale.ENGLISH).contains(containedString.toLowerCase(Locale.ENGLISH));
    }
}

