/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.util;

import com.huawei.ism.thread.ThreadPoolManager;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.log.LogManager;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;

public class WaitingProgressDialogUtil {
    public static List<?> execute(JFrame parent, String custMsg, int custWidth, Callable<?> ... tasks) {
        return WaitingProgressDialogUtil.execute(new WaitingProgressDialog(parent, custMsg, custWidth), true, 0L, tasks);
    }

    private static List<?> execute(ProgressDialog pd, boolean showBusybox, long timeout, final Callable<?> ... tasks) {
        ProgressDialog progressDialog;
        if (showBusybox) {
            progressDialog = pd;
        } else {
            progressDialog = null;
            pd.dispose();
        }
        ExecutorService executor = ThreadPoolManager.getInstance().getAsyncExcutor();
        Callable taskB = new Callable<List<?>>(){

            @Override
            public List<?> call() throws Exception {
                ArrayList<Object> result = new ArrayList<Object>(0);
                Callable[] callableArray = tasks;
                int n = tasks.length;
                int n2 = 0;
                while (n2 < n) {
                    Callable task = callableArray[n2];
                    try {
                        result.add(task.call());
                    }
                    catch (Throwable ex) {
                        result.add(ex);
                    }
                    ++n2;
                }
                if (progressDialog != null) {
                    WaitingProgressDialogUtil.disposeProgressDialog(progressDialog);
                }
                return result;
            }
        };
        Future future = executor.submit(taskB);
        if (progressDialog != null) {
            progressDialog.setVisible(true);
            progressDialog.toFront();
        }
        List result = new ArrayList(0);
        try {
            result = timeout <= 0L ? (List)future.get() : (List)future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            LogManager.error((Object)"", (Throwable)e);
        }
        if (progressDialog != null) {
            WaitingProgressDialogUtil.disposeProgressDialog(progressDialog);
        }
        return result;
    }

    private static void disposeProgressDialog(final ProgressDialog progressDialog) {
        SwingUtil.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                progressDialog.setVisible(false);
                progressDialog.dispose();
            }
        });
    }

    private static class WaitingProgressDialog
    extends ProgressDialog {
        private static final long serialVersionUID = -56127034106619263L;

        public WaitingProgressDialog(Window parent, String custMizeMsg, int custWidth) {
            super(parent, custMizeMsg, custWidth);
            this.setFocusableWindowState(false);
            this.setFocusable(false);
        }
    }
}

