/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.worktaker.impl;

import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.worktaker.AbstractWorktaker;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogRow;
import com.huawei.ism.tool.loganalyzer.entity.log.LogDeCompressDir;
import com.huawei.ism.tool.loganalyzer.faulttree.decompress.DecompressMain;
import com.huawei.ism.tool.loganalyzer.faulttree.decompress.decompressor.ProcessExitException;
import com.huawei.ism.tool.loganalyzer.faulttree.decompress.threadpool.DiskIsEnoughThread;
import com.huawei.ism.tool.loganalyzer.util.LoganalyzerContext;
import com.huawei.ism.tool.loganalyzer.util.SearchConstant;
import com.huawei.ism.tool.loganalyzer.util.SearcherUtils;
import com.huawei.ism.tool.loganalyzer.worktaker.IDeCompressPkgWorktaker;
import com.huawei.ism.tool.obase.filechooser.HibernateContainer;
import java.io.File;
import java.util.Map;
import java.util.Set;

public class DeCompressPkgWorktakerImpl
extends AbstractWorktaker
implements IDeCompressPkgWorktaker {
    private static final File TEMP_PATH_FILE = new File(ApplicationContext.getInstance().getTmpPath(), "all_TempDecompress_Dir.txt");

    @Override
    public LogDeCompressDir convertLogDir(LogRow row, LogDeCompressDir logDeCompressDir, DiskIsEnoughThread isEnough) {
        File srcFile = row.getLogFile();
        if (srcFile.isDirectory()) {
            logDeCompressDir.setDeDeCompressDir(srcFile);
            return logDeCompressDir;
        }
        File srcTempDir = new File(SearchConstant.getInstant().getTemp(), "InfoAnalyzer_LogSrcDir");
        String dirName = String.valueOf(System.nanoTime());
        String fileName = srcFile.getName();
        StringBuffer strb = new StringBuffer(dirName);
        strb.append("_");
        strb.append(fileName.subSequence(0, fileName.lastIndexOf(46)));
        dirName = strb.toString().trim();
        File logDir = new File(srcTempDir, dirName);
        logDeCompressDir.setDeDeCompressRandomDir(logDir);
        Map<String, File> logTempDir = LoganalyzerContext.getInstance().getLogTempMap();
        logTempDir.put(srcFile.getName(), logDir);
        Set<String> tempDir = LoganalyzerContext.getInstance().getTempFiles();
        tempDir.add(SearchConstant.getInstant().getTemp());
        SearcherUtils.writeTempPathToFile(srcTempDir.getAbsolutePath(), TEMP_PATH_FILE);
        HibernateContainer.getInstance().put(fileName, (Object)logDir);
        try {
            DecompressMain.decompress(srcFile, logDir, isEnough);
        }
        catch (ProcessExitException e) {
            logDir.delete();
            throw e;
        }
        logDeCompressDir.setDeDeCompressDir(DecompressMain.getSystemLogPath(logDir));
        return logDeCompressDir;
    }
}

