/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.worktaker.impl;

import com.huawei.ism.tool.base.utils.KeyValue;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.worktaker.AbstractWorktaker;
import com.huawei.ism.tool.loganalyzer.entity.analyze.AnalyzeResult;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogRow;
import com.huawei.ism.tool.loganalyzer.entity.analyze.ResultViewInfo;
import com.huawei.ism.tool.loganalyzer.entity.config.OldRule;
import com.huawei.ism.tool.loganalyzer.entity.config.Param;
import com.huawei.ism.tool.loganalyzer.entity.config.SingleLogSearchRule;
import com.huawei.ism.tool.loganalyzer.entity.log.Log;
import com.huawei.ism.tool.loganalyzer.worktaker.IIndexSearchWorkTaker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class IndexSearchWorkTakerImpl
extends AbstractWorktaker
implements IIndexSearchWorkTaker {
    @Override
    public AnalyzeResult analyze(OldRule oneRule, Map<SingleLogSearchRule, List<Log>> searchResult, LogRow logRow) {
        AnalyzeResult result = new AnalyzeResult();
        LinkedList<Log> srcLogs = new LinkedList<Log>();
        Collection<List<Log>> list = searchResult.values();
        for (List<Log> lgs : list) {
            srcLogs.addAll(lgs);
        }
        result.setOriginalLogs(srcLogs);
        ResultViewInfo viewInfo = oneRule.getResultViewInfo();
        result.setResultViewInfo(viewInfo);
        List<Param> params = viewInfo.getParams();
        Map<String, String> paramsMap = this.parseParams(params, oneRule, searchResult, logRow);
        List<KeyValue<String, String>> viewInfoTable = this.replaceParms(paramsMap, viewInfo, logRow);
        result.setViewInfoTable(viewInfoTable);
        return result;
    }

    private List<KeyValue<String, String>> replaceParms(Map<String, String> paramsMap, ResultViewInfo viewInfo, LogRow logRow) {
        List<KeyValue<String, String>> viewInfos = viewInfo.getViewInfos();
        ArrayList<KeyValue<String, String>> viewInfoTable = new ArrayList<KeyValue<String, String>>();
        for (KeyValue<String, String> info : viewInfos) {
            logRow.analyzeInterruptedFromStopCommand();
            String val = (String)info.getValue();
            if (val == null) {
                val = "";
            }
            for (Map.Entry<String, String> paramsEntry : paramsMap.entrySet()) {
                logRow.analyzeInterruptedFromStopCommand();
                if (val.contains("|${" + paramsEntry.getKey() + "}")) {
                    val = val.replaceAll("\\|\\$\\{" + paramsEntry.getKey() + "\\}", paramsEntry.getValue());
                    continue;
                }
                if (!val.contains("${" + paramsEntry.getKey() + "}")) continue;
                val = val.replaceAll("\\$\\{" + paramsEntry.getKey() + "\\}", paramsEntry.getValue());
            }
            viewInfoTable.add((KeyValue<String, String>)new KeyValue((Object)((String)info.getKey()), (Object)val));
        }
        return viewInfoTable;
    }

    private Map<String, String> parseParams(List<Param> params, OldRule oneRule, Map<SingleLogSearchRule, List<Log>> searchResult, LogRow row) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        for (Param p : params) {
            row.analyzeInterruptedFromStopCommand();
            SingleLogSearchRule logSeRule = oneRule.getSearchRuleById(p.getFromInfoId());
            List<Log> logs = searchResult.get(logSeRule);
            if (logs == null || logs.isEmpty()) {
                paramsMap.put(p.getParamName(), "??");
                continue;
            }
            StringBuilder paramsBuilder = new StringBuilder();
            this.parseSingleParam(paramsBuilder, logs, p);
            paramsMap.put(p.getParamName(), paramsBuilder.toString());
        }
        return paramsMap;
    }

    private void parseSingleParam(StringBuilder paramsBuilder, List<Log> logs, Param p) {
        for (Log l : logs) {
            String pram = "";
            if (1 == p.getType()) {
                if ("date".equals(p.getValue())) {
                    pram = l.getDate();
                }
            } else if (2 == p.getType()) {
                pram = StringUtils.findMatchStr((String)l.getOriginalStr(), (String)p.getValue(), (int)0);
            }
            paramsBuilder.append(pram);
            if (StringUtils.isNULLStr((String)pram)) continue;
            paramsBuilder.append(" , ");
        }
    }
}

