/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.worktaker.impl;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.loganalyzer.entity.config.RuleFileConfig;
import com.huawei.ism.tool.loganalyzer.util.ComponentDefine;
import com.huawei.ism.tool.loganalyzer.util.SearcherUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class LoadRuleFileConfig {
    private static final String FUNCTION = "functions/function";
    private static final String PARAM = "/param";
    private static final String PRODUCT_NODE_NAME = "product";
    private static final String PRODUCT_NAME = "productname";
    private static final String PRODUCT_TYPE = "supporttypes";
    private static final String PRODUCT_VERSION = "supportversion";
    private static final String PRODUCT_CONFIG = "config";
    private static final String CONFIG_PATH = "defaultpath";
    private static final String CONFIG_MODEL = "model";
    private static final String CONFIG_VERSION = "version";
    private static final String CONFIG_SYSTEM_NAME = "systemname";
    private static final String CONFIG_SOFTWARE_VERSION = "softwareversion";
    private static final String CONFIG_SN = "sn";
    private static final String PATH_TAGNAME = "path";
    private static final String VAL_TAGNAME = "value";
    private static final String RULE_FILE_NAME = "products.xml";
    private static final String VERMAP_FILE = "vermap.ini";
    private static List<RuleFileConfig> configs = new ArrayList<RuleFileConfig>();
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(LoadRuleFileConfig.class);
    private static LoadRuleFileConfig instance = null;

    private LoadRuleFileConfig() {
        LoadRuleFileConfig.init();
    }

    public static synchronized LoadRuleFileConfig getInstance() {
        if (instance == null) {
            instance = new LoadRuleFileConfig();
        }
        return instance;
    }

    private static void init() {
        if (!configs.isEmpty()) {
            return;
        }
        File[] ruleFiles = LoadRuleFileConfig.getRuleFiles();
        if (ruleFiles == null) {
            return;
        }
        File[] fileArray = ruleFiles;
        int n = ruleFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            File proFile = new File(file, RULE_FILE_NAME);
            File vermapFile = new File(file, VERMAP_FILE);
            RuleFileConfig config = LoadRuleFileConfig.loadProductInfo(proFile, vermapFile);
            if (config != null) {
                configs.add(config);
            }
            ++n2;
        }
    }

    private static File[] getRuleFiles() {
        File ruleFile = new File(ComponentDefine.CONFIG_PATH);
        ToolLoggerFactory.getLogger(LoadRuleFileConfig.class).debug("package path:" + ComponentDefine.CONFIG_PATH);
        if (!ruleFile.exists()) {
            return new File[0];
        }
        File[] ruleFiles = ruleFile.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        return ruleFiles;
    }

    private static RuleFileConfig loadProductInfo(File proFile, File vermapFile) {
        if (!proFile.exists()) {
            return null;
        }
        RuleFileConfig config = new RuleFileConfig();
        List<String> vermapSpcVersions = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(proFile);
            Document doc = XmlUtils.parseDocument((InputStream)fileInputStream);
            if (doc == null) {
                return null;
            }
            Element root = doc.getDocumentElement();
            Collection rlEles = XmlUtils.getChildren((Element)root, (String)PRODUCT_NODE_NAME);
            if (rlEles != null && !rlEles.isEmpty()) {
                String productName = LoadRuleFileConfig.getNodeValByTag(rlEles, PRODUCT_NAME);
                String productType = LoadRuleFileConfig.getNodeValByTag(rlEles, PRODUCT_TYPE).trim();
                String productVersion = LoadRuleFileConfig.getNodeValByTag(rlEles, PRODUCT_VERSION).trim();
                List<String> productTypesList = Arrays.asList(productType.split(","));
                List<String> productVersionList = Arrays.asList(productVersion.split(","));
                config.setFunctions(LoadRuleFileConfig.getSupportFunction(root));
                config.setEventVersion(LoadRuleFileConfig.getEventInfo(root, CONFIG_VERSION));
                config.setEventProlist(LoadRuleFileConfig.getEventInfo(root, "prolist"));
                config.setProductName(productName);
                config.setSupportTypes(productTypesList);
                config.setSupporttVersions(productVersionList);
            }
            vermapSpcVersions = LoadRuleFileConfig.loadVermapFile(vermapFile);
            config.setVermapSpcVersions(vermapSpcVersions);
            LoadRuleFileConfig.addLoadConfig(config, root);
            RuleFileConfig ruleFileConfig = config;
            return ruleFileConfig;
        }
        catch (Exception e) {
            LOGGER.debug("Parse productsconf file is error!", (Throwable)e);
            return null;
        }
        finally {
            StreamUtils.closeResource(null, (Closeable)fileInputStream);
        }
    }

    private static List<String> loadVermapFile(File vermapFile) {
        ArrayList<String> vermapSpcVersions = new ArrayList<String>();
        FileInputStream vermapFileInputStream = null;
        InputStreamReader inputStream = null;
        BufferedReader reader = null;
        try {
            try {
                vermapFileInputStream = new FileInputStream(vermapFile);
                inputStream = new InputStreamReader((InputStream)vermapFileInputStream, "UTF-8");
                reader = new BufferedReader(inputStream);
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (StringUtils.isNULLStr((String)line)) continue;
                    vermapSpcVersions.add(line.trim());
                }
            }
            catch (Exception e) {
                LOGGER.debug("Parse load Vermap file is error!");
                StreamUtils.closeResource(null, reader);
                StreamUtils.closeResource(null, (Closeable)inputStream);
                StreamUtils.closeResource(null, (Closeable)vermapFileInputStream);
                return null;
            }
        }
        catch (Throwable throwable) {
            StreamUtils.closeResource(null, reader);
            StreamUtils.closeResource(null, inputStream);
            StreamUtils.closeResource(null, (Closeable)vermapFileInputStream);
            throw throwable;
        }
        StreamUtils.closeResource(null, (Closeable)reader);
        StreamUtils.closeResource(null, (Closeable)inputStream);
        StreamUtils.closeResource(null, (Closeable)vermapFileInputStream);
        return vermapSpcVersions;
    }

    private static void addLoadConfig(RuleFileConfig config, Element root) {
        Collection configEles = XmlUtils.getChildren((Element)root, (String)PRODUCT_CONFIG);
        Element configElement = XmlUtils.getChild((Element)root, (String)PRODUCT_CONFIG);
        Collection swvEles = XmlUtils.getChildren((Element)configElement, (String)CONFIG_SOFTWARE_VERSION);
        Collection verEles = XmlUtils.getChildren((Element)configElement, (String)CONFIG_VERSION);
        if (configEles == null || configEles.isEmpty()) {
            return;
        }
        for (Element configEle : configEles) {
            Node configPath = XmlUtils.getChild((Element)configEle, (String)CONFIG_PATH).getFirstChild();
            String defPathVal = "";
            if (configPath != null) {
                defPathVal = configPath.getNodeValue();
                defPathVal = new StringBuffer().append(defPathVal).append(",").append(LoadRuleFileConfig.getNodeValByTag(swvEles, PATH_TAGNAME).trim()).append(",").append(LoadRuleFileConfig.getNodeValByTag(verEles, PATH_TAGNAME)).toString();
            }
            Collection modelEles = XmlUtils.getChildren((Element)configEle, (String)CONFIG_MODEL);
            String modelPathVal = LoadRuleFileConfig.getNodeValByTag(modelEles, PATH_TAGNAME);
            String modelKeyVal = LoadRuleFileConfig.getNodeValByTag(modelEles, VAL_TAGNAME);
            Collection versionEles = XmlUtils.getChildren((Element)configEle, (String)CONFIG_VERSION);
            String versionPathVal = LoadRuleFileConfig.getNodeValByTag(versionEles, PATH_TAGNAME);
            String versionKeyVal = LoadRuleFileConfig.getNodeValByTag(versionEles, VAL_TAGNAME);
            Collection sysNameEles = XmlUtils.getChildren((Element)configEle, (String)CONFIG_SYSTEM_NAME);
            String sysNamePathVal = LoadRuleFileConfig.getNodeValByTag(sysNameEles, PATH_TAGNAME);
            String sysNameKeyVal = LoadRuleFileConfig.getNodeValByTag(sysNameEles, VAL_TAGNAME);
            Collection snEles = XmlUtils.getChildren((Element)configEle, (String)CONFIG_SN);
            String snPathVal = LoadRuleFileConfig.getNodeValByTag(snEles, PATH_TAGNAME);
            String snkeyVal = LoadRuleFileConfig.getNodeValByTag(snEles, VAL_TAGNAME);
            Collection softVerNameEles = XmlUtils.getChildren((Element)configEle, (String)CONFIG_SOFTWARE_VERSION);
            String softVePathVal = LoadRuleFileConfig.getNodeValByTag(softVerNameEles, PATH_TAGNAME);
            String softVekeyVal = LoadRuleFileConfig.getNodeValByTag(softVerNameEles, VAL_TAGNAME);
            List<String> defPathList = Arrays.asList(defPathVal.split(","));
            List<String> modelPathList = Arrays.asList(modelPathVal.split(","));
            List<String> sysNamePathList = Arrays.asList(sysNamePathVal.split(","));
            List<String> snPathList = Arrays.asList(snPathVal.split(","));
            List<String> versionPathList = Arrays.asList(versionPathVal.split(","));
            List<String> softVerPathList = Arrays.asList(softVePathVal.split(","));
            List<String> versionKeyList = Arrays.asList(versionKeyVal.split(","));
            List<String> modelKeyList = Arrays.asList(modelKeyVal.split(","));
            List<String> sysNameKeyList = Arrays.asList(sysNameKeyVal.split(","));
            List<String> snKeyList = Arrays.asList(snkeyVal.split(","));
            List<String> softVerKeyList = Arrays.asList(softVekeyVal.split(","));
            config.setDefalutPathList(defPathList);
            config.setModelPaths(modelPathList);
            config.setModelKeys(modelKeyList);
            config.setVersionPaths(versionPathList);
            config.setVersionKeys(versionKeyList);
            config.setSysNamePaths(sysNamePathList);
            config.setSysNameKeys(sysNameKeyList);
            config.setSnPaths(snPathList);
            config.setSnKeys(snKeyList);
            config.setSnPaths(softVerPathList);
            config.setSoftVerKeys(softVerKeyList);
            config.setSoftVerPaths(softVerPathList);
        }
    }

    private static List<String> getSupportFunction(Element root) {
        ArrayList<String> functions = new ArrayList<String>();
        Collection rlEles = XmlUtils.searchByExp2Ele((Node)root, (String)FUNCTION);
        for (Element rlEle : rlEles) {
            functions.add(XmlUtils.getAttribute((Element)rlEle, (String)"name"));
        }
        return functions;
    }

    private static String getEventInfo(Element root, String target) {
        Collection rlEles = XmlUtils.searchByExp2Ele((Node)root, (String)"functions/function/param");
        for (Element rlEle : rlEles) {
            if (!XmlUtils.getAttribute((Element)rlEle, (String)"name").equals(target)) continue;
            if (LanguageManager.getInstance().getCurrentLanguage().equals(Locale.ENGLISH)) {
                return XmlUtils.getAttribute((Element)rlEle, (String)"value_en");
            }
            return XmlUtils.getAttribute((Element)rlEle, (String)"value_zh");
        }
        return "";
    }

    public List<RuleFileConfig> getConfigs() {
        return configs;
    }

    public Map<String, List<String>> getShowTytes() {
        HashMap<String, List<String>> showMap = new HashMap<String, List<String>>();
        for (RuleFileConfig config : configs) {
            this.getPruductMap(showMap, config);
        }
        return showMap;
    }

    public List<String> getVersion() {
        ArrayList<String> vermapSpcVersions = new ArrayList<String>();
        ArrayList<String> vermapVersions = new ArrayList<String>();
        for (RuleFileConfig config : configs) {
            vermapSpcVersions.addAll(config.getVermapSpcVersions());
        }
        for (String verString : vermapSpcVersions) {
            String spc = verString.trim().split("=")[1];
            vermapVersions.add(spc);
        }
        return vermapVersions;
    }

    private void getPruductMap(Map<String, List<String>> map, RuleFileConfig config) {
        List<String> typesList = SearcherUtils.listTrim(config.getSupportTypes());
        List<String> versionList = SearcherUtils.listTrim(config.getSupporttVersions());
        for (String type : typesList) {
            for (String version : versionList) {
                if (map.containsKey(type)) {
                    if (map.get(type).contains(version)) continue;
                    map.get(type).add(version);
                    continue;
                }
                ArrayList<String> versions = new ArrayList<String>();
                versions.addAll(versionList);
                map.put(type, versions);
            }
        }
    }

    public RuleFileConfig getProductName(String version) {
        RuleFileConfig reslut = null;
        for (RuleFileConfig config : configs) {
            int sign = 0;
            for (String ver : config.getSupportTypes()) {
                int versionSign = 0;
                if (!version.contains(ver.trim()) || ver.length() <= sign) continue;
                for (String productVersion : config.getSupporttVersions()) {
                    if (!version.contains(productVersion.trim()) || productVersion.length() <= versionSign) continue;
                    reslut = config;
                    versionSign = productVersion.length();
                }
                sign = ver.length();
            }
        }
        return reslut;
    }

    public List<String> getUnSupportFunction(String functionSign) {
        ArrayList<String> unSupportList = new ArrayList<String>();
        for (RuleFileConfig config : configs) {
            if (config.getFunctions().contains(functionSign)) continue;
            unSupportList.add(config.getProductName().trim());
        }
        return unSupportList;
    }

    public String getUnSupEventMsg() {
        StringBuilder builder = new StringBuilder();
        List<String> unSupportEventList = this.getUnSupportFunction("RESOLVE_EVENT");
        for (String temp : unSupportEventList) {
            builder.append('\n');
            builder.append(temp);
        }
        return builder.toString();
    }

    private static String getNodeValByTag(Collection<Element> els, String tagName) {
        String val = "";
        Node node = null;
        try {
            for (Element element : els) {
                Element ee = XmlUtils.getChild((Element)element, (String)tagName);
                if (ee != null && (node = ee.getFirstChild()) != null) break;
            }
            if (node != null) {
                val = node.getNodeValue();
            }
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(LoadRuleFileConfig.class).error("", (Throwable)e);
        }
        return val;
    }

    public Set<String> getProNames() {
        HashSet<String> proNames = new HashSet<String>();
        for (RuleFileConfig config : configs) {
            proNames.addAll(SearcherUtils.listTrim(config.getSupportTypes()));
        }
        return proNames;
    }
}

