/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.worktaker.impl;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.WorktakerUtil;
import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.worktaker.AbstractWorktaker;
import com.huawei.ism.tool.loganalyzer.entity.FaultTreeData;
import com.huawei.ism.tool.loganalyzer.entity.analyze.Event;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogRow;
import com.huawei.ism.tool.loganalyzer.entity.analyze.PythonRule;
import com.huawei.ism.tool.loganalyzer.entity.analyze.ReportLog;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.cause.Cause;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.cause.CauseGroup;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.cause.CauseGroupList;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.rule.Rule;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.model.DataSource;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.model.SourceType;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.model.Type;
import com.huawei.ism.tool.loganalyzer.faulttree.model.DeviceType;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.cache.RuleMatchResultCache;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.mode.PrimarySearchMode;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.mode.SearchMode;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.CauseMatchResult;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.RecordInfo;
import com.huawei.ism.tool.loganalyzer.logic.configloader.AnalyzeRulesReader;
import com.huawei.ism.tool.loganalyzer.logic.logsearcher.AnaLogByPyCaller;
import com.huawei.ism.tool.loganalyzer.logic.logsearcher.AnalyzeEvent;
import com.huawei.ism.tool.loganalyzer.logic.pkgdecompress.SearchBomCodeByFile;
import com.huawei.ism.tool.loganalyzer.ui.main.MainLogAnaDialog;
import com.huawei.ism.tool.loganalyzer.util.AnalyzeLogExecuter;
import com.huawei.ism.tool.loganalyzer.util.LoganalyzerContext;
import com.huawei.ism.tool.loganalyzer.util.SearchConstant;
import com.huawei.ism.tool.loganalyzer.util.SearcherUtils;
import com.huawei.ism.tool.loganalyzer.worktaker.IIndexSearchWorkTaker;
import com.huawei.ism.tool.loganalyzer.worktaker.ILogWorkTaker;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;

public class LogWorkTakerImpl
extends AbstractWorktaker
implements ILogWorkTaker {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(LogWorkTakerImpl.class);
    private static final String SECCUSS = "Success";
    private AnalyzeLogExecuter analyzeLogExecuter = new AnalyzeLogExecuter();

    @Override
    public void doAnalyzeAction(LogRow row, File xmlFile) throws ToolException {
        row.analyzeInterruptedFromStopCommand();
        DeviceType type = DeviceType.type(row.getType());
        row.setDeviceType(type);
        DataSource ds = new DataSource(row.getLogDeCompressDir().getDeDeCompressRandomDir(), type.fileCategorizerCache());
        row.getSearchProgress().add(2);
        MainLogAnaDialog.getInstance().layout.getMainFaultTree().getFaultTreeProgressBar().setProgress(row.getSearchProgress());
        List<Cause> causeList = this.filterCauseByModelVersion(row, type);
        HashMap<String, CauseMatchResult> causeMatchResultMap = new HashMap<String, CauseMatchResult>();
        Map<String, List<Rule>> ruleListMap = this.findRulesToBeSearched(causeList);
        if (!ruleListMap.isEmpty()) {
            PrimarySearchMode searchMode = new PrimarySearchMode(row);
            ((SearchMode)searchMode).search(ds, ruleListMap);
            RuleMatchResultCache ruleMatchResultCache = ((SearchMode)searchMode).getRuleMatchResultCache();
            ruleMatchResultCache.searchFaultObject(row.getDeviceType());
            ruleMatchResultCache.findDateInfo(row.getDeviceType());
            ruleMatchResultCache.diagnose();
            for (Cause cause : causeList) {
                CauseMatchResult cmr = cause.getLogicExpression().exec(ruleMatchResultCache);
                if (!cmr.isMatch()) continue;
                cmr.setCauseId(cause.getId());
                causeMatchResultMap.put(cmr.getCauseId(), cmr);
            }
        } else {
            row.getSearchProgress().add(row.getDeviceType() == DeviceType.UNIFINED ? 80 : 91);
            MainLogAnaDialog.getInstance().layout.getMainFaultTree().getFaultTreeProgressBar().setProgress(row.getSearchProgress());
        }
        ConcurrentMap<String, File> logFiles = LoganalyzerContext.getInstance().getDecompressLogFile();
        String logFileName = row.getLogFile().getName();
        File depressPathFile = this.storeDepressPaths(logFileName, logFiles, row);
        IIndexSearchWorkTaker indexSearchWorkTaker = (IIndexSearchWorkTaker)WorktakerUtil.getWorktaker(IIndexSearchWorkTaker.class);
        this.valid(logFiles, row, logFileName, depressPathFile);
        if (type == DeviceType.UNIFINED) {
            row.getSearchProgress().setInfo(ResourceUtil.getString((String)Type.BOMCODE.getDesc()));
            MainLogAnaDialog.getInstance().layout.getMainFaultTree().getFaultTreeProgressBar().setProgress(row.getSearchProgress());
            SourceType bomcodeType = ds.getSourceType(Type.BOMCODE);
            if (bomcodeType != null) {
                SearchBomCodeByFile.getInstance().setAllBomCode(bomcodeType.getFileList(), row.getLogFile().getAbsolutePath());
            }
            row.getSearchProgress().add(3);
            MainLogAnaDialog.getInstance().layout.getMainFaultTree().getFaultTreeProgressBar().setProgress(row.getSearchProgress());
            row.getSearchProgress().setInfo(ResourceUtil.getString((String)"info.analyze.faultTree.progress.scriptexec"));
            MainLogAnaDialog.getInstance().layout.getMainFaultTree().getFaultTreeProgressBar().setProgress(row.getSearchProgress());
            this.rulesSetting(xmlFile, row);
            File helpFile = new File(xmlFile.getParentFile(), "helpCase.zip");
            File helpPath = new File(xmlFile.getParentFile(), "helpCase");
            if (helpFile.exists()) {
                FileUtils.unZip((String)helpPath.getAbsolutePath(), (String)helpFile.getAbsolutePath());
            }
            List<PythonRule> pythonRules = row.getPythonRules();
            row.analyzeInterruptedFromStopCommand();
            this.doPythonSearch(pythonRules, depressPathFile, indexSearchWorkTaker, row);
            row.getSearchProgress().add(8);
            MainLogAnaDialog.getInstance().layout.getMainFaultTree().getFaultTreeProgressBar().setProgress(row.getSearchProgress());
        }
        FaultTreeData ftd = new FaultTreeData(type);
        List<ReportLog> reportLoglist = ftd.getReportLog(causeMatchResultMap);
        ftd.addKnownRiskLogs(row.getFaultTreeCauseLogs(), causeMatchResultMap);
        row.getFaultTreeCauseLogs().addAll(reportLoglist);
        this.copyCauseMatchFile(row, causeMatchResultMap);
        row.analyzeInterruptedFromStopCommand();
        row.getSearchProgress().setInfo(ResourceUtil.getString((String)Type.EVENT.getDesc()));
        MainLogAnaDialog.getInstance().layout.getMainFaultTree().getFaultTreeProgressBar().setProgress(row.getSearchProgress());
        SourceType eventType = ds.getSourceType(Type.EVENT);
        if (eventType != null) {
            this.doEventParse(eventType.getFileList(), xmlFile.getParentFile().getName(), indexSearchWorkTaker, row);
        }
        row.analyzeInterruptedFromStopCommand();
        row.getSearchProgress().add(2);
        MainLogAnaDialog.getInstance().layout.getMainFaultTree().getFaultTreeProgressBar().setProgress(row.getSearchProgress());
        ds.destroy();
    }

    public void copyCauseMatchFile(LogRow row, Map<String, CauseMatchResult> causeMatchResultMap) {
        for (CauseMatchResult causeMatchResult : causeMatchResultMap.values()) {
            for (List<RecordInfo> infoList : causeMatchResult.getRecordInfoMap().values()) {
                this.getLogLink(row, infoList);
            }
        }
    }

    public void getLogLink(LogRow row, List<RecordInfo> infoList) {
        for (RecordInfo recordInfo : infoList) {
            File logFile = new File(recordInfo.getFilePath());
            String tmpReportPath = String.valueOf(row.getReportTmpFile()) + File.separator + "data" + File.separator + "detail" + File.separator + "files";
            String tmpFileName = "";
            tmpFileName = logFile.getAbsolutePath().contains("InfoAnalyzer_LogSrcDir") ? logFile.getAbsolutePath().replace(SearcherUtils.getSameStr(logFile.getAbsolutePath(), String.valueOf(SearcherUtils.getLogPath(row.getLogDeCompressDir().getDeDeCompressDir()).getAbsolutePath()) + File.separator, 0, 0, 1), "") : logFile.getAbsolutePath().replace(SearcherUtils.getSameStr(logFile.getAbsolutePath(), String.valueOf(SearcherUtils.getLogPath(new File(LoganalyzerContext.getInstance().getIndexFileString())).getAbsolutePath()) + File.separator, 0, 0, 1), "");
            File tmpReportFile = new File(tmpReportPath, tmpFileName);
            if (!tmpReportFile.getParentFile().exists()) {
                com.huawei.ism.tool.base.utils.FileUtils.createDir((File)tmpReportFile.getParentFile());
                LOGGER.info("copy" + logFile.getName() + "to temp report success" + tmpReportFile.getAbsolutePath());
            }
            if (tmpReportFile.exists()) continue;
            StreamUtils.copyFile((File)logFile, (File)tmpReportFile);
        }
    }

    private Map<String, List<Rule>> findRulesToBeSearched(List<Cause> causeList) {
        HashMap<String, Rule> ruleMap = new HashMap<String, Rule>();
        for (Cause cause : causeList) {
            ruleMap.putAll(cause.getLogicExpression().getRuleMap());
        }
        HashMap<String, List<Rule>> ruleListMap = new HashMap<String, List<Rule>>();
        for (Map.Entry e : ruleMap.entrySet()) {
            List<String> stList = ((Rule)e.getValue()).getSourceTypeList();
            for (String sourceType : stList) {
                ArrayList<Rule> ruleList = (ArrayList<Rule>)ruleListMap.get(sourceType);
                if (ruleList == null) {
                    ruleList = new ArrayList<Rule>();
                    ruleListMap.put(sourceType, ruleList);
                }
                ruleList.add((Rule)e.getValue());
            }
        }
        return ruleListMap;
    }

    private List<Cause> filterCauseByModelVersion(LogRow row, DeviceType type) {
        ArrayList<Cause> causeList = new ArrayList<Cause>();
        for (CauseGroupList causeGroupList : type.causeGroupCache().getCauseGroupLists()) {
            for (CauseGroup causeGroup : causeGroupList.getCauseGroupList()) {
                for (Cause cause : causeGroup.getCauseList()) {
                    if (!cause.valid(row.getType(), row.getVersion())) continue;
                    causeList.add(cause);
                }
            }
        }
        return causeList;
    }

    private void valid(ConcurrentMap<String, File> logFiles, LogRow row, String logFileName, File depressPathFile) {
        boolean flag;
        this.validDepressPathFile(row, depressPathFile);
        File dataCollectPath = this.storeDataCollectPaths(logFileName, logFiles);
        if (dataCollectPath == null) {
            row.analyzeInterruptedFromAnError("info.nanlyze.tabel.type.faild");
        }
        boolean bl = flag = row.getRow() != null && !StringUtils.isNULLStr((String)row.getType());
        if (flag) {
            row.analyzeInterruptedFromStopCommand();
            this.settingDay(row, dataCollectPath);
        }
    }

    private void validDepressPathFile(LogRow row, File depressPathFile) {
        if (depressPathFile == null) {
            row.analyzeInterruptedFromAnError("info.nanlyze.tabel.type.faild");
        }
        if (StringUtils.isNULLStr((String)depressPathFile.getName())) {
            row.analyzeInterruptedFromAnError("info.nanlyze.file.disk.not.enough");
        }
        if ("stop".equals(depressPathFile.getName())) {
            row.analyzeInterruptedFromStopCommand();
        }
    }

    private File storeDepressPaths(String logRow, ConcurrentMap<String, File> logFiles, LogRow row) {
        File logFile = null;
        for (Map.Entry e : logFiles.entrySet()) {
            if (!logRow.equalsIgnoreCase((String)e.getKey())) continue;
            logFile = (File)e.getValue();
            if (SearcherUtils.getLogPath(logFile) != null) {
                LoganalyzerContext.getInstance().setFilePath(SearcherUtils.getLogPath(logFile).getPath());
            } else {
                row.analyzeInterruptedFromAnError("info.nanlyze.tabel.type.filelost");
            }
            LOGGER.info("decompress file path: " + logFile);
            return logFile;
        }
        return logFile;
    }

    private File storeDataCollectPaths(String logRow, ConcurrentMap<String, File> logFiles) {
        File logFile = null;
        for (Map.Entry e : logFiles.entrySet()) {
            if (!logRow.equalsIgnoreCase((String)e.getKey())) continue;
            logFile = (File)e.getValue();
            LOGGER.info(" dataCollect file path: " + logFile);
            return logFile;
        }
        return logFile;
    }

    private void settingDay(LogRow row, File dataCollectFile) {
        if (row.getRow() != null && !StringUtils.isNULLStr((String)row.getType()) && 1 == SearchConstant.getInstant().getDateType()) {
            SearcherUtils.setSelectDate(row.getLogFile(), dataCollectFile);
        }
    }

    private void rulesSetting(File xmlFile, LogRow row) {
        row.analyzeInterruptedFromStopCommand();
        File xmlPyRuleFile = new File(xmlFile.getParentFile(), "AnalyzeRule_Python.xml");
        row.analyzeInterruptedFromStopCommand();
        List<PythonRule> pythonRules = this.getParsePythonRule(xmlPyRuleFile, row);
        row.setPythonRules(pythonRules);
    }

    private List<PythonRule> getParsePythonRule(File xmlPyRuleFile, LogRow row) {
        AnalyzeRulesReader ruleReader = new AnalyzeRulesReader();
        List<PythonRule> pythonRules = null;
        if (!xmlPyRuleFile.exists()) {
            return new ArrayList<PythonRule>();
        }
        try {
            pythonRules = ruleReader.parsePythonRuleFile(xmlPyRuleFile, row);
        }
        catch (ToolException e) {
            LOGGER.error("class name:LogWorkTakerImpl;method name:getParseRule;  parse the configuration file fail", (Throwable)e);
            return null;
        }
        return pythonRules;
    }

    private String doEventParse(List<File> list, String productModel, IIndexSearchWorkTaker indexSearchWorkTaker, LogRow row) {
        StringBuffer pathBuffer = new StringBuffer();
        pathBuffer.append(ApplicationContext.getInstance().getPackagesPath());
        pathBuffer.append(File.separator).append("AnalyzeLogTool").append(File.separator).append("products").append(File.separator).append(productModel);
        File xls = new File(pathBuffer.toString(), "EventDetail.xls");
        AnalyzeEvent analyzeEvent = new AnalyzeEvent();
        Map<Long, List<Event>> eventsMap = analyzeEvent.doAnalyzeEvents(list, row);
        SearcherUtils.eventTransitionLog(eventsMap, xls, indexSearchWorkTaker, row);
        return SECCUSS;
    }

    private String doPythonSearch(List<PythonRule> rules, File logDir, IIndexSearchWorkTaker indexSearchWorkTaker, LogRow row) {
        ArrayList<AnaLogByPyCaller> callers = new ArrayList<AnaLogByPyCaller>();
        for (PythonRule rule : rules) {
            callers.add(new AnaLogByPyCaller(rule, logDir, indexSearchWorkTaker, row));
        }
        this.analyzeLogExecuter.executePythonCall(callers);
        LOGGER.info("Search the log with python finish. ");
        return SECCUSS;
    }

    @Override
    public String doReport(LogRow row) throws ToolException, IOException {
        row.analyzeInterruptedFromStopCommand();
        ToolLoggerFactory.getLogger(this.getClass()).debug("start create report file.");
        if (!row.isResultNotEmpty()) {
            row.setAnalyzeEndTime(System.currentTimeMillis());
            return "";
        }
        row.analyzeInterruptedFromStopCommand();
        File log = row.getLogFile();
        row.analyzeInterruptedFromStopCommand();
        String defaultName = "LogAnalysisReport_" + log.getName() + "_" + StringUtils.formatDate((Object)new Date(), (String)"yyyyMMddHHmmss") + ".zip";
        String reportFile = String.valueOf(MainLogAnaDialog.getInstance().getSettingDirDialog().getOutputPath().getText()) + File.separator + defaultName;
        this.checkTemFolder(row, reportFile);
        this.generateReport(row);
        row.analyzeInterruptedFromStopCommand();
        ZipUtils.compressFile((String)reportFile, (String)row.getReportTmpFile());
        File ropFile = new File(reportFile);
        com.huawei.ism.tool.loganalyzer.util.FileUtils.setFilePermissions(ropFile);
        if (!ropFile.canWrite()) {
            return "ERROR";
        }
        LoganalyzerContext.getInstance().setReportExported(true);
        row.analyzeInterruptedFromStopCommand();
        row.setAnalyzeEndTime(System.currentTimeMillis());
        ToolLoggerFactory.getLogger(this.getClass()).debug("create " + defaultName + " success");
        return reportFile;
    }

    private void checkTemFolder(LogRow row, String reportFile) {
        File tmpfolder = new File(reportFile.substring(0, reportFile.lastIndexOf(File.separator)));
        if (!tmpfolder.exists()) {
            boolean isSuc = tmpfolder.mkdirs();
            ToolLoggerFactory.getLogger(this.getClass()).info("tmpfolder create " + isSuc);
        }
        if (!SearcherUtils.checkDiskFreeSpace(tmpfolder.getAbsolutePath())) {
            row.analyzeInterruptedFromAnError("info.nanlyze.file.disk.not.enough");
        }
    }

    private void generateReport(LogRow logRow) {
    }
}

