/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl.number.parse;

import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.python.icu.impl.StringSegment;
import org.python.icu.impl.number.AffixPatternProvider;
import org.python.icu.impl.number.CurrencyPluralInfoAffixProvider;
import org.python.icu.impl.number.CustomSymbolCurrency;
import org.python.icu.impl.number.DecimalFormatProperties;
import org.python.icu.impl.number.Grouper;
import org.python.icu.impl.number.PatternStringParser;
import org.python.icu.impl.number.PropertiesAffixPatternProvider;
import org.python.icu.impl.number.RoundingUtils;
import org.python.icu.impl.number.parse.AffixMatcher;
import org.python.icu.impl.number.parse.AffixTokenMatcherFactory;
import org.python.icu.impl.number.parse.CombinedCurrencyMatcher;
import org.python.icu.impl.number.parse.DecimalMatcher;
import org.python.icu.impl.number.parse.IgnorablesMatcher;
import org.python.icu.impl.number.parse.InfinityMatcher;
import org.python.icu.impl.number.parse.MinusSignMatcher;
import org.python.icu.impl.number.parse.MultiplierParseHandler;
import org.python.icu.impl.number.parse.NanMatcher;
import org.python.icu.impl.number.parse.NumberParseMatcher;
import org.python.icu.impl.number.parse.PaddingMatcher;
import org.python.icu.impl.number.parse.ParsedNumber;
import org.python.icu.impl.number.parse.PercentMatcher;
import org.python.icu.impl.number.parse.PermilleMatcher;
import org.python.icu.impl.number.parse.PlusSignMatcher;
import org.python.icu.impl.number.parse.RequireAffixValidator;
import org.python.icu.impl.number.parse.RequireCurrencyValidator;
import org.python.icu.impl.number.parse.RequireDecimalSeparatorValidator;
import org.python.icu.impl.number.parse.RequireNumberValidator;
import org.python.icu.impl.number.parse.ScientificMatcher;
import org.python.icu.number.NumberFormatter;
import org.python.icu.number.Scale;
import org.python.icu.text.DecimalFormatSymbols;
import org.python.icu.util.Currency;
import org.python.icu.util.CurrencyAmount;
import org.python.icu.util.ULocale;

public class NumberParserImpl {
    private final int parseFlags;
    private final List<NumberParseMatcher> matchers = new ArrayList<NumberParseMatcher>();
    private boolean frozen;

    public static NumberParserImpl createSimpleParser(ULocale locale2, String pattern, int parseFlags) {
        NumberParserImpl parser2 = new NumberParserImpl(parseFlags);
        Currency currency = Currency.getInstance("USD");
        DecimalFormatSymbols symbols2 = DecimalFormatSymbols.getInstance(locale2);
        IgnorablesMatcher ignorables = IgnorablesMatcher.DEFAULT;
        AffixTokenMatcherFactory factory = new AffixTokenMatcherFactory();
        factory.currency = currency;
        factory.symbols = symbols2;
        factory.ignorables = ignorables;
        factory.locale = locale2;
        factory.parseFlags = parseFlags;
        PatternStringParser.ParsedPatternInfo patternInfo = PatternStringParser.parseToPatternInfo(pattern);
        AffixMatcher.createMatchers(patternInfo, parser2, factory, ignorables, parseFlags);
        Grouper grouper = Grouper.forStrategy(NumberFormatter.GroupingStrategy.AUTO).withLocaleData(locale2, patternInfo);
        parser2.addMatcher(ignorables);
        parser2.addMatcher(DecimalMatcher.getInstance(symbols2, grouper, parseFlags));
        parser2.addMatcher(MinusSignMatcher.getInstance(symbols2, false));
        parser2.addMatcher(PlusSignMatcher.getInstance(symbols2, false));
        parser2.addMatcher(PercentMatcher.getInstance(symbols2));
        parser2.addMatcher(PermilleMatcher.getInstance(symbols2));
        parser2.addMatcher(NanMatcher.getInstance(symbols2, parseFlags));
        parser2.addMatcher(InfinityMatcher.getInstance(symbols2));
        parser2.addMatcher(PaddingMatcher.getInstance("@"));
        parser2.addMatcher(ScientificMatcher.getInstance(symbols2, grouper));
        parser2.addMatcher(CombinedCurrencyMatcher.getInstance(currency, symbols2, parseFlags));
        parser2.addMatcher(new RequireNumberValidator());
        parser2.freeze();
        return parser2;
    }

    public static Number parseStatic(String input, ParsePosition ppos, DecimalFormatProperties properties, DecimalFormatSymbols symbols2) {
        NumberParserImpl parser2 = NumberParserImpl.createParserFromProperties(properties, symbols2, false);
        ParsedNumber result2 = new ParsedNumber();
        parser2.parse(input, true, result2);
        if (result2.success()) {
            ppos.setIndex(result2.charEnd);
            return result2.getNumber();
        }
        ppos.setErrorIndex(result2.charEnd);
        return null;
    }

    public static CurrencyAmount parseStaticCurrency(String input, ParsePosition ppos, DecimalFormatProperties properties, DecimalFormatSymbols symbols2) {
        NumberParserImpl parser2 = NumberParserImpl.createParserFromProperties(properties, symbols2, true);
        ParsedNumber result2 = new ParsedNumber();
        parser2.parse(input, true, result2);
        if (result2.success()) {
            ppos.setIndex(result2.charEnd);
            assert (result2.currencyCode != null);
            return new CurrencyAmount(result2.getNumber(), Currency.getInstance(result2.currencyCode));
        }
        ppos.setErrorIndex(result2.charEnd);
        return null;
    }

    public static NumberParserImpl createDefaultParserForLocale(ULocale loc) {
        DecimalFormatSymbols symbols2 = DecimalFormatSymbols.getInstance(loc);
        DecimalFormatProperties properties = PatternStringParser.parseToProperties("0");
        return NumberParserImpl.createParserFromProperties(properties, symbols2, false);
    }

    public static NumberParserImpl createParserFromProperties(DecimalFormatProperties properties, DecimalFormatSymbols symbols2, boolean parseCurrency) {
        Scale multiplier;
        ULocale locale2 = symbols2.getULocale();
        AffixPatternProvider affixProvider = properties.getCurrencyPluralInfo() == null ? new PropertiesAffixPatternProvider(properties) : new CurrencyPluralInfoAffixProvider(properties.getCurrencyPluralInfo(), properties);
        Currency currency = CustomSymbolCurrency.resolve(properties.getCurrency(), locale2, symbols2);
        boolean isStrict = properties.getParseMode() == DecimalFormatProperties.ParseMode.STRICT;
        Grouper grouper = Grouper.forProperties(properties);
        int parseFlags = 0;
        if (!properties.getParseCaseSensitive()) {
            parseFlags |= 1;
        }
        if (properties.getParseIntegerOnly()) {
            parseFlags |= 0x10;
        }
        if (properties.getParseToBigDecimal()) {
            parseFlags |= 0x1000;
        }
        if (properties.getSignAlwaysShown()) {
            parseFlags |= 0x400;
        }
        if (isStrict) {
            parseFlags |= 8;
            parseFlags |= 4;
            parseFlags |= 0x100;
            parseFlags |= 0x200;
        } else {
            parseFlags |= 0x80;
        }
        if (grouper.getPrimary() <= 0) {
            parseFlags |= 0x20;
        }
        if (parseCurrency || affixProvider.hasCurrencySign()) {
            parseFlags |= 2;
        }
        if (!parseCurrency) {
            parseFlags |= 0x2000;
        }
        IgnorablesMatcher ignorables = isStrict ? IgnorablesMatcher.STRICT : IgnorablesMatcher.DEFAULT;
        NumberParserImpl parser2 = new NumberParserImpl(parseFlags);
        AffixTokenMatcherFactory factory = new AffixTokenMatcherFactory();
        factory.currency = currency;
        factory.symbols = symbols2;
        factory.ignorables = ignorables;
        factory.locale = locale2;
        factory.parseFlags = parseFlags;
        AffixMatcher.createMatchers(affixProvider, parser2, factory, ignorables, parseFlags);
        if (parseCurrency || affixProvider.hasCurrencySign()) {
            parser2.addMatcher(CombinedCurrencyMatcher.getInstance(currency, symbols2, parseFlags));
        }
        if (affixProvider.containsSymbolType(-3)) {
            parser2.addMatcher(PercentMatcher.getInstance(symbols2));
        }
        if (affixProvider.containsSymbolType(-4)) {
            parser2.addMatcher(PermilleMatcher.getInstance(symbols2));
        }
        if (!isStrict) {
            parser2.addMatcher(PlusSignMatcher.getInstance(symbols2, false));
            parser2.addMatcher(MinusSignMatcher.getInstance(symbols2, false));
        }
        parser2.addMatcher(NanMatcher.getInstance(symbols2, parseFlags));
        parser2.addMatcher(InfinityMatcher.getInstance(symbols2));
        String padString = properties.getPadString();
        if (padString != null && !ignorables.getSet().contains(padString)) {
            parser2.addMatcher(PaddingMatcher.getInstance(padString));
        }
        parser2.addMatcher(ignorables);
        parser2.addMatcher(DecimalMatcher.getInstance(symbols2, grouper, parseFlags));
        if (!properties.getParseNoExponent() || properties.getMinimumExponentDigits() > 0) {
            parser2.addMatcher(ScientificMatcher.getInstance(symbols2, grouper));
        }
        parser2.addMatcher(new RequireNumberValidator());
        if (isStrict) {
            parser2.addMatcher(new RequireAffixValidator());
        }
        if (parseCurrency) {
            parser2.addMatcher(new RequireCurrencyValidator());
        }
        if (properties.getDecimalPatternMatchRequired()) {
            boolean patternHasDecimalSeparator = properties.getDecimalSeparatorAlwaysShown() || properties.getMaximumFractionDigits() != 0;
            parser2.addMatcher(RequireDecimalSeparatorValidator.getInstance(patternHasDecimalSeparator));
        }
        if ((multiplier = RoundingUtils.scaleFromProperties(properties)) != null) {
            parser2.addMatcher(new MultiplierParseHandler(multiplier));
        }
        parser2.freeze();
        return parser2;
    }

    public NumberParserImpl(int parseFlags) {
        this.parseFlags = parseFlags;
        this.frozen = false;
    }

    public void addMatcher(NumberParseMatcher matcher) {
        assert (!this.frozen);
        this.matchers.add(matcher);
    }

    public void addMatchers(Collection<? extends NumberParseMatcher> matchers) {
        assert (!this.frozen);
        this.matchers.addAll(matchers);
    }

    public void freeze() {
        this.frozen = true;
    }

    public int getParseFlags() {
        return this.parseFlags;
    }

    public void parse(String input, boolean greedy, ParsedNumber result2) {
        this.parse(input, 0, greedy, result2);
    }

    public void parse(String input, int start, boolean greedy, ParsedNumber result2) {
        assert (this.frozen);
        assert (start >= 0 && start < input.length());
        StringSegment segment = new StringSegment(input, 0 != (this.parseFlags & 1));
        segment.adjustOffset(start);
        if (greedy) {
            this.parseGreedyRecursive(segment, result2);
        } else {
            this.parseLongestRecursive(segment, result2);
        }
        for (NumberParseMatcher matcher : this.matchers) {
            matcher.postProcess(result2);
        }
        result2.postProcess();
    }

    private void parseGreedyRecursive(StringSegment segment, ParsedNumber result2) {
        if (segment.length() == 0) {
            return;
        }
        int initialOffset = segment.getOffset();
        for (int i = 0; i < this.matchers.size(); ++i) {
            NumberParseMatcher matcher = this.matchers.get(i);
            if (!matcher.smokeTest(segment)) continue;
            matcher.match(segment, result2);
            if (segment.getOffset() == initialOffset) continue;
            this.parseGreedyRecursive(segment, result2);
            segment.setOffset(initialOffset);
            return;
        }
    }

    private void parseLongestRecursive(StringSegment segment, ParsedNumber result2) {
        if (segment.length() == 0) {
            return;
        }
        ParsedNumber initial = new ParsedNumber();
        initial.copyFrom(result2);
        ParsedNumber candidate = new ParsedNumber();
        int initialOffset = segment.getOffset();
        block0: for (int i = 0; i < this.matchers.size(); ++i) {
            NumberParseMatcher matcher = this.matchers.get(i);
            if (!matcher.smokeTest(segment)) continue;
            int charsToConsume = 0;
            while (charsToConsume < segment.length()) {
                charsToConsume += Character.charCount(segment.codePointAt(charsToConsume));
                candidate.copyFrom(initial);
                segment.setLength(charsToConsume);
                boolean maybeMore = matcher.match(segment, candidate);
                segment.resetLength();
                if (segment.getOffset() - initialOffset == charsToConsume) {
                    this.parseLongestRecursive(segment, candidate);
                    if (candidate.isBetterThan(result2)) {
                        result2.copyFrom(candidate);
                    }
                }
                segment.setOffset(initialOffset);
                if (maybeMore) continue;
                continue block0;
            }
        }
    }

    public String toString() {
        return "<NumberParserImpl matchers=" + this.matchers.toString() + ">";
    }
}

