/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.log.ui;

import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.ILogSupportService;
import com.huawei.ism.tool.framework.pubservice.entity.OperaLog;
import com.huawei.ism.tool.log.ui.DebugLogMainPanel;
import com.huawei.ism.tool.log.ui.OperaLogMainPanel;
import com.huawei.ism.tool.obase.ui.dialogs.PublicDialog;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LogManageDialog
extends PublicDialog {
    private static final long serialVersionUID = -4457814745266927012L;
    private JTabbedPane tabPane;
    private OperaLogMainPanel operaLogPanel;

    public LogManageDialog(Window parent) {
        super(parent, true);
        this.addOperaLog("systemconfig.enter.export.open.logmanager", true);
        this.initDialog();
        this.initListener();
    }

    private void initDialog() {
        this.setTitle(ResourceUtil.getString("operalog.remind.main.title"));
        this.setLayout(new BorderLayout());
        this.add(this.buildJTabbedPane());
        this.setModal(true);
        UiMethod.setComponentSize(new Dimension(1000, 680), this);
        SwingUtil.putScreenCenter(this);
    }

    private JTabbedPane buildJTabbedPane() {
        this.tabPane = new JTabbedPane();
        this.operaLogPanel = new OperaLogMainPanel(this);
        this.tabPane.setFont(new Font(null, 1, 12));
        String operaLogRes = ResourceUtil.getString("operalog.remind.operalog.title");
        String debugLogRes = ResourceUtil.getString("operalog.remind.debuglog.title");
        this.tabPane.add((Component)this.operaLogPanel, operaLogRes);
        this.tabPane.add((Component)new DebugLogMainPanel(this), debugLogRes);
        this.tabPane.setToolTipTextAt(0, operaLogRes);
        this.tabPane.setToolTipTextAt(1, debugLogRes);
        return this.tabPane;
    }

    private void initListener() {
        this.tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (LogManageDialog.this.tabPane.getSelectedIndex() == 0) {
                    LogManageDialog.this.refreshOpreaLog();
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                LogManageDialog.this.addOperaLog("systemconfig.logmanager.export.close.dialog", true);
            }
        });
    }

    private void refreshOpreaLog() {
        this.operaLogPanel.refreshDataWithProgressDialog(this);
    }

    private void addOperaLog(String operName, boolean result) {
        OperaLog log = new OperaLog();
        log.setUserName(ApplicationContext.getInstance().getCurToolkitUser());
        log.setDeviceName("Smartkit");
        log.setDeviceNameEn("Smartkit");
        log.setOperateType("operalog.type.system");
        log.setOperaName(operName);
        log.setResult(result);
        ILogSupportService logService = PublicServiceManage.getInstance().getService(ILogSupportService.class);
        if (null != logService) {
            logService.addOperaLog(log);
        }
    }
}

