/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.silence;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.SystemEnvUtil;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.silence.ISilenceTask;
import com.huawei.ism.tool.silence.entity.TaskConfigInfo;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SilenceTaskFactory {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SilenceTaskFactory.class);

    public static ISilenceTask getService(String name) throws ToolException {
        LOGGER.info("begin to get task instance:{}", (Object)name);
        TaskConfigInfo taskConfig = SilenceTaskFactory.findTaskConfig(name);
        try {
            String userDir = SystemEnvUtil.getDefaultUserDir();
            String jarPath = userDir + File.separator + taskConfig.getJarPath();
            LOGGER.info("silence task jarpath={}", (Object)jarPath);
            URLClassLoader urlLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Class<URLClassLoader> sysclass = URLClassLoader.class;
            Method method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            URL url = new URL("jar:file:" + File.separator + jarPath + "!/");
            method.invoke((Object)urlLoader, url);
            SilenceTaskFactory.loadJar(userDir + File.separator + "lib", method, urlLoader);
            SilenceTaskFactory.loadJar(userDir + File.separator + "plugins", method, urlLoader);
            Class<?> silenceTask = urlLoader.loadClass(taskConfig.getClassName());
            return (ISilenceTask)silenceTask.newInstance();
        }
        catch (Exception e) {
            LOGGER.error("service initial error.", (Throwable)e);
            throw new ToolException("silence.factory.findError");
        }
    }

    private static void loadJar(String path, Method method, URLClassLoader clsLoader) {
        File jarDir = FilePathUtils.checkFile((File)new File(path));
        File[] jarFiles = jarDir.listFiles();
        if (jarFiles == null) {
            return;
        }
        for (File file : jarFiles) {
            if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
            try {
                URL url = new URL("jar:file:/" + file.getCanonicalPath() + "!/");
                LOGGER.info("load url={}", (Object)url);
                method.invoke((Object)clsLoader, url);
            }
            catch (Exception e) {
                LOGGER.error("load jar error");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TaskConfigInfo findTaskConfig(String name) throws ToolException {
        InputStream fis = SilenceTaskFactory.class.getResourceAsStream("/config/silenceTask.xml");
        try {
            Document doc = XmlUtils.parseDocument((InputStream)fis);
            NodeList serviceNodes = XmlUtils.searchNodeByExp((Document)doc, (String)"//service");
            if (serviceNodes == null) {
                LOGGER.error("serviceNodes is null.");
                throw new ToolException("silence.taskconfig.parseError");
            }
            String jarPath = "";
            String className = "";
            for (int i = 0; i < serviceNodes.getLength(); ++i) {
                Element e;
                Node node = serviceNodes.item(i);
                if (!(node instanceof Element) || !name.equals((e = (Element)node).getAttribute("name"))) continue;
                jarPath = e.getAttribute("jarpath");
                className = e.getAttribute("class");
                break;
            }
            if (StringUtils.isNULLStr(jarPath) || StringUtils.isNULLStr(className)) {
                LOGGER.error("can not find task config.");
                throw new ToolException("silence.taskconfig.parseError");
            }
            TaskConfigInfo configInfo = new TaskConfigInfo();
            configInfo.setName(name);
            configInfo.setJarPath(jarPath);
            configInfo.setClassName(className);
            TaskConfigInfo taskConfigInfo = configInfo;
            return taskConfigInfo;
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)fis);
        }
    }
}

