/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.silence;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.framework.init.FrameworkInitiator;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.silence.ISilenceTask;
import com.huawei.ism.tool.silence.SilenceTaskFactory;
import com.huawei.ism.tool.silence.entity.DeviceResultInfo;
import com.huawei.ism.tool.silence.entity.SilenceTaskRequest;
import com.huawei.ism.tool.silence.entity.SilenceTaskResponse;
import com.huawei.ism.tool.silence.entity.TaskExtensionInfo;
import com.huawei.ism.tool.silence.util.TaskExtensionFileParser;
import com.huawei.ism.tool.silence.util.TaskFileParser;
import com.huawei.ism.tool.silence.util.TaskProgressFileWirter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;

public class SilenceTaskMain {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SilenceTaskMain.class);
    private static final long TASK_TIMEOUT_MS = 604800000L;
    private static final String TASKFILEPATH = "taskfile";
    private static final String SCENCE = "sence";
    private static final String ARGSPLITMARK = "=";
    private static final String KMC_CONFIG_PATH = "kmcConfigPath";
    private static FileOutputStream fos = null;
    private static FileLock locker = null;
    private static String scence = "";
    private static String taskFilePath = "";
    private static String kmcConfigPath = "";
    private static ISilenceTask service = null;
    private static boolean taskEnd = false;
    private static SilenceTaskRequest req = null;

    public static void main(String[] args) {
        TaskProgressFileWirter writer = null;
        try {
            SilenceTaskMain.init(args);
            SilenceTaskMain.setKmcConfigPath(kmcConfigPath);
            req = new TaskFileParser().parse(taskFilePath);
            writer = new TaskProgressFileWirter(req.getWorkPath());
            if (!SilenceTaskMain.requestFileLock()) {
                LOGGER.info("has exist task.");
                throw new ToolException("silence.task.process.exist");
            }
            service = SilenceTaskFactory.getService(scence);
            service.init();
            service.excute(req);
            SilenceTaskMain.updateTaskProgress(writer);
            SilenceTaskMain.exitTask(0);
        }
        catch (ToolException e) {
            LOGGER.error("Execute remote task toolexception.", (Throwable)e);
            SilenceTaskMain.writeProgressWhenError(writer, ResourceUtil.getString(e.getErrorId()));
            SilenceTaskMain.exitTask(-1);
        }
        catch (Exception e) {
            LOGGER.error("Execute remote task exception.", (Throwable)e);
            SilenceTaskMain.writeProgressWhenError(writer, ResourceUtil.getString("silence.main.task.error"));
            SilenceTaskMain.exitTask(-1);
        }
    }

    private static void setKmcConfigPath(String configPath) {
        LOGGER.info("configPath = {}", (Object)configPath);
        System.setProperty("eservice.tools.encrypt.param.config.path", configPath);
    }

    private static void init(String[] args) throws ToolException {
        LOGGER.info("user.dir : {}", (Object)System.getProperty("user.dir"));
        for (String arg : args) {
            if (arg.contains(TASKFILEPATH)) {
                taskFilePath = arg.split(ARGSPLITMARK, 2)[1];
                continue;
            }
            if (arg.contains(SCENCE)) {
                scence = arg.split(ARGSPLITMARK, 2)[1];
                continue;
            }
            if (!arg.contains(KMC_CONFIG_PATH)) continue;
            kmcConfigPath = arg.split(ARGSPLITMARK, 2)[1];
        }
        if (StringUtils.isNULLStr(taskFilePath) || StringUtils.isNULLStr(scence)) {
            LOGGER.info("the param is empty.");
            throw new ToolException("silence.task.params.error");
        }
        FrameworkInitiator.init();
        FileUtils.setLogsPermissions();
    }

    private static void updateTaskProgress(TaskProgressFileWirter writer) throws ToolException {
        long startTime = System.currentTimeMillis();
        while (!taskEnd) {
            try {
                if (service.isSupportAcceptCmd()) {
                    Collection<TaskExtensionInfo> taskExtensionInfos = new TaskExtensionFileParser().parse(req.getWorkPath());
                    service.acceptCmd(taskExtensionInfos);
                }
                SilenceTaskResponse response = service.getResponse();
                writer.write(response);
                taskEnd = response.isTaskEnd();
                ConnUtils.sleep(10000);
            }
            catch (ToolException e) {
                LOGGER.error("update task progress error.", (Throwable)e);
            }
            if (System.currentTimeMillis() - startTime <= 604800000L) continue;
            throw new ToolException("silence.task.timeout");
        }
    }

    private static void writeProgressWhenError(TaskProgressFileWirter writer, String errorMsg) {
        LOGGER.info("errmsg={}", (Object)errorMsg);
        if (null != writer) {
            SilenceTaskResponse response = new SilenceTaskResponse();
            response.setResult("failed");
            response.setStatus("finished");
            response.setErrMsg(errorMsg);
            for (Map.Entry<String, DeviceResultInfo> entry : response.getDevRsps().entrySet()) {
                entry.getValue().setStatus("finished");
            }
            try {
                writer.write(response);
            }
            catch (ToolException e) {
                LOGGER.error("updateTaskProgressWhenFail error", (Throwable)e);
            }
        }
    }

    private static void exitTask(int status) {
        LOGGER.info("Exit task -> status : {}", (Object)status);
        if (null != locker) {
            try {
                locker.release();
            }
            catch (IOException e) {
                LOGGER.error("Release file locker failed.", (Throwable)e);
            }
        }
        StreamUtils.closeStream(fos, null);
        Runtime.getRuntime().halt(status);
    }

    private static boolean requestFileLock() {
        try {
            fos = new FileOutputStream("runningFlag");
            locker = fos.getChannel().tryLock();
            if (null == locker) {
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.error("Get runningFalg lock failed.", (Throwable)e);
        }
        return true;
    }
}

