/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.silence.util;

import com.huawei.ism.tool.silence.entity.DeviceResultInfo;
import com.huawei.ism.tool.silence.entity.SilenceTaskResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ResponseHelper {
    public static final String STATUS_WAITING = "waiting";
    public static final String STATUS_RUNING = "running";
    public static final String STATUS_PAUSE = "pause";
    public static final String STATUS_FINISHED = "finished";
    public static final String RESULT_INIT = "";
    public static final String RESULT_SUCCEED = "success";
    public static final String RESULT_FAILED = "failed";
    public static final String RETURN_DATA = "returnData";
    public static final String OPERATION_RETRY = "continue";
    public static final String OPERATION_STOP = "stop";
    public static final String STYLE_NORAML = "NORMAL";
    public static final String STYLE_RUNNING = "RUNNING";
    public static final String STYLE_FAILED = "FAILED";
    public static final String STYLE_SUCCEED = "SUCCEED";
    public static final String STYLE_PAUSE = "PAUSE";
    public static final int PROGRESS_FINISH = 100;

    public void mergeResult(SilenceTaskResponse response) {
        if (!RESULT_INIT.equals(response.getResult()) && STATUS_FINISHED.equals(response.getStatus())) {
            response.setProgress(100);
            response.setTaskEnd(true);
            return;
        }
        Map<String, DeviceResultInfo> resultInfos = response.getDevRsps();
        ArrayList<String> allStatus = new ArrayList<String>();
        ArrayList<String> allResult = new ArrayList<String>();
        int totalProgress = 0;
        for (Map.Entry<String, DeviceResultInfo> entry : resultInfos.entrySet()) {
            DeviceResultInfo resultInfo = entry.getValue();
            allStatus.add(resultInfo.getStatus());
            allResult.add(resultInfo.getResult());
            totalProgress += resultInfo.getProgress().intValue();
        }
        response.setProgress(totalProgress / resultInfos.size());
        response.setResult(this.mergeResult(allResult));
        response.setStatus(this.mergeStatus(allStatus));
    }

    private String mergeResult(List<String> allResult) {
        if (allResult.contains(RESULT_INIT)) {
            return RESULT_INIT;
        }
        if (allResult.contains(RESULT_FAILED)) {
            return RESULT_FAILED;
        }
        return RESULT_SUCCEED;
    }

    private String mergeStatus(List<String> allStatus) {
        if (allStatus.contains(STATUS_RUNING) || allStatus.contains(STATUS_PAUSE)) {
            return STATUS_RUNING;
        }
        if (!allStatus.contains(STATUS_FINISHED)) {
            return STATUS_WAITING;
        }
        return STATUS_FINISHED;
    }

    public void updateDeviceResultWhenError(DeviceResultInfo deviceResultInfo, String errMsg) {
        deviceResultInfo.setErrMsg(errMsg);
        deviceResultInfo.setStatus(STATUS_FINISHED);
        deviceResultInfo.setResult(RESULT_FAILED);
    }
}

