/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.silence.util;

import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.silence.entity.TaskExtensionInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TaskExtensionFileParser {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(TaskExtensionFileParser.class);
    private static final String TAG_DEVICE = "//device";
    private static final String TAG_PARAM = "//param";

    public Collection<TaskExtensionInfo> parse(String workpath) {
        HashMap<String, TaskExtensionInfo> taskExtensionInfos = new HashMap<String, TaskExtensionInfo>();
        File[] files = new File(workpath).listFiles();
        ArrayList<String> extensionFilenames = new ArrayList<String>();
        if (files == null) {
            return taskExtensionInfos.values();
        }
        for (File file : files) {
            if (!file.getName().startsWith("taskExtension_") || !file.getName().endsWith(".xml")) continue;
            extensionFilenames.add(file.getName());
        }
        Collections.sort(extensionFilenames);
        for (String filename : extensionFilenames) {
            File filepath = new File(workpath, filename);
            this.parseFile(filepath, taskExtensionInfos);
            filepath.delete();
        }
        return taskExtensionInfos.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFile(File taskExtensionFile, Map<String, TaskExtensionInfo> taskExtensionInfos) {
        LOGGER.info("parse file = {}", (Object)taskExtensionFile);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(taskExtensionFile);
            Document doc = XmlUtils.parseDocument((InputStream)fis);
            NodeList deviceNodes = XmlUtils.searchNodeByExp((Document)doc, (String)TAG_DEVICE);
            List<String> devices = TaskExtensionFileParser.parseDeviceNodes(deviceNodes);
            NodeList paramNodes = XmlUtils.searchNodeByExp((Document)doc, (String)TAG_PARAM);
            Map<String, String> params = TaskExtensionFileParser.parseParamList(paramNodes);
            for (String device : devices) {
                TaskExtensionInfo taskExtensionInfo = new TaskExtensionInfo(device, params.get("type"));
                if (params.containsKey(device)) {
                    taskExtensionInfo.setCmdContent(params.get(device));
                }
                taskExtensionInfos.put(device, taskExtensionInfo);
            }
            if (devices.isEmpty() && !params.isEmpty()) {
                TaskExtensionInfo taskExtensionInfo = new TaskExtensionInfo("ALL", params.get("type"));
                if (params.containsKey("ALL")) {
                    taskExtensionInfo.setCmdContent(params.get("ALL"));
                }
                taskExtensionInfos.put("ALL", taskExtensionInfo);
            }
        }
        catch (Exception e) {
            LOGGER.error("parse file exception.", (Throwable)e);
        }
        finally {
            StreamUtils.closeStream(null, fis);
            if (!taskExtensionFile.delete()) {
                LOGGER.error("delete file error.filename=" + taskExtensionFile.getName());
            }
        }
    }

    private static List<String> parseDeviceNodes(NodeList nodeList) {
        if (null == nodeList) {
            return null;
        }
        ArrayList<String> params = new ArrayList<String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            params.add(e.getAttribute("serialNo"));
        }
        return params;
    }

    private static Map<String, String> parseParamList(NodeList nodeList) {
        if (null == nodeList) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            String key = e.getAttribute("key");
            String value = e.getAttribute("value");
            params.put(key, value);
        }
        return params;
    }
}

